/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.autofill;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IAutoFillVariableProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoFillService {
    private Logger logger = Logger.getLogger(AutoFillService.class);
    private Specification spec;
    private Title title;

    public AutoFillService(Specification spec) {
        this.spec = spec;
    }

    public void autoFill(Title title) {
        if (title == null) {
            return;
        }
        Asset rootAsset = title.getAsset();
        if (rootAsset == null) {
            return;
        }
        this.title = title;
        this.walkAssetTree(rootAsset, null);
    }

    private void walkAssetTree(Asset asset, String parentPath) {
        String path = parentPath == null ? asset.getAssetType() : parentPath + "/" + asset.getAssetType();
        TitleConf titleConf = AutoFillService.getTitleConfByPath(this.spec, path);
        this.processAsset(asset, titleConf);
        for (Relation r : asset.getRelations()) {
            this.walkAssetTree(r.getTargetAsset(), path);
        }
    }

    public static TitleConf getTitleConfByPath(Specification spec, String path) {
        if (path == null) {
            return null;
        }
        String[] names = path.split("/");
        TitleConf conf = null;
        List confs = spec.getRootTitleConfs();
        for (String name : names) {
            conf = AutoFillService.getTitleConfByName(confs, name);
            if (conf == null) {
                return null;
            }
            confs = conf.getChildren();
        }
        return conf;
    }

    private static TitleConf getTitleConfByName(List<TitleConf> confs, String name) {
        if (confs == null) {
            return null;
        }
        for (TitleConf conf : confs) {
            if (!conf.getName().equals(name)) continue;
            return conf;
        }
        return null;
    }

    private void processAsset(Asset asset, TitleConf titleConf) {
        if (titleConf == null) {
            return;
        }
        SpecSearcher searcher = new SpecSearcher();
        List<SimpleVariable> vars = searcher.getAutoFillFields(titleConf);
        this.autoFill(asset, vars);
    }

    private void autoFill(Asset asset, List<SimpleVariable> vars) {
        if (vars == null || vars.isEmpty()) {
            return;
        }
        for (SimpleVariable var : vars) {
            String className;
            String value;
            String xpath = var.getXPath();
            Field field = asset.getFirstField(xpath);
            if (field != null && field.getValue() != null || (value = this.getAutoFillValue(this.spec, className = var.getAutoFillProvider(), this.title, asset)) == null) continue;
            field = new Field(xpath, value);
            field.setAutoFill(true);
            field.setIndices(this.getIndicesFromXpath(xpath));
            asset.addField(field);
        }
    }

    private ArrayList<Integer> getIndicesFromXpath(String xpath) {
        String[] a = xpath.split("/");
        if (a.length == 0) {
            throw new IllegalArgumentException("Invalid xpath");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String s : a) {
            if (s.equals("") || s.startsWith("@")) continue;
            indices.add(new Integer(1));
        }
        return indices;
    }

    private String getAutoFillValue(Specification spec, String className, Title title, Asset asset) {
        try {
            ClassLoader classloader = spec.getClassLoader();
            Class<?> providerClass = classloader.loadClass(className);
            Object obj = providerClass.newInstance();
            if (obj instanceof IAutoFillVariableProvider) {
                IAutoFillVariableProvider provider = (IAutoFillVariableProvider)obj;
                return provider.getValue(title, asset);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unable to generate value", (Throwable)ex);
        }
        return null;
    }

    private static class SpecSearcher {
        private List<SimpleVariable> list;

        private SpecSearcher() {
        }

        public List<SimpleVariable> getAutoFillFields(TitleConf titleConf) {
            this.list = new ArrayList<SimpleVariable>();
            if (titleConf != null) {
                List vars = titleConf.getMetadata();
                for (Variable var : vars) {
                    if (var instanceof ComplexVariable) {
                        this.processComplexVariable((ComplexVariable)var);
                        continue;
                    }
                    this.processSimpleVariable((SimpleVariable)var);
                }
            }
            return this.list;
        }

        private void processComplexVariable(ComplexVariable complexVar) {
            List vars = complexVar.getChildren();
            for (Variable var : vars) {
                if (var instanceof ComplexVariable) {
                    this.processComplexVariable((ComplexVariable)var);
                    continue;
                }
                this.processSimpleVariable((SimpleVariable)var);
            }
        }

        private void processSimpleVariable(SimpleVariable simpleVar) {
            if (simpleVar.isAutoFillable() && simpleVar.getAutoFillProvider() != null) {
                this.list.add(simpleVar);
            }
        }
    }
}

