/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.compare;

import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.compare.IAssetCompareReport;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.entities.compare.TitleCompareReport;
import org.springframework.context.ApplicationContext;

class TitleComparator {
    TitleComparator() {
    }

    public boolean isDifferent(Title title1, Title title2) {
        Asset asset1 = title1 != null ? title1.getAsset() : null;
        Asset asset2 = title2 != null ? title2.getAsset() : null;
        return this.getTTVHandler().areAssetsDifferent(asset1, asset2);
    }

    public ITitleCompareReport compare(Title title1, Title title2) {
        TitleCompareReport report = new TitleCompareReport(title1, title2);
        Asset asset1 = title1 != null ? title1.getAsset() : null;
        Asset asset2 = title2 != null ? title2.getAsset() : null;
        IAssetCompareReport assetReport = this.getTTVHandler().compareAssets(asset1, asset2);
        report.setAssetCompareReport(assetReport);
        return report;
    }

    private ITTVDataModelHandler getTTVHandler() {
        ApplicationContext springContext = ApplicationContextHelper.getInstance().getContext();
        return (ITTVDataModelHandler)springContext.getBean("TTVSpecHandler");
    }
}

