/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.PropertyValueField;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAssetMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class TitleIngestService
implements ITitleIngestService {
    private static final String ASSET_MAP_FILTER_XPATH = "/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id";
    private DocumentBuilderFactory documentBuilderFactoryInstance;
    private ITitleManager titleManagerInstance;
    private IContentClassService contentClassServiceInstance;
    private IPartnerManagement partnerManagementInstance;
    private IScheduleSearchService scheduleSearchServiceInstance;
    private TitleStatusService statusServiceInstance;

    public void start() {
    }

    public void stop() {
        this.documentBuilderFactoryInstance = null;
        this.titleManagerInstance = null;
        this.contentClassServiceInstance = null;
        this.partnerManagementInstance = null;
        this.scheduleSearchServiceInstance = null;
        this.statusServiceInstance = null;
    }

    public String getServiceName() {
        return "Title Ingest Service";
    }

    @Transactional
    public TitleIngestResult createTitleForMetadata(String metadataPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = providerId;
        String string3 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.createTitleForMetadata_aroundBody1$advice(this, string, string2, string3, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("createTitleForMetadata", String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private Map<String, FileMapResult> mapMetadataOnly(String metadataPath, Title title) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = this.mapFile(title, title.getAsset(), metadataPath, true);
        result.put(metadataPath, mapping);
        return result;
    }

    @Transactional
    public TitleIngestResult createTitleForPackage(String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = assetFolderPath;
        String string3 = providerId;
        String string4 = contentClassName;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.createTitleForPackage_aroundBody3$advice(this, string, string2, string3, string4, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("createTitleForPackage", String.class, String.class, String.class, String.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private void sendProgressUpdateForAssets(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        Collection fileMappings = titleIngestResult.getMappings().values();
        for (FileMapResult fileMap : fileMappings) {
            if (fileMap.isMetadata() || !fileMap.isMapped()) continue;
            String assetType = fileMap.getParentAsset().getAssetType();
            this.statusService().sendAssetReceivedStatus(ingestedTitle, assetType, plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private void sendProgressUpdateForMetadata(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        this.statusService().sendMetadataReceivedStatus(ingestedTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private Long getPlannerId(Title title) {
        Long result = this.scheduleSearchService().findEarliestUpcomingPlannerId(title);
        if (result == null) {
            result = this.scheduleSearchService().findPastPlannerId(title);
        }
        return result;
    }

    private ISavedTitle saveTitle(Title title, ITitleActionSource source) throws TitleIngestException {
        ISavedTitle savedTitle;
        try {
            savedTitle = this.titleManager().save(title, source);
        }
        catch (TitleValidationException e) {
            throw new TitleIngestException("It was not possible to ingest the title", (Throwable)e);
        }
        return savedTitle;
    }

    private void checkIfThereIsOnlyOneNonExistingRootAsset(Document metadataDocument) throws TitleIngestException {
        List titleIds = this.titleManager().getTitleIDs(metadataDocument);
        if (titleIds.size() != 1) {
            throw new TitleIngestException("There should be only one root asset in this document");
        }
        if (titleIds.get(0) != null) {
            throw new TitleIngestException("It's not possible to create a title from this package. The title already exists with the id " + titleIds.get(0));
        }
    }

    private Title createTitleObjectForCreation(Document metadataDocument, String providerId, String contentClassName) throws TitleIngestException {
        Title title = new Title();
        title.setAsset(this.getRootAsset(metadataDocument));
        title.setPartnerId(this.getPartnerId(providerId));
        title.setContentClassId(this.getContentClassId(contentClassName));
        try {
            this.contentClassService().applyContentClassMetadata(title);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("It wasn't possible to create the new title. Error trying to apply the content class.", (Throwable)e);
        }
        return title;
    }

    private Long getPartnerId(String providerId) throws TitleIngestException {
        Partner sourceOrSelfPartner = this.partnerManagement().getSourceOrSelfPartner(providerId);
        if (sourceOrSelfPartner == null) {
            throw new TitleIngestException("it wasn't possible to get any source or self partner for the providerId = " + providerId);
        }
        return sourceOrSelfPartner.getId();
    }

    private Map<String, FileMapResult> mapFilesForPackage(String metadataPath, String assetFolderPath, Title title) throws TitleIngestException {
        FileMapResult metadataMapping = this.mapFile(title, title.getAsset(), metadataPath, true);
        List<String> assetFilePaths = this.getAssetsInFolder(assetFolderPath);
        List<FileMapResult> contentMappings = this.mapContentFiles(title, assetFilePaths);
        HashMap<String, FileMapResult> mappings = new HashMap<String, FileMapResult>();
        mappings.put(metadataPath, metadataMapping);
        for (FileMapResult fmr : contentMappings) {
            mappings.put(fmr.getPath(), fmr);
        }
        return mappings;
    }

    private List<FileMapResult> mapContentFiles(Title title, List<String> assetFilePaths) throws TitleIngestException {
        ArrayList<FileMapResult> result = new ArrayList<FileMapResult>();
        for (String assetPath : assetFilePaths) {
            String assetFileName = new File(assetPath).getName();
            List<Asset> matchingAssets = this.findAssetWithFileName(assetFileName, title);
            if (matchingAssets.size() > 1) {
                throw new TitleIngestException("More than one asset found for fileName: " + assetFileName);
            }
            if (matchingAssets.size() == 0) {
                FileMapResult noMappingResult = new FileMapResult(assetFileName, null, null, false);
                result.add(noMappingResult);
                continue;
            }
            Asset matchingAsset = matchingAssets.get(0);
            FileMapResult fileMappingResult = this.mapFile(title, matchingAsset, assetPath, false);
            result.add(fileMappingResult);
        }
        return result;
    }

    private FileMapResult mapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        String size;
        File file = new File(filePath);
        try {
            size = String.valueOf(file.length());
        }
        catch (Exception e) {
            size = "";
        }
        com.tandbergtv.metadatamanager.model.File newFile = this.titleManager().createOriginalFile();
        newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        title.addFile(asset, newFile);
        return new FileMapResult(filePath, asset, newFile, isMetadata);
    }

    private FileMapResult mapAndMoveFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        File mappedFile = new File(filePath);
        if (AssetsManager.getThreadLocalInstance().isUnmappedFile(filePath)) {
            mappedFile = this.moveToMappedLocation(new File(filePath));
        }
        return this.mapFile(title, asset, mappedFile.getAbsolutePath(), isMetadata);
    }

    private File moveToMappedLocation(File file) throws TitleIngestException {
        try {
            return AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(file);
        }
        catch (IOException e) {
            throw new TitleIngestException("It was not possible to move the file " + file.getName() + " to the mapped files location", (Throwable)e);
        }
    }

    private Asset getRootAsset(Document metadataDocument) throws TitleIngestException {
        try {
            ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDocument);
            List mergedAssets = specHandler.mergeWithoutSave(metadataDocument);
            if (mergedAssets.size() != 1) {
                throw new TitleIngestException("The mergeWithoutSave operation should return exactly one asset, but " + mergedAssets.size() + " were found.");
            }
            return (Asset)mergedAssets.get(0);
        }
        catch (MetadataException e) {
            throw new TitleIngestException("It wasn't possible to create the title", (Throwable)e);
        }
    }

    private Long getContentClassId(String contentClassName) throws TitleIngestException {
        try {
            if (this.isEmpty(contentClassName)) {
                return this.contentClassService().getDefaultContentClassId();
            }
            Long id = this.contentClassService().getContentClassIdByName(contentClassName);
            if (id == null) {
                throw new TitleIngestException("The content class with name " + contentClassName + " wasn't fond.");
            }
            return id;
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("It was not possible to obtain the content class using the given content class name: " + contentClassName, (Throwable)e);
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    private List<String> getAssetsInFolder(String assetFolderPath) throws TitleIngestException {
        File assetsFolder = this.getFolder(assetFolderPath);
        ArrayList<String> result = new ArrayList<String>();
        for (File f : assetsFolder.listFiles()) {
            if (this.isMetadataFile(f) || f.isDirectory()) continue;
            result.add(f.getAbsolutePath());
        }
        return result;
    }

    private List<Asset> findAssetWithFileName(String fileName, Title title) {
        if (title == null || title.getAsset() == null) {
            return null;
        }
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset a : title.getAllAssets(false)) {
            if (!fileName.equals(this.getAssetFileName(a))) continue;
            result.add(a);
        }
        return result;
    }

    private String getAssetFileName(Asset asset) {
        Field fileNameField = asset.getFirstField(FieldName.URL.toString());
        if (fileNameField == null || fileNameField.getValue() == null) {
            return null;
        }
        String fileNameValue = fileNameField.getValue();
        int pathSeperaterIndex = fileNameValue.lastIndexOf(File.separator);
        if (pathSeperaterIndex < 0) {
            return fileNameValue;
        }
        return fileNameValue.substring(pathSeperaterIndex + 1, fileNameValue.length());
    }

    public String generateUnmappedContentPath(String contentFilePath, String providerId) {
        if (contentFilePath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        String fileName = new File(contentFilePath).getName();
        return this.getUnmappedFilesDirectory() + File.separator + providerId + File.separator + fileName + "_" + this.timestamp() + File.separator + fileName;
    }

    private String getUnmappedFilesDirectory() {
        return AssetsManager.getThreadLocalInstance().getUnmappedFilesDirectory().getAbsolutePath();
    }

    private long timestamp() {
        return Calendar.getInstance().getTimeInMillis();
    }

    @Transactional
    public ContentMapping getMappingForContent(String assetPath, String providerId) {
        String string = assetPath;
        String string2 = providerId;
        return (ContentMapping)TitleIngestService.getMappingForContent_aroundBody5$advice(this, string, string2, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getMappingForContent", String.class, String.class).getAnnotation(Transactional.class), null);
    }

    private Long getTitleId(Asset asset) {
        Asset rootAsset = asset.getRoot();
        if (rootAsset == null) {
            rootAsset = asset;
        }
        Long titleId = this.titleManager().getIDByAssetID(Long.valueOf(rootAsset.getId()));
        return titleId;
    }

    private Collection<Asset> findAssetsWithFileName(String fileName, String filterValue) {
        AssetSearchService service = ApplicationContextHelper.getInstance().getAssetSearchService();
        SearchInfo info = this.buildSearchInfo(fileName, ASSET_MAP_FILTER_XPATH, filterValue);
        ArrayList values = new ArrayList();
        String orgAssetIdCol = DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ORIGINAL_ASSET_ID.toString());
        PropertyValueField originalAsset = new PropertyValueField(orgAssetIdCol, values, LogicalOperator.ISNULL, Asset.class);
        info.getFields().add(originalAsset);
        String query = service.getQuery("", "", info, null);
        return service.search(query);
    }

    private SearchInfo buildSearchInfo(String filePath, String filterXpath, String filterValue) {
        SearchInfo info = new SearchInfo();
        ArrayList<MetadataValueFieldInfo> searchFields = new ArrayList<MetadataValueFieldInfo>();
        info.setProperty(AssetSearchKey.FIELDS.toString());
        MetadataValueFieldInfo searchField = new MetadataValueFieldInfo(FieldName.URL.toString(), LogicalOperator.EQUAL, filePath);
        searchFields.add(searchField);
        info.setFields(searchFields);
        if (filterValue != null && filterValue.trim().length() > 0 && filterXpath != null && filterXpath.trim().length() > 0) {
            MetadataValueFieldInfo filterField = new MetadataValueFieldInfo(filterXpath, LogicalOperator.EQUAL, filterValue);
            info.getFields().add(filterField);
        }
        return info;
    }

    @Transactional
    public ContentMapping getMappingForMetadata(String metadataPath) throws TitleIngestException {
        String string = metadataPath;
        return (ContentMapping)TitleIngestService.getMappingForMetadata_aroundBody7$advice(this, string, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getMappingForMetadata", String.class).getAnnotation(Transactional.class), null);
    }

    private Document createDocument(String filePath) throws TitleIngestException {
        Document document = null;
        try {
            DocumentBuilder docBuilder = this.documentBuilderFactory().newDocumentBuilder();
            document = docBuilder.parse(new File(filePath));
        }
        catch (Exception e) {
            throw new TitleIngestException("Unable to parse the metadata file: " + filePath, (Throwable)e);
        }
        return document;
    }

    @Transactional
    public Collection<TitleAssetMapping> getUnmappedContentForTitle(Long titleId) throws TitleIngestException {
        Long l = titleId;
        return (Collection)TitleIngestService.getUnmappedContentForTitle_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getUnmappedContentForTitle", Long.class).getAnnotation(Transactional.class), null);
    }

    private TitleAssetMapping getUnmappedContentForTitleAsset(Title title, Asset asset, String providerId) throws TitleIngestException {
        TitleAsset titleAsset = new TitleAsset(title.getId(), Long.valueOf(asset.getId()));
        Collection<String> filePaths = this.findUnmappedContentFilesMatchingAsset(providerId, asset);
        return new TitleAssetMapping(titleAsset, filePaths);
    }

    private String getProviderId(Title title) {
        Partner partner = this.partnerManagement().getPartner(title.getPartnerId().longValue());
        return partner.getProviderId();
    }

    private Collection<String> findUnmappedContentFilesMatchingAsset(String providerId, Asset asset) throws TitleIngestException {
        String fileName = TitleUtil.getFileName(asset);
        try {
            List<File> unmappedFiles = AssetsManager.getThreadLocalInstance().getUnmappedFiles(fileName, providerId);
            ArrayList<String> result = new ArrayList<String>(unmappedFiles.size());
            for (File uf : unmappedFiles) {
                result.add(uf.getAbsolutePath());
            }
            return result;
        }
        catch (IOException e) {
            throw new TitleIngestException("It wasn't possible to obtain the unmapped files", (Throwable)e);
        }
    }

    @Transactional
    public TitleAssetMapping getUnmappedContentForTitleAsset(Long titleId, Long assetId) throws TitleIngestException {
        Long l = titleId;
        Long l2 = assetId;
        return (TitleAssetMapping)TitleIngestService.getUnmappedContentForTitleAsset_aroundBody11$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getUnmappedContentForTitleAsset", Long.class, Long.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = assetPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForContent_aroundBody13$advice(this, string, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForContent", String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private Asset getSingleAssetInTitle(String assetPath, Long titleId, Title title) throws TitleIngestException {
        String assetName = new File(assetPath).getName();
        List<Asset> assetsInTitle = this.findAssetWithFileName(assetName, title);
        if (assetsInTitle.size() != 1) {
            throw new TitleIngestException("There should be one asset with name " + assetName + " in the title with id " + titleId + ", but " + assetsInTitle.size() + " were found.");
        }
        return assetsInTitle.get(0);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, Long assetId, ITitleActionSource source) throws TitleIngestException {
        String string = assetPath;
        Long l = titleId;
        Long l2 = assetId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForContent_aroundBody15$advice(this, string, l, l2, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForContent", String.class, Long.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private TitleIngestResult updateTitleForContent(String assetPath, Title title, Asset asset, ITitleActionSource source) throws TitleIngestException {
        Map<String, FileMapResult> mappings = this.mapContent(title, asset, assetPath);
        Long plannerId = this.getPlannerId(title);
        ISavedTitle savedTitle = this.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private Map<String, FileMapResult> mapContent(Title title, Asset asset, String assetPath) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = this.mapAndMoveFile(title, asset, assetPath, false);
        result.put(assetPath, mapping);
        return result;
    }

    @Transactional
    public TitleIngestResult updateTitleForMetadata(String metadataPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForMetadata_aroundBody17$advice(this, string, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForMetadata", String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public TitleIngestResult updateTitleForPackage(String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        String string = metadataPath;
        String string2 = assetFolderPath;
        Long l = titleId;
        ITitleActionSource iTitleActionSource = source;
        return (TitleIngestResult)TitleIngestService.updateTitleForPackage_aroundBody19$advice(this, string, string2, l, iTitleActionSource, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("updateTitleForPackage", String.class, String.class, Long.class, ITitleActionSource.class).getAnnotation(Transactional.class), null);
    }

    private Title getTitleObjectForUpdate(Long titleId, Document metadataDocument, String metadataPath) throws TitleIngestException {
        try {
            Title title = this.titleManager().getForUpdate(titleId);
            Long rootAssetId = title.getAsset().getId();
            if (!title.getIsActive().booleanValue()) {
                throw new TitleIngestException("Cannot update title[#" + titleId + "] since it is inactive.");
            }
            ISpecHandler specHandler = SpecHandlerFactory.getInstance((Document)metadataDocument);
            List mergedAssets = specHandler.mergeWithoutSave(rootAssetId, metadataDocument);
            if (mergedAssets.size() != 1) {
                throw new TitleIngestException("The mergeWithoutSave operation should return exactly one asset, but " + mergedAssets.size() + " were found.");
            }
            title.setAsset((Asset)mergedAssets.get(0));
            this.contentClassService().applyContentClassMetadata(title);
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("It wasn't possible to update title[#" + titleId + "] with metadata file: " + metadataPath, (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("It wasn't possible to update title[#" + titleId + "] with metadata file: " + metadataPath + ". Error trying to apply the content class.", (Throwable)e);
        }
    }

    public String getMetadataPathForPackage(String packageFolderPath) throws TitleIngestException {
        File[] packageFiles;
        String result = null;
        File packageFolder = this.getFolder(packageFolderPath);
        for (File f : packageFiles = packageFolder.listFiles()) {
            if (!this.isMetadataFile(f)) continue;
            if (result != null) {
                throw new TitleIngestException("The folder " + packageFolderPath + " contains more than one xml file");
            }
            result = f.getAbsolutePath();
        }
        if (result == null) {
            throw new TitleIngestException("The folder " + packageFolderPath + " contains no xml file");
        }
        return result;
    }

    private boolean isMetadataFile(File f) {
        return f.getName().toLowerCase().endsWith(".xml");
    }

    private File getFolder(String folderPath) throws TitleIngestException {
        if (folderPath == null) {
            throw new IllegalArgumentException("folderPath can't be null");
        }
        File result = new File(folderPath);
        if (!result.exists()) {
            throw new TitleIngestException("The folder " + folderPath + " doesn't exist.");
        }
        if (!result.isDirectory()) {
            throw new TitleIngestException("The path " + folderPath + " is not a directory.");
        }
        return result;
    }

    @Transactional
    public List<Asset> getContentAssets(Long titleId) throws TitleIngestException {
        Long l = titleId;
        return (List)TitleIngestService.getContentAssets_aroundBody21$advice(this, l, TransactionEnforcer.aspectOf(), TitleIngestService.class.getDeclaredMethod("getContentAssets", Long.class).getAnnotation(Transactional.class), null);
    }

    private boolean assetHasContentUrl(Asset asset) {
        return !this.isEmpty(this.getAssetFileName(asset));
    }

    private DocumentBuilderFactory documentBuilderFactory() {
        if (this.documentBuilderFactoryInstance == null) {
            this.documentBuilderFactoryInstance = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactoryInstance.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        return this.documentBuilderFactoryInstance;
    }

    private ITitleManager titleManager() {
        if (this.titleManagerInstance == null) {
            this.titleManagerInstance = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        }
        return this.titleManagerInstance;
    }

    private IContentClassService contentClassService() {
        if (this.contentClassServiceInstance == null) {
            this.contentClassServiceInstance = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        }
        return this.contentClassServiceInstance;
    }

    private IPartnerManagement partnerManagement() {
        if (this.partnerManagementInstance == null) {
            this.partnerManagementInstance = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        }
        return this.partnerManagementInstance;
    }

    private IScheduleSearchService scheduleSearchService() {
        if (this.scheduleSearchServiceInstance == null) {
            this.scheduleSearchServiceInstance = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        }
        return this.scheduleSearchServiceInstance;
    }

    private TitleStatusService statusService() {
        if (this.statusServiceInstance == null) {
            this.statusServiceInstance = new TitleStatusService();
        }
        return this.statusServiceInstance;
    }

    private void validateActiveTitle(Title title) throws TitleIngestException {
        if (!title.getIsActive().booleanValue()) {
            throw new TitleIngestException("The title[" + title.getId() + "] is inactive.");
        }
    }

    private static final /* synthetic */ TitleIngestResult createTitleForMetadata_aroundBody0(TitleIngestService this_, String metadataPath, String providerId, String contentClassName, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Document metadataDocument = this_.createDocument(metadataPath);
        this_.checkIfThereIsOnlyOneNonExistingRootAsset(metadataDocument);
        Title title = this_.createTitleObjectForCreation(metadataDocument, providerId, contentClassName);
        Map<String, FileMapResult> mappings = this_.mapMetadataOnly(metadataPath, title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, null);
        this_.sendProgressUpdateForMetadata(result, source);
        return result;
    }

    private static final /* synthetic */ Object createTitleForMetadata_aroundBody1$advice(TitleIngestService this_, String metadataPath, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForMetadata_aroundBody0(this_, metadataPath, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.createTitleForMetadata_aroundBody0(this_, metadataPath, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleIngestResult createTitleForPackage_aroundBody2(TitleIngestService this_, String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (assetFolderPath == null) {
            throw new IllegalArgumentException("assetFolderPath can't be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Document metadataDocument = this_.createDocument(metadataPath);
        this_.checkIfThereIsOnlyOneNonExistingRootAsset(metadataDocument);
        Title title = this_.createTitleObjectForCreation(metadataDocument, providerId, contentClassName);
        Map<String, FileMapResult> mappings = this_.mapFilesForPackage(metadataPath, assetFolderPath, title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, null);
        this_.sendProgressUpdateForMetadata(result, source);
        this_.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private static final /* synthetic */ Object createTitleForPackage_aroundBody3$advice(TitleIngestService this_, String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.createTitleForPackage_aroundBody2(this_, metadataPath, assetFolderPath, providerId, contentClassName, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.createTitleForPackage_aroundBody2(this_, metadataPath, assetFolderPath, providerId, contentClassName, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ContentMapping getMappingForContent_aroundBody4(TitleIngestService this_, String assetPath, String providerId) {
        String fileName = new File(assetPath).getName();
        Collection<Asset> assetsWithFileName = this_.findAssetsWithFileName(fileName, providerId);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>(assetsWithFileName.size());
        for (Asset asset : assetsWithFileName) {
            Long titleId = this_.getTitleId(asset);
            titleAssets.add(new TitleAsset(titleId, Long.valueOf(asset.getId())));
        }
        return new ContentMapping(assetPath, titleAssets);
    }

    private static final /* synthetic */ Object getMappingForContent_aroundBody5$advice(TitleIngestService this_, String assetPath, String providerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getMappingForContent_aroundBody4(this_, assetPath, providerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentMapping object = TitleIngestService.getMappingForContent_aroundBody4(this_, assetPath, providerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ ContentMapping getMappingForMetadata_aroundBody6(TitleIngestService this_, String metadataPath) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("metadataPath can't be null");
        }
        Document document = this_.createDocument(metadataPath);
        List titleIDs = this_.titleManager().getTitleIDs(document);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>();
        for (Long id : titleIDs) {
            Title title;
            if (id == null || (title = this_.titleManager().get(id)) == null || title.getAsset() == null) continue;
            titleAssets.add(new TitleAsset(title.getId(), Long.valueOf(title.getAsset().getId())));
        }
        return new ContentMapping(metadataPath, titleAssets);
    }

    private static final /* synthetic */ Object getMappingForMetadata_aroundBody7$advice(TitleIngestService this_, String metadataPath, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getMappingForMetadata_aroundBody6(this_, metadataPath);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentMapping object = TitleIngestService.getMappingForMetadata_aroundBody6(this_, metadataPath);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Collection getUnmappedContentForTitle_aroundBody8(TitleIngestService this_, Long titleId) {
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        ArrayList<TitleAssetMapping> result = new ArrayList<TitleAssetMapping>();
        Title title = this_.titleManager().get(titleId);
        this_.validateActiveTitle(title);
        String providerId = this_.getProviderId(title);
        for (Asset asset : title.getAllAssets(false)) {
            if (!this_.assetHasContentUrl(asset)) continue;
            result.add(this_.getUnmappedContentForTitleAsset(title, asset, providerId));
        }
        return result;
    }

    private static final /* synthetic */ Object getUnmappedContentForTitle_aroundBody9$advice(TitleIngestService this_, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getUnmappedContentForTitle_aroundBody8(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = TitleIngestService.getUnmappedContentForTitle_aroundBody8(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleAssetMapping getUnmappedContentForTitleAsset_aroundBody10(TitleIngestService this_, Long titleId, Long assetId) {
        Title title = this_.titleManager().get(titleId);
        this_.validateActiveTitle(title);
        Asset asset = title.getAsset(assetId.longValue());
        String providerId = this_.getProviderId(title);
        return this_.getUnmappedContentForTitleAsset(title, asset, providerId);
    }

    private static final /* synthetic */ Object getUnmappedContentForTitleAsset_aroundBody11$advice(TitleIngestService this_, Long titleId, Long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getUnmappedContentForTitleAsset_aroundBody10(this_, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleAssetMapping object = TitleIngestService.getUnmappedContentForTitleAsset_aroundBody10(this_, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForContent_aroundBody12(TitleIngestService this_, String assetPath, Long titleId, ITitleActionSource source) {
        if (assetPath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Title title = this_.titleManager().getForUpdate(titleId);
        if (!title.getIsActive().booleanValue()) {
            throw new TitleIngestException("Cannot update title[#" + titleId + "] since it is inactive.");
        }
        Asset asset = this_.getSingleAssetInTitle(assetPath, titleId, title);
        return this_.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ Object updateTitleForContent_aroundBody13$advice(TitleIngestService this_, String assetPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForContent_aroundBody12(this_, assetPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForContent_aroundBody12(this_, assetPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForContent_aroundBody14(TitleIngestService this_, String assetPath, Long titleId, Long assetId, ITitleActionSource source) {
        if (assetPath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (assetId == null) {
            throw new IllegalArgumentException("assetId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Title title = this_.titleManager().getForUpdate(titleId);
        if (!title.getIsActive().booleanValue()) {
            throw new TitleIngestException("Cannot update title[#" + titleId + "] since it is inactive.");
        }
        Asset asset = title.getAsset(assetId.longValue());
        return this_.updateTitleForContent(assetPath, title, asset, source);
    }

    private static final /* synthetic */ Object updateTitleForContent_aroundBody15$advice(TitleIngestService this_, String assetPath, Long titleId, Long assetId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForContent_aroundBody14(this_, assetPath, titleId, assetId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForContent_aroundBody14(this_, assetPath, titleId, assetId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForMetadata_aroundBody16(TitleIngestService this_, String metadataPath, Long titleId, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("providerId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Document metadataDocument = this_.createDocument(metadataPath);
        Title title = this_.getTitleObjectForUpdate(titleId, metadataDocument, metadataPath);
        Map<String, FileMapResult> mappings = this_.mapMetadataOnly(metadataPath, title);
        Long plannerId = this_.getPlannerId(title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this_.sendProgressUpdateForMetadata(result, source);
        return result;
    }

    private static final /* synthetic */ Object updateTitleForMetadata_aroundBody17$advice(TitleIngestService this_, String metadataPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForMetadata_aroundBody16(this_, metadataPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForMetadata_aroundBody16(this_, metadataPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ TitleIngestResult updateTitleForPackage_aroundBody18(TitleIngestService this_, String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) {
        if (metadataPath == null) {
            throw new IllegalArgumentException("contentFilePath can't be null");
        }
        if (assetFolderPath == null) {
            throw new IllegalArgumentException("assetFolderPath can't be null");
        }
        if (titleId == null) {
            throw new IllegalArgumentException("titleId can't be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("source can't be null");
        }
        Document metadataDocument = this_.createDocument(metadataPath);
        Title title = this_.getTitleObjectForUpdate(titleId, metadataDocument, metadataPath);
        Map<String, FileMapResult> mappings = this_.mapFilesForPackage(metadataPath, assetFolderPath, title);
        Long plannerId = this_.getPlannerId(title);
        ISavedTitle savedTitle = this_.saveTitle(title, source);
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this_.sendProgressUpdateForMetadata(result, source);
        this_.sendProgressUpdateForAssets(result, source);
        return result;
    }

    private static final /* synthetic */ Object updateTitleForPackage_aroundBody19$advice(TitleIngestService this_, String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.updateTitleForPackage_aroundBody18(this_, metadataPath, assetFolderPath, titleId, source);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleIngestResult object = TitleIngestService.updateTitleForPackage_aroundBody18(this_, metadataPath, assetFolderPath, titleId, source);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ List getContentAssets_aroundBody20(TitleIngestService this_, Long titleId) {
        if (titleId == null) {
            throw new TitleIngestException("titleId can't be null");
        }
        Title title = this_.titleManager().get(titleId);
        this_.validateActiveTitle(title);
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset asset : title.getAllAssets(false)) {
            if (!this_.assetHasContentUrl(asset)) continue;
            result.add(asset);
        }
        return result;
    }

    private static final /* synthetic */ Object getContentAssets_aroundBody21$advice(TitleIngestService this_, Long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleIngestService.getContentAssets_aroundBody20(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleIngestService.getContentAssets_aroundBody20(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }
}

