/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.xport;

import com.tandbergtv.watchpoint.pmm.title.provider.TitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.xport.InstanceConfigurationException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class TitleProviderInstanceParser {
    private static final String INSTANCE_XPATH = "//TitleProviderInstance";
    private static final String INSTANCE_NAME_ATTR = "name";
    private static final String INSTANCE_KEY_ATTR = "key";
    private static final String PROPERTY_ELEMENT = "Property";
    private static final String PROPERTY_KEY_ATTR = "key";

    public List<TitleProviderInstance> parse(InputStream stream) throws InstanceConfigurationException {
        ArrayList<TitleProviderInstance> instances = new ArrayList<TitleProviderInstance>();
        Document document = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(stream);
        }
        catch (Exception e) {
            String msg = "Failed to load the Instance Configuration XML file from stream.";
            throw new InstanceConfigurationException(msg, e);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpath.evaluate(INSTANCE_XPATH, document, XPathConstants.NODESET);
        }
        catch (Exception e) {
            String msg = "Failed to get list of TitleProviderInstance elements from the Title Provider Instance configuration XML file.";
            throw new InstanceConfigurationException(msg, e);
        }
        int nodeCount = nodes != null ? nodes.getLength() : 0;
        for (int i = 0; i < nodeCount; ++i) {
            Element instanceElement = (Element)nodes.item(i);
            instances.add(this.parseTitleProviderInstance(instanceElement, xpath));
        }
        return instances;
    }

    private TitleProviderInstance parseTitleProviderInstance(Element element, XPath xpath) {
        TitleProviderInstance instance = new TitleProviderInstance();
        instance.setKey(element.getAttribute("key"));
        instance.setName(element.getAttribute(INSTANCE_NAME_ATTR));
        Map<String, String> properties = instance.getProperties();
        NodeList nodes = element.getElementsByTagName(PROPERTY_ELEMENT);
        int nodeCount = nodes != null ? nodes.getLength() : 0;
        for (int i = 0; i < nodeCount; ++i) {
            Element propertyElement = (Element)nodes.item(i);
            String key = propertyElement.getAttribute("key");
            String value = propertyElement.getTextContent();
            properties.put(key, value);
        }
        return instance;
    }
}

