/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.xport;

import com.tandbergtv.cms.title.search.entities.EntityName;
import com.tandbergtv.cms.title.search.entities.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleSearchStrategy;
import com.tandbergtv.watchpoint.pmm.title.provider.xport.TitleCreator;
import com.tandbergtv.watchpoint.pmm.title.provider.xport.TitleSearchFields;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.SearchParameter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import org.apache.log4j.Logger;

public class XportTitleSearchStrategy
implements ITitleSearchStrategy {
    private ITitleProvider provider;
    private Logger logger = Logger.getLogger(XportTitleSearchStrategy.class);
    private static String SEARCH_STORED_PROC_DEFN = "PKG_WATCHPOINT_INTEGRATION.XportPackageSearch(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String COUNT_STORED_PROC_DEFN = "PKG_WATCHPOINT_INTEGRATION.XportPackageSearchCNT(?,?,?,?,?,?,?,?)";
    private static final String SPECIFICATION_CABLELABS = "CableLabsVOD1.1";
    private static int INVALID_INDEX = -1;
    private static int PACKAGE_ASSET_ID_INDEX = 1;
    private static int PROVIDER_ID_INDEX = 2;
    private static int TITLE_BRIEF_INDEX = 3;
    private static int LISC_STARTDATE_FROM_INDEX = 4;
    private static int LISC_STARTDATE_TO_INDEX = 5;
    private static int LISC_ENDDATE_FROM_INDEX = 6;
    private static int LISC_ENDDATE_TO_INDEX = 7;
    private static int COUNT_RESULT_INDEX = 8;
    private static int ORDER_BY_INDEX = 8;
    private static int ORDER_PREFERENCE_INDEX = 9;
    private static int START_ROW_NUMBER_INDEX = 10;
    private static int TOTAL_ROWS_INDEX = 11;
    private static int SEARCH_RESULTS_INDEX = 12;

    @Override
    public ITitleProvider getTitleProvider() {
        return this.provider;
    }

    @Override
    public void setTitleProvider(ITitleProvider provider) {
        this.provider = provider;
    }

    @Override
    public int count(SearchCriteria criteria) {
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement stmt = null;
        ITitleProviderInstance providerInstance = this.getProviderInstance(criteria);
        if (providerInstance == null) {
            this.logger.error((Object)"No provider found.");
            return 0;
        }
        this.validateSpecification(criteria);
        conn = this.getConnection(providerInstance.getProperties());
        String query = "{ call " + COUNT_STORED_PROC_DEFN + " }";
        stmt = this.prepareCall(criteria, conn, query);
        try {
            stmt.execute();
            int resultCount = stmt.getInt(COUNT_RESULT_INDEX);
            this.logger.debug((Object)("Got " + resultCount + " rows in query result."));
            int n = resultCount;
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error calling SP: ", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                this.logger.warn((Object)"Error while closing connection/resultset/stmt: ", (Throwable)e);
            }
        }
    }

    @Override
    public Collection<Title> search(SearchCriteria criteria) {
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        ITitleProviderInstance providerInstance = this.getProviderInstance(criteria);
        if (providerInstance == null) {
            throw new RuntimeException("No provider instance found during search.");
        }
        this.validateSpecification(criteria);
        conn = this.getConnection(providerInstance.getProperties());
        try {
            String query = "{ call " + SEARCH_STORED_PROC_DEFN + " }";
            stmt = this.prepareCall(criteria, conn, query);
            stmt.execute();
            rs = ((OracleCallableStatement)stmt).getCursor(SEARCH_RESULTS_INDEX);
            String specification = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchFields.SPECIFICATION.toString());
            Collection<Title> titles = TitleCreator.createTitles(rs, specification);
            String externalLocation = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString());
            for (Title title : titles) {
                title.setExternalLocation(externalLocation);
            }
            Collection<Title> collection = titles;
            return collection;
        }
        catch (SQLException e1) {
            throw new RuntimeException("Error while calling SP/processing resultset.", e1);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                this.logger.warn((Object)"Error while closing connection/resultset/stmt: ", (Throwable)e);
            }
        }
    }

    private ITitleProviderInstance getProviderInstance(SearchCriteria criteria) {
        String externalLocation = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString());
        if (this.provider != null) {
            return this.provider.getProviderInstance(externalLocation);
        }
        return null;
    }

    private CallableStatement prepareCall(SearchCriteria criteria, Connection conn, String query) {
        try {
            CallableStatement stmt = conn.prepareCall(query);
            String assetId = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchFields.TITLE_ASSET_ID.toString());
            stmt.setString(PACKAGE_ASSET_ID_INDEX, assetId);
            String providerId = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchFields.TITLE_PROVIDER_ID.toString());
            stmt.setString(PROVIDER_ID_INDEX, providerId);
            String titleBrief = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchFields.TITLE_BRIEF.toString());
            stmt.setString(TITLE_BRIEF_INDEX, titleBrief);
            RangeParameter startDateRange = this.getRangeParameter(criteria, TitleSearchFields.TITLE_LICENSE_START_DATE_WINDOW.toString());
            String startDateFrom = startDateRange == null ? null : startDateRange.getFrom();
            stmt.setString(LISC_STARTDATE_FROM_INDEX, startDateFrom);
            String startDateTo = startDateRange == null ? null : startDateRange.getTo();
            stmt.setString(LISC_STARTDATE_TO_INDEX, startDateTo);
            RangeParameter endDateRange = this.getRangeParameter(criteria, TitleSearchFields.TITLE_LICENSE_END_DATE_WINDOW.toString());
            String endDateFrom = endDateRange == null ? null : endDateRange.getFrom();
            stmt.setString(LISC_ENDDATE_FROM_INDEX, endDateFrom);
            String endDateTo = endDateRange == null ? null : endDateRange.getTo();
            stmt.setString(LISC_ENDDATE_TO_INDEX, endDateTo);
            if (query.indexOf(SEARCH_STORED_PROC_DEFN) != INVALID_INDEX) {
                String sortProperty;
                SortParameter sortParam = this.getSortParameter(criteria);
                this.logger.debug((Object)sortParam);
                String string = sortProperty = sortParam != null ? sortParam.getSortingColumn() : null;
                if (sortProperty != null) {
                    String specification = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchFields.SPECIFICATION.toString());
                    String sectionName = this.getTitleSection(specification, sortProperty);
                    sortProperty = sectionName != null ? TitleCreator.buildColumnName(sectionName, sortProperty) : null;
                }
                stmt.setString(ORDER_BY_INDEX, sortProperty);
                SortingOrder sortOrder = sortParam != null ? sortParam.getSortingOrder() : null;
                String sortOrderValue = this.getSortOrderValue(sortOrder);
                stmt.setString(ORDER_PREFERENCE_INDEX, sortOrderValue);
                stmt.setInt(START_ROW_NUMBER_INDEX, criteria.getStartingRecordNumber() + 1);
                stmt.setInt(TOTAL_ROWS_INDEX, criteria.getRecordsCount());
                stmt.registerOutParameter(SEARCH_RESULTS_INDEX, -10);
            } else {
                stmt.registerOutParameter(COUNT_RESULT_INDEX, 4);
            }
            return stmt;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while preparing call for query: " + query, e);
        }
    }

    private String getParameterValue(SearchCriteria criteria, String entityName, String key) {
        Entity e = (Entity)criteria.getParameter(entityName, Entity.class);
        List subParams = e.getSubParameters();
        for (SearchParameter p : subParams) {
            if (!p.getFieldName().equalsIgnoreCase(key)) continue;
            if (p.getDecoratedParameter() instanceof ValueParameter) {
                String val = (String)((ValueParameter)p.getDecoratedParameter()).getValue();
                return val == null || val.trim().length() == 0 ? null : val;
            }
            if (!(p instanceof Entity)) continue;
            List childParams = ((Entity)p).getSubParameters();
            for (SearchParameter childParam : childParams) {
                if (!childParam.getFieldName().equalsIgnoreCase(TitleSearchKey.METADATA_VALUE.toString()) || !(childParam.getDecoratedParameter() instanceof ValueParameter)) continue;
                String val = (String)((ValueParameter)childParam.getDecoratedParameter()).getValue();
                return val == null || val.trim().length() == 0 ? null : val;
            }
        }
        return null;
    }

    private RangeParameter getRangeParameter(SearchCriteria criteria, String key) {
        Entity title = (Entity)criteria.getParameter(EntityName.TITLE.toString(), Entity.class);
        List subParams = title.getSubParameters();
        for (SearchParameter p : subParams) {
            if (!p.getFieldName().equalsIgnoreCase(key) || !(p instanceof Entity)) continue;
            List childParams = ((Entity)p).getSubParameters();
            for (SearchParameter childParam : childParams) {
                if (!childParam.getFieldName().equalsIgnoreCase(TitleSearchKey.METADATA_VALUE.toString()) || !(childParam.getDecoratedParameter() instanceof RangeParameter)) continue;
                return (RangeParameter)childParam.getDecoratedParameter();
            }
        }
        return null;
    }

    private SortParameter getSortParameter(SearchCriteria criteria) {
        Entity title = (Entity)criteria.getParameter(EntityName.TITLE.toString(), Entity.class);
        List subParams = title.getSubParameters();
        for (SearchParameter p : subParams) {
            if (!(p.getDecoratedParameter() instanceof SortParameter)) continue;
            return (SortParameter)p.getDecoratedParameter();
        }
        return null;
    }

    private Connection getConnection(Map<String, String> properties) {
        String dbConnString = properties.get("DBConnectionString".toString());
        String dbUsername = properties.get("DBUsername".toString());
        String dbPassword = properties.get("DBPassword".toString());
        String dbDriverClass = properties.get("DBDriverClass".toString());
        try {
            Class.forName(dbDriverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error while loading driver class: " + dbDriverClass, e);
        }
        try {
            return DriverManager.getConnection(dbConnString, dbUsername, dbPassword);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while getting connection to: " + dbConnString, e);
        }
    }

    private void validateSpecification(SearchCriteria criteria) {
        String specification = this.getParameterValue(criteria, EntityName.TITLE.toString(), TitleSearchFields.SPECIFICATION.toString());
        if (!SPECIFICATION_CABLELABS.equals(specification)) {
            throw new RuntimeException("Search Strategy does not support specification: " + specification + ", only specification: " + SPECIFICATION_CABLELABS + " is supported.");
        }
    }

    private String getSortOrderValue(SortingOrder sortOrder) {
        String value = null;
        if (sortOrder == SortingOrder.ASCENDING) {
            value = "ASC";
        } else if (sortOrder == SortingOrder.DESCENDING) {
            value = "DESC";
        }
        return value;
    }

    private String getTitleSection(String specName, String metadataName) {
        if (metadataName.trim().length() == 0) {
            return null;
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager specManager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        Specification spec = specManager.getSpecificationByName(specName);
        return this.getTitleSection(spec.getRootTitleConf(), metadataName);
    }

    private String getTitleSection(TitleConf titleConf, String metadataName) {
        LinkedList<TitleConf> queue = new LinkedList<TitleConf>();
        queue.add(titleConf);
        while (!queue.isEmpty()) {
            TitleConf current = (TitleConf)queue.poll();
            List metadata = current.getMetadata();
            for (Variable variable : metadata) {
                if (!variable.getName().equals(metadataName)) continue;
                return current.getName();
            }
            for (TitleConf child : current.getChildren()) {
                queue.add(child);
            }
        }
        return null;
    }
}

