/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.title.search.builder.IQueryBuilder;
import com.tandbergtv.cms.title.search.entities.AssetSearchField;
import com.tandbergtv.cms.title.search.entities.FileSearchField;
import com.tandbergtv.cms.title.search.entities.SearchFieldNode;
import com.tandbergtv.cms.title.search.entities.SearchFieldNodeList;
import com.tandbergtv.cms.title.search.entities.TitleSortInfo;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.FieldSearchKey;
import com.tandbergtv.metadatamanager.search.FileInfo;
import com.tandbergtv.metadatamanager.search.ListFieldInfo;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.PropertyValueField;
import com.tandbergtv.metadatamanager.search.RangeFieldInfo;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.search.SearchFieldList;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.search.SortField;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import java.util.ArrayList;
import java.util.List;

public class AssetSearchQueryBuilder
implements IQueryBuilder {
    private AssetSearchService assetSearchService = (AssetSearchService)ApplicationContextHelper.getInstance().getContext().getBean("assetSearch");
    private static String SEARCH_ALIAS = "searchResults";
    private static String SORT_ALIAS = "sortResults";

    public String getSearchSubQuery(List<SearchFieldNode> searchFields, TitleSortInfo sortInfo) {
        SearchInfo info;
        SortField mdmSortField = null;
        if (sortInfo != null && sortInfo.getSortEntityClazz().equals(Field.class)) {
            mdmSortField = this.getSortField(sortInfo);
        }
        if ((info = this.convert(searchFields)) != null || mdmSortField != null) {
            return this.assetSearchService.getQuery(SEARCH_ALIAS, SORT_ALIAS, info, mdmSortField);
        }
        return "";
    }

    public SortField getSortField(TitleSortInfo sortInfo) {
        SortField field = new SortField();
        field.setAssetType(sortInfo.getAssetType());
        field.setTtvxpath(sortInfo.getSortItemName());
        field.setOrder(sortInfo.getOrder());
        return field;
    }

    public SearchInfo convert(List<SearchFieldNode> searchFields) {
        if (searchFields == null || searchFields.isEmpty()) {
            return null;
        }
        SearchInfo info = new SearchInfo();
        ArrayList<Object> mdmFields = new ArrayList<Object>();
        for (SearchFieldNode sfn : searchFields) {
            if (sfn instanceof AssetSearchField) {
                mdmFields.add(this.getField((AssetSearchField)sfn));
                continue;
            }
            if (sfn instanceof SearchFieldNodeList) {
                if (!((SearchFieldNodeList)sfn).getEntityClazz().equals(Asset.class)) continue;
                mdmFields.add(this.getFields((SearchFieldNodeList)sfn));
                continue;
            }
            if (!(sfn instanceof FileSearchField)) continue;
            mdmFields.add(this.getFileField((FileSearchField)sfn));
        }
        info.setFields(mdmFields);
        return info;
    }

    private SearchFieldList getFields(SearchFieldNodeList sfn) {
        SearchFieldList fieldList = new SearchFieldList();
        fieldList.setConjunction(sfn.isConjunction());
        for (SearchFieldNode sf : sfn.getNodeList()) {
            if (sf instanceof AssetSearchField) {
                SearchField field = this.getField((AssetSearchField)sf);
                fieldList.getSubFields().add(field);
                continue;
            }
            if (sf instanceof FileSearchField) {
                fieldList.getSubFields().add(this.getFileField((FileSearchField)sf));
                continue;
            }
            SearchFieldList mdmFields = this.getFields((SearchFieldNodeList)sf);
            for (SearchField f : mdmFields.getSubFields()) {
                fieldList.getSubFields().add(f);
            }
        }
        return fieldList;
    }

    public String getDefaultConditions(String alias) {
        return this.assetSearchService.getDefaultAssetConditions(alias);
    }

    private SearchField getField(AssetSearchField field) {
        ListFieldInfo sf = null;
        if (field.isListParameter()) {
            sf = new ListFieldInfo(field.getName(), field.getValues(), field.getOperator(), field.getSectionName());
        } else if (field.isValueParameter()) {
            String ttvxpath;
            String value = "";
            if (field.getValues() != null) {
                value = (String)field.getValues().get(0);
            }
            String string = ttvxpath = field.getName().startsWith(FieldSearchKey.FIELD_XPATH_PATTERN.toString()) ? field.getName() : "";
            if (this.isMetadataCondition(field)) {
                sf = new MetadataValueFieldInfo(ttvxpath, field.getOperator(), value);
                ((MetadataValueFieldInfo)sf).setAssetType(field.getSectionName());
            } else {
                ArrayList<String> values = new ArrayList<String>();
                sf = new PropertyValueField();
                if (field.getName().equals("asset.id")) {
                    ((PropertyValueField)sf).setName(AssetSearchKey.ASSET_ID.toString());
                } else {
                    ((PropertyValueField)sf).setName(AssetSearchKey.ASSET_TYPE.toString());
                    ((PropertyValueField)sf).setEntityClass(Asset.class);
                    ((PropertyValueField)sf).setOperator(field.getOperator());
                    values.add(field.getName());
                }
                if (!value.isEmpty()) {
                    values.add(value);
                }
                ((PropertyValueField)sf).setValues(values);
            }
        } else if (field.isRangeParameter()) {
            sf = new RangeFieldInfo(field.getName(), field.getSectionName(), (String)field.getValues().get(0), (String)field.getValues().get(1), field.getOperator(), field.isConjunction());
        }
        sf.setIgnoreCase(field.getIgnoreCase());
        sf.setConjunction(field.isConjunction());
        return sf;
    }

    private boolean isMetadataCondition(AssetSearchField field) {
        boolean matchesOperator;
        boolean sectionNameDifferentFromProperty = !field.getSectionName().equals(field.getName());
        boolean bl = matchesOperator = field.getOperator().equals((Object)LogicalOperator.CONTAINSUNPARSABLE) || field.getOperator().equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE);
        if (sectionNameDifferentFromProperty) {
            return true;
        }
        return !sectionNameDifferentFromProperty && matchesOperator;
    }

    private FileInfo getFileField(FileSearchField field) {
        String value = field.getValues().size() == 1 ? (String)field.getValues().get(0) : null;
        FileInfo fileInfo = new FileInfo(field.getName(), field.getOperator(), value, field.getParentAssetType(), field.isInvert(), field.isConjunction());
        return fileInfo;
    }

    public String getSortSubQuery(TitleSortInfo sortInfo) {
        if (!sortInfo.getSortEntityClazz().equals(Asset.class) && !sortInfo.getSortEntityClazz().equals(Field.class)) {
            return "";
        }
        return this.assetSearchService.getQuery(this.getSortField(sortInfo));
    }
}

