/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.title.search.entities.SearchColumn;
import com.tandbergtv.cms.title.search.entities.TitleSortInfo;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.AssetSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.SiteQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleAssetJoinBuilder;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.List;

public class QueryHelperBase {
    public static final String SPACEY_ON = "\r\nON (";
    protected static final String TITLE_ALIAS = "T";
    private static final String FIELD_TABLE_ALIAS_BASE = "scf";
    private static final String FIELD_ALIAS_BASE = "sc";
    protected static final String MAIN_ASSET_ALIAS = "PACKAGE_ASSET";
    protected static final TitleSortInfo DEFAULT_SORT = new TitleSortInfo("id", "", SortingOrder.DESCENDING, Title.class);
    protected static final String SITE_ALIAS = "dst";
    protected static final String TITLE_ID = "T." + DBNameFinder.getInstance().getColumnName(Title.class, "id");
    protected static final String LEFT_RELATION = QueryConstants.LEFT_JOIN + DBNameFinder.getInstance().getTableName(Relation.class) + " ";
    protected AssetSearchQueryBuilder asqb = new AssetSearchQueryBuilder();
    private TitleAssetJoinBuilder tajb = new TitleAssetJoinBuilder();
    protected SiteQueryBuilder ssqb = new SiteQueryBuilder();

    protected void populateResultFieldJoins(List<SearchColumn> searchColumns, StringBuilder joins, StringBuilder fieldsInner, StringBuilder fieldsOuter, StringBuilder orderBy, TitleSortInfo sortInfo) {
        int i;
        ArrayList<String> assetsJoined = new ArrayList<String>();
        assetsJoined.add("PACKAGE");
        if (sortInfo.isTitleSort() && sortInfo.getSortItemName().equals("id")) {
            orderBy.append(this.getTitleSort(sortInfo));
        }
        for (i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            String fieldName = sc.getFieldName();
            StringBuilder currentField = new StringBuilder();
            if (!sc.isMetaData() && fieldName.equals("id")) continue;
            if (!sc.isMetaData()) {
                if (sc.getFieldName().equals("status")) {
                    joins.append("JOIN  PMM_TITLESTATUS TITLESTATUS ON( TITLESTATUS.ID_ = T.TITLESTATUSID) \r\n");
                    currentField.append("TITLESTATUS.DESCRIPTION");
                } else if (sc.getFieldName().equals("qsMatchingValue")) {
                    currentField.append("F.VALUE");
                } else {
                    currentField.append(TITLE_ALIAS);
                    currentField.append(".");
                    currentField.append(DBNameFinder.getInstance().getColumnName(Title.class, fieldName));
                }
            } else {
                String field = this.addJoin(joins, assetsJoined, sc.getSectionType(), sc.getFieldName(), i);
                currentField.append(field);
            }
            if (orderBy.length() == 0 && (this.isMetaDataOrderFieldMatch(sortInfo, sc) || this.isTitleOrderFieldMatch(sortInfo, sc))) {
                orderBy.append((CharSequence)currentField);
                orderBy.append(" ");
                orderBy.append(sortInfo.getSqlOrder());
                orderBy.append(", ");
                orderBy.append(this.getTitleSort(DEFAULT_SORT));
            }
            fieldsInner.append((CharSequence)currentField);
            fieldsInner.append(QueryConstants.AS);
            fieldsInner.append(FIELD_ALIAS_BASE);
            fieldsInner.append(i);
            fieldsOuter.append(FIELD_ALIAS_BASE);
            fieldsOuter.append(i);
            if (i >= searchColumns.size() - 1) continue;
            fieldsInner.append(", ");
            fieldsOuter.append(", ");
        }
        this.cleanupOrderBy(orderBy, joins, assetsJoined, sortInfo, i);
    }

    private void cleanupOrderBy(StringBuilder orderBy, StringBuilder joins, List<String> assetsJoined, TitleSortInfo sortInfo, int currentFieldIndex) {
        if (orderBy.length() == 0) {
            if (sortInfo.isTitleSort()) {
                String fieldName = sortInfo.getSortItemName();
                orderBy.append(TITLE_ALIAS);
                orderBy.append(".");
                orderBy.append(DBNameFinder.getInstance().getColumnName(Title.class, fieldName));
            } else if (sortInfo.isMetaDataSort()) {
                String field = this.addJoin(joins, assetsJoined, sortInfo.getAssetType(), sortInfo.getSortItemName(), currentFieldIndex);
                orderBy.append(field);
            } else if (sortInfo.getSortEntityClazz().equals(Site.class)) {
                orderBy.append(SITE_ALIAS);
                orderBy.append("." + this.ssqb.getField(sortInfo.getSortItemName()));
            }
            orderBy.append(" ");
            orderBy.append(sortInfo.getSqlOrder());
            orderBy.append(", ");
            orderBy.append(this.getTitleSort(DEFAULT_SORT));
        }
        orderBy.insert(0, "ORDER BY ");
    }

    private String addJoin(StringBuilder joins, List<String> assetsJoined, String assetType, String xpath, int index) {
        String asset_alias = assetType + "_ASSET";
        if (!assetsJoined.contains(assetType)) {
            assetsJoined.add(assetType);
            joins.append(QueryConstants.LEFT_JOIN);
            joins.append("MDM_ASSET ");
            joins.append(asset_alias);
            joins.append(SPACEY_ON);
            joins.append(asset_alias);
            joins.append(".ROOTASSET_ID = ");
            joins.append(MAIN_ASSET_ALIAS);
            joins.append(".ID  AND ");
            joins.append(asset_alias);
            joins.append(".TYPE='");
            joins.append(assetType);
            joins.append("') \r\n");
        }
        String fieldAlias = FIELD_TABLE_ALIAS_BASE + index;
        joins.append(QueryConstants.LEFT_JOIN);
        joins.append("MDM_FIELD ");
        joins.append(fieldAlias);
        joins.append(SPACEY_ON);
        joins.append(fieldAlias);
        joins.append(".ASSET_ID = ");
        joins.append(asset_alias);
        joins.append(".ID AND ");
        joins.append(fieldAlias);
        joins.append(".TTVXPATH = '");
        joins.append(xpath);
        joins.append("') \r\n");
        return fieldAlias + "." + this.getDataTypeCol(xpath);
    }

    private String getDataTypeCol(String xpath) {
        String dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
        if (dataType.equals("string") || dataType.equals("time") || dataType.equals("boolean")) {
            return "VALUE";
        }
        if (dataType.equals("date")) {
            return "DATEVALUE";
        }
        if (dataType.equals("integer")) {
            return "INTVALUE";
        }
        if (dataType.equals("float")) {
            return "FLOATVALUE";
        }
        return "VALUE";
    }

    private boolean isMetaDataOrderFieldMatch(TitleSortInfo sortInfo, SearchColumn sc) {
        return sortInfo.isMetaDataSort() && sc.isMetaData() && sortInfo.getAssetType().equals(sc.getSectionType()) && sortInfo.getSortItemName().equals(sc.getFieldName());
    }

    private boolean isTitleOrderFieldMatch(TitleSortInfo sortInfo, SearchColumn sc) {
        return sortInfo.isTitleSort() && !sc.isMetaData() && sortInfo.getSortItemName().equals(sc.getFieldName());
    }

    private String getTitleSort(TitleSortInfo sortInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(TITLE_ALIAS);
        sb.append(".");
        sb.append(DBNameFinder.getInstance().getColumnName(Title.class, sortInfo.getSortItemName()));
        sb.append(" ");
        sb.append(sortInfo.getSqlOrder());
        return sb.toString();
    }

    protected void joinOntoAssetMain(StringBuffer sb) {
        String tableName = DBNameFinder.getInstance().getTableName(Asset.class);
        sb.append("\r\nJOIN ");
        sb.append(tableName);
        sb.append(" ");
        sb.append(MAIN_ASSET_ALIAS);
        sb.append(SPACEY_ON);
        sb.append(this.tajb.getJoin(TITLE_ALIAS, MAIN_ASSET_ALIAS));
        sb.append(")");
    }

    protected void appendGroupByTitleId(StringBuffer sb) {
        sb.append("\r\n");
        sb.append("GROUP BY ");
        sb.append(TITLE_ID);
    }
}

