/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.title.search.builder.IMainQueryBuilder;
import com.tandbergtv.cms.title.search.entities.SearchField;
import com.tandbergtv.cms.title.search.entities.SearchFieldNode;
import com.tandbergtv.cms.title.search.entities.SearchFieldNodeList;
import com.tandbergtv.cms.title.search.entities.SiteSearchField;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.watchpoint.pmm.title.search.QueryBuilderHelper;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.List;

public class SiteQueryBuilder
implements IMainQueryBuilder {
    public String getCondition(List<SearchFieldNode> searchFields, String alias) {
        StringBuffer sb = new StringBuffer();
        this.handleSearchFieldNode(sb, searchFields.get(0), alias);
        for (int i = 1; i < searchFields.size(); ++i) {
            SearchFieldNode sfn = searchFields.get(i);
            sb.append(sfn.isConjunction() ? " AND " : " OR ");
            this.handleSearchFieldNode(sb, sfn, alias);
        }
        return sb.toString();
    }

    public String getCondition(SearchFieldNode field, String alias) {
        StringBuffer sb = new StringBuffer();
        this.handleSearchFieldNode(sb, field, alias);
        return sb.toString();
    }

    private void handleSearchFieldNode(StringBuffer sb, SearchFieldNode sfn, String alias) {
        if (sfn instanceof SearchFieldNodeList) {
            sb.append("(");
            sb.append(this.getCondition(((SearchFieldNodeList)sfn).getNodeList(), alias));
            sb.append(")");
        } else if (sfn instanceof SiteSearchField) {
            SearchField sf = (SearchField)sfn;
            LogicalOperator lop = sf.getOperator();
            List values = sf.getValues();
            String fieldName = this.getField(sf.getName());
            SearchType searchType = sf.getSearchType();
            sb.append(QueryBuilderHelper.getCondition(fieldName, lop, values, alias, searchType));
        }
    }

    public String getField(String fieldName) {
        if (fieldName.equals("id")) {
            return "ID_";
        }
        if (fieldName.equals("title")) {
            return "titleId";
        }
        if (fieldName.equals("distributionSite")) {
            return "siteId";
        }
        if (fieldName.equals("status")) {
            return "status";
        }
        return "";
    }
}

