/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.title.search.builder.IMainQueryBuilder;
import com.tandbergtv.cms.title.search.entities.SearchField;
import com.tandbergtv.cms.title.search.entities.SearchFieldNode;
import com.tandbergtv.cms.title.search.entities.SearchFieldNodeList;
import com.tandbergtv.cms.title.search.entities.TitleSearchField;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.search.QueryBuilderHelper;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.ArrayList;
import java.util.List;

public class TitleSearchQueryBuilder
implements IMainQueryBuilder {
    public static final String TITLE_STATUS = "status";

    public String getCondition(List<SearchFieldNode> searchFields, String alias) {
        StringBuffer sb = new StringBuffer();
        this.handleSearchFieldNode(sb, searchFields.get(0), alias);
        for (int i = 1; i < searchFields.size(); ++i) {
            SearchFieldNode sfn = searchFields.get(i);
            sb.append(sfn.isConjunction() ? " AND " : " OR ");
            this.handleSearchFieldNode(sb, sfn, alias);
        }
        return sb.toString();
    }

    public String getCondition(SearchFieldNode searchField, String alias) {
        StringBuffer sb = new StringBuffer();
        this.handleSearchFieldNode(sb, searchField, alias);
        return sb.toString();
    }

    private void handleSearchFieldNode(StringBuffer sb, SearchFieldNode sfn, String alias) {
        if (sfn instanceof SearchFieldNodeList) {
            sb.append("(");
            sb.append(this.getCondition(((SearchFieldNodeList)sfn).getNodeList(), alias));
            sb.append(")");
        } else if (sfn instanceof TitleSearchField) {
            SearchField sf = (SearchField)sfn;
            LogicalOperator lop = sf.getOperator();
            List<String> values = sf.getValues();
            String fieldName = this.getField(sf.getName());
            SearchType searchType = sf.getSearchType();
            if (sf.getName().equals(TITLE_STATUS)) {
                values = this.convertTitleStatus(values);
                searchType = SearchType.NUMERIC;
            }
            sb.append(QueryBuilderHelper.getCondition(fieldName, lop, values, alias, searchType));
        }
    }

    private String getField(String fieldName) {
        String col = DBNameFinder.getInstance().getColumnName(Title.class, fieldName);
        return col;
    }

    private List<String> convertTitleStatus(List<String> statuses) {
        ArrayList<String> result = new ArrayList<String>();
        for (String str : statuses) {
            result.add(String.valueOf(TitleStatus.valueOf((String)str).ordinal()));
        }
        return result;
    }
}

