/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.cms.title.search.entities.AssetSearchField;
import com.tandbergtv.cms.title.search.entities.FileSearchField;
import com.tandbergtv.cms.title.search.entities.PagingInfo;
import com.tandbergtv.cms.title.search.entities.ParamType;
import com.tandbergtv.cms.title.search.entities.SearchColumn;
import com.tandbergtv.cms.title.search.entities.SearchField;
import com.tandbergtv.cms.title.search.entities.SearchFieldNode;
import com.tandbergtv.cms.title.search.entities.SearchFieldNodeList;
import com.tandbergtv.cms.title.search.entities.SiteSearchField;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.title.search.entities.TitleSearchField;
import com.tandbergtv.cms.title.search.entities.TitleSortInfo;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.QueryHelperBase;
import com.tandbergtv.watchpoint.pmm.title.search.TitleAssetSubQueryJoinBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSiteJoinBuilder;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleSearchQueryHelper
extends QueryHelperBase {
    private static final Logger logger = Logger.getLogger(TitleSearchQueryHelper.class);
    private static final String SQ_ASSET_ALIAS = "a2";
    private TitleSearchQueryBuilder tsqb = new TitleSearchQueryBuilder();
    private TitleSiteJoinBuilder tsjb = new TitleSiteJoinBuilder();
    private TitleAssetSubQueryJoinBuilder assetSubQueryJB = new TitleAssetSubQueryJoinBuilder();

    public String getCountQuery(List<SearchFieldNode> searchFields, boolean includeMasters, boolean includeNonSiteCopies, boolean includeSiteCopies, List<Integer> siteIds, SiteType siteType, List<Long> partnerIds) {
        Map<Class<?>, List<SearchFieldNode>> lookup = this.breakApartSearch(searchFields);
        boolean leftAssetSub = this.leftJoinOnAssetSub(searchFields, lookup, null);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT count(*) as cnt");
        boolean joinOntoSite = !siteIds.isEmpty() || includeSiteCopies ^ includeNonSiteCopies;
        this.putFromTogether(sb, lookup, null, joinOntoSite, siteType, leftAssetSub);
        String specialConditions = this.getSpecialCriteria(includeMasters, includeNonSiteCopies, includeSiteCopies, siteIds, siteType);
        this.buildWhere(sb, lookup, specialConditions, leftAssetSub, partnerIds);
        String result = sb.toString();
        logger.debug((Object)result);
        return result;
    }

    public String getQuery(List<SearchFieldNode> searchFields, TitleSortInfo sortInfo, PagingInfo pagingInfo, boolean includeMasters, boolean includeNonSiteCopies, boolean includeSiteCopies, Collection<Integer> siteIds, SiteType siteType, boolean includeCount, List<SearchColumn> searchColumns, List<Long> partnerIds) {
        if (sortInfo == null) {
            sortInfo = DEFAULT_SORT;
        }
        StringBuilder scFieldsInner = new StringBuilder();
        StringBuilder scFieldsOuter = new StringBuilder();
        StringBuilder scJoins = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        this.populateResultFieldJoins(searchColumns, scJoins, scFieldsInner, scFieldsOuter, orderBy, sortInfo);
        Map<Class<?>, List<SearchFieldNode>> lookup = this.breakApartSearch(searchFields);
        boolean leftAssetSub = this.leftJoinOnAssetSub(searchFields, lookup, sortInfo);
        StringBuffer sb = new StringBuffer();
        sb.append(QueryConstants.SELECT);
        if (pagingInfo != null) {
            sb.append("rownum rnum, ");
        }
        sb.append(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
        if (scFieldsOuter.length() > 0) {
            sb.append(",");
            sb.append((CharSequence)scFieldsOuter);
        }
        if (includeCount) {
            sb.append(",  cnt");
        }
        sb.append(" FROM (");
        sb.append(QueryConstants.SELECT);
        sb.append(TITLE_ID);
        if (scFieldsInner.length() > 0) {
            sb.append(", ");
            sb.append((CharSequence)scFieldsInner);
        }
        sb.append(", ROW_NUMBER() OVER(PARTITION BY T.ID_ ORDER BY T.ID_) RN");
        if (includeCount) {
            sb.append(", count(DISTINCT " + TITLE_ID + ") over( ) cnt ");
        }
        boolean joinOntoSite = !siteIds.isEmpty() || includeSiteCopies ^ includeNonSiteCopies;
        this.putFromTogether(sb, lookup, sortInfo, joinOntoSite, siteType, leftAssetSub);
        sb.append((CharSequence)scJoins);
        String specialConditions = this.getSpecialCriteria(includeMasters, includeNonSiteCopies, includeSiteCopies, siteIds, siteType);
        this.buildWhere(sb, lookup, specialConditions, leftAssetSub, partnerIds);
        sb.append("\r\n");
        sb.append((CharSequence)orderBy);
        sb.append(")\r\n WHERE RN = 1");
        if (pagingInfo != null) {
            this.wrapWithPagingClause(sb, pagingInfo, includeCount, scFieldsOuter);
        }
        String result = sb.toString();
        logger.debug((Object)result);
        return result;
    }

    private boolean leftJoinOnAssetSub(List<SearchFieldNode> searchFields, Map<Class<?>, List<SearchFieldNode>> lookup, TitleSortInfo sortInfo) {
        if (searchFields.size() > 0) {
            return !searchFields.get(0).isConjunction() && lookup.size() > 1 && lookup.containsKey(AssetSearchField.class);
        }
        return sortInfo != null && (sortInfo.getSortEntityClazz().equals(Asset.class) || sortInfo.getSortEntityClazz().equals(Field.class));
    }

    private void putFromTogether(StringBuffer sb, Map<Class<?>, List<SearchFieldNode>> lookup, TitleSortInfo sortInfo, boolean joinOntoSite, SiteType siteType, boolean leftAssetSub) {
        String table = DBNameFinder.getInstance().getTableName(Title.class);
        sb.append(" \r\nFROM ");
        sb.append(table);
        sb.append(" ");
        sb.append("T");
        this.joinOntoAssetMain(sb);
        if (joinOntoSite) {
            this.joinOntoSite(sb, siteType);
        }
        this.joinOntoAssetSubQuery(sb, lookup.get(AssetSearchField.class), leftAssetSub);
    }

    private void joinOntoSite(StringBuffer sb, SiteType siteType) {
        String tableName = siteType == SiteType.DISTRIBUTION_SITE ? "SITES_DISTSITETITLE" : "SITES_TRACKSITETITLE";
        sb.append("\r\nLEFT JOIN ");
        sb.append(tableName);
        sb.append(" ");
        sb.append("dst");
        sb.append("\r\nON (");
        sb.append(this.tsjb.getJoin("T", "dst"));
        sb.append(")");
    }

    private void joinOntoAssetSubQuery(StringBuffer sb, List<SearchFieldNode> criteria, boolean leftAssetSub) {
        if (criteria != null && criteria.size() > 0) {
            sb.append("\r\n");
            if (leftAssetSub) {
                sb.append("LEFT ");
            }
            sb.append("JOIN (");
            sb.append(this.asqb.getSearchSubQuery(criteria, null));
            sb.append(") ");
            sb.append(SQ_ASSET_ALIAS);
            sb.append("\r\nON (");
            sb.append("");
            sb.append(this.assetSubQueryJB.getJoin("T", SQ_ASSET_ALIAS));
            sb.append(")");
        }
    }

    private void buildWhere(StringBuffer sb, Map<Class<?>, List<SearchFieldNode>> lookup, String specialConditions, boolean leftOnAssetSub, List<Long> partnerIds) {
        sb.append(" WHERE ");
        boolean addedMainCondtion = false;
        sb.append(" ");
        sb.append(this.asqb.getDefaultConditions("PACKAGE_ASSET"));
        sb.append(" ");
        if (lookup.containsKey(TitleSearchField.class)) {
            sb.append("\r\n AND (");
            sb.append("(");
            sb.append(this.tsqb.getCondition(lookup.get(TitleSearchField.class), "T"));
            addedMainCondtion = true;
            sb.append(")");
            if (leftOnAssetSub) {
                if (addedMainCondtion) {
                    sb.append(" OR ");
                }
                sb.append(SQ_ASSET_ALIAS);
                sb.append(".assetId IS NOT NULL");
                addedMainCondtion = true;
            }
            sb.append(")");
        }
        if (!partnerIds.isEmpty()) {
            sb.append(" AND T.Partner_Id in (");
            Iterator<Long> iterator = partnerIds.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (!specialConditions.isEmpty()) {
            sb.append(" \r\n AND (");
            sb.append(specialConditions);
            sb.append(")");
        }
    }

    private String getSpecialCriteria(boolean includeMasters, boolean includeNonSiteCopies, boolean includeSiteCopies, Collection<Integer> siteIds, SiteType siteType) {
        StringBuffer result = new StringBuffer();
        if (includeMasters && includeNonSiteCopies && includeSiteCopies && siteIds.isEmpty()) {
            return "";
        }
        String origIdIsNotNull = this.tsqb.getCondition((SearchFieldNode)new TitleSearchField("originalId", SearchType.NUMERIC, LogicalOperator.ISNOTEMPTY, ParamType.VALUE, false, true), "T");
        String origIdIsNull = this.tsqb.getCondition((SearchFieldNode)new TitleSearchField("originalId", SearchType.NUMERIC, LogicalOperator.ISEMPTY, ParamType.VALUE, false, true), "T");
        String hasSite = this.ssqb.getCondition((SearchFieldNode)new SiteSearchField(false, "id", SearchType.NUMERIC, LogicalOperator.ISNOTEMPTY, ParamType.VALUE, false, siteType), "dst");
        String noSite = this.ssqb.getCondition((SearchFieldNode)new SiteSearchField(false, "id", SearchType.NUMERIC, LogicalOperator.ISEMPTY, ParamType.VALUE, false, siteType), "dst");
        if (includeMasters && includeNonSiteCopies && includeSiteCopies) {
            result.append(noSite);
            result.append(" OR ");
            result.append(this.getSiteIn(siteIds, siteType));
        } else if (includeMasters && includeNonSiteCopies) {
            result.append(noSite);
        } else if (includeNonSiteCopies && includeSiteCopies && siteIds.isEmpty()) {
            result.append(origIdIsNotNull);
        } else if (includeNonSiteCopies && includeSiteCopies && !siteIds.isEmpty()) {
            result.append(origIdIsNotNull);
            result.append(" AND (");
            result.append(noSite);
            result.append(" OR ");
            result.append(this.getSiteIn(siteIds, siteType));
            result.append(")");
        } else if (includeMasters && includeSiteCopies && siteIds.isEmpty()) {
            result.append(origIdIsNull);
            result.append(" OR ");
            result.append(hasSite);
        } else if (includeMasters && includeSiteCopies && !siteIds.isEmpty()) {
            result.append(origIdIsNull);
            result.append(" OR ");
            result.append(this.getSiteIn(siteIds, siteType));
        } else {
            if (includeMasters) {
                return origIdIsNull;
            }
            if (includeNonSiteCopies) {
                result.append(origIdIsNotNull);
                result.append(" AND ");
                result.append(noSite);
            } else {
                if (includeSiteCopies && siteIds.isEmpty()) {
                    return hasSite;
                }
                if (includeSiteCopies && !siteIds.isEmpty()) {
                    return this.getSiteIn(siteIds, siteType);
                }
            }
        }
        return result.toString();
    }

    private String getSiteIn(Collection<Integer> sitesCopiesToInclude, SiteType siteType) {
        ArrayList<String> values = new ArrayList<String>();
        for (Integer id : sitesCopiesToInclude) {
            values.add(String.valueOf(id));
        }
        return this.ssqb.getCondition((SearchFieldNode)new SiteSearchField(false, "distributionSite", values, SearchType.NUMERIC, LogicalOperator.IN, ParamType.VALUE, false, siteType), "dst");
    }

    private void wrapWithPagingClause(StringBuffer sb, PagingInfo info, boolean includeCnt, StringBuilder scFieldsOuter) {
        int startIndex = info.getStartIndex();
        int endIndex = info.getStartIndex() + info.getMaxRecordCount() + 1;
        StringBuilder insert = new StringBuilder(QueryConstants.SELECT);
        insert.append(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
        if (scFieldsOuter.length() > 0) {
            insert.append(",");
            insert.append((CharSequence)scFieldsOuter);
        }
        if (includeCnt) {
            insert.append(", cnt");
        }
        insert.append("\r\nFROM (");
        sb.insert(0, insert);
        sb.append(" AND ROWNUM < ");
        sb.append(endIndex);
        sb.append(" ) WHERE RNUM > ");
        sb.append(startIndex);
    }

    private Map<Class<?>, List<SearchFieldNode>> breakApartSearch(List<SearchFieldNode> searchfields) {
        HashMap lookup = new HashMap();
        this.breakApartSearch(searchfields, lookup);
        return lookup;
    }

    private void breakApartSearch(List<SearchFieldNode> searchfields, Map<Class<?>, List<SearchFieldNode>> mainCondition) {
        Class type = null;
        for (SearchFieldNode sfn : searchfields) {
            if (sfn instanceof SearchFieldNodeList) {
                SearchFieldNodeList snfl = (SearchFieldNodeList)sfn;
                type = this.getListType(snfl);
                if (snfl.getNodeList().size() == 1) {
                    sfn = (SearchFieldNode)snfl.getNodeList().get(0);
                }
            } else if (sfn instanceof FileSearchField) {
                type = AssetSearchField.class;
            } else if (sfn instanceof SearchField) {
                type = sfn.getClass();
            }
            if (type == null) continue;
            if (!mainCondition.containsKey(type)) {
                mainCondition.put(type, new ArrayList());
            }
            mainCondition.get(type).add(sfn);
        }
    }

    private Class<?> getListType(SearchFieldNodeList snfl) {
        SearchFieldNode sub = (SearchFieldNode)snfl.getNodeList().get(0);
        if (sub instanceof SearchFieldNodeList) {
            return this.getListType((SearchFieldNodeList)sub);
        }
        if (sub instanceof FileSearchField) {
            return AssetSearchField.class;
        }
        return sub.getClass();
    }
}

