/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.thumbnail;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.PartnerThumbnail;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleThumbnailReader;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.hibernate.Query;
import org.hibernate.Session;

public class TitleThumbnailReader
implements ITitleThumbnailReader {
    private static final Logger logger = Logger.getLogger(TitleThumbnailReader.class);

    @Transactional
    public InputStream getThumbnail(long titleId) {
        long l = titleId;
        return (InputStream)TitleThumbnailReader.getThumbnail_aroundBody1$advice(this, l, TransactionEnforcer.aspectOf(), TitleThumbnailReader.class.getDeclaredMethod("getThumbnail", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public InputStream getThumbnail(long titleId, long assetId) {
        long l = titleId;
        long l2 = assetId;
        return (InputStream)TitleThumbnailReader.getThumbnail_aroundBody3$advice(this, l, l2, TransactionEnforcer.aspectOf(), TitleThumbnailReader.class.getDeclaredMethod("getThumbnail", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    private InputStream getPartnerThumbnail(long titleId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String queryString = "SELECT thumbnail FROM PartnerThumbnail thumbnail, Title title WHERE thumbnail.partnerId = title.partnerId and title.id = :titleID";
            Query query = session.createQuery(queryString);
            query.setParameter("titleID", (Object)titleId);
            PartnerThumbnail partnerThumbnail = (PartnerThumbnail)query.uniqueResult();
            if (partnerThumbnail != null && partnerThumbnail.getThumbnailImage() != null) {
                return new ByteArrayInputStream(partnerThumbnail.getThumbnailImage());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to read partner thumbnail for title[#" + titleId + "], error: " + e.getLocalizedMessage()));
        }
        return null;
    }

    public String getServiceName() {
        return this.getClass().getName();
    }

    public void start() {
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    private static final /* synthetic */ InputStream getThumbnail_aroundBody0(TitleThumbnailReader this_, long titleId) {
        InputStream stream = null;
        try {
            IAssetTypesConfigurationService service = this_.getService(IAssetTypesConfigurationService.class);
            List assetTypes = service.getThumbnailAssetTypes();
            Session session = HibernateContext.getContext().getCurrentSession();
            String queryString = "SELECT property.assetId, asset.type, property.value FROM TitleAssetProperty property, Asset asset WHERE property.assetId = asset.id and property.name = 'THUMBNAIL' AND property.titleId = :titleID";
            Query query = session.createQuery(queryString);
            query.setParameter("titleID", (Object)titleId);
            List results = query.list();
            ArrayList<AssetThumbnail> thumbnails = new ArrayList<AssetThumbnail>();
            for (Object result : results) {
                Object[] values = (Object[])result;
                Long assetId = (Long)values[0];
                String assetType = (String)values[1];
                String value = (String)values[2];
                if (!assetTypes.contains(assetType)) continue;
                thumbnails.add(new AssetThumbnail(assetId, assetType, value));
            }
            Collections.sort(thumbnails, new AssetThumbnailComparator(assetTypes));
            for (AssetThumbnail thumbnail : thumbnails) {
                try {
                    stream = new FileInputStream(new File(thumbnail.thumbnailPath));
                    break;
                }
                catch (Exception e) {
                    String msg = "Failed to read thumbnail: " + thumbnail.thumbnailPath + ", error: " + e.getLocalizedMessage();
                    logger.warn((Object)msg);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to get thumbnail for title[#" + titleId + "], using default. Error: " + e.getLocalizedMessage()));
        }
        if (stream == null) {
            stream = this_.getPartnerThumbnail(titleId);
        }
        return stream;
    }

    private static final /* synthetic */ Object getThumbnail_aroundBody1$advice(TitleThumbnailReader this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleThumbnailReader.getThumbnail_aroundBody0(this_, titleId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            InputStream object = TitleThumbnailReader.getThumbnail_aroundBody0(this_, titleId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ InputStream getThumbnail_aroundBody2(TitleThumbnailReader this_, long titleId, long assetId) {
        ITitleAssetResourceManager resourceManager = this_.getService(ITitleAssetResourceManager.class);
        TitleAssetResource resource = resourceManager.getThumbnail(titleId, assetId);
        if (resource != null) {
            try {
                return new FileInputStream(new File(resource.getResourcePath()));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read thumbnail: " + resource.getResourcePath() + ", error: " + e.getLocalizedMessage()));
            }
        }
        return null;
    }

    private static final /* synthetic */ Object getThumbnail_aroundBody3$advice(TitleThumbnailReader this_, long titleId, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleThumbnailReader.getThumbnail_aroundBody2(this_, titleId, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            InputStream object = TitleThumbnailReader.getThumbnail_aroundBody2(this_, titleId, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            throw new RuntimeException(e);
        }
    }

    private static final class AssetThumbnailComparator
    implements Comparator<AssetThumbnail> {
        List<String> assetTypes;

        public AssetThumbnailComparator(List<String> assetTypes) {
            this.assetTypes = assetTypes;
        }

        @Override
        public int compare(AssetThumbnail o1, AssetThumbnail o2) {
            int typeIndex2;
            int typeIndex1 = this.assetTypes.indexOf(o1.assetType);
            if (typeIndex1 != (typeIndex2 = this.assetTypes.indexOf(o2.assetType))) {
                Integer index1 = typeIndex1 < 0 ? Integer.MAX_VALUE : new Integer(typeIndex1);
                Integer index2 = typeIndex2 < 0 ? Integer.MAX_VALUE : new Integer(typeIndex2);
                return index1.compareTo(index2);
            }
            Long assetId1 = o1.assetId;
            Long assetId2 = o2.assetId;
            return assetId1.compareTo(assetId2);
        }
    }

    private static final class AssetThumbnail {
        long assetId;
        String assetType;
        String thumbnailPath;

        public AssetThumbnail(long assetId, String assetType, String thumbnailPath) {
            this.assetId = assetId;
            this.assetType = assetType;
            this.thumbnailPath = thumbnailPath;
        }
    }
}

