/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.service.IServiceManagement;
import com.tandbergtv.watchpoint.pmm.service.ServiceManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ContainerCache
extends CacheService<IContainer> {
    private static String SERVICE_NAME = "Container Cache";
    private static int THREAD_FACTORY_THREAD_COUNT = 3;
    public static int MAX_CONTAINER_COUNT = 250;
    private Logger logger = Logger.getLogger(ContainerCache.class);
    private static ICacheService<IContainer> instance;
    private ScheduledThreadPoolExecutor executor;

    protected ContainerCache() {
        super(SERVICE_NAME, MAX_CONTAINER_COUNT);
    }

    public static synchronized ICacheService<IContainer> getInstance() {
        if (instance == null) {
            instance = new ContainerCache();
        }
        return instance;
    }

    public void start() {
        this.logger.debug((Object)"Starting Container Cache service.");
        super.start();
        this.logger.debug((Object)"Loading partners and services in the background now.");
        this.executor = new ScheduledThreadPoolExecutor(THREAD_FACTORY_THREAD_COUNT);
        this.populatePartners();
        this.populateServices();
        this.populateSites();
        this.logger.debug((Object)"Done starting the cache.");
    }

    public void stop() {
        this.executor.shutdown();
    }

    private List<Partner> populatePartners() {
        Callable<List<Partner>> starterThread = new Callable<List<Partner>>(){

            @Override
            public List<Partner> call() throws Exception {
                IPartnerManagement partnerMgr = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
                List partners = partnerMgr.getAllActivePartners();
                ContainerCache.this.logger.debug((Object)("Got " + partners.size() + " partners from db."));
                for (Partner p : partners) {
                    ContainerCache.this.add(Long.valueOf(p.getContainerContextId()), p);
                }
                ContainerCache.this.logger.debug((Object)("Cache has " + ContainerCache.this.count() + " containers."));
                return partners;
            }
        };
        this.executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        return null;
    }

    private List<Service> populateServices() {
        Callable<List<Service>> starterThread = new Callable<List<Service>>(){

            @Override
            public List<Service> call() throws Exception {
                IServiceManagement serviceMgr = ServiceManager.getInstance();
                List services = serviceMgr.getAllActiveServices();
                ContainerCache.this.logger.debug((Object)("Got " + services.size() + " services from db."));
                for (Service s : services) {
                    ContainerCache.this.add(Long.valueOf(s.getContainerContextId()), s);
                }
                ContainerCache.this.logger.debug((Object)("Cache has " + ContainerCache.this.count() + " containers."));
                return services;
            }
        };
        this.executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        return null;
    }

    private List<Site> populateSites() {
        Callable<List<Site>> starterThread = new Callable<List<Site>>(){

            @Override
            public List<Site> call() {
                ContainerCache.this.logger.info((Object)"Populating sites now.");
                for (int i = 0; i < 10; ++i) {
                    ISiteManager siteManager = null;
                    try {
                        siteManager = (ISiteManager)new InitialContext().lookup("cms/SiteManager/local");
                    }
                    catch (NamingException e1) {
                        ContainerCache.this.logger.error((Object)"Error when looking up site manager: ", (Throwable)e1);
                    }
                    if (siteManager == null) {
                        ContainerCache.this.logger.debug((Object)"Will wait for SiteManager EJB to be up...");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            ContainerCache.this.logger.error((Object)"Error while sleeping: ", (Throwable)e);
                        }
                        if (i != 9) continue;
                        ContainerCache.this.logger.error((Object)"Unable to load site contexts into container cache. Reason: Unable to get SiteManager");
                        return null;
                    }
                    ContainerCache.this.logger.info((Object)"Got site manager ejb....");
                    List allSites = siteManager.getAllSites();
                    if (allSites != null) {
                        for (int j = 0; j < allSites.size(); ++j) {
                            try {
                                ContainerCache.this.add(Long.valueOf(((Site)allSites.get(j)).getContainerContextId()), allSites.get(j));
                                continue;
                            }
                            catch (Exception e) {
                                ContainerCache.this.logger.error((Object)"Error while reading container context id: ", (Throwable)e);
                            }
                        }
                    }
                    ContainerCache.this.logger.info((Object)("Added " + allSites.size() + " sites to container cache."));
                    return allSites;
                }
                ContainerCache.this.logger.info((Object)"Didnt find any sites");
                return new ArrayList<Site>();
            }
        };
        this.executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        return null;
    }
}

