/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import com.jinfonet.awt.JFont;
import guitools.Painter;
import guitools.toolkit.RepaintImageListener;
import guitools.toolkit.TComponent;
import guitools.toolkit.TextCaret;
import guitools.toolkit.TextDoAction;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.image.ImageObserver;
import java.util.Stack;
import jet.log.JRLogger;

public class TextComp
extends TComponent
implements KeyListener,
FocusListener,
MouseListener,
MouseMotionListener,
RepaintImageListener {
    public static final int TOP = 0;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 2;
    private static final Insets QOIV = new Insets(3, 4, 3, 4);
    int actionPerformed = 0;
    int add = 1;
    boolean addNotify;
    boolean addRepaintImageListener;
    boolean adjustString;
    String append = "";
    boolean beep = true;
    boolean bottom;
    int charAt;
    int charWidth;
    char class$;
    String clipRect;
    transient ActionListener consume;
    protected transient TextListener textListener;
    boolean control;
    int controlDkShadow;
    int controlHighlight;
    int controlLtHighlight;
    int controlShadow;
    FontMetrics copy;
    TextCaret createImage = new TextCaret((Component)((Object)this), 600L);
    Image cut;
    Image delChar;
    static final Stack delWord = new Stack();
    static final Stack dispose = new Stack();
    static Clipboard drawArea = null;
    private static JRLogger drawImage = JRLogger.getLogger((String)(class$guitools$toolkit$TextComp == null ? (class$guitools$toolkit$TextComp = TextComp.class$("guitools.toolkit.TextComp")) : class$guitools$toolkit$TextComp).getName());
    boolean drawLine = true;
    static Class class$guitools$toolkit$TextComp;

    public TextComp() {
        this("");
    }

    public TextComp(String string) {
        this.enableEvents(60L);
        this.append = string == null ? "" : string;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        super.reshape(n, n2, n3, n4);
        if (n3 != dimension.width && dimension.height != n4) {
            this.updateTextPos();
            this.updateCaretPos();
            this.updateBackImage();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.copy == null) {
            Font font = this.getFont();
            this.copy = font instanceof JFont ? ((JFont)font).getFontMetrics() : this.getToolkit().getFontMetrics(font);
        }
        if (this.tpb != null) {
            this.tpb.addRepaintImageListener((RepaintImageListener)this);
        }
    }

    public void removeNotify() {
        this.createImage.stop();
        super.removeNotify();
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.isShowing()) {
            this.copy = font instanceof JFont ? ((JFont)font).getFontMetrics() : this.getToolkit().getFontMetrics(font);
            this.updateTextPos();
        } else {
            this.copy = null;
        }
        if (!this.updateCaretPos()) {
            this.repaint();
        }
    }

    public synchronized void setText(String string) {
        String string2 = string = string == null ? "" : string;
        if (!this.append.equals(string)) {
            int n;
            this.append = string;
            int n2 = string.length();
            int n3 = this.charAt > n2 ? n2 : this.charAt;
            int n4 = n = this.charWidth > n2 ? n2 : this.charWidth;
            if (n3 != this.charAt || n != this.charWidth) {
                this.charAt = n3;
                this.charWidth = n;
                this.updateCaretPos();
            }
            this.processEvent(new TextEvent(this, 900));
            this.updateTextPos();
            this.repaint();
        }
    }

    public synchronized String getText() {
        return this.append;
    }

    public synchronized String getSelectedText() {
        int n = this.charAt < this.charWidth ? this.charAt : this.charWidth;
        int n2 = this.charAt > this.charWidth ? this.charAt : this.charWidth;
        String string = this.append.substring(n, n2);
        if (this.echoCharIsSet()) {
            String string2 = "";
            int n3 = 0;
            while (n3 < string.length()) {
                string2 = string2 + this.class$;
                ++n3;
            }
            string = string2;
        }
        return string;
    }

    public boolean isEditable() {
        return this.beep;
    }

    public synchronized void setEditable(boolean bl) {
        this.beep = bl;
    }

    public boolean isOvercast() {
        return this.bottom;
    }

    public synchronized void setOvercast(boolean bl) {
        this.bottom = bl;
    }

    public synchronized int getSelectionStart() {
        return this.charAt;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.charWidth);
    }

    public synchronized int getSelectionEnd() {
        return this.charWidth;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.charAt, n);
    }

    public synchronized void select(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.append.length();
        int n6 = n < 0 ? 0 : (n4 = n > n5 ? n5 : n);
        int n7 = n2 < 0 ? 0 : (n3 = n2 > n5 ? n5 : n2);
        if (n4 != this.charAt || n3 != this.charWidth) {
            boolean bl = this.charAt != this.charWidth;
            this.charAt = n4;
            this.charWidth = n3;
            if (!this.updateCaretPos() && (n4 != n3 || bl)) {
                this.repaint();
            }
        }
    }

    public synchronized void selectAll() {
        this.charAt = 0;
        this.charWidth = this.append.length();
        if (!this.updateCaretPos()) {
            this.repaint();
        }
    }

    public void setCaretPosition(int n) {
        if (this.charAt != this.charWidth || this.charAt != n) {
            String string = this.echo();
            if (n < 0) {
                Toolkit.getDefaultToolkit().beep();
                n = 0;
            }
            boolean bl = this.charAt != this.charWidth;
            int n2 = string.length();
            if (n > n2) {
                Toolkit.getDefaultToolkit().beep();
                n = n2;
            }
            this.charAt = n;
            this.charWidth = n;
            if (!this.updateCaretPos() && bl) {
                this.repaint();
            }
        }
    }

    public int getCaretPosition() {
        return this.charWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.createImage.isAlive() && this.isVisible()) {
            this.createImage.setVisible(false);
            Dimension dimension = this.getSize();
            n = n < 0 ? 0 : n;
            n2 = n2 < 0 ? 0 : n2;
            n3 = (n3 += n) > dimension.width ? dimension.width - n : n3 - n;
            n4 = n4 > dimension.height ? dimension.height - n2 : (n4 += n2) - n2;
            this.editorPaint(n, n2, n3, n4);
            super.repaint(l, n, n2, n3, n4);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    if (this.delChar != null) {
                        graphics.clipRect(n, n2, n3, n4);
                        graphics.drawImage(this.delChar, 0, 0, (ImageObserver)((Object)this));
                    }
                    Object var10_8 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            if (this.isEnabled()) {
                this.createImage.setVisible(true);
            }
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            if (this.drawLine) {
                this.updateTextPos();
            }
            if (this.createImage.isAlive() && !this.control) {
                if (this.delChar != null) {
                    graphics.drawImage(this.delChar, 0, 0, (ImageObserver)((Object)this));
                }
            } else {
                Dimension dimension = this.getSize();
                if (this.hasEraser()) {
                    if (this.beep && this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(SystemColor.control);
                    }
                    graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
                }
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(0, 0, dimension.width - 1, 0);
                graphics.drawLine(0, 0, 0, dimension.height - 1);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(1, 1, dimension.width - 2, 1);
                graphics.drawLine(1, 1, 1, dimension.height - 2);
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
                graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                if (!this.control) {
                    this.drawText(graphics, dimension.width, dimension.height);
                }
            }
        }
    }

    protected void drawText(Graphics graphics, int n, int n2) {
        String string = this.echo();
        int n3 = string.length();
        int n4 = this.copy.getMaxAscent();
        int n5 = this.createImage.isAlive() ? this.controlDkShadow : this.controlLtHighlight;
        int n6 = this.createImage.isAlive() ? this.controlHighlight : this.controlShadow;
        int n7 = this.copy.stringWidth(string);
        int n8 = n4 + this.copy.getMaxDescent();
        graphics.clipRect(TextComp.QOIV.left, TextComp.QOIV.top, n - TextComp.QOIV.left - TextComp.QOIV.right, n2 - TextComp.QOIV.top - TextComp.QOIV.bottom);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawString(string, n5, n6 + n4);
        if (this.addNotify) {
            graphics.drawLine(n5, n6 + n8, n5 + n7, n6 + n8);
        }
        if (this.addRepaintImageListener) {
            graphics.drawLine(n5, n6 + n4 * 2 / 3, n5 + n7, n6 + n4 * 2 / 3);
        }
        if (this.createImage.isAlive()) {
            int n9;
            int n10;
            int n11 = this.charAt == 0 ? this.controlDkShadow : (n10 = this.charAt == n3 ? this.controlDkShadow + n7 : this.controlDkShadow + this.copy.stringWidth(string.substring(0, this.charAt)));
            int n12 = this.charWidth == this.charAt ? n10 : (this.charWidth == 0 ? this.controlDkShadow : (n9 = this.charWidth == n3 ? this.controlDkShadow + n7 : this.controlDkShadow + this.copy.stringWidth(string.substring(0, this.charWidth))));
            if (n10 != n9) {
                graphics.setXORMode(new Color(this.getBackground().getRGB()));
                graphics.setColor(this.getForeground());
                graphics.fillRect(n10 < n9 ? n10 : n9, n6, n10 < n9 ? n9 - n10 : n10 - n9, n8);
                graphics.setPaintMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editorPaint(int n, int n2, int n3, int n4) {
        if (this.delChar != null) {
            int n5 = this.delChar.getWidth((ImageObserver)((Object)this));
            int n6 = this.delChar.getHeight((ImageObserver)((Object)this));
            Graphics graphics = this.delChar.getGraphics();
            try {
                if (this.hasEraser()) {
                    if (this.beep && this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(SystemColor.control);
                    }
                    graphics.fillRect(0, 0, n5, n6);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(0, 0, n5 - 1, 0);
                    graphics.drawLine(0, 0, 0, n6 - 1);
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(1, 1, n5 - 2, 1);
                    graphics.drawLine(1, 1, 1, n6 - 2);
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 2);
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
                    graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
                } else if (this.cut != null) {
                    graphics.drawImage(this.cut, 0, 0, (ImageObserver)((Object)this));
                }
                this.drawText(graphics, n5, n6);
                Object var9_8 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    public void setAlignments(int n, int n2) {
        boolean bl = false;
        if (this.actionPerformed != n && n >= 0 && n <= 2) {
            this.actionPerformed = n;
            bl = true;
        }
        if (this.add != n2 && n2 >= 0 && n2 <= 2) {
            this.add = n2;
            bl = true;
        }
        if (bl) {
            this.updateTextPos();
            if (!this.updateCaretPos()) {
                this.repaint();
            }
        }
    }

    public int getHAlignment() {
        return this.actionPerformed;
    }

    public int getVAlignment() {
        return this.add;
    }

    public void setUnderline(boolean bl) {
        if (this.addNotify != bl) {
            this.addNotify = bl;
            this.repaint();
        }
    }

    public boolean getUnderline() {
        return this.addNotify;
    }

    public void setStrikeout(boolean bl) {
        if (this.addRepaintImageListener != bl) {
            this.addRepaintImageListener = bl;
            this.repaint();
        }
    }

    public boolean getStrikeout() {
        return this.addRepaintImageListener;
    }

    public void setWordwrap(boolean bl) {
        if (this.adjustString != bl) {
            this.adjustString = bl;
            this.repaint();
        }
    }

    public boolean getWordwrap() {
        return this.adjustString;
    }

    public void beforeDrawImage() {
        if (this.createImage.isAlive()) {
            this.createImage.suspend();
            this.createImage.I = false;
        }
    }

    public void afterDrawImage() {
        if (this.createImage.isAlive()) {
            this.createImage.resume();
        }
    }

    public void clearStacks() {
        delWord.removeAllElements();
        dispose.removeAllElements();
    }

    public boolean isEmptyUndo() {
        return delWord.isEmpty();
    }

    public boolean isEmptyRedo() {
        return dispose.isEmpty();
    }

    public void undo() {
        if (!delWord.isEmpty()) {
            TextDoAction textDoAction = (TextDoAction)delWord.pop();
            switch (textDoAction.I) {
                case 0: {
                    dispose.push(this.QOIV(textDoAction));
                    break;
                }
                case 1: {
                    dispose.push(this.delete(textDoAction));
                    break;
                }
                case 2: {
                    dispose.push(this.replace(textDoAction));
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        if (!dispose.isEmpty()) {
            TextDoAction textDoAction = (TextDoAction)dispose.pop();
            switch (textDoAction.I) {
                case 0: {
                    delWord.push(this.QOIV(textDoAction));
                    break;
                }
                case 1: {
                    delWord.push(this.delete(textDoAction));
                    break;
                }
                case 2: {
                    delWord.push(this.replace(textDoAction));
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void cut() {
        if (this.charAt != this.charWidth) {
            int n = this.charAt < this.charWidth ? this.charAt : this.charWidth;
            int n2 = this.charAt > this.charWidth ? this.charAt : this.charWidth;
            String string = this.append.substring(n, n2);
            if (drawArea != null) {
                drawArea.setContents(new StringSelection(string), null);
            }
            this.pushUndo(this.delete(new TextDoAction(1, n, n2, string)));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void copy() {
        if (this.charAt != this.charWidth && drawArea != null) {
            drawArea.setContents(new StringSelection(this.getSelectedText()), null);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void paste() {
        Transferable transferable;
        if (drawArea != null && (transferable = drawArea.getContents(null)) != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insert(Painter.adjustString((String)string));
            }
            catch (Exception exception) {
                if (drawImage.isErrorEnabled()) {
                    drawImage.error((Object)"", (Throwable)exception);
                }
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
    }

    public void setActionCommand(String string) {
        this.clipRect = string;
    }

    public String getActionCommand() {
        return this.clipRect == null ? this.append : this.clipRect;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.consume = AWTEventMulticaster.add(this.consume, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.consume = AWTEventMulticaster.remove(this.consume, actionListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.consume != null) {
            this.consume.actionPerformed(actionEvent);
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.textListener != null) {
            this.textListener.textValueChanged(textEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = keyEvent.getID();
        if (n == 400) {
            this.keyTyped(keyEvent);
        } else if (n == 401) {
            this.keyPressed(keyEvent);
        } else if (n == 402) {
            this.keyReleased(keyEvent);
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.createImage.isAlive()) {
                    this.requestFocus();
                }
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 504: {
                this.setCursor(Cursor.getPredefinedCursor(2));
                break;
            }
            case 505: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            this.mouseDragged(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && this.createImage.isAlive()) {
            this.createImage.suspend();
            this.setCaretPosition(this.getPos(mouseEvent.getX()));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!mouseEvent.isPopupTrigger() && !mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && this.createImage.isAlive()) {
            int n = this.getPos(mouseEvent.getX());
            if (mouseEvent.getClickCount() > 1 && this.append.length() > 0) {
                char c = this.append.charAt(n = n == this.append.length() ? --n : n);
                if (Character.isLetterOrDigit(c)) {
                    this.select(this.getPrevWord(n), this.getNextWord(n));
                } else if (Character.isSpaceChar(c)) {
                    this.select(this.charAt, n);
                } else {
                    this.select(n, n + 1);
                }
            } else {
                this.select(this.charAt, n);
            }
            this.createImage.resume();
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.select(this.charAt, this.getPos(mouseEvent.getX()));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        block34: {
            int n;
            char c;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            block33: {
                if (!this.isEnabled()) {
                    return;
                }
                this.createImage.suspend();
                bl4 = keyEvent.isAltDown();
                bl3 = keyEvent.isShiftDown();
                bl2 = keyEvent.isControlDown();
                c = keyEvent.getKeyChar();
                n = keyEvent.getKeyCode();
                bl = true;
                if (!keyEvent.isActionKey() || bl4) break block33;
                switch (n) {
                    case 36: {
                        if (bl3) {
                            this.select(0, this.charWidth);
                            break;
                        }
                        this.setCaretPosition(0);
                        break;
                    }
                    case 35: {
                        int n2 = this.append.length();
                        if (bl3) {
                            this.select(this.charAt, n2);
                            break;
                        }
                        this.setCaretPosition(n2);
                        break;
                    }
                    case 37: {
                        if (bl3 && bl2) {
                            this.select(this.charAt, this.movePrevWord(this.charWidth - 1));
                            break;
                        }
                        if (bl3) {
                            this.select(this.charAt, this.charWidth - 1);
                            break;
                        }
                        if (bl2) {
                            this.setCaretPosition(this.movePrevWord(this.charWidth - 1));
                            break;
                        }
                        int n3 = this.charAt < this.charWidth ? this.charAt : (this.charAt > this.charWidth ? this.charWidth : this.charAt - 1);
                        this.setCaretPosition(n3);
                        break;
                    }
                    case 39: {
                        if (bl3 && bl2) {
                            this.select(this.charAt, this.moveNextWord(this.charWidth + 1));
                            break;
                        }
                        if (bl3) {
                            this.select(this.charAt, this.charWidth + 1);
                            break;
                        }
                        if (bl2) {
                            this.setCaretPosition(this.moveNextWord(this.charWidth + 1));
                            break;
                        }
                        int n4 = this.charAt < this.charWidth ? this.charWidth : (this.charAt > this.charWidth ? this.charAt : this.charWidth + 1);
                        this.setCaretPosition(n4);
                        break;
                    }
                    case 155: {
                        if (this.beep) {
                            this.setOvercast(!this.bottom);
                            break;
                        }
                        break block34;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
                break block34;
            }
            if (Character.isISOControl(c) && bl2 && (n == 67 || n == 99) && !bl4 && !bl3) {
                this.copy();
            } else if (this.beep && Character.isISOControl(c)) {
                switch (n) {
                    case 8: {
                        if (bl4 && !bl3 && !bl2) {
                            this.undo();
                            break;
                        }
                        if (bl2) {
                            this.delWord(true);
                            break;
                        }
                        this.delChar(true);
                        break;
                    }
                    case 86: 
                    case 118: {
                        if (bl4 || bl3 || !bl2) break;
                        this.paste();
                        break;
                    }
                    case 88: 
                    case 120: {
                        if (bl4 || bl3 || !bl2) break;
                        this.cut();
                        break;
                    }
                    case 89: 
                    case 121: {
                        if (bl4 || bl3 || !bl2) break;
                        this.redo();
                        break;
                    }
                    case 90: 
                    case 122: {
                        if (bl4 || bl3 || !bl2) break;
                        this.undo();
                        break;
                    }
                    case 127: {
                        if (!bl4 && !bl3 && bl2) {
                            this.delWord(false);
                            break;
                        }
                        if (bl4 || bl3 || bl2) break;
                        this.delChar(false);
                        break;
                    }
                    case 10: {
                        if (bl4 || bl3 || bl2) break;
                        this.processEvent(new ActionEvent(this, 1001, this.getActionCommand(), keyEvent.getModifiers()));
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
        }
        this.createImage.resume();
        if (bl) {
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.beep && !Character.isISOControl(c)) {
            this.insert("" + c);
            this.processEvent(new TextEvent(this, 900));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.beep) {
            this.createImage.resume();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackImage() {
        Dimension dimension = this.getSize();
        if (this.createImage.isAlive() && dimension.width > 0 && dimension.height > 0) {
            this.createImage.setVisible(false);
            if (!this.hasEraser()) {
                this.cut = this.createImage(dimension.width, dimension.height);
                if (this.cut != null) {
                    Graphics graphics = this.cut.getGraphics();
                    try {
                        this.control = true;
                        this.tpb.drawArea(graphics, this.mapBoundsToBoard());
                        this.control = false;
                        graphics.setColor(this.getForeground());
                        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                        Object var4_3 = null;
                        graphics.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        graphics.dispose();
                        throw throwable;
                    }
                }
            }
            if (this.delChar == null || this.delChar.getWidth((ImageObserver)((Object)this)) != dimension.width || this.delChar.getHeight((ImageObserver)((Object)this)) != dimension.height) {
                this.delChar = this.createImage(dimension.width, dimension.height);
            }
            this.repaint();
            this.repaintImage();
            this.createImage.setVisible(true);
        }
    }

    public void setEditor(boolean bl) {
        if (bl) {
            if (!this.createImage.isAlive()) {
                this.createImage.start();
                this.updateBackImage();
                this.updateCaretPos();
            }
        } else if (this.createImage.isAlive()) {
            this.createImage.stop();
            this.cut = null;
            this.delChar = null;
            this.repaint();
        }
    }

    public boolean isEditor() {
        return this.createImage.isAlive();
    }

    protected void updateTextPos() {
        if (this.copy != null) {
            Dimension dimension = this.getSize();
            String string = this.echo();
            int n = this.copy.stringWidth(string);
            int n2 = this.copy.getMaxAscent() + this.copy.getMaxDescent();
            if (this.actionPerformed == 0) {
                this.controlLtHighlight = TextComp.QOIV.left;
            } else if (this.actionPerformed == 1) {
                this.controlLtHighlight = (dimension.width - n) / 2;
            } else if (this.actionPerformed == 2) {
                this.controlLtHighlight = dimension.width - n - TextComp.QOIV.right;
            }
            if (this.add == 0) {
                this.controlShadow = TextComp.QOIV.top;
            } else if (this.add == 1) {
                this.controlShadow = (dimension.height - n2) / 2;
            } else if (this.add == 2) {
                this.controlShadow = dimension.height - n2 - TextComp.QOIV.bottom;
            }
            this.controlDkShadow = this.controlLtHighlight;
            this.controlHighlight = this.controlShadow;
            this.drawLine = false;
        }
    }

    protected boolean updateCaretPos() {
        if (this.copy != null) {
            int n = this.controlDkShadow;
            Dimension dimension = this.getSize();
            String string = this.echo();
            int n2 = this.copy.stringWidth(string);
            if (n2 < dimension.width - 4) {
                this.updateTextPos();
            }
            int n3 = this.charWidth == 0 ? 0 : (this.charWidth == string.length() ? n2 : this.copy.stringWidth(string.substring(0, this.charWidth)));
            int n4 = this.controlDkShadow + n3;
            n4 = n4 < 2 ? 2 : (n4 > dimension.width - 3 ? dimension.width - 3 : n4);
            this.controlDkShadow = n4 - n3;
            this.createImage.setBounds(n4, this.controlHighlight, 2, this.copy.getHeight());
            if (n != this.controlDkShadow) {
                this.repaint();
                return true;
            }
        }
        return false;
    }

    protected int getPos(int n) {
        int n2;
        int n3 = this.getSize().width - 3;
        int n4 = this.append.length();
        int n5 = this.copy.stringWidth(this.append);
        if (n <= this.controlDkShadow) {
            n2 = 0;
        } else if (n > this.controlDkShadow + n5) {
            n2 = n4;
        } else {
            int n6;
            int n7 = 0;
            while ((n6 = this.controlDkShadow + this.copy.stringWidth(this.append.substring(0, n2 = (n7 + n4) / 2))) != n) {
                if (n6 > n) {
                    n4 = n2;
                } else if (n6 < n) {
                    n7 = n2 + 1;
                }
                if (n7 != n4) continue;
            }
            if (n7 == n4) {
                int n8 = this.copy.charWidth(this.append.charAt(n2));
                n2 = n6 < n ? (n - n6 > n8 / 2 ? n2 + 1 : n2) : (n6 > n ? (n6 - n > n8 / 2 && n2 > 0 ? n2 - 1 : n2) : n2);
            }
        }
        return n2;
    }

    protected void delChar(boolean bl) {
        int n;
        int n2;
        if (this.charAt != this.charWidth) {
            n2 = this.charAt < this.charWidth ? this.charAt : this.charWidth;
            n = this.charAt > this.charWidth ? this.charAt : this.charWidth;
        } else {
            int n3 = this.append.length();
            if (bl && this.charAt == 0 && this.charWidth == 0 || !bl && this.charAt == n3 && this.charWidth == n3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            n2 = this.charWidth - (bl ? 1 : 0);
            n = this.charWidth + (bl ? 0 : 1);
        }
        this.pushUndo(this.delete(new TextDoAction(1, n2, n, this.append.substring(n2, n))));
    }

    protected void delWord(boolean bl) {
        int n;
        int n2;
        if (this.charAt != this.charWidth) {
            n2 = this.charAt < this.charWidth ? this.charAt : this.charWidth;
            n = this.charAt > this.charWidth ? this.charAt : this.charWidth;
        } else {
            int n3 = this.append.length();
            if (bl && this.charAt == 0 && this.charWidth == 0 || !bl && this.charAt == n3 && this.charWidth == n3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            n2 = this.charWidth - (bl ? 1 : 0);
            n = this.charWidth + (bl ? 0 : 1);
        }
        n2 = bl ? this.getPrevWord(n2) : n2;
        n = bl ? n : this.getNextWord(n);
        this.pushUndo(this.delete(new TextDoAction(1, n2, n, this.append.substring(n2, n))));
    }

    protected void insert(String string) {
        if (this.charAt != this.charWidth) {
            int n = this.charAt < this.charWidth ? this.charAt : this.charWidth;
            int n2 = this.charAt > this.charWidth ? this.charAt : this.charWidth;
            this.pushUndo(this.replace(new TextDoAction(2, n, n2, string)));
        } else if (this.bottom && this.charWidth < this.append.length()) {
            this.pushUndo(this.replace(new TextDoAction(2, this.charWidth, this.charWidth + string.length(), string)));
        } else {
            this.pushUndo(this.QOIV(new TextDoAction(0, this.charWidth, this.charWidth + string.length(), string)));
        }
    }

    TextDoAction delete(TextDoAction textDoAction) {
        textDoAction.I = 0;
        this.append = this.append.substring(0, textDoAction.Z) + this.append.substring(textDoAction.C, this.append.length());
        this.charWidth = this.charAt = textDoAction.Z;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    TextDoAction replace(TextDoAction textDoAction) {
        String string = this.append.substring(textDoAction.Z, textDoAction.C);
        this.append = this.append.substring(0, textDoAction.Z) + textDoAction.B + this.append.substring(textDoAction.C, this.append.length());
        this.charWidth = this.charAt = textDoAction.Z + textDoAction.B.length();
        textDoAction.C = this.charAt;
        textDoAction.B = string;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    TextDoAction QOIV(TextDoAction textDoAction) {
        textDoAction.I = 1;
        this.append = this.append.substring(0, textDoAction.Z) + textDoAction.B + this.append.substring(textDoAction.Z, this.append.length());
        this.charWidth = this.charAt = textDoAction.Z + textDoAction.B.length();
        textDoAction.C = this.charAt;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    protected void pushUndo(TextDoAction textDoAction) {
        delWord.push(textDoAction);
        dispose.removeAllElements();
        this.processEvent(new TextEvent(this, 900));
    }

    protected int getPrevWord(int n) {
        if ((n = this.skipPrevSpaceChar(n)) > 0) {
            char[] cArray = this.append.substring(0, n).toCharArray();
            if (Character.isLetterOrDigit(cArray[--n])) {
                --n;
                while (n >= 0) {
                    if (!Character.isLetterOrDigit(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            }
            ++n;
        }
        return n < 0 ? 0 : n;
    }

    protected int getNextWord(int n) {
        int n2;
        int n3 = 0;
        if ((n = this.skipNextSpaceChar(n)) < (n2 = this.append.length())) {
            char[] cArray = this.append.substring(n).toCharArray();
            n2 = cArray.length;
            if (Character.isLetterOrDigit(cArray[n3])) {
                while (n3 < n2) {
                    if (!Character.isLetterOrDigit(cArray[n3])) {
                        return n3 + n;
                    }
                    ++n3;
                }
            }
        }
        return n3 + n;
    }

    protected int movePrevWord(int n) {
        if ((n = this.skipPrevSpaceChar(n)) > 0) {
            char[] cArray = this.append.substring(0, n).toCharArray();
            if (Character.isLetterOrDigit(cArray[--n])) {
                --n;
                while (n >= 0) {
                    if (!Character.isLetterOrDigit(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            } else {
                --n;
                while (n >= 0) {
                    if (Character.isLetterOrDigit(cArray[n]) || Character.isSpaceChar(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            }
            ++n;
        }
        return n < 0 ? 0 : n;
    }

    /*
     * Unable to fully structure code
     */
    protected int moveNextWord(int var1_1) {
        block4: {
            var3_2 = 0;
            if ((var1_1 = this.skipNextSpaceChar(var1_1)) >= (var4_3 = this.append.length())) break block4;
            var2_4 = this.append.substring(var1_1).toCharArray();
            var4_3 = var2_4.length;
            if (!Character.isLetterOrDigit(var2_4[var3_2])) ** GOTO lbl15
            while (var3_2 < var4_3) {
                if (!Character.isLetterOrDigit(var2_4[var3_2])) {
                    return var3_2 + var1_1;
                }
                ++var3_2;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (Character.isLetterOrDigit(var2_4[var3_2]) || Character.isSpaceChar(var2_4[var3_2])) {
                    return var3_2 + var1_1;
                }
                ++var3_2;
lbl15:
                // 2 sources

                ** while (var3_2 < var4_3)
            }
        }
        return var3_2 + var1_1;
    }

    protected int skipPrevSpaceChar(int n) {
        if (n > 0 && Character.isSpaceChar(this.append.charAt(n))) {
            --n;
            while (n >= 0) {
                if (!Character.isSpaceChar(this.append.charAt(n))) {
                    return ++n;
                }
                --n;
            }
        }
        return n < 0 ? 0 : n;
    }

    protected int skipNextSpaceChar(int n) {
        int n2 = this.append.length();
        if (n < n2 && Character.isSpaceChar(this.append.charAt(n))) {
            while (n < n2) {
                if (!Character.isSpaceChar(this.append.charAt(n))) {
                    return n;
                }
                ++n;
            }
        }
        return n;
    }

    protected String paramString() {
        String string = super.paramString() + ",text=" + this.append;
        if (this.beep) {
            string = string + ",editable=" + this.beep;
        }
        if (this.bottom) {
            string = string + ",overcast=" + this.bottom;
        }
        return string + ",selection=" + this.charAt + "-" + this.charWidth;
    }

    public char getEchoChar() {
        return this.class$;
    }

    public synchronized void setEchoChar(char c) {
        this.class$ = c;
    }

    public boolean echoCharIsSet() {
        return this.class$ != '\u0000';
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.createImage.stop();
        }
        super.setEnabled(bl);
        this.repaint();
    }

    private String echo() {
        String string = this.append;
        if (this.class$ != '\u0000') {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < string.length()) {
                stringBuffer.setCharAt(n, this.class$);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            drawArea = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable throwable) {
            drawArea = null;
        }
    }
}

