/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import com.jinfonet.dataservice.expression.ExpressionFactoryImpl;
import com.jinfonet.security.api.AuthorizeManager;
import com.jinfonet.security.api.Permissions;
import com.jinfonet.security.api.SecurityService;
import com.jinfonet.security.api.exception.InvalidResource;
import java.security.acl.Permission;
import java.util.Vector;
import jet.api.CatalogAPI;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.rptservice.util.ReportTools;
import jet.universe.DataCollection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.Measure;

public class APITools {
    public static String[] ops = new String[]{">", ">=", "=", "! =", "<=", "<", "like", "not like", "in", "not in", "between", "not between", "is null", "is not null"};
    public static int GREAT = 0;
    public static int GREATEQUAL = 1;
    public static int EQUAL = 2;
    public static int NOTEQUAL = 3;
    public static int LESSEQUAL = 4;
    public static int LESS = 5;
    public static int LIKE = 6;
    public static int NOTLIKE = 7;
    public static int IN = 8;
    public static int NOTIN = 9;
    public static int BETWEEN = 10;
    public static int NOTBETWEEN = 11;
    public static int ISNULL = 12;
    public static int NOTNULL = 13;
    public static int[] intops = new int[]{GREAT, GREATEQUAL, EQUAL, NOTEQUAL, LESSEQUAL, LESS, LIKE, NOTLIKE, IN, NOTIN, BETWEEN, NOTBETWEEN, ISNULL, NOTNULL};

    public static BLNode[] getAll(BLContainer bLContainer) {
        BLNode[] bLNodeArray = bLContainer.getBLChildren();
        BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
        if (bLNodeArray != null && bLNodeArray.length > 0) {
            BLNode[] bLNodeArray3 = new BLNode[bLNodeArray.length];
            System.arraycopy(bLNodeArray, 0, bLNodeArray3, 0, bLNodeArray.length);
            bLNodeArray2 = bLNodeArray3;
            int n = 0;
            while (n < bLNodeArray.length) {
                if (bLNodeArray[n] instanceof BLContainer) {
                    BLNode[] bLNodeArray4 = APITools.getAll((BLContainer)bLNodeArray[n]);
                    bLNodeArray3 = new BLNode[bLNodeArray2.length + bLNodeArray4.length];
                    System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, bLNodeArray2.length);
                    System.arraycopy(bLNodeArray4, 0, bLNodeArray3, bLNodeArray2.length, bLNodeArray4.length);
                    bLNodeArray2 = bLNodeArray3;
                }
                ++n;
            }
        }
        return bLNodeArray2;
    }

    public static BLNode[] getAll(CatalogAPI catalogAPI, String string, BLContainer bLContainer) {
        int n = 0;
        BLNode[] bLNodeArray = bLContainer.getBLChildren();
        BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
        int n2 = 0;
        while (n2 < bLNodeArray.length) {
            if (APITools.GREAT(catalogAPI, string, bLNodeArray[n2].getBLQualifyName(), Permissions.P_VISIBLE)) {
                bLNodeArray2[n] = bLNodeArray[n2];
                ++n;
            }
            ++n2;
        }
        BLNode[] bLNodeArray3 = new BLNode[n];
        System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, n);
        BLNode[] bLNodeArray4 = new BLNode[bLNodeArray3.length];
        if (bLNodeArray3 != null && bLNodeArray3.length > 0) {
            BLNode[] bLNodeArray5 = new BLNode[bLNodeArray3.length];
            System.arraycopy(bLNodeArray3, 0, bLNodeArray5, 0, bLNodeArray3.length);
            bLNodeArray4 = bLNodeArray5;
            int n3 = 0;
            while (n3 < bLNodeArray3.length) {
                if (bLNodeArray3[n3] instanceof BLContainer) {
                    BLNode[] bLNodeArray6 = APITools.getAll((BLContainer)bLNodeArray3[n3]);
                    bLNodeArray5 = new BLNode[bLNodeArray4.length + bLNodeArray6.length];
                    System.arraycopy(bLNodeArray4, 0, bLNodeArray5, 0, bLNodeArray4.length);
                    System.arraycopy(bLNodeArray6, 0, bLNodeArray5, bLNodeArray4.length, bLNodeArray6.length);
                    bLNodeArray4 = bLNodeArray5;
                }
                ++n3;
            }
        }
        return bLNodeArray4;
    }

    public static String[] getBLMeasureHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            BLNode[] bLNodeArray = APITools.getAll((BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.BETWEEN((DataElement)jetObject2);
                int n3 = 0;
                while (n3 < bLNodeArray.length) {
                    if (bLNodeArray[n3].getElementType() == 5 && APITools.BETWEEN((DataElement)bLNodeArray[n3]) == n2) {
                        stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                        ++n;
                    }
                    ++n3;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLMeasureHandlesByUser(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            BLNode[] bLNodeArray = APITools.getAll(catalogAPI, string3, (BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                int n2 = APITools.BETWEEN((DataElement)jetObject2);
                int n3 = 0;
                while (n3 < bLNodeArray.length) {
                    if (bLNodeArray[n3].getElementType() == 5 && APITools.BETWEEN((DataElement)bLNodeArray[n3]) == n2) {
                        stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                        ++n;
                    }
                    ++n3;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getBLDetailHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll((BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                JetUResourceEntity jetUResourceEntity;
                int n2 = APITools.BETWEEN((DataElement)jetObject2);
                int n3 = 0;
                while (n3 < bLNodeArray.length) {
                    if (bLNodeArray[n3].getElementType() == 7 && APITools.BETWEEN((DataElement)bLNodeArray[n3]) == n2) {
                        jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray[n3]);
                        if (jetUResourceEntity instanceof JetUFormula) {
                            int n4 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                            if (n4 == 104 || n4 == 100) {
                                stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                                ++n;
                            }
                        } else {
                            stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                            ++n;
                        }
                    }
                    ++n3;
                }
                jetUResourceEntity = new String[n];
                System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n);
                return jetUResourceEntity;
            }
        }
        return new String[0];
    }

    public static String[] getBLDetailHandlesByUser(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll(catalogAPI, string3, (BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                JetUResourceEntity jetUResourceEntity;
                int n2 = APITools.BETWEEN((DataElement)jetObject2);
                int n3 = 0;
                while (n3 < bLNodeArray.length) {
                    if (bLNodeArray[n3].getElementType() == 7 && APITools.BETWEEN((DataElement)bLNodeArray[n3]) == n2) {
                        jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray[n3]);
                        if (jetUResourceEntity instanceof JetUFormula) {
                            int n4 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                            if (n4 == 104 || n4 == 100) {
                                stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                                ++n;
                            }
                        } else {
                            stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                            ++n;
                        }
                    }
                    ++n3;
                }
                jetUResourceEntity = new String[n];
                System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n);
                return jetUResourceEntity;
            }
        }
        return new String[0];
    }

    public static String[] getBLDetailHandles(CatalogAPI catalogAPI, String string) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            JetUResourceEntity jetUResourceEntity;
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < bLNodeArray.length) {
                if (bLNodeArray[n2].getElementType() == 7) {
                    jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray[n2]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n3 == 104 || n3 == 100) {
                            stringArray[n] = ((JetObject)bLNodeArray[n2]).getQualifyName();
                            ++n;
                        }
                    } else {
                        stringArray[n] = ((JetObject)bLNodeArray[n2]).getQualifyName();
                        ++n;
                    }
                }
                ++n2;
            }
            jetUResourceEntity = new String[n];
            System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n);
            return jetUResourceEntity;
        }
        return new String[0];
    }

    public static String[] getBLDetailHandlesByUser(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo)) {
            JetUResourceEntity jetUResourceEntity;
            int n = 0;
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
            int n2 = 0;
            while (n2 < bLNodeArray.length) {
                if (APITools.GREAT(catalogAPI, string2, bLNodeArray[n2].getBLQualifyName(), Permissions.P_VISIBLE)) {
                    bLNodeArray2[n] = bLNodeArray[n2];
                    ++n;
                }
                ++n2;
            }
            BLNode[] bLNodeArray3 = new BLNode[n];
            System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, n);
            String[] stringArray = new String[bLNodeArray3.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < bLNodeArray3.length) {
                if (bLNodeArray3[n4].getElementType() == 7) {
                    jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray3[n4]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n5 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n5 == 104 || n5 == 100) {
                            stringArray[n3] = ((JetObject)bLNodeArray3[n4]).getQualifyName();
                            ++n3;
                        }
                    } else {
                        stringArray[n3] = ((JetObject)bLNodeArray3[n4]).getQualifyName();
                        ++n3;
                    }
                }
                ++n4;
            }
            jetUResourceEntity = new String[n3];
            System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n3);
            return jetUResourceEntity;
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll((BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                JetUResourceEntity jetUResourceEntity;
                int n2 = APITools.BETWEEN((DataElement)jetObject2);
                int n3 = 0;
                while (n3 < bLNodeArray.length) {
                    if (bLNodeArray[n3].getElementType() == 4 && APITools.BETWEEN((DataElement)bLNodeArray[n3]) == n2) {
                        jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray[n3]);
                        if (jetUResourceEntity instanceof JetUFormula) {
                            int n4 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                            if (n4 == 104 || n4 == 100) {
                                stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                                ++n;
                            }
                        } else {
                            stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                            ++n;
                        }
                    }
                    ++n3;
                }
                jetUResourceEntity = new String[n];
                System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n);
                return jetUResourceEntity;
            }
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandlesByUser(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            BLNode[] bLNodeArray = APITools.getAll(catalogAPI, string3, (BLContainer)jetObject);
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            JetObject jetObject2 = catalogAPI.getObj(string2);
            if (jetObject2 != null && jetObject2 instanceof DataElement) {
                JetUResourceEntity jetUResourceEntity;
                int n2 = APITools.BETWEEN((DataElement)jetObject2);
                int n3 = 0;
                while (n3 < bLNodeArray.length) {
                    if (bLNodeArray[n3].getElementType() == 4 && APITools.BETWEEN((DataElement)bLNodeArray[n3]) == n2) {
                        jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray[n3]);
                        if (jetUResourceEntity instanceof JetUFormula) {
                            int n4 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                            if (n4 == 104 || n4 == 100) {
                                stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                                ++n;
                            }
                        } else {
                            stringArray[n] = ((JetObject)bLNodeArray[n3]).getQualifyName();
                            ++n;
                        }
                    }
                    ++n3;
                }
                jetUResourceEntity = new String[n];
                System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n);
                return jetUResourceEntity;
            }
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandles(CatalogAPI catalogAPI, String string) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            JetUResourceEntity jetUResourceEntity;
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            String[] stringArray = new String[bLNodeArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < bLNodeArray.length) {
                if (bLNodeArray[n2].getElementType() == 4) {
                    jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray[n2]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n3 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n3 == 104 || n3 == 100) {
                            stringArray[n] = ((JetObject)bLNodeArray[n2]).getQualifyName();
                            ++n;
                        }
                    } else {
                        stringArray[n] = ((JetObject)bLNodeArray[n2]).getQualifyName();
                        ++n;
                    }
                }
                ++n2;
            }
            jetUResourceEntity = new String[n];
            System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n);
            return jetUResourceEntity;
        }
        return new String[0];
    }

    public static String[] getBLDimensionHandlesByUser(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            JetUResourceEntity jetUResourceEntity;
            int n = 0;
            BLNode[] bLNodeArray = ((BLContainer)jetObject).getBLChildren();
            BLNode[] bLNodeArray2 = new BLNode[bLNodeArray.length];
            int n2 = 0;
            while (n2 < bLNodeArray.length) {
                if (APITools.GREAT(catalogAPI, string2, bLNodeArray[n2].getBLQualifyName(), Permissions.P_VISIBLE)) {
                    bLNodeArray2[n] = bLNodeArray[n2];
                    ++n;
                }
                ++n2;
            }
            BLNode[] bLNodeArray3 = new BLNode[n];
            System.arraycopy(bLNodeArray2, 0, bLNodeArray3, 0, n);
            String[] stringArray = new String[bLNodeArray3.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < bLNodeArray3.length) {
                if (bLNodeArray3[n4].getElementType() == 4) {
                    jetUResourceEntity = APITools.EQUAL((DataElement)bLNodeArray3[n4]);
                    if (jetUResourceEntity instanceof JetUFormula) {
                        int n5 = ReportTools.getFormulaType(null, null, (JetUFormula)((JetUFormula)jetUResourceEntity));
                        if (n5 == 104 || n5 == 100) {
                            stringArray[n3] = ((JetObject)bLNodeArray3[n4]).getQualifyName();
                            ++n3;
                        }
                    } else {
                        stringArray[n3] = ((JetObject)bLNodeArray3[n4]).getQualifyName();
                        ++n3;
                    }
                }
                ++n4;
            }
            jetUResourceEntity = new String[n3];
            System.arraycopy(stringArray, 0, jetUResourceEntity, 0, n3);
            return jetUResourceEntity;
        }
        return new String[0];
    }

    public static String[] getParameterHandles(CatalogAPI catalogAPI, String string, String string2) {
        JetUDatabase jetUDatabase = catalogAPI.I().getDatabase(string);
        if (jetUDatabase != null) {
            Vector vector = jetUDatabase.getParameters();
            String[] stringArray = new String[vector.size()];
            int n = 0;
            JetObject jetObject = catalogAPI.getObj(string2);
            if (jetObject != null && jetObject instanceof DataElement) {
                int n2 = APITools.BETWEEN((DataElement)jetObject);
                JetUParameter jetUParameter = null;
                int n3 = 0;
                while (n3 < vector.size()) {
                    jetUParameter = (JetUParameter)vector.elementAt(n3);
                    if (jetUParameter.getColDesc().getSqlType() == n2) {
                        stringArray[n] = jetUParameter.getQualifyName();
                        ++n;
                    }
                    ++n3;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
        }
        return new String[0];
    }

    public static String[] getOperators(CatalogAPI catalogAPI, String string, String string2) {
        return ops;
    }

    public static int[] getIntOperators(CatalogAPI catalogAPI, String string, String string2) {
        return intops;
    }

    public static String[] getSpecialFields(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject = catalogAPI.getObj(string2);
        if (jetObject != null && jetObject instanceof DataElement) {
            int n = APITools.BETWEEN((DataElement)jetObject);
            switch (n) {
                case 1: 
                case 12: {
                    return new String[]{"username"};
                }
            }
        }
        return new String[0];
    }

    private static int BETWEEN(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        int n = -1;
        while (jetContainable != null) {
            if ((JetObject)jetContainable instanceof JetUDatabase) break;
            jetContainable = ((JetObject)jetContainable).getParent();
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        if (jetUResourceEntity != null) {
            n = jetUResourceEntity.getColDesc().getSqlType();
        }
        return n;
    }

    private static JetUResourceEntity EQUAL(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        int n = -1;
        while (jetContainable != null) {
            if ((JetObject)jetContainable instanceof JetUDatabase) break;
            jetContainable = ((JetObject)jetContainable).getParent();
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        return jetUResourceEntity;
    }

    public static IExpressionFactory getIExpressionFactory(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        JetUDatabase jetUDatabase = catalogAPI.I().getDatabase(string);
        if (jetUDatabase != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof JBusinessLogic) {
            return new ExpressionFactoryImpl(catalogAPI.I(), string, (JBusinessLogic)jetObject);
        }
        return null;
    }

    public static Vector[] getValues(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        JetObject jetObject2 = catalogAPI.getObj(string);
        if (jetObject2 != null && jetObject2 instanceof CategoryInfo && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof DataElement) {
            JetContainable jetContainable = jetObject.getParent();
            while (jetContainable != null) {
                if ((JetObject)jetContainable instanceof JetUDatabase) break;
                jetContainable = ((JetObject)jetContainable).getParent();
            }
            JetUUniverse jetUUniverse = catalogAPI.I();
            String string3 = ((DataElement)jetObject).getRefMappingName();
            String string4 = ((JetUDatabase)jetContainable).getResourceName();
            Vector[] vectorArray = null;
            JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(string3);
            if (jetUResourceEntity instanceof JetUFormula) {
                return null;
            }
            try {
                DataCollection dataCollection = new DataCollection();
                dataCollection.setRecordsToDisplay(500);
                vectorArray = dataCollection.getResultSet(jetUUniverse, string4, string3, (Vector)null, true);
            }
            catch (ClassCastException classCastException) {
                catalogAPI.I(classCastException);
            }
            catch (Exception exception) {
                catalogAPI.I(exception);
            }
            return vectorArray;
        }
        return new Vector[0];
    }

    public static Vector[] getValues(CatalogAPI catalogAPI, String string, String string2, String string3) {
        JetObject jetObject;
        JetObject jetObject2 = catalogAPI.getObj(string);
        if (jetObject2 != null && jetObject2 instanceof CategoryInfo && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof DataElement) {
            JetContainable jetContainable = jetObject.getParent();
            while (jetContainable != null) {
                if ((JetObject)jetContainable instanceof JetUDatabase) break;
                jetContainable = ((JetObject)jetContainable).getParent();
            }
            JetUUniverse jetUUniverse = catalogAPI.I();
            String string4 = ((DataElement)jetObject).getRefMappingName();
            String string5 = ((JetUDatabase)jetContainable).getResourceName();
            Vector[] vectorArray = null;
            JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(string4);
            if (jetUResourceEntity instanceof JetUFormula || jetUResourceEntity instanceof JetUUDSField || jetUResourceEntity instanceof JetUProcField || jetUResourceEntity instanceof JetUFileQueryField || jetUResourceEntity instanceof JetUFmlQueryField) {
                return null;
            }
            try {
                DataCollection dataCollection = new DataCollection();
                dataCollection.setRecordsToDisplay(500);
                vectorArray = dataCollection.getResultSet(jetUUniverse, string5, string4, (Vector)null, true, string3);
            }
            catch (ClassCastException classCastException) {
                catalogAPI.I(classCastException);
            }
            catch (Exception exception) {
                catalogAPI.I(exception);
                exception.printStackTrace();
            }
            return vectorArray;
        }
        return new Vector[0];
    }

    public static String getBLNodeHandle(CatalogAPI catalogAPI, String string, String string2, String string3) {
        Object var4_4 = null;
        JetObject jetObject = catalogAPI.getObj(string2);
        if (jetObject != null && jetObject instanceof JBusinessLogic) {
            BLNode bLNode = ((JBusinessLogic)jetObject).get(string3);
            return ((JetObject)bLNode).getQualifyName();
        }
        return null;
    }

    private static boolean GREAT(CatalogAPI catalogAPI, String string, String string2, Permission permission) {
        SecurityService securityService = SecurityService.getInstance();
        AuthorizeManager authorizeManager = securityService.getCubeAuthorizeManager(catalogAPI.I().getFullFileName());
        boolean bl = false;
        try {
            bl = authorizeManager.checkPermission(string, string2, permission);
        }
        catch (InvalidResource invalidResource) {
            catalogAPI.I((Exception)((Object)invalidResource));
        }
        return bl;
    }

    public static String createFmlBySum(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        String string3 = null;
        if (string2 != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof Measure) {
            String string4 = catalogAPI.getHandle(string, ((Measure)jetObject).getRefMappingName(), 10);
            if (string4 != null) {
                jetObject = catalogAPI.getObj(string4);
                JetUSummary jetUSummary = (JetUSummary)jetObject;
                String string5 = jetUSummary.function.get() + jetUSummary.groupbyFld.get();
                String string6 = jetUSummary.groupbyFld.get();
                if (string6.indexOf(" ") != -1) {
                    string6 = '\"' + string6 + '\"';
                }
                String string7 = "\"" + jetUSummary.function.get() + "\"" + "+" + "\" \"" + "+" + "@" + string6;
                int n = 0;
                String string8 = string5;
                while (catalogAPI.isNameExist(string, string8)) {
                    string8 = string5 + n++;
                }
                if (catalogAPI.insert(string, string8, "", string7) != null) {
                    string3 = string8;
                }
            } else {
                String string9 = ((Measure)jetObject).getAggFunction() + ((Measure)jetObject).getRefMappingName();
                String string10 = ((Measure)jetObject).getRefMappingName();
                if (string10.indexOf(" ") != -1) {
                    string10 = '\"' + string10 + '\"';
                }
                String string11 = "\"" + ((Measure)jetObject).getAggFunction() + "\"" + "+" + "\" \"" + "+" + "@" + string10;
                int n = 0;
                String string12 = string9;
                while (catalogAPI.isNameExist(string, string12)) {
                    string12 = string9 + n++;
                }
                if (catalogAPI.insert(string, string12, "", string11) != null) {
                    string3 = string12;
                }
            }
        }
        return string3;
    }

    public static String getMeasureFunction(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        if (string2 != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof Measure) {
            String string3 = catalogAPI.getHandle(string, ((Measure)jetObject).getRefMappingName(), 10);
            if (string3 != null) {
                jetObject = catalogAPI.getObj(string3);
                return ((JetUSummary)jetObject).function.get();
            }
            return ((Measure)jetObject).getAggFunction();
        }
        return null;
    }

    public static String getMeasureField(CatalogAPI catalogAPI, String string, String string2) {
        JetObject jetObject;
        if (string2 != null && (jetObject = catalogAPI.getObj(string2)) != null && jetObject instanceof Measure) {
            String string3 = catalogAPI.getHandle(string, ((Measure)jetObject).getRefMappingName(), 10);
            if (string3 != null) {
                jetObject = catalogAPI.getObj(string3);
                return ((JetUSummary)jetObject).fldName.get();
            }
            return ((Measure)jetObject).getRefMappingName();
        }
        return null;
    }

    public static String getBLViewName(CatalogAPI catalogAPI, String string, boolean bl) {
        JetObject jetObject = catalogAPI.getObj(string);
        if (jetObject != null && jetObject instanceof CategoryInfo) {
            if (bl) {
                return ((CategoryInfo)jetObject).getDisplayName();
            }
            return ((CategoryInfo)jetObject).getName();
        }
        return null;
    }
}

