/*
 * Decompiled with CFR 0.152.
 */
package jet.connect.jdbms;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import jet.connect.Record;
import jet.connect.jdbms.JDbBuffer;
import jet.connect.jdbms.JDbRecordModel;
import jet.connect.jdbms.JDbResultSet;
import jet.connect.jdbms.JDbTableDesc;
import jet.connect.jdbms.JDbTables;
import jet.connect.jdbms.JDbWhere;
import jet.connect.jdbms.JResultSet;
import jet.util.RAFile;

public class JDbConnection {
    File QOIV;
    File addRecord;
    JDbBuffer append;
    JDbRecordModel close;
    JDbResultSet commit;

    public JDbConnection(File file, String string) throws SQLException {
        this(file, string, JDbTables.getRecordModel(string));
    }

    public JDbConnection(File file, String string, int n, int n2) throws SQLException {
        this(file, string, JDbTables.getRecordModel(string), n, n2);
    }

    public JDbConnection(File file, String string, JDbRecordModel jDbRecordModel) throws SQLException {
        this(file, string, jDbRecordModel, -1, -1);
    }

    public JDbConnection(File file, String string, JDbRecordModel jDbRecordModel, int n, int n2) throws SQLException {
        block12: {
            int n3;
            int n4;
            this.QOIV = file;
            this.addRecord = new File(file, string);
            this.close = jDbRecordModel;
            if (!this.addRecord.exists()) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.addRecord));
                n4 = dataInputStream.readInt();
                n3 = dataInputStream.readInt();
                dataInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
            catch (IOException iOException) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
            jDbRecordModel.setRecordCount(n3);
            try {
                this.append = n > 0 && n2 > 0 ? new JDbBuffer(jDbRecordModel, this.addRecord, n, n2) : new JDbBuffer(jDbRecordModel, this.addRecord);
                this.append.setNeedWaitFetch(false);
                this.append.I((long)n4);
                this.append.I(n3);
                if (n3 <= 0) break block12;
                try {
                    this.append.readFirst();
                }
                catch (Throwable throwable) {
                    if (n > 0 && n2 > 0) {
                        this.append.close();
                        this.append = new JDbBuffer(jDbRecordModel, this.addRecord);
                        this.append.setNeedWaitFetch(false);
                        this.append.I((long)n4);
                        this.append.I(n3);
                        this.append.readFirst();
                        this.append.restart();
                        Record record = jDbRecordModel.currentRecord;
                        File file2 = new File(file, this.addRecord.getName() + "temp");
                        JDbBuffer jDbBuffer = new JDbBuffer(jDbRecordModel, file2, n, n2);
                        jDbBuffer.setNeedWaitFetch(false);
                        jDbBuffer.I((long)n4);
                        while (true) {
                            try {
                                this.append.nextRecord(record);
                                jDbBuffer.addRecord(record);
                            }
                            catch (SQLException sQLException) {
                                jDbBuffer.finish();
                                jDbBuffer.refreshAllToFile();
                                jDbBuffer.close();
                                this.append.close();
                                JDbTableDesc.copyTableHeader(this.addRecord, file2);
                                this.addRecord.delete();
                                file2.renameTo(this.addRecord);
                                this.append = new JDbBuffer(jDbRecordModel, this.addRecord, n, n2);
                                this.append.setNeedWaitFetch(false);
                                this.append.I((long)n4);
                                this.append.I(n3);
                                this.append.readFirst();
                                break block12;
                            }
                        }
                    }
                    throw new SQLException("Cannot connect to the table(" + string + ")" + "! Error:" + throwable);
                }
            }
            catch (IOException iOException) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
        }
        this.commit = new JDbResultSet(jDbRecordModel);
    }

    public static JDbConnection connect(File file, String string, JDbRecordModel jDbRecordModel) throws SQLException {
        return new JDbConnection(file, string, jDbRecordModel);
    }

    public static JDbConnection connect(File file, String string, JDbRecordModel jDbRecordModel, int n, int n2) throws SQLException {
        return new JDbConnection(file, string, jDbRecordModel, n, n2);
    }

    public static JDbConnection connect(File file, String string) throws SQLException {
        return new JDbConnection(file, string);
    }

    public static JDbConnection connect(File file, String string, int n, int n2) throws SQLException {
        return new JDbConnection(file, string, n, n2);
    }

    public void disconnect() throws SQLException {
        try {
            int n = (int)this.append.getBeging();
            this.commit.commit();
            this.append.close();
            RAFile rAFile = new RAFile(this.addRecord, "rw");
            rAFile.seek(0L);
            rAFile.writeInt(n);
            rAFile.writeInt(this.close.getRecordCount());
            rAFile.close();
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot disconnect from the table(" + this.addRecord.toString() + ")");
        }
    }

    public void commit() throws SQLException {
        try {
            this.commit.commit();
            RAFile rAFile = new RAFile(this.addRecord, "rw");
            rAFile.seek(0L);
            rAFile.writeInt((int)this.append.getBeging());
            rAFile.writeInt(this.close.getRecordCount());
            rAFile.close();
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot commit to the table(" + this.addRecord.toString() + ")");
        }
    }

    public synchronized JResultSet select(JDbWhere jDbWhere) throws SQLException {
        this.commit.setWhere(jDbWhere);
        return this.commit;
    }

    public int getRecords() {
        return this.append == null ? -1 : this.append.getRecords();
    }
}

