/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.jacl;

import java.security.Principal;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.SecurityData;

public class JAclEntryImpl
implements JAclEntry {
    protected boolean bNegative = false;
    protected String name = null;
    protected Vector vPermission = new Vector();
    protected String realmName;
    private String QOIV = "";
    private byte add = (byte)-1;
    private SecurityData addPermission;

    public JAclEntryImpl(String string, SecurityData securityData) {
        this.name = string;
        this.addPermission = securityData;
    }

    public synchronized boolean setPrincipal(Principal principal) {
        if (principal == null) {
            return false;
        }
        String string = principal.getName();
        if (principal instanceof BaseUser) {
            this.QOIV = string;
            this.add = 1;
            return true;
        }
        if (principal instanceof BaseRole) {
            this.QOIV = string;
            this.add = (byte)2;
            return true;
        }
        this.QOIV = string;
        this.add = (byte)3;
        return true;
    }

    public Principal getPrincipal() {
        if (this.add == 2) {
            BaseRole baseRole = this.addPermission.getRole(this.QOIV);
            return baseRole;
        }
        if (this.add == 1) {
            BaseUser baseUser = this.addPermission.getUser(this.QOIV);
            return baseUser;
        }
        BaseGroup baseGroup = this.addPermission.getGroup(this.QOIV);
        return baseGroup;
    }

    public synchronized void setNegativePermissions() {
        this.bNegative = true;
    }

    public boolean isNegative() {
        return this.bNegative;
    }

    public synchronized boolean addPermission(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (this.vPermission.contains(permission)) {
            return false;
        }
        if (permission instanceof JPermission) {
            JPermission jPermission = (JPermission)permission;
            int n = jPermission.getType();
            if (n == -1) {
                this.vPermission.add(permission);
                return true;
            }
            Enumeration enumeration = this.vPermission.elements();
            while (enumeration.hasMoreElements()) {
                JPermission jPermission2 = (JPermission)enumeration.nextElement();
                if (!jPermission2.typeEquals(permission)) continue;
                this.vPermission.remove(jPermission2);
                this.vPermission.add(permission);
                return true;
            }
            this.vPermission.add(permission);
            return true;
        }
        this.vPermission.add(permission);
        return true;
    }

    public synchronized boolean removePermission(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (this.vPermission.contains(permission)) {
            this.vPermission.remove(permission);
            return true;
        }
        return false;
    }

    public synchronized boolean checkPermission(Permission permission) {
        if (permission == null) {
            return false;
        }
        int n = 0;
        while (n < this.vPermission.size()) {
            JPermission jPermission = (JPermission)this.vPermission.elementAt(n);
            if (jPermission.equals(permission)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Enumeration permissions() {
        return ((Vector)this.vPermission.clone()).elements();
    }

    public Object clone() {
        Object object;
        JAclEntryImpl jAclEntryImpl = new JAclEntryImpl(this.name, this.addPermission);
        if (this.bNegative) {
            jAclEntryImpl.setNegativePermissions();
        }
        int n = 0;
        while (n < this.vPermission.size()) {
            object = (JPermission)this.vPermission.elementAt(n);
            jAclEntryImpl.addPermission((Permission)object);
            ++n;
        }
        if (this.add == 2) {
            object = this.addPermission.getRole(this.QOIV);
            jAclEntryImpl.setPrincipal((Principal)object);
        } else if (this.add == 1) {
            object = this.addPermission.getUser(this.QOIV);
            jAclEntryImpl.setPrincipal((Principal)object);
        } else {
            object = this.addPermission.getGroup(this.QOIV);
            jAclEntryImpl.setPrincipal((Principal)object);
        }
        return jAclEntryImpl;
    }

    public void removeAllPermissions() {
        this.vPermission.clear();
    }

    public int hashCode() {
        if (this.add == 1) {
            String string = this.QOIV + String.valueOf(this.bNegative) + "User";
            return string.hashCode();
        }
        if (this.add == 2) {
            String string = this.QOIV + String.valueOf(this.bNegative) + "Role";
            return string.hashCode();
        }
        String string = this.QOIV + String.valueOf(this.bNegative) + "Group";
        return string.hashCode();
    }
}

