/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.jacl;

import java.security.Principal;
import java.security.acl.Permission;
import java.util.Hashtable;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.ResourceNode;

public class ResourceTree {
    private ResourceNode QOIV = null;
    private Hashtable addChild = new Hashtable();
    private String checkPermission = "";
    public static final String ROOT = "RESOURCE_TREE_ROOT";

    public ResourceTree(String string, ResourceNode resourceNode) {
        this.QOIV = resourceNode;
        this.checkPermission = string;
        resourceNode.setParentNodeId(ROOT);
        String string2 = resourceNode.getNodeId();
        if (!this.addChild.containsValue(resourceNode)) {
            this.QOIV(string2, resourceNode);
        }
    }

    public ResourceNode addChild(ResourceNode resourceNode) {
        ResourceNode resourceNode2 = this.QOIV.addChild(resourceNode);
        return resourceNode2;
    }

    public ResourceNode getRoot() {
        return this.QOIV;
    }

    private void QOIV(String string, ResourceNode resourceNode) {
        this.addChild.put(string, resourceNode);
    }

    public ResourceNode getNode(String string) {
        if (this.addChild.containsKey(string)) {
            return (ResourceNode)this.addChild.get(string);
        }
        return null;
    }

    public ResourceNode addChildToParentNode(String string, ResourceNode resourceNode) {
        ResourceNode resourceNode2 = this.getNode(string);
        if (resourceNode2 == null) {
            return null;
        }
        ResourceNode resourceNode3 = resourceNode2.addChild(resourceNode);
        this.addChild.put(resourceNode3.getNodeId(), resourceNode3);
        return resourceNode3;
    }

    public boolean removeNodeFromParent(String string, String string2) {
        ResourceNode resourceNode = this.getNode(string);
        if (resourceNode == null) {
            return false;
        }
        boolean bl = resourceNode.removeChild(string2);
        return bl;
    }

    public boolean removeNode(String string) {
        ResourceNode resourceNode;
        ResourceNode resourceNode2 = this.getNode(string);
        boolean bl = true;
        if (resourceNode2 == null) {
            return false;
        }
        String string2 = resourceNode2.getNodeParentId();
        if (string2 != null && string2.length() != 0 && !string2.equals(ROOT) && (resourceNode = this.getNode(string2)) != null && (bl = resourceNode.removeChild(string))) {
            this.addChild.remove(string);
        }
        return bl;
    }

    public boolean rename(String string, String string2) {
        ResourceNode resourceNode = this.getNode(string);
        if (resourceNode == null) {
            return false;
        }
        resourceNode.rename(string2);
        return true;
    }

    public String getTreeId() {
        return this.checkPermission;
    }

    public JAcl getJAcl(String string, Principal principal) {
        ResourceNode resourceNode = this.getNode(string);
        if (resourceNode == null) {
            return null;
        }
        JAcl jAcl = resourceNode.getJAcl();
        if (jAcl == null) {
            String string2 = resourceNode.getNodeParentId();
            if (string2.equals(ROOT)) {
                return null;
            }
            return this.getJAcl(string2, principal);
        }
        return jAcl;
    }

    public boolean checkPermission(String string, Principal principal, Permission permission) {
        JAcl jAcl = this.getJAcl(string, principal);
        if (jAcl == null) {
            return false;
        }
        return jAcl.checkPermission(principal, permission);
    }

    public JPermission getPolicyPermission(String string, Principal principal, String string2, int n) {
        JAcl jAcl = this.getJAcl(string, principal);
        if (jAcl == null) {
            return null;
        }
        try {
            return jAcl.getPolicyPermission(principal, string2, n);
        }
        catch (JPermissionLinkException jPermissionLinkException) {
            return null;
        }
        catch (JPolicyLinkException jPolicyLinkException) {
            return null;
        }
    }
}

