/*
 * Decompiled with CFR 0.152.
 */
package jet.server;

import com.jinfonet.util.JRLog;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.ShutdownThread;
import jet.server.log.ServiceLogger;
import jet.server.util.SCMEvent;
import jet.server.util.SCMEventListener;
import jet.server.util.SCMEventManager;
import jet.util.NullStream;
import server.servlet.http.HttpAdminServer;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerBase;

public class JREntServer
implements SCMEventListener {
    private static boolean I = false;
    private static HttpServer QOIV = null;
    private static HttpAdminServer addSCMEventListener = null;

    protected static void help() {
        PrintStream printStream = System.err;
        printStream.println("Usage: srun [options]");
        printStream.println("Options:");
        printStream.println("  -?                print this help message");
        printStream.println("  -p port           the port number to listen on");
        printStream.println("  -ap adminport    the port number administration tools used");
        printStream.println("  -realm realmname  active realm");
        printStream.println("  -l backlog        maximum queue length for incoming connection indications");
        printStream.println("  -m max            maximum number of connection handlers");
        printStream.println("  -t timeout        connection timeout in milliseconds");
        printStream.println("  -s filename       servlet property file name");
        printStream.println("  -web directory    root directory when access via web, default value is %install_root%\\public_html");
        printStream.println("  -env              print environment");
        printStream.println("  -silent           output nothing");
        printStream.println("  -local            administration on local host only");
        printStream.println("  -vDebug           Enables JReport Engine to output messages to a file and sets all log files' trace levels to INFO and error levels to WARN");
        printStream.println("  -vError           Enables JReport Engine to output messages to a file and sets all log files' trace levels to OFF and error levels to ERROR. ");
        printStream.println("  -logall           set all error log levels to WARNING and trace log levels to TRIVIAL");
        printStream.println("  -jrs.admin.server");
        printStream.println("       [host:port]  admin server's host and RMI port");
        printStream.println("  -cleanup          check integrality of server data and cleanup invalid data");
        System.exit(1);
    }

    protected static void printEnv() {
        System.out.println("Java VM: " + System.getProperty("java.version"));
        System.out.println("Java home: " + System.getProperty("java.home"));
        System.out.println("Server port: " + ServerEnv.getPort());
        System.out.println("Administration port: " + ServerEnv.getAdminPort());
        System.out.println("Active realm: " + ServerEnv.getActiveRealm());
        System.out.println("Maximum connection handlers: " + QOIV.getMaxHandlers());
        System.out.println("Connection timeout(ms): " + QOIV.getTimeout());
        System.out.println("Maximum connection queue length: " + QOIV.getBacklog());
        if (I) {
            System.out.println("Administration on local host only");
        }
    }

    public static synchronized void shutdownServer() {
        if (QOIV != null) {
            QOIV.quitWithoutExit();
            QOIV = null;
        }
        if (addSCMEventListener != null) {
            addSCMEventListener.quit();
            addSCMEventListener = null;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Serializable serializable;
        Object object2;
        ExProperties exProperties = new ExProperties();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        String string = "jrserver.log";
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                object2 = stringArray[n2];
                if (((String)object2).equals("-?") || ((String)object2).equals("-help")) {
                    JREntServer.help();
                    return;
                }
                if (((String)object2).equalsIgnoreCase("-p")) {
                    exProperties.put("httpserver.port", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-ap")) {
                    exProperties.put("httpserver.admin.port", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-realm")) {
                    exProperties.put("server.realm.active", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-l")) {
                    exProperties.put("httpserver.backlog", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-m")) {
                    exProperties.put("httpserver.max.handlers", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-t")) {
                    exProperties.put("httpserver.timeout", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-d")) {
                    exProperties.put("servlet.dir", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-web")) {
                    if (!((File)(serializable = new File((String)(object = stringArray[++n2])))).isDirectory()) {
                        System.out.println((String)object + " is not a directory!");
                        System.exit(1);
                    } else if (!((File)serializable).exists()) {
                        System.out.println((String)object + " does not exist!");
                        System.exit(1);
                    } else if (!((File)serializable).canRead()) {
                        System.out.println((String)object + " can not be read!");
                        System.exit(1);
                    }
                    ServerEnv.setWebDir((String)object);
                } else if (((String)object2).equalsIgnoreCase("-r")) {
                    exProperties.put("document.dir", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-s")) {
                    exProperties.put("httpserver.servlet.propfile", stringArray[++n2]);
                } else if (((String)object2).equalsIgnoreCase("-env")) {
                    bl = true;
                } else if (((String)object2).equalsIgnoreCase("-silent")) {
                    System.setOut(new PrintStream((OutputStream)new NullStream()));
                    System.setErr(new PrintStream((OutputStream)new NullStream()));
                } else if (((String)object2).equalsIgnoreCase("-local")) {
                    I = true;
                } else if (((String)object2).equalsIgnoreCase("-vError")) {
                    n |= 4;
                } else if (((String)object2).equalsIgnoreCase("-vDebug")) {
                    n |= 1;
                } else if (((String)object2).equalsIgnoreCase("-logall")) {
                    n = 5;
                } else if (((String)object2).toUpperCase().startsWith("-log".toUpperCase())) {
                    System.out.println("-log[:fileName] option has been discarded, please set the logger file name in " + System.getProperty("reporthome") + "\\bin\\LogConfig.properties.");
                } else if (((String)object2).equalsIgnoreCase("-jrs.admin.server")) {
                    System.getProperties().put("jrs.admin.server", stringArray[++n2]);
                } else if (((String)object2).startsWith("-Rsystables:")) {
                    System.getProperties().put("restore.systables", ((String)object2).substring("-Rsystables:".length()));
                } else if (((String)object2).startsWith("-Rprofiling:")) {
                    System.getProperties().put("restore.profiling", ((String)object2).substring("-Rprofiling:".length()));
                } else if (((String)object2).equalsIgnoreCase("-cleanup")) {
                    System.getProperties().put("check.systables", "true");
                } else {
                    System.err.println("Invalid option:" + (String)object2);
                    bl2 = false;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            JREntServer.help();
        }
        if (!bl2) {
            JREntServer.help();
        }
        if (JRLog.isAd()) {
            JRLog.print((Object)("set debugLevel in main :" + n));
        }
        if (n != 0) {
            JDebug.setDebugLevel((int)n);
            ServiceLogger.setDebug();
        }
        boolean bl4 = APIUtil.getBoolean(System.getProperty("isLaunchPad"), false);
        try {
            QOIV = new HttpServer(exProperties, false);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            if (bl4) {
                JREntServer.I();
            }
            System.exit(1);
        }
        object2 = new HttpAdminServer(QOIV.getServerPorps(), QOIV, I);
        QOIV.setAdminServer((HttpAdminServer)object2);
        ((HttpAdminServer)object2).setLocalOnly(I);
        addSCMEventListener = object2;
        QOIV.start();
        ((HttpServerBase)object2).start();
        System.out.println(ReportEnv.getProductionName() + " Version " + 9 + "." + 0 + "." + 0 + (ReportEnv.servicepack != 0 ? "; Service Pack: " + ReportEnv.servicepack : "") + (ReportEnv.updates != 0 ? "; Update: " + ReportEnv.updates : ""));
        System.out.println("");
        if (bl) {
            JREntServer.printEnv();
            System.out.println("");
        }
        System.out.println(JSvrResource.getMessage("SERVER_OK"));
        System.out.println("");
        System.out.println(ReportEnv.getProductionName() + " is ready for service.");
        object = new JREntServer();
        serializable = SCMEventManager.getInstance();
        ((SCMEventManager)serializable).addSCMEventListener((SCMEventListener)object);
        ServiceLogger.logDebug(4670008, object, 4);
        if (bl4) {
            JREntServer.I();
        }
        try {
            ShutdownThread.registerShutdownHook();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        QOIV.lockForPreviewServer();
    }

    private static void I() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
            if (string == null) {
                string = inetAddress.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(unknownHostException);
        }
        if (string == null) {
            string = "localhost";
        }
        int n = ServerEnv.getPort();
        String string2 = "http://" + string + ":" + n + "/launchpad.jsp";
        String string3 = System.getProperty("DefaultBrowserPath");
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(string3 + " " + string2);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public void handleSCMEvent(SCMEvent sCMEvent) {
        int n = sCMEvent.getID();
        switch (n) {
            case 1: {
                ServiceLogger.logDebug(4670009, 4);
                ServiceLogger.logDebug(4670010, QOIV, 4);
                QOIV.quitWithoutExit();
                break;
            }
            case 3: {
                ServiceLogger.logDebug(4670011, 4);
                break;
            }
            case 4: {
                ServiceLogger.logDebug(4670012, 4);
                break;
            }
            case 2: {
                ServiceLogger.logDebug(4670013, 4);
                break;
            }
            default: {
                ServiceLogger.logDebug(4670014, new Integer(n), 4);
            }
        }
    }
}

