/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.Authenticator;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.schedule.SchdTools;
import jet.util.Base64;

public class BaseHttpUtil {
    public static final String PROP_OUTPUT_ENCODING = "output_encoding";
    public static final String CONTENT_LOCATION = "Content-Location";
    protected static boolean isRemoteServer = false;

    protected BaseHttpUtil() {
    }

    public static String makeQuery(Hashtable hashtable) {
        return CSUtil.makeNoHeadQuery(hashtable);
    }

    public static Properties parseQuery(String string) {
        return CSUtil.parseQuery(string);
    }

    public static Properties getParameters(HttpServletRequest httpServletRequest) {
        int n = BaseHttpUtil.append();
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        switch (n) {
            case 0: {
                BaseHttpUtil.QOIV(httpServletRequest, properties, ";");
                break;
            }
            case 1: {
                BaseHttpUtil.QOIV(httpServletRequest, properties, " ");
                break;
            }
            case 2: {
                BaseHttpUtil.QOIV(httpServletRequest, properties, ",");
                break;
            }
            case 3: {
                BaseHttpUtil.QOIV(httpServletRequest, properties, ":");
                break;
            }
            case 4: {
                Enumeration enumeration = httpServletRequest.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String[] stringArray = httpServletRequest.getParameterValues(string);
                    int n2 = stringArray.length;
                    String string2 = null;
                    properties2.clear();
                    if (stringArray.length > 1) {
                        int n3 = 0;
                        while (n3 < n2) {
                            if (n3 == 0) {
                                string2 = "\"" + stringArray[0] + "\"";
                                properties2.put(stringArray[0], "");
                            } else if (properties2.get(stringArray[n3]) == null) {
                                string2 = string2 + "\"" + stringArray[n3] + "\"";
                                properties2.put(stringArray[n3], "");
                            }
                            ++n3;
                        }
                    } else {
                        string2 = stringArray[0];
                    }
                    if (string2 == null) continue;
                    properties.put(string, string2);
                }
                break;
            }
            case 5: {
                Enumeration enumeration = httpServletRequest.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String[] stringArray = httpServletRequest.getParameterValues(string);
                    int n4 = stringArray.length;
                    String string3 = null;
                    properties2.clear();
                    if (stringArray.length > 1) {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (n5 == 0) {
                                string3 = "{" + stringArray[0] + "}";
                                properties2.put(stringArray[0], "");
                            } else if (properties2.get(stringArray[n5]) == null) {
                                string3 = string3 + "{" + stringArray[n5] + "}";
                                properties2.put(stringArray[n5], "");
                            }
                            ++n5;
                        }
                    } else {
                        string3 = stringArray[0];
                    }
                    if (string3 == null) continue;
                    properties.put(string, string3);
                }
                break;
            }
            default: {
                BaseHttpUtil.QOIV(httpServletRequest, properties, ";");
            }
        }
        return properties;
    }

    private static Properties QOIV(HttpServletRequest httpServletRequest, Properties properties, String string) {
        Properties properties2 = new Properties();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string2);
            String string3 = httpServletRequest.getParameter("_isMultiple_" + string2);
            if (string3 != null && string3.trim().length() > 0) {
                properties.put(string2, stringArray);
                continue;
            }
            int n = stringArray.length;
            String string4 = null;
            properties2.clear();
            int n2 = 0;
            while (n2 < n) {
                if (n2 == 0) {
                    string4 = stringArray[0];
                    properties2.put(stringArray[0], "");
                } else if (properties2.get(stringArray[n2]) == null) {
                    string4 = string4 + string + stringArray[n2];
                    properties2.put(stringArray[n2], "");
                }
                ++n2;
            }
            if (string4 == null) continue;
            properties.put(string2, string4);
        }
        return properties;
    }

    private static int append() {
        String string;
        if (isRemoteServer) {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            string = httpRptServer.getServerEnv().getWebPageOptions().getMultipleParameterValuesDelimiter();
        } else {
            string = ServerEnv.getMultipleParameterValuesDelimiter();
        }
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.equals("&nbsp;")) {
            return 1;
        }
        if (string.equals(",")) {
            return 2;
        }
        if (string.equals(":")) {
            return 3;
        }
        if (string.equals("\"")) {
            return 4;
        }
        if (string.equals("{}")) {
            return 5;
        }
        return 0;
    }

    public static String decodeEsc(String string) {
        return CSUtil.convertEscapes(string);
    }

    public static String encodeEsc(String string) {
        return CSUtil.replWithEsc(string);
    }

    public static boolean dirIncludeCatalog(HttpRptServer httpRptServer, String string, String string2) {
        int n;
        Vector vector = null;
        String string3 = null;
        try {
            vector = httpRptServer.getResourceManager().getSubpathsAndCatalogs(string, string2);
        }
        catch (Exception exception) {
            string3 = exception.getMessage();
        }
        int n2 = n = vector == null ? 0 : vector.size();
        if (n == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            PathInfo pathInfo = (PathInfo)vector.elementAt(n3);
            try {
                if (pathInfo.isCatalog()) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
            ++n3;
        }
        return false;
    }

    public static boolean dirIncludeReport(HttpRptServer httpRptServer, String string, String string2) {
        int n;
        Vector vector = null;
        String string3 = null;
        try {
            vector = httpRptServer.getResourceManager().getSubpathsAndCatalogs(string, string2);
        }
        catch (RptServerException rptServerException) {
            string3 = rptServerException.getMessage();
        }
        int n2 = n = vector == null ? 0 : vector.size();
        if (n == 0) {
            return false;
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        int n3 = 0;
        while (n3 < n) {
            PathInfo pathInfo = (PathInfo)vector.elementAt(n3);
            boolean bl = pathInfo.isDir();
            boolean bl2 = pathInfo.isCatalog();
            boolean bl3 = pathInfo.isSelfContainReport();
            boolean bl4 = pathInfo.isReport();
            String string4 = pathInfo.getName();
            String string5 = HttpUtil.encodeEsc(string4);
            if (bl2 || bl4 || bl3) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static String encodeEsc(String string, boolean bl) {
        return CSUtil.replWithEsc(string, bl);
    }

    public static void sendMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) {
        BaseHttpUtil.changePassword(httpServletRequest, httpServletResponse, n, string, null);
    }

    public static void sendMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, Throwable throwable) {
        BaseHttpUtil.changePassword(httpServletRequest, httpServletResponse, n, null, throwable);
    }

    private static void changePassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string, Throwable throwable) {
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (throwable != null) {
            if (string2 != null) {
                string2 = string2 + " -" + JSvrResource.getMessage("SLT_ERR_65") + ": \n";
            }
            string2 = string2 + SchdTools.getStackTraceString(throwable);
        }
        httpServletResponse.setStatus(n);
        httpServletResponse.setHeader("JRS-MESSAGE", CSUtil.replWithEsc(string2));
        try {
            if (n == 200) {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                httpServletResponse.setContentType("text/html");
                servletOutputStream.println("<html>");
                servletOutputStream.println("<head>");
                servletOutputStream.println("<title>" + JSvrResource.getMessage("SLT_ERR_66") + "</title>");
                servletOutputStream.println("</head>");
                servletOutputStream.println("<body>");
                servletOutputStream.println("<H1>" + JSvrResource.getMessage("SLT_ERR_67") + "</H1>");
                servletOutputStream.write(string2.getBytes());
                servletOutputStream.println();
                servletOutputStream.println("</body>");
                servletOutputStream.println("</html>");
            } else {
                httpServletResponse.sendError(n, string2);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static String changePassword(Authenticator authenticator, String string, String string2, boolean bl, Hashtable hashtable) throws IOException {
        String string3 = null;
        String string4 = (String)hashtable.get("jrs.uid");
        String string5 = (String)hashtable.get("jrs.password");
        String string6 = (String)hashtable.get("jrs.new_password");
        String string7 = (String)hashtable.get("jrs.confirm_new_password");
        if (string4 == null || string4.trim().length() == 0) {
            return JSvrResource.getMessage("SLT_ERR_69");
        }
        if (bl) {
            string4 = new String(Base64.decode((String)BaseHttpUtil.dc(string4)), "ISO-8859-1");
        }
        if (bl) {
            if (string5 != null && string5.trim().length() != 0) {
                string5 = new String(Base64.decode((String)BaseHttpUtil.dc(string5)), "ISO-8859-1");
            }
            if (string6 != null && string6.trim().length() != 0) {
                string6 = new String(Base64.decode((String)BaseHttpUtil.dc(string6)), "ISO-8859-1");
            }
            if (string7 != null && string7.trim().length() != 0) {
                string7 = new String(Base64.decode((String)BaseHttpUtil.dc(string7)), "ISO-8859-1");
            }
        }
        string3 = string6 == null && string7 == null || string6 != null && string7 != null && string6.equals(string7) ? authenticator.changePassword(string, string2, string4, string5, string6) : JSvrResource.getMessage("SLT_ERR_70");
        return string3;
    }

    private static String dc(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 2 == 0) {
                char c = stringBuffer.charAt(n3);
                char c2 = stringBuffer.charAt(n2);
                stringBuffer.setCharAt(n3, c2);
                stringBuffer.setCharAt(n2, c);
            }
            ++n3;
            --n2;
        }
        return stringBuffer.reverse().toString();
    }

    public static boolean isJRClient(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        boolean bl = false;
        String string = httpServletRequest.getHeader("User-Agent");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.toLowerCase().startsWith("JRViewer".toLowerCase()) && !string2.toLowerCase().startsWith("JRClient-API".toLowerCase()) && !string2.toLowerCase().startsWith("JRptClient".toLowerCase())) continue;
                bl = true;
                break;
            }
        }
        if (!bl && hashtable != null) {
            bl = CSUtil.getBoolean((String)hashtable.get("jrs.is_plain"), false);
        }
        return bl;
    }

    public static boolean isClientAPI(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        boolean bl = false;
        String string = httpServletRequest.getHeader("User-Agent");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.toLowerCase().startsWith("JRClient-API".toLowerCase())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String getTempResultKey(String string) {
        String string2 = string;
        if (string2 != null) {
            int n = string2.lastIndexOf(".");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf("_")) >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static void redirect(HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, String string2) throws IOException {
        httpServletResponse.setStatus(301);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Location", string);
        httpServletResponse.setHeader(CONTENT_LOCATION, string);
        printWriter.println("<html><head><title>" + JSvrResource.getMessage("SLT_PG_125") + "</title>");
        printWriter.println("</head><body><H1>" + JSvrResource.getMessage("SLT_PG_125") + "</H1>");
        printWriter.println(JSvrResource.getMessage("SLT_PG_126") + ":");
        printWriter.println("<a href=\"" + string + "\">" + string2 + "</a></body></html>");
        printWriter.close();
    }

    public static void outputHtmlTableHeader(PrintWriter printWriter, String string, String[] stringArray) throws IOException {
        printWriter.println("<table style=\"font-family:Arial;font-size:10pt;\" bgColor=\"#dcdcdc\" border=\"0\" cellPadding=\"2\" cellSpacing=\"1\" width=100%>");
        printWriter.println("<caption align=\"left\"><b>" + string + "</b></caption><tr bgcolor=\"#000000\">");
        int n = 0;
        while (n < stringArray.length) {
            printWriter.print("<td align=\"center\"><b><font color=\"#ECECEC\">" + stringArray[n] + "</td>");
            ++n;
        }
        printWriter.println("</tr>");
    }

    public static int getResultType(String string, int n) {
        return CSUtil.getResultType(string, n);
    }

    public static boolean hasPageSecurity(String string) {
        return new File(CSUtil.removeExtName(string) + ".pgn").exists();
    }
}

