/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import jet.Env;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.ServerEnvBuilder;
import jet.server.api.RemoteFileService;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.admin.cfg.ConfigurationCluster;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoRemoteServerException;
import jet.server.api.http.BaseHttpUtil;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.TooManyTimesException;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.intf.jrs.RemoteNLSManager;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrrmisvr.JRNLSManager;
import jet.server.jrserver.http.JRHttpRptServer;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.server.util.ServerUtil;
import jet.server.util.UploadFileUtil;
import jet.util.HashVector;
import server.servlet.http.HttpResponse;

public class HttpUtil
extends BaseHttpUtil {
    private static boolean LINE = false;
    private static HttpRptServer QOIV = null;
    private static boolean activeCount = false;
    private static String add = null;
    private static String append = null;
    private static String build = null;
    private static String canRead = null;
    private static boolean checkAdminLogin = true;
    private static String checkLogin = null;
    private static String close = null;
    private static String closeAll = null;
    private static String connect = null;
    private static String copyFilesByPrefix = null;
    private static String decodeEsc = null;
    private static boolean disconnect = false;
    private static boolean endsWith = false;
    private static String entries = "JReport.log";
    private static int enumerate = 0;
    private static int equals = 2000;
    private static HashVector equalsIgnoreCase = new HashVector();
    private static HashVector exists = new HashVector();
    private static String finish = null;
    private static String flush = null;
    private static RemoteFileService forName = null;
    private static RemoteNLSManager freeMemory = null;
    private static List get = null;
    private static String getActiveRMIPort = null;
    private static final String[] getActiveRealm = new String[]{"jrs.submit_schedule_form", "jrs.try_vw", "jrs.web_vw", "jrs.submit_schedule", "jrs.submit_schedule_form_old", "jrs.run_vw", "jrs.run_task"};

    private HttpUtil() {
    }

    public static synchronized void initEnv(Properties properties) {
        String string;
        String string2 = "reporthome";
        String string3 = "install.root";
        String string4 = "jreport.context";
        Properties properties2 = System.getProperties();
        Properties properties3 = ServerEnvBuilder.servEnv;
        if (endsWith) {
            properties2.put(string4, "");
            properties2.remove(string4);
            HttpUtil.getHttpRptServer();
            return;
        }
        try {
            Object object;
            block53: {
                if (properties == null) {
                    throw new IllegalArgumentException(" props = null ");
                }
                ServerEnvBuilder.prepare(properties);
                ServerEnvBuilder.build(properties);
                ServerEnvBuilder.mergeServerProperties(properties);
                activeCount = ServerEnvBuilder.isStandalone();
                BaseHttpUtil.isRemoteServer = ServerEnvBuilder.isRMIntegrate();
                if (BaseHttpUtil.isRemoteServer) {
                    finish = properties2.getProperty("jrs.remote.host");
                    flush = properties2.getProperty("jrs.remote.rmiport");
                }
                if ((string = properties3.getProperty(string2)) == null) {
                    string = System.getProperty(string3);
                }
                if (string == null) {
                    string = Env.getReportHome();
                }
                if (string != null) {
                    ServerEnvBuilder.setReporthome(string);
                    checkLogin = string;
                    if (!checkLogin.endsWith(File.separator)) {
                        checkLogin = checkLogin + File.separator;
                    }
                }
                String string5 = "temp_dir";
                String string6 = "jrs.dir.temp";
                close = properties.getProperty(string5);
                if (close != null && close.trim().length() > 0) {
                    System.getProperties().put(string6, close.trim());
                } else {
                    close = properties.getProperty(string6);
                }
                String string7 = "history_dir";
                String string8 = "jrs.dir.history";
                closeAll = properties.getProperty(string7);
                if (closeAll != null && closeAll.trim().length() > 0) {
                    System.getProperties().put(string8, closeAll.trim());
                } else {
                    closeAll = properties.getProperty(string8);
                }
                if (!BaseHttpUtil.isRemoteServer) {
                    String string9 = "jrs.server_class";
                    canRead = properties.getProperty(string9);
                    if (ServiceLogger.isLoggable(4, 6)) {
                        ServiceLogger.logDebug(6670018, canRead, 6);
                    }
                    QOIV = canRead == null || canRead.trim().length() == 0 ? new JRHttpRptServer() : (HttpRptServer)Class.forName(canRead.trim()).newInstance();
                    QOIV.init(properties);
                } else {
                    QOIV = RemoteReportServerToolkit.getRemoteWrappedRptServer(finish, flush);
                    forName = RemoteReportServerToolkit.getRemoteFileService(finish, flush);
                    ServerEnv.initEmptyServerProps();
                    try {
                        freeMemory = (RemoteNLSManager)RemoteObjectFactory.getRemoteObject(finish, Integer.parseInt(flush), "nlsManager");
                        UserDataToolkit.setNLSManager(new JRNLSManager(freeMemory));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (QOIV == null) {
                        return;
                    }
                }
                if (BaseHttpUtil.isRemoteServer) {
                    add = String.valueOf(QOIV.getServerEnv().getWebPageOptions().getActiveRealmScheme());
                } else {
                    boolean bl = ServerEnv.isClusterAdminServer();
                    if (bl) {
                        add = properties.getProperty("auth_scheme");
                        if (add != null) {
                            if ((add = add.trim()).equalsIgnoreCase("Digest")) {
                                add = "Digest";
                            } else if (add.equalsIgnoreCase("Basic")) {
                                add = "Basic";
                            } else {
                                add = "Basic";
                                ServiceLogger.logError(2670019, new Object[]{add, "Basic"}, 2);
                            }
                        } else {
                            String string10 = ServerEnv.getActiveRealm();
                            Realm realm = Realm.get(string10);
                            if (realm != null) {
                                add = realm.getScheme() == 0 ? "Basic" : "Digest";
                            } else {
                                add = "Basic";
                                ServiceLogger.logError(2670020, "Basic", 2);
                            }
                        }
                    } else {
                        String string11;
                        ClusterService clusterService = QOIV.getClusterService();
                        Member member = clusterService.getAdminMember();
                        String string12 = member.getHost();
                        MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string12, CSUtil.parseInt(string11 = member.getPort()), "MemberMonitor");
                        add = (String)memberMonitor.getCommonProps().get("jrs.auth_scheme");
                        if (add == null || add.length() == 0) {
                            add = "Basic";
                            ServiceLogger.logError(2670019, new Object[]{add, "Basic"}, 2);
                        }
                    }
                }
                build = properties.getProperty("default_doc");
                if (build != null) {
                    if (ServiceLogger.isLoggable(4, 6)) {
                        ServiceLogger.logDebug(0x65C6C5, build, 6);
                    }
                    if (build.trim().length() != 0) {
                        try {
                            File file = new File(build);
                            if (!file.exists() || file.isDirectory()) {
                                ServiceLogger.logDebug(4670022, build, 4);
                                build = null;
                                break block53;
                            }
                            build = file.getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException);
                            build = null;
                        }
                    } else {
                        build = null;
                    }
                }
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6670023, build, 6);
            }
            if ((append = properties.getProperty("codebase")) == null || append.length() == 0) {
                append = QOIV.getServerEnv().getHomePath() + "lib";
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6670024, append, 6);
            }
            try {
                object = new File(append);
                if (!((File)object).exists() || ((File)object).isFile()) {
                    append = null;
                    ServiceLogger.logError(2670025, append, 2);
                } else {
                    append = ((File)object).getCanonicalPath();
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
                ServiceLogger.logError(2670026, append, 2);
                append = null;
            }
            try {
                checkAdminLogin = BaseHttpUtil.isRemoteServer ? QOIV.getServerEnv().getWebPageOptions().needSecurity() : ServerEnv.needSecurity();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            object = properties.getProperty("isConvertedServletPath");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                LINE = true;
            }
            if (!BaseHttpUtil.isRemoteServer) {
                QOIV.start();
            }
            disconnect = true;
            endsWith = true;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        string = null;
        try {
            string = QOIV.getResourceManager().getRealm();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (ServiceLogger.isLoggable(3, 4)) {
            ServiceLogger.logEvent(4670027, new Object[]{string, close, closeAll, build, canRead, append, connect, add, LINE, decodeEsc, copyFilesByPrefix, entries, checkAdminLogin}, 4);
        }
    }

    public static boolean isRemoteServer() {
        return BaseHttpUtil.isRemoteServer;
    }

    public static RemoteFileService getRemoteFileService() {
        return forName;
    }

    public static HttpRptServer getHttpRptServer() {
        if (BaseHttpUtil.isRemoteServer) {
            QOIV = RemoteReportServerToolkit.getRemoteWrappedRptServer(finish, flush);
            forName = RemoteReportServerToolkit.getRemoteFileService(finish, flush);
            try {
                if (freeMemory != null) {
                    freeMemory.getAvailableEncoding();
                }
            }
            catch (RemoteException remoteException) {
                freeMemory = null;
            }
            try {
                if (freeMemory == null) {
                    freeMemory = (RemoteNLSManager)RemoteObjectFactory.getRemoteObject(finish, Integer.parseInt(flush), "nlsManager");
                    UserDataToolkit.setNLSManager(new JRNLSManager(freeMemory));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return QOIV;
    }

    public static String getAuthScheme() {
        return add;
    }

    public static String getDefaultDoc() {
        return build;
    }

    public static String getBase(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.QOIV(httpServletRequest, true, bl, false);
    }

    public static String getBaseNoPath(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.QOIV(httpServletRequest, false, bl, false);
    }

    public static String getQueryBase(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.QOIV(httpServletRequest, true, bl, true);
    }

    public static String getQueryBaseNoPath(HttpServletRequest httpServletRequest, boolean bl) {
        return HttpUtil.QOIV(httpServletRequest, false, bl, true);
    }

    private static String LINE(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        return httpSession.getId();
    }

    private static String QOIV(HttpServletRequest httpServletRequest, boolean bl, boolean bl2, boolean bl3) {
        String string = null;
        if (bl && (string = httpServletRequest.getPathInfo()) != null && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string == null) {
            string = "";
        } else if (string.length() > 0 && !string.startsWith("/")) {
            string = "/" + string;
        }
        String string2 = HttpUtil.getServletPath(httpServletRequest);
        if (string2 == null) {
            string2 = "";
        } else {
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return bl3 && string2.trim().length() == 0 && string.trim().length() == 0 ? "/" : (bl2 ? CSUtil.replWithEsc(string2, false) : string2) + (bl2 ? CSUtil.replWithEsc(string, false) : string);
    }

    public static String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        if (!BaseHttpUtil.isRemoteServer) {
            UserSession userSession = QOIV.getHttpUserSessionManager().getUserSession(httpServletRequest);
            if (userSession != null) {
                string = userSession.getUserID();
            }
        } else {
            string = QOIV.getHttpUserSessionManager().getUser(httpServletRequest);
        }
        return string == null ? "" : string;
    }

    public static boolean isSecure() {
        return checkAdminLogin;
    }

    public static void restartServer() throws Throwable {
        try {
            ServiceLogger.logEvent(4670028, QOIV, 4);
            QOIV.restart(System.getProperties());
            disconnect = true;
            ServiceLogger.logEvent(4670029, QOIV, 4);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void shutdownServer() throws Throwable {
        block8: {
            block7: {
                try {
                    try {
                        block10: {
                            block9: {
                                if (!disconnect) break block9;
                                if (!HttpUtil.isRemoteServer()) break block10;
                            }
                            Object var2 = null;
                            break block7;
                        }
                        ServiceLogger.logEvent(4670030, QOIV, 4);
                        QOIV.shutdown();
                        QOIV = null;
                        if (HttpUtil.connect()) {
                            HttpUtil.close();
                        }
                        ServiceLogger.logEvent(4670031, QOIV, 4);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ServiceLogger.closeAll();
                    ServerEnvBuilder.release();
                    endsWith = false;
                    disconnect = false;
                    throw throwable;
                }
            }
            ServiceLogger.closeAll();
            ServerEnvBuilder.release();
            endsWith = false;
            disconnect = false;
            return;
        }
        Object var2_1 = null;
        ServiceLogger.closeAll();
        ServerEnvBuilder.release();
        endsWith = false;
        disconnect = false;
    }

    public static String getHttpURL() {
        return getActiveRMIPort;
    }

    public static boolean checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        return HttpUtil.activeCount(httpServletRequest, httpServletResponse, false);
    }

    public static boolean checkAdminLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        return HttpUtil.activeCount(httpServletRequest, httpServletResponse, true);
    }

    private static boolean activeCount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws TooManyUsersException, IOException, TooManyTimesException, RuntimeException, NoRemoteServerException {
        boolean bl2;
        String string;
        Object object;
        if (getActiveRMIPort == null) {
            object = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).substring(0);
            int n = ((String)object).indexOf(":", "http://".length());
            int n2 = n = n == -1 ? ((String)object).indexOf("/", "http://".length()) : n;
            if (n != -1) {
                string = InetAddress.getLocalHost().getHostAddress();
                int n3 = ((String)object).lastIndexOf("/");
                getActiveRMIPort = "http://" + string + ((String)object).substring(n, n3 + 1);
            }
        }
        HttpUtil.initEnv(System.getProperties());
        if (BaseHttpUtil.isRemoteServer && QOIV == null) {
            object = finish == null ? "null" : finish;
            String string2 = flush == null ? "null" : flush;
            throw new NoRemoteServerException(670010, new Object[]{object, string2}, null);
        }
        QOIV.getHttpUserSessionManager().removeExpiredUserSessions(httpServletRequest);
        object = new Properties();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ((Properties)object).put(string, httpServletRequest.getParameter(string));
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(6670032, QOIV, 6);
            ServiceLogger.logDebug(6670033, QOIV.getHttpUserSessionManager(), 6);
            ServiceLogger.logDebug(6670034, QOIV.getResourceManager(), 6);
        }
        boolean bl3 = bl2 = HttpUtil.isSecure() && QOIV.getHttpUserSessionManager().getUserSession(httpServletRequest) == null;
        if (bl && !QOIV.getHttpUserSessionManager().checkAdminLogin(httpServletRequest, httpServletResponse, QOIV.getResourceManager().getRealm(), (Properties)object)) {
            QOIV.getHttpUserSessionManager().sendUnauthorizedResponse(httpServletRequest, httpServletResponse, add, QOIV.getResourceManager().getRealm());
            return false;
        }
        if (!QOIV.getHttpUserSessionManager().checkLogin(httpServletRequest, httpServletResponse, QOIV.getResourceManager().getRealm(), (Properties)object)) {
            QOIV.getHttpUserSessionManager().sendUnauthorizedResponse(httpServletRequest, httpServletResponse, add, QOIV.getResourceManager().getRealm());
            return false;
        }
        if (bl2) {
            HttpUtil.add(httpServletRequest);
        }
        UserSession userSession = QOIV.getHttpUserSessionManager().getUserSession(httpServletRequest);
        try {
            if (userSession != null) {
                QOIV.getHttpUserSessionManager().refreshLastAccessTime(userSession.getID());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return true;
    }

    private static void add(HttpServletRequest httpServletRequest) {
        UserSession userSession = QOIV.getHttpUserSessionManager().getUserSession(httpServletRequest);
        Enumeration enumeration = QOIV.getHttpUserSessionManager().getAllUserSessions();
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                UserSession userSession2 = (UserSession)enumeration.nextElement();
                if (!userSession2.getUserID().equals(userSession.getUserID())) continue;
                ++n;
            }
        }
        if (n == 1) {
            QOIV.getResourceManager().loadUserResAliasToMem(userSession.getUserID());
        }
    }

    public static void logout(HttpServletRequest httpServletRequest) {
        if (!HttpUtil.isSecure()) {
            return;
        }
        UserSession userSession = QOIV.getHttpUserSessionManager().getUserSession(httpServletRequest);
        if (userSession == null) {
            return;
        }
        String string = userSession.getUserID();
        HttpUtil.getHttpRptServer().getHttpUserSessionManager().logout(httpServletRequest);
        Enumeration enumeration = QOIV.getHttpUserSessionManager().getAllUserSessions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                UserSession userSession2 = (UserSession)enumeration.nextElement();
                if (!userSession2.getUserID().equals(userSession.getUserID())) continue;
                return;
            }
        }
        QOIV.getResourceManager().rmUserResAliasFromMem(string);
    }

    public static boolean checkPermission(HttpServletRequest httpServletRequest) throws NoPrivilegeException {
        String string;
        Object object;
        String string2;
        String string3;
        QOIV.getTempResultOwnerManager().removeOwnersIfTimeout();
        String string4 = httpServletRequest.getParameter("jrs.cmd");
        if (string4 != null) {
            string4 = string4.trim().toLowerCase();
        } else {
            string4 = httpServletRequest.getParameter("cmd");
            if (string4 != null) {
                string4 = string4.trim().toLowerCase();
            }
        }
        if (string4 != null && QOIV.getHttpUserSessionManager().isExtraChannel(httpServletRequest)) {
            int n = 0;
            while (n < getActiveRealm.length) {
                if (string4.equals(getActiveRealm[n])) {
                    throw new NoPrivilegeException(630008);
                }
                ++n;
            }
        }
        if ((string3 = httpServletRequest.getParameter("jrs.path")) == null || string3.length() == 0) {
            string2 = httpServletRequest.getParameter("jrs.catalog");
            string3 = string2 != null && string2.length() > 0 && string2.lastIndexOf("/") != -1 ? string2.substring(0, string2.lastIndexOf("/") + 1) : ((object = httpServletRequest.getParameter("jrs.report")) != null && ((String)object).length() > 0 && ((String)object).lastIndexOf("/") != -1 ? ((String)object).substring(0, ((String)object).lastIndexOf("/") + 1) : "/");
        }
        if (string4 != null && (string4.equalsIgnoreCase("jrs.try_vw") || string4.equalsIgnoreCase("jrs.web_vw")) && (string2 = httpServletRequest.getParameter("jrs.report")) != null) {
            string3 = string2;
        }
        if (string3.indexOf("/") == -1) {
            string3 = BaseHttpUtil.decodeEsc(string3);
        }
        int n = CSUtil.parseInt(httpServletRequest.getParameter("jrs.version_number"), -1);
        if (ServiceLogger.isLoggable(3, 6)) {
            ServiceLogger.logEvent(6670035, new Object[]{string4, string3, new Integer(n)}, 6);
        }
        object = QOIV.getHttpUserSessionManager().getUserSession(httpServletRequest);
        try {
            if (object != null) {
                QOIV.getHttpUserSessionManager().refreshLastAccessTime(object.getID());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(6670036, QOIV, 6);
            ServiceLogger.logDebug(6670037, QOIV.getHttpUserSessionManager(), 6);
            ServiceLogger.logDebug(6670038, QOIV.getHttpUserSessionManager().getAuthenticator(), 6);
            ServiceLogger.logDebug(6670039, object, 6);
        }
        String string5 = string = object != null ? object.getUserID() : "";
        if (string3.startsWith("/USERFOLDERPATH") && !string3.startsWith("/USERFOLDERPATH/" + string)) {
            string3 = "/USERFOLDERPATH/" + string;
        }
        return HttpUtil.checkPermission(object.getRealm(), string, string3, n, string4 == null ? httpServletRequest.getMethod() : string4);
    }

    private static boolean checkPermission(String string, String string2, String string3, int n, String string4) {
        if (n == -1) {
            return QOIV.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string, string2, string3, string4);
        }
        return QOIV.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string, string2, string3, n, string4);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws IOException {
        Object object;
        Object object2;
        boolean bl;
        String string;
        if (!file.exists()) {
            throw new IOException(JSvrResource.getMessage("SLT_ERR_71", file.getName()));
        }
        if (file.length() <= 0L) {
            ServiceLogger.logDebug(4670126, file.getName(), 4);
        } else {
            if (file.isDirectory()) {
                throw new IOException(JSvrResource.getMessage("SLT_ERR_72", file.getName()));
            }
            if (!file.canRead()) {
                throw new IOException(JSvrResource.getMessage("SLT_ERR_73", file.getName()));
            }
        }
        String string2 = file.getName();
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        if ((string = QOIV.getResourceManager().getMIMEType(string3)) == null || string.trim().length() == 0) {
            string = "application/octet-stream";
        }
        if (!(bl = ServerUtil.isFileNotModified(file, httpServletRequest, httpServletResponse))) {
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType(string);
            httpServletResponse.setContentLength((int)file.length());
            object2 = new FileInputStream(file);
            object = new byte[65536];
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                int n2 = ((FileInputStream)object2).read((byte[])object);
                while (n2 >= 0) {
                    if (n2 > 0) {
                        servletOutputStream.write((byte[])object, 0, n2);
                    }
                    n2 = ((FileInputStream)object2).read((byte[])object);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            ((FileInputStream)object2).close();
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        if (ServiceLogger.isLoggable(0, 5)) {
            object2 = httpServletRequest.getSession(false);
            object = object2 == null ? null : object2.getId();
            ServiceLogger.logAccessSuccessEvent(QOIV.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), (String)object, 5670100, new Object[]{file.getCanonicalPath(), bl ? " 304" : " 200"}, 5);
        }
    }

    public static void sendRemoteFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2;
        if (!HttpUtil.getRemoteFileService().exists(string) || HttpUtil.getRemoteFileService().length(string) <= 0L) {
            throw new IOException(JSvrResource.getMessage("SLT_ERR_71", string));
        }
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string3 = string.substring(n);
        }
        if ((string2 = QOIV.getResourceManager().getMIMEType(string3)) == null || string2.trim().length() == 0) {
            string2 = "application/octet-stream";
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(string2);
        httpServletResponse.setContentLength((int)HttpUtil.getRemoteFileService().length(string));
        FileInputStream fileInputStream = (FileInputStream)HttpUtil.getRemoteFileService().readFile(string);
        byte[] byArray = new byte[65536];
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            int n2 = fileInputStream.read(byArray);
            while (n2 >= 0) {
                if (n2 > 0) {
                    servletOutputStream.write(byArray, 0, n2);
                }
                n2 = fileInputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        fileInputStream.close();
        servletOutputStream.flush();
        servletOutputStream.close();
        if (ServiceLogger.isLoggable(0, 5)) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            String string4 = httpSession == null ? null : httpSession.getId();
            ServiceLogger.logAccessSuccessEvent("", HttpUtil.getUser(httpServletRequest), string4, 5670100, new Object[]{string, " 304"}, 5);
        }
    }

    private static String getURI(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string.indexOf("?") != -1) {
            string = string.substring(0, string.indexOf("?"));
        }
        return string;
    }

    public static String getServletPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServletPath();
        if (activeCount) {
            return string;
        }
        if (string == null) {
            string = "";
        } else {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        String string2 = httpServletRequest.getRequestURI();
        if (string2 != null && string2.length() > 0) {
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() > 0 && string.length() > 0) {
                int n = string2.toLowerCase().indexOf(string.toLowerCase());
                if (n > 1) {
                    string = string2.substring(0, n + string.length());
                } else {
                    String string3 = httpServletRequest.getContextPath();
                    if (!string.startsWith(string3)) {
                        string = string3 + string;
                    }
                }
            }
        }
        return string;
    }

    public static long getReportWaitTimeouts() {
        if (!BaseHttpUtil.isRemoteServer) {
            return ServerEnv.getReportWaitTimeouts();
        }
        return QOIV.getServerEnv().getWebPageOptions().getReportWaitTimeouts();
    }

    public static boolean isPublishTempToVersion() {
        if (!BaseHttpUtil.isRemoteServer) {
            return ServerEnv.isPublishTempToVersion();
        }
        return QOIV.getServerEnv().getWebPageOptions().isPublishTempToVersion();
    }

    public static boolean isPublishTempToVersion(String string) {
        if (!BaseHttpUtil.isRemoteServer) {
            return ServerEnv.isPublishTempToVersion(string);
        }
        return QOIV.getServerEnv().getWebPageOptions().isPublishTempToVersion(string);
    }

    public static boolean isEnableDynamicResource() {
        if (!BaseHttpUtil.isRemoteServer) {
            return ServerEnv.isEnableDynamicResource();
        }
        return QOIV.getServerEnv().getWebPageOptions().isEnableDynamicResource();
    }

    public static boolean isEnableTaskDuration() {
        if (!BaseHttpUtil.isRemoteServer) {
            return ServerEnv.isEnableTaskDuration();
        }
        return QOIV.getServerEnv().getWebPageOptions().isEnableTaskDuration();
    }

    public static void copyFilesByPrefix(String string, String string2, String string3, String string4) throws Exception {
        SchdTools.copyFilesByPrefix(string, string2, string3, string4);
    }

    private static RandomAccessFile append(String string) throws IOException {
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = (RandomAccessFile)exists.get((Object)string);
        if (randomAccessFile == null) {
            randomAccessFile = new RandomAccessFile(string, "r");
            if (equalsIgnoreCase.size() > equals) {
                RandomAccessFile randomAccessFile2 = (RandomAccessFile)equalsIgnoreCase.get(equalsIgnoreCase.elementAt(0));
                equalsIgnoreCase.remove(equalsIgnoreCase.elementAt(0));
                randomAccessFile2.close();
            }
            equalsIgnoreCase.put((Object)string, (Object)randomAccessFile);
        }
        return randomAccessFile;
    }

    public static void processPartialRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, Hashtable hashtable) throws Exception {
        RandomAccessFile randomAccessFile = null;
        String string = httpServletRequest.getHeader("Range");
        if (!file.exists()) {
            BaseHttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JSvrResource.getMessage("SLT_ERR_35", file.getCanonicalPath()));
            return;
        }
        if (string == null) {
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, file);
            return;
        }
        if (string.indexOf("bytes") < 0) {
            throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
        }
        int n = string.indexOf(61);
        if (n < 0) {
            throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
        }
        if ((n = (string = string.substring(n + 1, string.length())).indexOf(45)) < 0) {
            throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
        }
        int n2 = -1;
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
            }
        }
        int n3 = -1;
        string2 = string.substring(n + 1, string.length()).trim();
        if (string2.length() == 0) {
            n3 = -1;
        } else {
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                throw new ProtocolException(JSvrResource.getMessage("SLT_ERR_36"));
            }
        }
        try {
            randomAccessFile = HttpUtil.append(file.getCanonicalPath());
            if (n3 == -1) {
                n3 = (int)randomAccessFile.length();
            }
            int n4 = Math.min(n3 - n2 + 1, (int)randomAccessFile.length() - n2);
            byte[] byArray = new byte[n4];
            randomAccessFile.seek(n2);
            int n5 = randomAccessFile.read(byArray, 0, n4);
            if (ServiceLogger.isLoggable(0, 5)) {
                ServiceLogger.logAccessSuccessEvent(QOIV.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), HttpUtil.LINE(httpServletRequest), 5670101, new Object[]{file.getCanonicalPath(), String.valueOf(n2), String.valueOf(n5), String.valueOf(randomAccessFile.length())}, 5);
            }
            HttpUtil.build(httpServletRequest, httpServletResponse, byArray, n2, n5, (int)randomAccessFile.length(), "application/octet-stream", "chunked", true);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
    }

    private static void build(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, byte[] byArray, int n, int n2, int n3, String string, String string2, boolean bl) throws Exception {
        httpServletResponse.setStatus(206);
        httpServletResponse.setHeader("Content-Range", "bytes " + n + "-" + (n + n2 - 1) + "/" + n3);
        httpServletResponse.setContentType(string);
        httpServletResponse.setContentLength(n2);
        httpServletResponse.getOutputStream().write(byArray, 0, n2);
    }

    public static boolean isShowNameWithPostfix() {
        boolean bl = false;
        try {
            bl = BaseHttpUtil.isRemoteServer ? QOIV.getServerEnv().getWebPageOptions().isShowNameWithPostfix() : ServerEnv.isShowNameWithPostfix();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return bl;
    }

    public static String getJSPWebAppName(String string) {
        String string2 = ServerEnv.getJSPWebAppName(string);
        if (BaseHttpUtil.isRemoteServer && (string2 == null || string2.trim().length() == 0)) {
            return QOIV.getServerEnv().getWebPageOptions().getJSPWebAppName(string);
        }
        return string2;
    }

    public static boolean useRelativeWebAppUrl() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().useRelativeWebAppUrl();
        }
        return ServerEnv.useRelativeAppUrl();
    }

    public static String getWebAppUrl(HttpServletRequest httpServletRequest, String string) {
        String string2 = "";
        if (HttpUtil.useRelativeWebAppUrl()) {
            String string3;
            int n;
            String string4 = HttpUtil.getURI(httpServletRequest);
            string4 = string4.substring(0, string4.lastIndexOf("/"));
            String string5 = string;
            if (!string5.startsWith("/")) {
                string5 = "/" + string5;
            }
            string5 = HttpUtil.canRead(string5);
            string4 = HttpUtil.canRead(string4);
            while ((n = string5.indexOf("/", 1)) != -1 && string4.startsWith(string3 = string5.substring(0, n))) {
                string4 = string4.substring(n);
                string5 = string5.substring(n);
            }
            n = 0;
            if (string4.equals("/")) {
                string4 = "";
            }
            while ((n = string4.indexOf("/", n)) != -1) {
                string2 = string2 + "../";
                ++n;
            }
            string2 = string2 + string5.substring(1);
        } else {
            string2 = string;
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
        }
        return string2;
    }

    private static String canRead(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("/").append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    private static void checkAdminLogin() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (activeCount) {
            string = checkLogin + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException("Can not found language resource, Path:" + string);
            }
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2.isDirectory()) {
                    String string2 = file2.getName();
                    arrayList.add(string2.replace('-', '_'));
                }
                ++n;
            }
        } else {
            String string3 = "resources/jrnlslocator.txt";
            string = ServerUtil.getZipFilePath(string3);
            if (string != null) {
                JarFile jarFile = new JarFile(string);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string4 = ((Object)enumeration.nextElement()).toString();
                    if (string4 == null || !string4.endsWith("/properties/")) continue;
                    String string5 = string4.substring(0, string4.indexOf("/properties/"));
                    string5 = string5.substring(string5.lastIndexOf("/") + 1);
                    arrayList.add(string5.replace('-', '_'));
                }
            } else {
                throw new IOException("Can not found language resource, Path:" + string);
            }
        }
        get = arrayList;
    }

    public static List getLanguageList() {
        if (get == null) {
            try {
                HttpUtil.checkAdminLogin();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return get;
    }

    public static boolean isPipeline() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().isPipeline();
        }
        return ServerEnv.isPipeline();
    }

    public static boolean isShowVersionParamContents() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().isShowVersionParamContents();
        }
        return ServerEnv.isShowVersionParamContents();
    }

    private static String checkLogin(long l) {
        StringBuffer stringBuffer = new StringBuffer("" + l);
        int n = stringBuffer.length();
        if (n > 3) {
            int n2 = n - 3;
            while (n2 > 0) {
                stringBuffer.insert(n2, ",");
                n2 -= 3;
            }
        }
        return stringBuffer.toString();
    }

    public static String getProductVersionInfo() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String string2 = string + "Version " + 9 + "." + 0 + "." + 0;
        return string2;
    }

    public static String getProductLicense() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;" + ReportEnv.getProductLicense((String)"<br>&nbsp;&nbsp;&nbsp;&nbsp;");
        return string;
    }

    public static String getProductSystemInfo() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String string2 = "<br>";
        String string3 = "";
        Runtime runtime = Runtime.getRuntime();
        string3 = string3 + string + "Total memory available for objects: " + HttpUtil.checkLogin(runtime.totalMemory()) + " bytes (" + HttpUtil.checkLogin(runtime.freeMemory()) + " bytes free)" + System.getProperty("line.separator") + string2;
        string3 = string3 + string + "Active threads count: " + Thread.activeCount();
        return string3;
    }

    public static String getAdhocServletPath() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getAdhocServletPath();
        }
        return ServerEnv.getAdhocServletPath();
    }

    public static String getAdhocJspPath() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getAdhocJspPath();
        }
        return ServerEnv.getAdhocJspPath();
    }

    public static String getJRServletPath() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getJRServletPath();
        }
        return ServerEnv.getJRServletPath();
    }

    public static boolean isEnableMonitorLink() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().isEnableMonitorLink();
        }
        return ServerEnv.isEnableMonitorLink();
    }

    public static String getProductSystemProp() {
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String string2 = "<br>";
        String string3 = "";
        Properties properties = System.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.indexOf(".separator") >= 0) continue;
            string3 = string3 + string + string4 + ": " + (String)properties.get(string4) + string2;
        }
        return string3;
    }

    public static boolean getAdHoc() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getAdHoc();
        }
        return ServerEnv.getAdHocUser() > 0;
    }

    public static String getLogInfoBeforeService(ServletRequest servletRequest, ServletResponse servletResponse) {
        StringBuffer stringBuffer = new StringBuffer(servletRequest.getClass().getName() + "@" + Integer.toHexString(servletRequest.hashCode()) + "->" + servletResponse.getClass().getName() + "@" + Integer.toHexString(servletResponse.hashCode()));
        if (!(servletRequest instanceof HttpServletRequest)) {
            return stringBuffer.append(" " + servletRequest.getProtocol()).toString();
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        stringBuffer.append(CSUtil.LINE + "\t" + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " " + httpServletRequest.getProtocol());
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equalsIgnoreCase("Authorization")) {
                    stringBuffer.append(CSUtil.LINE + "\t" + string + ":(username and password)");
                    continue;
                }
                stringBuffer.append(CSUtil.LINE + "\t" + string + ":" + httpServletRequest.getHeader(string));
            }
        }
        if (activeCount) {
            stringBuffer.append(CSUtil.LINE + "\t" + "(Content length:" + httpServletRequest.getContentLength() + ")");
            ((HttpResponse)servletResponse).setLogging(true);
        }
        return stringBuffer.toString();
    }

    public static String getLogInfoAfterService(ServletRequest servletRequest, ServletResponse servletResponse) {
        StringBuffer stringBuffer = new StringBuffer(servletRequest.getClass().getName() + "@" + Integer.toHexString(servletRequest.hashCode()) + "->" + servletResponse.getClass().getName() + "@" + Integer.toHexString(servletResponse.hashCode()));
        if (!(servletResponse instanceof HttpServletResponse)) {
            return stringBuffer.append(servletResponse.toString()).toString();
        }
        if (activeCount) {
            try {
                String string;
                HttpResponse httpResponse = (HttpResponse)servletResponse;
                httpResponse.finish();
                byte[] byArray = httpResponse.getLog();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "ISO-8859-1"));
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(CSUtil.LINE + "\t" + string);
                    if (string.length() != 0) continue;
                    stringBuffer.append(CSUtil.LINE + "\t" + "(Contents...)");
                    break;
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
        return stringBuffer.toString();
    }

    public static Properties uploadSkinFile(HttpServletRequest httpServletRequest, String string) throws IOException {
        return UploadFileUtil.uploadSkinFile(httpServletRequest, string);
    }

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string) throws IOException {
        return UploadFileUtil.getUploadFileProperties(httpServletRequest, string);
    }

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string, boolean bl) throws IOException {
        return UploadFileUtil.getUploadFileProperties(httpServletRequest, string, bl);
    }

    public static boolean isStandaloneServer() {
        return activeCount;
    }

    public static void updateServletPaths(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        if (!activeCount && servletContext.getAttribute("jreport_servlet_paths_updated") == null) {
            ServerEnv.updateServletPaths(httpServletRequest);
            servletContext.setAttribute("jreport_servlet_paths_updated", (Object)"true");
        }
    }

    private static void close() {
        ServiceLogger.logDebug(4670040, 4);
        HttpUtil.closeAll();
        ServiceLogger.logDebug(4670041, 4);
    }

    private static void closeAll() {
        ServiceLogger.logDebug(4670042, 4);
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        Thread thread = null;
        int n = 0;
        while (n < threadArray.length) {
            try {
                String string;
                thread = threadArray[n];
                if (thread != null && ((string = thread.getName()).equalsIgnoreCase("AWT-EventQueue-0") || string.equalsIgnoreCase("AWT-Shutdown"))) {
                    ServiceLogger.logDebug(4670043, string, 4);
                    thread.interrupt();
                    thread.stop();
                    ServiceLogger.logDebug(4670044, string, 4);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            ++n;
        }
    }

    private static boolean connect() {
        String string = "jet.server.servlets.JRServerContextListener";
        String string2 = "org.apache.catalina.startup.Bootstrap";
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            String string3 = new String();
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            string3 = stringWriter.toString();
            if (string3.indexOf("jet.server.servlets.JRServerContextListener") >= 0 && string3.indexOf("org.apache.catalina.startup.Bootstrap") >= 0) {
                ServiceLogger.logDebug(4670045, 4);
                return true;
            }
            ServiceLogger.logDebug(4670046, 4);
            return false;
        }
    }

    public static String getRealmDir() {
        ConfigurationCluster configurationCluster = QOIV.getAdminService().getConfigService().getConfigurationCluster();
        String string = configurationCluster.getShareRealmDirectory();
        String string2 = string == null || string.length() == 0 ? QOIV.getServerEnv().getHomePath() + "realm" : string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isValidMonitoringURL(String string, String string2, String string3) {
        boolean bl;
        block25: {
            HttpURLConnection httpURLConnection;
            HttpURLConnection httpURLConnection2;
            block24: {
                bl = false;
                string2 = HttpUtil.getHostAddress(string2);
                httpURLConnection2 = null;
                httpURLConnection = null;
                URL uRL = new URL(string);
                httpURLConnection2 = (HttpURLConnection)uRL.openConnection();
                httpURLConnection2.connect();
                if (httpURLConnection2.getResponseCode() == 401) {
                    int n;
                    String string4 = httpURLConnection2.getHeaderField("MonitoredTo");
                    if (string4 != null && string2.equals(string4.substring(0, n = string4.indexOf(":"))) && string3.equals(string4.substring(n + 1))) {
                        bl = true;
                    }
                    break block24;
                }
                int n = string.indexOf(".jsp");
                n = string.lastIndexOf("/", n);
                String string5 = string.substring(0, n) + "/getServerStatus.jsp";
                uRL = new URL(string5);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                String string6 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl2 = false;
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (string6.indexOf("Admin") >= 0) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    if (string6.indexOf("</tr>") >= 0) break;
                    arrayList.add(0, string6);
                }
                int n2 = 0;
                int n3 = 0;
                bl2 = false;
                String string7 = null;
                String string8 = null;
                int n4 = 0;
                int n5 = arrayList.size();
                while (n4 < n5) {
                    string6 = (String)arrayList.get(n4);
                    if (string6.indexOf("Admin") >= 0) {
                        bl2 = true;
                    } else if (bl2 && (n2 = string6.indexOf(">")) > 0) {
                        n3 = string6.indexOf("<", n2);
                        if (string8 == null) {
                            string8 = string6.substring(n2 + 1, n3).trim();
                        } else {
                            string7 = string6.substring(n2 + 1, n3).trim();
                            break;
                        }
                    }
                    ++n4;
                }
                if (!string2.equals(string7) || !string3.equals(string8)) break block24;
                bl = true;
            }
            Object var20_22 = null;
            try {
                if (httpURLConnection2 != null) {
                    httpURLConnection2.disconnect();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                break block25;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block25;
            {
                catch (Exception exception) {
                    bl = false;
                    Object var20_23 = null;
                    try {
                        if (httpURLConnection2 != null) {
                            httpURLConnection2.disconnect();
                        }
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                        break block25;
                    }
                    catch (Exception exception2) {
                        ServiceLogger.logError(exception2, 3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                try {
                    if (httpURLConnection2 != null) {
                        httpURLConnection2.disconnect();
                    }
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
        return bl;
    }

    public static boolean isValidMonitoringURL(String string) {
        if (BaseHttpUtil.isRemoteServer) {
            return HttpUtil.isValidMonitoringURL(string, finish, flush);
        }
        return HttpUtil.isValidMonitoringURL(string, ServerEnv.getLocalRMIHost(), String.valueOf(ServerEnv.getActiveRMIPort()));
    }

    public static String getValidMonitoringURL() {
        return QOIV.getServerEnv().getWebPageOptions().getMonitoringWebURL();
    }

    public static String getValidMonitoringURL(String string, String string2) {
        String string3 = null;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "RemoteMonitorService");
            if (remoteMonitorService != null) {
                string3 = remoteMonitorService.getMonitorServerURL();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static String getHostAddress(String string) {
        String string2 = null;
        try {
            string2 = string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
        }
        return string2;
    }

    public static int getAutoRecoverTaskMaxTimes() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getAutoRecoverTaskMaxTimes();
        }
        return ServerEnv.getAutoRecoverTaskMaxTimes();
    }

    public static long getAutoRecoverTaskInterval() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getAutoRecoverTaskInterval();
        }
        return ServerEnv.getAutoRecoverTaskInterval();
    }

    public static boolean getAutoRecoverTaskRedoAll() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getAutoRecoverTaskRedoAll();
        }
        return ServerEnv.getAutoRecoverTaskRedoAll();
    }

    public static String getJspUri(HttpServletRequest httpServletRequest, String string) {
        if (HttpUtil.isStandaloneServer()) {
            return string;
        }
        if (string.startsWith("/")) {
            return httpServletRequest.getContextPath() + string;
        }
        return string;
    }

    public static String getOndemandJspUri(HttpServletRequest httpServletRequest) {
        return HttpUtil.getJspUri(httpServletRequest, "/jinfonet/getOndemand.jsp");
    }

    public static String filterXSS(String string) {
        if (string != null) {
            int n = -1;
            while ((n = string.indexOf("+", n + 1)) >= 0) {
                int n2 = string.lastIndexOf("'", n);
                if (n2 < 0) {
                    n2 = string.lastIndexOf("\"", n);
                }
                if (n2 < 0) continue;
                int n3 = string.indexOf("'", n);
                if (n3 < 0) {
                    n3 = string.indexOf("\"", n);
                }
                if (n3 <= 0) continue;
                string = string.substring(0, n2) + string.substring(n3 + 1);
            }
        }
        return string;
    }

    public static int getOndemandTaskInitPriority() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getOndemandTaskInitPriority();
        }
        return ServerEnv.getOndemandTaskInitPriority();
    }

    public static int getScheduleTaskInitPriority() {
        if (BaseHttpUtil.isRemoteServer) {
            return QOIV.getServerEnv().getWebPageOptions().getScheduleTaskInitPriority();
        }
        return ServerEnv.getScheduleTaskInitPriority();
    }
}

