/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.util;

import jet.server.cache.core.intf.CacheElement;
import jet.server.cache.core.intf.ElementAttributes;
import jet.server.cache.core.memory.intf.MemoryCache;

public class CacheShrinker
implements Runnable {
    private final MemoryCache QOIV;
    private final long currentTimeMillis;

    public CacheShrinker(MemoryCache memoryCache) {
        this.QOIV = memoryCache;
        long l = memoryCache.getCacheAttributes().getMaxMemoryObjectIdleSeconds();
        this.currentTimeMillis = l == -1L ? -1L : l * 1000L;
    }

    public void run() {
        this.shrink();
    }

    protected void shrink() {
        try {
            Object[] objectArray = this.QOIV.getKeys();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                CacheElement cacheElement = this.QOIV.getQuiet(object);
                if (cacheElement != null) {
                    long l;
                    ElementAttributes elementAttributes = cacheElement.getElementAttributes();
                    boolean bl = false;
                    long l2 = System.currentTimeMillis();
                    if (!cacheElement.getElementAttributes().getIsEternal() && (bl = this.QOIV(cacheElement, l2))) {
                        this.QOIV.remove(cacheElement.getKey());
                    }
                    if (!bl && this.currentTimeMillis != -1L && (l = elementAttributes.getLastAccessTime()) + this.currentTimeMillis < l2) {
                        this.QOIV.remove(cacheElement.getKey());
                        object = null;
                        cacheElement = null;
                    }
                }
                ++n2;
            }
            objectArray = null;
        }
        finally {
            return;
        }
    }

    private boolean QOIV(CacheElement cacheElement, long l) {
        ElementAttributes elementAttributes = cacheElement.getElementAttributes();
        long l2 = elementAttributes.getMaxLifeSeconds();
        long l3 = elementAttributes.getCreateTime();
        if (l2 != -1L && l - l3 > l2 * 1000L) {
            return true;
        }
        long l4 = elementAttributes.getMaxIdleSeconds();
        long l5 = elementAttributes.getLastAccessTime();
        return l4 != -1L && l - l5 > l4 * 1000L;
    }
}

