/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.db.DataHandler;
import jet.server.log.ServiceLogger;
import jet.server.schedule.Committer;

public abstract class AbstractDataTable
extends UnicastRemoteObject
implements Committer,
DataHandler {
    public static final String CREATE_TABLE_PREFIX = "CREATE TABLE ";
    public static final String CREATE_HSQLTABLE_PREFIX = "CREATE CACHED TABLE ";
    public static final String DROP_TABLE_PREFIX = "DROP TABLE ";
    public static final String INSERT_PREFIX = "INSERT INTO ";
    public static final String DELETE_PREFIX = "DELETE FROM ";
    public static final String SELECT_ALL_PREFIX = "SELECT * FROM ";
    public static final String SELECT_NUM_PREFIX = "SELECT COUNT(*) FROM ";
    public static final String UPDATE_PREFIX = "UPDATE ";
    public static final String ORDER_BY_ID_DESC = " ORDER BY ID DESC";
    public static final String FAILED_CONSTRUCTOR = "FailedConstructor";
    public static final String FAILED_CREATE_TABLE = "FailedCreateTable";
    public static final String FAILED_DROP_TABLE = "FailedDropTable";
    public static final String FAILED_ADDREC = "FailedInsertRecord";
    public static final String FAILED_DELREC = "FailedDeleteRecord";
    public static final String FAILED_UPDREC = "FailedUpdateRecord";
    public static final String FAILED_GETREC = "FailedSelectRecord";
    public static final String FAILED_COMMIT = "FailedCommit";
    public static int MAX_BATCH_COMMIT = 100;
    protected Connection conn = null;
    protected Statement stmt = null;
    protected StringBuffer sqlbuf = new StringBuffer();
    private DaemonThread QOIV = null;
    private int append = MAX_BATCH_COMMIT;
    private int checkDoCommit = 0;

    public String makeTableName(String string, String string2, int n) {
        String string3 = string.length() > 8 ? string.substring(0, 7) : string;
        String string4 = string2 == null ? "00000000" : Integer.toHexString(string2.hashCode());
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(string3).append("_");
        this.sqlbuf.append(string4).append("_").append(n);
        return this.sqlbuf.substring(0);
    }

    public AbstractDataTable(String string, String string2, String string3) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        try {
            this.conn = DriverManager.getConnection(string, string2, string3);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            try {
                this.stmt.execute("CHECKPOINT");
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_CONSTRUCTOR, exception);
        }
    }

    public void commit() throws RemoteException {
        try {
            this.conn.commit();
            try {
                this.stmt.execute("CHECKPOINT");
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            this.checkDoCommit = 0;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_COMMIT, exception);
        }
    }

    public void setCommitDelay(int n) {
        this.append = n;
    }

    public int getCommitDelay() {
        return this.append;
    }

    public boolean isValidTable(String string) throws RemoteException {
        try {
            this.stmt.executeQuery(SELECT_NUM_PREFIX + string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean createTable(String string, String string2) throws RemoteException {
        try {
            boolean bl = this.conn.getMetaData().getDatabaseProductName().indexOf("HSQL") != -1;
            String string3 = bl ? CREATE_HSQLTABLE_PREFIX : CREATE_TABLE_PREFIX;
            this.stmt.execute(string3 + string + "(" + string2 + ");");
            this.commit();
            return true;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_CREATE_TABLE, exception);
        }
    }

    public boolean dropTable(String string) throws RemoteException {
        try {
            this.stmt.execute(DROP_TABLE_PREFIX + string);
            this.commit();
            return true;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_DROP_TABLE, exception);
        }
    }

    public void close() throws RemoteException {
        if (this.QOIV != null) {
            this.QOIV.shutdown();
        }
        try {
            this.commit();
            this.stmt.close();
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public synchronized int getRecordsAmount(String string, String string2) throws RemoteException {
        int n;
        block9: {
            ResultSet resultSet;
            block8: {
                resultSet = null;
                n = 0;
                this.sqlbuf.delete(0, this.sqlbuf.length());
                this.sqlbuf.append(SELECT_NUM_PREFIX).append(string);
                if (string2 != null) {
                    this.sqlbuf.append(" WHERE ").append(string2);
                }
                resultSet = this.stmt.executeQuery(this.sqlbuf.substring(0));
                if (!resultSet.next()) break block8;
                n = resultSet.getInt(1);
            }
            Object var7_5 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block9;
            {
                catch (Exception exception) {
                    throw new RemoteException(FAILED_GETREC, exception);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
        return n;
    }

    public void dataHandle(Object object) throws Exception {
    }

    public void excpHandle(Throwable throwable) {
        this.logException(throwable);
    }

    protected void process(Object object) throws RemoteException {
        if (this.QOIV == null || !this.QOIV.isActive()) {
            throw new RemoteException("NullDaemonThread");
        }
        this.QOIV.process(object);
    }

    protected void registerDataHandler(DataHandler dataHandler, String string) {
        this.QOIV = new DaemonThread(this, dataHandler, string);
        this.QOIV.setPriority(3);
        this.QOIV.start();
    }

    protected boolean delRecord(String string, String string2, boolean bl) throws RemoteException {
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(DELETE_PREFIX).append(string);
        if (string2 != null) {
            this.sqlbuf.append(" WHERE ").append(string2);
        }
        try {
            this.stmt.execute(this.sqlbuf.substring(0));
            this.checkDoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            throw new RemoteException(FAILED_DELREC, exception);
        }
    }

    protected boolean delRecords(String string, String string2, boolean bl) throws RemoteException {
        return this.delRecord(string, string2, true);
    }

    protected void checkDoCommit(boolean bl) throws RemoteException {
        if (bl) {
            this.commit();
        } else {
            ++this.checkDoCommit;
            if (this.checkDoCommit > this.append) {
                this.commit();
            }
        }
    }

    protected void logException(Throwable throwable) {
        ServiceLogger.logError(throwable);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    private class DaemonThread
    extends Thread {
        private LinkedList Q;
        private Object QOIV;
        private DataHandler addLast;
        private String append;
        private boolean clear;
        private boolean dataHandle;
        private final AbstractDataTable this$0;

        public DaemonThread(AbstractDataTable abstractDataTable, DataHandler dataHandler, String string) {
            this.this$0 = abstractDataTable;
            this.Q = new LinkedList();
            this.QOIV = new Object();
            this.addLast = null;
            this.append = null;
            this.clear = false;
            this.dataHandle = false;
            this.addLast = dataHandler;
            this.append = string == null ? "" : string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            this.clear = true;
            var1_1 = null;
            ** GOTO lbl37
            {
                this.dataHandle = true;
                if (this.addLast != null) {
                    try {
                        var2_2 = this.Q;
                        synchronized (var2_2) {
                            var1_1 = this.Q.removeFirst();
                        }
                        this.addLast.dataHandle(var1_1);
                    }
                    catch (Exception var2_3) {
                        ServiceLogger.logError(var2_3);
                    }
                }
                do {
                    if (!this.Q.isEmpty()) continue block10;
                    ServiceLogger.logEvent(this.append + ".Qsize= " + this.Q.size());
                    this.dataHandle = false;
                    super.setPriority(1);
                    Thread.yield();
                    var2_2 = this.QOIV;
                    synchronized (var2_2) {
                        try {
                            this.QOIV.wait();
                        }
                        catch (Exception var3_5) {
                            ServiceLogger.logError(var3_5);
                            break block10;
                        }
                    }
                    super.setPriority(10);
lbl37:
                    // 2 sources

                } while (this.clear);
            }
            this.Q.clear();
            this.clear = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Object object) {
            LinkedList linkedList = this.Q;
            synchronized (linkedList) {
                this.Q.addLast(object);
            }
            Object object2 = this.QOIV;
            synchronized (object2) {
                this.QOIV.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.QOIV;
            synchronized (object) {
                this.QOIV.notify();
            }
            this.clear = false;
        }

        public boolean isActive() {
            return this.clear;
        }
    }
}

