/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Vector;
import jet.cs.api.CompletedResultRecord;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.jrserver.JRCompletedResultRecord;
import jet.server.log.ServiceLogger;

public class CompletedResultTableImpl
extends TableImpl
implements Table {
    private static int INTEGER = 1;
    private static int QOIV = 2;
    private static int VARCHAR = 3;
    private static String add = "COMPLETEDRESULTTABLE_" + VARCHAR;
    private static int append = 0;
    private static int close = 1;
    private static int contains = 2;
    private static int createTable = 3;
    private static int delete = 4;
    private static String[] dropTable = new String[]{"PublishId", "RecordId", "pub_type", "Status", "Detail"};

    public CompletedResultTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, add);
        Table table;
        super.append(new FieldImpl(this.getName(), dropTable[append], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), dropTable[close], JDBCType.VARCHAR, 40, 1, 0));
        super.append(new FieldImpl(this.getName(), dropTable[contains], JDBCType.VARCHAR, 128, 1, 0));
        super.append(new FieldImpl(this.getName(), dropTable[createTable], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), dropTable[delete], JDBCType.VARCHAR, 256, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "COMPLETEDRESULTTABLE_" + INTEGER;
        if (database.tables().contains(string)) {
            table = database.tables(string);
            if (!updateDetailsTable.isUpdating(string)) {
                this.INTEGER(table, true);
                table.delete("");
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
        string = "COMPLETEDRESULTTABLE_" + QOIV;
        if (database.tables().contains(string)) {
            table = database.tables(string);
            if (!updateDetailsTable.isUpdating(string)) {
                this.INTEGER(table, false);
                table.delete("");
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
    }

    private void INTEGER(Table table, boolean bl) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("PublishId").getValue());
            fieldValueArray[1].setValue(recordset.fields("RecordId").getValue());
            if (bl) {
                fieldValueArray[2].setValue(recordset.fields("Type").getValue());
            } else {
                fieldValueArray[2].setValue(recordset.fields("pub_type").getValue());
            }
            fieldValueArray[3].setValue(recordset.fields("Status").getValue());
            fieldValueArray[4].setValue(recordset.fields("Detail").getValue());
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    public void addRecords(int n, String string, Vector vector) throws RemoteException {
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                CompletedResultRecord completedResultRecord = (CompletedResultRecord)vector.get(n2);
                FieldValue[] fieldValueArray = super.fields().values();
                fieldValueArray[append].setValue(new Integer(n));
                fieldValueArray[close].setValue(string);
                fieldValueArray[contains].setValue(completedResultRecord.getType());
                fieldValueArray[createTable].setValue(new Integer(completedResultRecord.getStatus()));
                fieldValueArray[delete].setValue(completedResultRecord.getDetail());
                try {
                    super.insert(fieldValueArray);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    throw new RemoteException("", sQLException);
                }
                ++n2;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Vector getRecordsByPublishID(int n) throws RemoteException {
        Vector<JRCompletedResultRecord> vector;
        block10: {
            StringBuffer stringBuffer = new StringBuffer();
            vector = new Vector<JRCompletedResultRecord>();
            Recordset recordset = null;
            stringBuffer.append(" WHERE ").append(this.fields(dropTable[append]).getName()).append("=").append(n);
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), false);
            while (recordset.next()) {
                JRCompletedResultRecord jRCompletedResultRecord = new JRCompletedResultRecord(recordset.getString(dropTable[contains]), recordset.getInt(dropTable[createTable]), recordset.getString(dropTable[delete]));
                vector.add(jRCompletedResultRecord);
            }
            Object var7_7 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block10;
            {
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                    throw new RemoteException("", exception);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    public boolean deleteRecordsByPublishID(int n) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            stringBuffer.append(" WHERE ").append(this.fields(dropTable[append]).getName()).append("=").append(n);
            bl = super.delete(stringBuffer.toString()) > 0;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        return bl;
    }

    public boolean deleteRecordsByRecordID(String string) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            stringBuffer.append(" WHERE ").append(this.fields(dropTable[close]).getName()).append("=").append(this.adapter.formatValue(string));
            bl = super.delete(stringBuffer.toString()) > 0;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        return bl;
    }

    public int deleteAllRecords() throws SQLException {
        return super.delete("");
    }
}

