/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.schedule.JRResultFiles;

public class ResultVersionRecordImpl
implements ResultVersionRecord,
Serializable {
    public static final int version = 1;
    protected int id = 0;
    protected int versionID = -1;
    protected String versionName = "";
    protected String catalogFile = "";
    protected String reportFile = "";
    protected String paramFile = "";
    protected String resultFile = "";
    protected String taskID = "";
    protected String submitter = "";
    protected long resultFormats = 0L;
    protected int reportAmount = -1;
    protected Date createdTime = new Date();
    protected Date expirationTime = new Date(this.createdTime.getTime() + 1094004736L);
    protected int launchType = -1;
    protected boolean expire = false;
    protected int expirationMethod = -1;
    protected Vector reportSheets = new Vector();

    public ResultVersionRecordImpl() {
    }

    public ResultVersionRecordImpl(String string, String string2, String string3, String string4, String string5, String string6, String string7, long l, Date date, Date date2, int n, boolean bl, int n2, int n3) {
        this.versionName = string == null ? "" : string;
        String string8 = this.catalogFile = string2 == null ? "" : string2;
        if (string2 != null && !string2.equals("/") && string2.endsWith("/")) {
            this.catalogFile = string2.substring(0, string2.length() - 1);
        }
        this.reportFile = string3 == null ? "" : string3;
        this.paramFile = string4 == null ? "" : string4;
        this.resultFile = string5 == null ? "" : string5;
        this.taskID = string6 == null ? "" : string6;
        this.submitter = string7 == null ? "" : string7;
        this.resultFormats = l;
        this.createdTime = date == null ? new Date() : date;
        this.expirationTime = date2 == null ? new Date(this.createdTime.getTime() + 1094004736L) : date2;
        this.launchType = n;
        this.expire = bl;
        this.expirationMethod = n2;
        this.reportAmount = n3;
        this.versionID = ResultVersionRecordImpl.makeRecordId(this.createdTime);
    }

    public static int makeRecordId(Date date) {
        return (int)(date.getTime() + (long)(Math.random() * 1.0E7));
    }

    public String getVersionID() {
        return String.valueOf(this.versionID);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getCatalogFile() {
        return this.catalogFile;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public String getParamFile() {
        return this.paramFile;
    }

    public String getResultFile() {
        ResultFiles resultFiles = this.getAllResultFiles();
        Vector vector = resultFiles.getResultFileNames();
        return (String)vector.elementAt(0);
    }

    public ResultFiles getAllResultFiles() {
        Hashtable hashtable = this.getAllReportResultFiles();
        Enumeration enumeration = hashtable.keys();
        if (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            return (ResultFiles)hashtable.get(string);
        }
        return null;
    }

    public Hashtable getAllReportResultFiles() {
        Hashtable hashtable = new Hashtable();
        if (this.resultFile.indexOf(";") < 0) {
            this.QOIV(hashtable, this.resultFile);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.resultFile, ";");
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                this.QOIV(hashtable, string);
            }
        }
        return hashtable;
    }

    private void QOIV(Hashtable hashtable, String string) {
        int n = string.indexOf("=");
        JRResultFiles jRResultFiles = null;
        if (n < 0) {
            String string2 = string.length() == 0 ? null : string;
            jRResultFiles = this.resultFormats != 0L ? new JRResultFiles(string2, this.resultFormats, 0L, 0L, 0L, this.reportAmount) : new JRResultFiles(CSUtil.getNameWithoutExt(string), CSUtil.getExtName(string));
            hashtable.put("jrs.report_result", jRResultFiles);
        } else {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (string3.equalsIgnoreCase("jrs.rst_result")) {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), ".rst");
            } else if (string3.equalsIgnoreCase("jrs.rsd_result")) {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), ".rsd");
            } else {
                this.reportSheets.add(string3);
                if (this.resultFormats != 0L) {
                    jRResultFiles = new JRResultFiles(string4, this.resultFormats, 0L, 0L, 0L, this.reportAmount);
                    jRResultFiles.removeFormat(0);
                    jRResultFiles.removeFormat(12);
                } else {
                    jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), CSUtil.getExtName(string4));
                }
            }
            hashtable.put(string3, jRResultFiles);
        }
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public long getResultFormats() {
        return this.resultFormats;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public int getExpirationMethod() {
        return this.expirationMethod;
    }

    public int getLaunchType() {
        return this.launchType;
    }

    public boolean isExpire() {
        return this.expire;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.version_id", this.taskID);
        properties2.put("jrs.catalog", this.catalogFile);
        properties2.put("jrs.report", this.reportFile);
        properties2.put("jrs.param_file", this.paramFile);
        JRResultFiles jRResultFiles = (JRResultFiles)this.getAllResultFiles();
        properties2.put("jrs.result", jRResultFiles.getResultFileNames());
        properties2.put("jrs.created_time", String.valueOf(this.createdTime.getTime()));
        properties2.put("jrs.expired_time", String.valueOf(this.expirationTime.getTime()));
        properties2.put("jrs.uid", this.submitter);
        return properties2;
    }

    public int getVersionNumber() {
        return 0;
    }

    public String getCreator() {
        return this.submitter;
    }

    public String getResourcePath() {
        return this.reportFile;
    }

    public String getRealPath() {
        return null;
    }
}

