/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.connect.jdbms.JDbConnection;
import jet.connect.jdbms.JDbTableDesc;
import jet.connect.jdbms.JDbTables;
import jet.connect.jdbms.JResultSet;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.db.VersionAmountRecord;
import jet.server.db.VersionAmountRecordContainer;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.util.IntKeyHashtable;

public class VersionAmountRecordContainerImpl
extends UnicastRemoteObject
implements VersionAmountRecordContainer {
    static String QOIV = "versionAmount";
    private JDbConnection addElement = null;
    JResultSet addVersionAmountRecord = null;
    IntKeyHashtable append = new IntKeyHashtable();
    int booleanValue = 0;
    long calculateRecordId = -1L;
    private boolean checkTable = true;
    private boolean close = false;
    private File commit = null;
    private File connect = null;
    private File copyFile = null;
    private String createTable = "";

    public VersionAmountRecordContainerImpl(String string) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.createTable = string;
        this.connect();
    }

    public VersionAmountRecordContainerImpl() throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.createTable = ServerEnv.propertiesPath;
        this.connect();
    }

    protected void connect() {
        try {
            String string = this.createTable;
            File file = new File(string);
            this.checkTable(file, QOIV);
            this.addElement = JDbConnection.connect(file, QOIV);
            this.addVersionAmountRecord = this.addElement.select(null);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    protected boolean checkTable(File file, String string) {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists()) {
            File file2 = new File(file.getPath(), string);
            this.commit = new File(file.getPath(), string + ".bak");
            this.connect = new File(file.getPath(), string + ".old");
            this.copyFile = new File(file.getPath(), string + ".old2");
            if (!file2.exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
                    randomAccessFile.writeInt(8);
                    randomAccessFile.writeInt(0);
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            try {
                if (!this.commit.exists()) {
                    SchdTools.copyFile(file2, this.commit);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            return true;
        }
        return false;
    }

    protected void disconnect() {
        try {
            this.addElement.disconnect();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (this.close && this.commit != null && this.connect != null && this.commit.exists()) {
            try {
                if (this.connect.exists()) {
                    if (this.copyFile.exists()) {
                        this.copyFile.delete();
                    }
                    this.connect.renameTo(this.copyFile);
                }
                this.commit.renameTo(this.connect);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    public int getMaxAmount(String string, String string2) throws RemoteException {
        try {
            Vector vector = this.getVersionAmountRecords(string, string2, null, null, new Boolean(true));
            if (vector.size() == 0) {
                return 0;
            }
            return ((VersionAmountRecord)vector.elementAt(0)).getMaxAmount();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw new ServerException("", sQLException);
        }
    }

    public void setMaxAmount(String string, String string2, String string3, int n) throws RemoteException {
        this.disableAmount(string, string2, string3);
        this.addVersionAmountRecord(string, string2, n, string3, new Date(), true);
    }

    public void disableAmount(String string, String string2, String string3) throws RemoteException {
        Vector vector = this.getVersionAmountRecords(string, string2, null, null, new Boolean(true));
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                VersionAmountRecord versionAmountRecord = (VersionAmountRecord)vector.elementAt(n);
                this.removeVersionAmountRecord(versionAmountRecord);
                ++n;
            }
        }
    }

    protected int calculateRecordId(Date date) {
        return (int)(date.getTime() + (long)(Math.random() * 1.0E7));
    }

    public synchronized VersionAmountRecord addVersionAmountRecord(String string, String string2, int n, String string3, Date date, boolean bl) {
        try {
            String string4 = string;
            if (string4 != null && !string4.equals("/") && string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            int n2 = this.calculateRecordId(date);
            int n3 = this.insert();
            VersionAmountRecord versionAmountRecord = new VersionAmountRecord(this.addVersionAmountRecord.getValueArray());
            versionAmountRecord.setRecord(n2, string4, string2, n, string3, date, bl);
            this.append.put(n2, (Object)new Integer(n3));
            this.update(versionAmountRecord);
            this.close = true;
            this.addElement();
            this.commit();
            return versionAmountRecord;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public synchronized void removeVersionAmountRecord(VersionAmountRecord versionAmountRecord) {
        try {
            Integer n = (Integer)this.append.get(versionAmountRecord.getVersionAmountId());
            if (n != null) {
                this.append.remove(versionAmountRecord.getVersionAmountId());
                int n2 = n;
                this.delete(n2);
                this.close = true;
                this.addElement();
                this.commit();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public synchronized void removeVersionAmountRecord(int n) {
        try {
            VersionAmountRecord versionAmountRecord = this.getVersionAmountRecord(n);
            if (versionAmountRecord != null) {
                this.removeVersionAmountRecord(versionAmountRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public synchronized VersionAmountRecord getVersionAmountRecord(int n) {
        VersionAmountRecord versionAmountRecord = null;
        Integer n2 = (Integer)this.append.get(n);
        int n3 = n2 != null ? n2.intValue() : this.loadVersionAmountRecord(n);
        if (n3 != -1) {
            this.QOIV(n3);
            versionAmountRecord = new VersionAmountRecord(this.addVersionAmountRecord.getValueArray());
        }
        return versionAmountRecord;
    }

    public synchronized Vector getVersionAmountRecords(String string, String string2, String string3, Date date, Boolean bl) {
        String string4 = string;
        if (string4 != null && !string4.equals("/") && string4.endsWith("/")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        Vector<VersionAmountRecord> vector = new Vector<VersionAmountRecord>();
        this.loadAllVersionAmountRecords();
        try {
            int n;
            this.addVersionAmountRecord = this.addElement.select(null);
            this.addVersionAmountRecord.setCursor(0);
            while ((n = this.addVersionAmountRecord.nextRecord()) != -1) {
                VersionAmountRecord versionAmountRecord = new VersionAmountRecord(this.addVersionAmountRecord.getValueArray());
                if (string4 != null && !string4.equalsIgnoreCase(versionAmountRecord.getCatFile()) || string2 != null && !string2.equalsIgnoreCase(versionAmountRecord.getReportFile()) || string3 != null && !string3.equalsIgnoreCase(versionAmountRecord.getSubmitUser()) || date != null && !date.equals(versionAmountRecord.getSubmitTime()) || bl != null && versionAmountRecord.getAvailable() != bl.booleanValue()) continue;
                vector.addElement(versionAmountRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return vector;
    }

    public synchronized Vector getVersionAmountRecords() {
        Vector<VersionAmountRecord> vector = new Vector<VersionAmountRecord>();
        this.loadAllVersionAmountRecords();
        try {
            int n;
            JResultSet jResultSet = this.addElement.select(null);
            jResultSet.setCursor(0);
            while ((n = jResultSet.nextRecord()) != -1) {
                vector.addElement(new VersionAmountRecord(jResultSet.getValueArray()));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return vector;
    }

    protected synchronized int loadVersionAmountRecord(int n) {
        try {
            int n2;
            JResultSet jResultSet = this.addElement.select(null);
            jResultSet.setCursor(this.booleanValue);
            while ((n2 = jResultSet.nextRecord()) != -1) {
                this.booleanValue = n2;
                DbValue[] dbValueArray = jResultSet.getValueArray();
                int n3 = ((DbInteger)dbValueArray[1]).get();
                this.append.put(n3, (Object)new Integer(n2));
                if (n3 != n) continue;
                return n2;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return -1;
    }

    protected synchronized void loadAllVersionAmountRecords() {
        int n;
        this.addVersionAmountRecord.setCursor(this.booleanValue);
        while ((n = this.addVersionAmountRecord.nextRecord()) != -1) {
            this.booleanValue = n;
            DbValue[] dbValueArray = this.addVersionAmountRecord.getValueArray();
            int n2 = ((DbInteger)dbValueArray[1]).get();
            this.append.put(n2, (Object)new Integer(n));
        }
    }

    private void QOIV(int n) {
        this.addVersionAmountRecord.setCursor(n);
        this.addVersionAmountRecord.nextRecord();
    }

    protected void update(VersionAmountRecord versionAmountRecord) throws SQLException {
        DbValue[] dbValueArray = versionAmountRecord.getValues();
        DbValue[] dbValueArray2 = this.addVersionAmountRecord.getValueArray();
        int n = 0;
        while (n < dbValueArray2.length) {
            dbValueArray2[n] = dbValueArray[n];
            ++n;
        }
        this.addVersionAmountRecord.update();
    }

    protected void delete(int n) throws SQLException {
        this.QOIV(n);
        this.addVersionAmountRecord.delete();
    }

    protected int insert() throws SQLException {
        return this.addVersionAmountRecord.insert();
    }

    public synchronized void commit() throws RemoteException {
        try {
            this.addElement.commit();
            this.checkTable = true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new ServerException("", exception);
        }
    }

    private synchronized void addElement() {
        this.calculateRecordId = System.currentTimeMillis();
        this.checkTable = false;
    }

    public synchronized boolean isCommitted() {
        return this.checkTable;
    }

    public synchronized long getLastModify() {
        return this.calculateRecordId;
    }

    public synchronized void close() {
        try {
            this.addElement.disconnect();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    static {
        try {
            JDbTableDesc jDbTableDesc = new JDbTableDesc(QOIV, 8);
            jDbTableDesc.setColumnDesc(1, "VersionAmountId", 4, 0, 10, 0, false);
            jDbTableDesc.setColumnDesc(2, "CatFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(3, "RptFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(4, "MaxAmount", 4, 0, 10, 0, false);
            jDbTableDesc.setColumnDesc(5, "SubmitUser", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(6, "SubmitDate", 93, 19, 0, 0, false);
            jDbTableDesc.setColumnDesc(7, "Expire", -7, 1, 0, 0, false);
            JDbTables.createTable(jDbTableDesc);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }
}

