/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.cs.PrefixFilenameFilter;
import jet.server.ServerEnv;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.db.AbstractDataTable;
import jet.server.db.ResultVersionRecordImpl;
import jet.server.db.VersionLimitTable;
import jet.server.db.VersionTable;
import jet.server.db.VersionTableImpl;
import jet.server.jrc.JRSchedulingService;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.ResultFolderManager;
import jet.server.schedule.SchdTools;

public class VersionTableImpl
extends AbstractDataTable
implements VersionTable,
Runnable {
    public static final int version = 1;
    public static final String TABLE_PREFIX = "VERSIONR";
    private String J = null;
    private PreparedStatement QOIV = null;
    private String add = null;
    private JRSchedulingService addRecord = null;
    private ResultFolderManager append = null;
    private VersionLimitTable catalogFile = null;
    private boolean checkDoCommit = true;
    private boolean clear = false;
    private static VersionTableImpl close = null;
    private boolean copyFile = false;

    public static VersionTableImpl newInstance(String string, String string2, String string3, String string4) throws RemoteException {
        if (close == null) {
            close = new VersionTableImpl(string, string2, string3, string4);
        }
        return close;
    }

    public static VersionTable getVersionTable() {
        return close;
    }

    private VersionTableImpl(String string, String string2, String string3, String string4) throws RemoteException {
        super(string, string2, string3);
        this.J = super.makeTableName(TABLE_PREFIX, string4, 1);
        if (!super.isValidTable(this.J)) {
            super.createTable(this.J, " id\t\t\t\tINTEGER NOT NULL IDENTITY, VersionId\t\t\tINTEGER NOT NULL, VersionName\t\tVARCHAR(256), CatFile           VARCHAR(256), RptFile           VARCHAR(256), ParamFile         VARCHAR(256), ResultFile        VARCHAR(256), TaskId\t\t\tVARCHAR(128), Submitter\t\t\tVARCHAR(128), ResultFormats     BIGINT, CreatedTime  \t\tBIGINT, ExpirationTime    BIGINT, LaunchType        INTEGER, Expire        \tBIT, UNIQUE(id, VersionId)");
        }
        try {
            this.QOIV = this.conn.prepareStatement("INSERT INTO " + this.J + " (VersionId,VersionName,CatFile,RptFile,ParamFile,ResultFile, TaskId,Submitter,ResultFormats,CreatedTime,ExpirationTime, LaunchType,Expire) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);");
        }
        catch (Exception exception) {
            throw new RemoteException("FailedConstructor", exception);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public String getTableName() {
        return this.J;
    }

    public void setSchedulingService(JRSchedulingService jRSchedulingService) {
        this.addRecord = jRSchedulingService;
    }

    public void setVersionDir(String string) {
        this.add = string;
        this.append = new ResultFolderManager(string, ServerEnv.getMaxVersionAmountPerSubfolder());
    }

    public ResultFolderManager getResultFolderManager() {
        return this.append;
    }

    public void setVersionLimitTable(VersionLimitTable versionLimitTable) {
        this.catalogFile = versionLimitTable;
    }

    public void close() {
        this.checkDoCommit = false;
        try {
            close = null;
            while (this.clear) {
                Thread.sleep(1000L);
            }
            while (this.copyFile) {
                Thread.sleep(1000L);
            }
            this.QOIV.close();
            super.close();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, String string6) throws RemoteException {
        Object object;
        String string7;
        Object object2;
        String string8 = CSUtil.getNameWithoutExt(string2);
        String string9 = this.append.getNextResultName(string8);
        if (string9 == null) {
            throw new ServerException(JCliResource.getMessage("CS_ERR_47"));
        }
        int n = string9.lastIndexOf(File.separator);
        String string10 = string9.substring(n);
        String string11 = string9 + string10;
        String string12 = CSUtil.getNameWithoutExt(string3);
        String string13 = CSUtil.getExtName(string3);
        JRResultFiles jRResultFiles = new JRResultFiles(string11, string13, 0L, 0L, 0L);
        int n2 = string12.indexOf(95);
        if (n2 != -1) {
            string12 = string12.substring(0, n2);
        }
        String string14 = string5 + string11;
        int n3 = string12.length();
        File file = new File(string4);
        PrefixFilenameFilter prefixFilenameFilter = new PrefixFilenameFilter(string12);
        String[] stringArray = file.list(prefixFilenameFilter);
        int n4 = stringArray.length;
        if (n4 > 0) {
            int n5 = 0;
            while (n5 < n4) {
                String string15 = string14 + stringArray[n5].substring(n3);
                SchdTools.copyFile(new File(string4 + stringArray[n5]), new File(string15));
                if (CSUtil.getExtName(stringArray[n5]).equals(".html")) {
                    object2 = string11.substring(string11.lastIndexOf(File.separator) + 1, string11.length());
                    SchdTools.replaceStringInFile(string15, string12, (String)object2);
                }
                ++n5;
            }
        }
        String string16 = null;
        object2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (properties != null) {
                string16 = string11 + ".param";
                object2 = new File(string5, string16);
                fileOutputStream = new FileOutputStream((File)object2);
                string7 = null;
                CSUtil.evalExpressionValues(properties);
                object = properties.keys();
                while (object.hasMoreElements()) {
                    string7 = (String)object.nextElement();
                    Object object3 = properties.get(string7);
                    fileOutputStream.write((string7 + "=" + object3 + "\n").getBytes());
                }
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    ServiceLogger.logError(iOException2, 3);
                }
            }
            ServiceLogger.logError(iOException, 2);
            throw new ServerException("", iOException);
        }
        string7 = string11 + string13;
        object = string4 + CSUtil.getNameWithoutExt(string3) + ".rst";
        if (new File((String)object).exists()) {
            string7 = string11 + ".rst";
        }
        this.addRecord(null, string, string2, string16, jRResultFiles.getSharedPrefix(), null, string6, jRResultFiles.getResultFormats(), new Date(), null, 0, false);
    }

    /*
     * Loose catch block
     */
    public synchronized ResultVersionRecord addRecord(String string, String string2, String string3, String string4, String string5, String string6, String string7, long l, Date date, Date date2, int n, boolean bl) throws RemoteException {
        ResultVersionRecordImpl resultVersionRecordImpl;
        block12: {
            resultVersionRecordImpl = new ResultVersionRecordImpl(string, string2, string3, string4, string5, string6, string7, l, date, date2, n, bl, 1, -1);
            try {
                this.J(resultVersionRecordImpl);
                super.checkDoCommit(false);
            }
            catch (Exception exception) {
                throw new RemoteException("FailedInsertRecord", exception);
            }
            int n2 = this.catalogFile.getMaxAmount(resultVersionRecordImpl.catalogFile, resultVersionRecordImpl.reportFile, resultVersionRecordImpl.submitter);
            String string8 = null;
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append(" CatFile='").append(resultVersionRecordImpl.catalogFile).append("'");
            this.sqlbuf.append(" AND RptFile='").append(resultVersionRecordImpl.reportFile).append("'");
            if (resultVersionRecordImpl.submitter != null && resultVersionRecordImpl.submitter.length() != 0) {
                this.sqlbuf.append(" AND Submitter='").append(resultVersionRecordImpl.submitter).append("'");
            }
            string8 = this.sqlbuf.substring(0);
            int n3 = super.getRecordsAmount(this.J, string8);
            if (n2 > 0 && n2 < n3) {
                ResultSet resultSet;
                block11: {
                    this.sqlbuf.delete(0, this.sqlbuf.length());
                    this.sqlbuf.append("SELECT * FROM ").append(this.J).append(" WHERE ID IN(");
                    this.sqlbuf.append("SELECT MIN(ID) FROM ").append(this.J).append(" WHERE ");
                    this.sqlbuf.append(string8).append(")");
                    resultSet = null;
                    ResultVersionRecordImpl resultVersionRecordImpl2 = null;
                    resultSet = this.stmt.executeQuery(this.sqlbuf.substring(0));
                    if (!resultSet.next()) break block11;
                    resultVersionRecordImpl2 = this.QOIV(resultSet);
                    this.add(resultVersionRecordImpl2);
                    this.addRecord(resultVersionRecordImpl2);
                }
                Object var22_20 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                break block12;
                {
                    catch (SQLException sQLException) {
                        throw new RemoteException("FailedInsertRecord", sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var22_21 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    throw throwable;
                }
            }
        }
        return resultVersionRecordImpl;
    }

    public synchronized void delRecord(int n) throws RemoteException {
        ResultVersionRecordImpl resultVersionRecordImpl = (ResultVersionRecordImpl)this.getRecord(n);
        if (resultVersionRecordImpl == null) {
            return;
        }
        try {
            this.add(resultVersionRecordImpl);
            this.addRecord(resultVersionRecordImpl);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedDeleteRecord", exception);
        }
    }

    /*
     * Loose catch block
     */
    public synchronized ResultVersionRecord getRecord(int n) throws RemoteException {
        ResultVersionRecordImpl resultVersionRecordImpl;
        block8: {
            ResultSet resultSet;
            block7: {
                resultVersionRecordImpl = null;
                resultSet = null;
                this.sqlbuf.delete(0, this.sqlbuf.length());
                this.sqlbuf.append("SELECT * FROM ").append(this.J);
                this.sqlbuf.append(" WHERE VersionId='").append(n).append("'");
                resultSet = this.stmt.executeQuery(this.sqlbuf.substring(0));
                if (!resultSet.next()) break block7;
                resultVersionRecordImpl = this.QOIV(resultSet);
            }
            Object var6_4 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block8;
            {
                catch (Exception exception) {
                    throw new RemoteException("FailedSelectRecord", exception);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
        return resultVersionRecordImpl;
    }

    public synchronized Vector getRecords(String string, String string2, String string3, String string4, Date date, int n) throws RemoteException {
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append("SELECT * FROM ").append(this.J).append(" WHERE ");
        if (n != -1) {
            this.sqlbuf.append(" LaunchType=").append(n);
        } else {
            this.sqlbuf.append(" LaunchType!=-1");
        }
        if (string != null) {
            this.sqlbuf.append(" AND CatFile='").append(string).append("'");
        }
        if (string2 != null) {
            this.sqlbuf.append(" AND RptFile='").append(string2).append("'");
        }
        if (string3 != null) {
            this.sqlbuf.append(" AND TaskId='").append(string3).append("'");
        }
        if (string4 != null && string4.length() != 0) {
            this.sqlbuf.append(" AND Submitter='").append(string4).append("'");
        }
        if (date != null) {
            this.sqlbuf.append(" AND CreatedTime=");
            this.sqlbuf.append(String.valueOf(date.getTime()));
        }
        this.sqlbuf.append(" ORDER BY ID DESC");
        try {
            int n2 = this.catalogFile.getMaxAmount(string, string2, string4);
            return this.catalogFile(this.sqlbuf.substring(0), n2);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
    }

    public synchronized Vector getAllRecords() throws RemoteException {
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append("SELECT * FROM ").append(this.J);
        this.sqlbuf.append(" ORDER BY ID DESC");
        try {
            return this.catalogFile(this.sqlbuf.substring(0), 0);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
    }

    public synchronized void adjustAmount(String string, String string2, String string3, int n) throws RemoteException {
        try {
            this.append(string, string2, null, n);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedAdjustAmount", exception);
        }
    }

    public synchronized void expireDelete() throws RemoteException {
        Date date = new Date();
        ResultVersionRecordImpl resultVersionRecordImpl = null;
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append("SELECT * FROM ").append(this.J);
        this.sqlbuf.append(" WHERE Expire=").append(true);
        this.sqlbuf.append(" AND ExpirationTime<=").append(date.getTime());
        try {
            Vector vector = this.catalogFile(this.sqlbuf.substring(0), 0);
            while (!vector.isEmpty()) {
                resultVersionRecordImpl = (ResultVersionRecordImpl)vector.remove(0);
                this.add(resultVersionRecordImpl);
                this.addRecord(resultVersionRecordImpl);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
    }

    public void insertRecord(ResultVersionRecordImpl resultVersionRecordImpl) throws RemoteException {
        try {
            this.J(resultVersionRecordImpl);
            super.checkDoCommit(false);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedInsertRecord", exception);
        }
    }

    public void run() {
        long l = 1440000L;
        while (this.checkDoCommit) {
            try {
                this.clear = true;
                this.expireDelete();
                this.clear = false;
            }
            catch (Exception exception) {
                super.logException(exception);
            }
            Thread.yield();
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                super.logException(exception);
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    private void J(ResultVersionRecordImpl resultVersionRecordImpl) throws SQLException {
        this.QOIV.setInt(1, resultVersionRecordImpl.versionID);
        this.QOIV.setString(2, resultVersionRecordImpl.versionName);
        this.QOIV.setString(3, resultVersionRecordImpl.catalogFile);
        this.QOIV.setString(4, resultVersionRecordImpl.reportFile);
        this.QOIV.setString(5, resultVersionRecordImpl.paramFile);
        this.QOIV.setString(6, resultVersionRecordImpl.resultFile);
        this.QOIV.setString(7, resultVersionRecordImpl.taskID);
        this.QOIV.setString(8, resultVersionRecordImpl.submitter);
        this.QOIV.setLong(9, resultVersionRecordImpl.resultFormats);
        this.QOIV.setLong(10, resultVersionRecordImpl.createdTime.getTime());
        this.QOIV.setLong(11, resultVersionRecordImpl.expirationTime.getTime());
        this.QOIV.setInt(12, resultVersionRecordImpl.launchType);
        this.QOIV.setBoolean(13, resultVersionRecordImpl.expire);
        this.QOIV.executeUpdate();
    }

    private ResultVersionRecordImpl QOIV(ResultSet resultSet) throws SQLException {
        ResultVersionRecordImpl resultVersionRecordImpl = new ResultVersionRecordImpl();
        resultVersionRecordImpl.id = resultSet.getInt("id");
        resultVersionRecordImpl.versionID = resultSet.getInt("VersionID");
        resultVersionRecordImpl.versionName = resultSet.getString("VersionName");
        resultVersionRecordImpl.catalogFile = resultSet.getString("CatFile");
        resultVersionRecordImpl.reportFile = resultSet.getString("RptFile");
        resultVersionRecordImpl.paramFile = resultSet.getString("ParamFile");
        resultVersionRecordImpl.resultFile = resultSet.getString("ResultFile");
        resultVersionRecordImpl.taskID = resultSet.getString("TaskId");
        resultVersionRecordImpl.submitter = resultSet.getString("Submitter");
        resultVersionRecordImpl.resultFormats = resultSet.getLong("ResultFormats");
        resultVersionRecordImpl.createdTime = new Date(resultSet.getLong("CreatedTime"));
        resultVersionRecordImpl.expirationTime = new Date(resultSet.getLong("ExpirationTime"));
        resultVersionRecordImpl.launchType = resultSet.getInt("LaunchType");
        resultVersionRecordImpl.expire = resultSet.getBoolean("Expire");
        return resultVersionRecordImpl;
    }

    private void add(ResultVersionRecordImpl resultVersionRecordImpl) throws RemoteException {
        super.delRecord(this.J, "VersionId=" + resultVersionRecordImpl.versionID, false);
    }

    private void addRecord(ResultVersionRecordImpl resultVersionRecordImpl) {
        if (resultVersionRecordImpl == null) {
            return;
        }
        File file = new File(resultVersionRecordImpl.resultFile);
        file.delete();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = resultVersionRecordImpl.resultFile.lastIndexOf(File.separator);
        if (n != -1) {
            string3 = resultVersionRecordImpl.resultFile.substring(0, n);
            if ((n = string3.lastIndexOf(File.separator)) != -1) {
                string2 = string3.substring(0, n);
            }
        } else {
            string3 = resultVersionRecordImpl.resultFile;
        }
        if ((string = string3) != null && string.length() > 0) {
            if (this.add != null) {
                SchdTools.deleteDir(this.add + string);
            }
            if (string2 != null) {
                this.append.decreaseResultAmount(string2);
            }
            try {
                ParameterFileManager.getInstance().delete(resultVersionRecordImpl.paramFile);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError(rptServerException);
            }
        }
    }

    private void append(String string, String string2, String string3, int n) throws RemoteException, SQLException, Exception {
        ResultVersionRecordImpl resultVersionRecordImpl = null;
        Vector vector = null;
        String string4 = null;
        int n2 = n;
        int n3 = 0;
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(" CatFile='").append(string).append("'");
        this.sqlbuf.append(" AND RptFile='").append(string2).append("'");
        if (string3 != null && string3.length() != 0) {
            this.sqlbuf.append(" AND Submitter='").append(string3).append("'");
        }
        string4 = this.sqlbuf.substring(0);
        n3 = super.getRecordsAmount(this.J, string4);
        if (n2 > 0 && n3 > n2) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append("SELECT * FROM ").append(this.J).append(" WHERE ");
            this.sqlbuf.append(string4).append(" ORDER BY ID DESC");
            vector = this.catalogFile(this.sqlbuf.substring(0), 0);
            resultVersionRecordImpl = (ResultVersionRecordImpl)vector.get(n2);
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append(" CatFile='").append(string).append("'");
            this.sqlbuf.append(" AND RptFile='").append(string2).append("'");
            this.sqlbuf.append(" AND id<=").append(resultVersionRecordImpl.id);
            super.delRecord(this.J, this.sqlbuf.substring(0), false);
            if (15 > n3 - n2) {
                int n4 = n2;
                while (n4 < n3) {
                    resultVersionRecordImpl = (ResultVersionRecordImpl)vector.get(n4);
                    this.addRecord(resultVersionRecordImpl);
                    ++n4;
                }
                vector.clear();
            } else {
                class DeleteThread
                implements Runnable {
                    private Vector v;
                    private int QOIV;
                    private int access$002;
                    private final VersionTableImpl this$0;

                    public DeleteThread(VersionTableImpl versionTableImpl, Vector vector, int n, int n2) {
                        this.this$0 = versionTableImpl;
                        this.v = null;
                        this.QOIV = 0;
                        this.access$002 = 0;
                        this.v = vector;
                        this.QOIV = n;
                        this.access$002 = n2;
                    }

                    public void run() {
                        VersionTableImpl.access$002(this.this$0, true);
                        if (this.v != null) {
                            int n = this.QOIV;
                            while (n < this.access$002) {
                                ResultVersionRecordImpl resultVersionRecordImpl = (ResultVersionRecordImpl)this.v.get(n);
                                try {
                                    VersionTableImpl.access$100(this.this$0, resultVersionRecordImpl);
                                }
                                catch (Exception exception) {
                                    ServiceLogger.logError(exception, 3);
                                }
                                ++n;
                            }
                            this.v.clear();
                        }
                        VersionTableImpl.access$002(this.this$0, false);
                    }
                }
                Thread thread = new Thread(new DeleteThread(this, vector, n2, n3));
                thread.start();
            }
        }
    }

    private Vector catalogFile(String string, int n) throws SQLException {
        Vector<ResultVersionRecordImpl> vector = new Vector<ResultVersionRecordImpl>();
        this.stmt.setMaxRows(n);
        ResultSet resultSet = this.stmt.executeQuery(string);
        while (resultSet.next()) {
            vector.add(this.QOIV(resultSet));
        }
        try {
            resultSet.close();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return vector;
    }

    static boolean access$002(VersionTableImpl versionTableImpl, boolean bl) {
        versionTableImpl.copyFile = bl;
        return versionTableImpl.copyFile;
    }

    static void access$100(VersionTableImpl versionTableImpl, ResultVersionRecordImpl resultVersionRecordImpl) {
        versionTableImpl.addRecord(resultVersionRecordImpl);
    }
}

