/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.Connector;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.IDGenerator;
import jet.server.log.ServiceLogger;

public abstract class DB
implements DBAdapter {
    protected Connector connector;
    protected IDGenerator idGen = null;

    public String formatValue(boolean bl) {
        return bl ? "1" : "0";
    }

    public String getDefaultSchema(String string, Connection connection) {
        String string2 = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string2 = databaseMetaData.getUserName();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 2);
        }
        return string2 == null ? string : string2;
    }

    public String formatValue(String string) {
        if (string == null) {
            return "NULL";
        }
        if (string.trim().length() == 0) {
            return "''";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = 0;
        int n2 = -1;
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append("'");
        while ((n2 = string.indexOf("'", n)) != -1) {
            stringBuffer.append(string.substring(n, n2 == 0 ? 0 : n2)).append("''");
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n)).append("'");
        string2 = stringBuffer.substring(0);
        return string2;
    }

    public String formatValue(Date date) {
        return "{d " + this.formatValue(date.toString()) + "}";
    }

    public String formatValue(Time time) {
        return "{t " + this.formatValue(time.toString()) + "}";
    }

    public String formatValue(Timestamp timestamp) {
        return "{ts " + this.formatValue(timestamp.toString()) + "}";
    }

    public final void setConnector(Connector connector) {
        this.connector = connector;
    }

    public final void setIDGenerator(IDGenerator iDGenerator) {
        this.idGen = iDGenerator;
    }

    public final Recordset select(Field[] fieldArray, Table[] tableArray, String string, boolean bl) throws SQLException {
        return this.select(fieldArray, tableArray, string, bl, 1);
    }

    public int insert(Table table, List list) throws SQLException {
        Connection connection = this.connector.getConnection();
        Statement statement = connection.createStatement();
        statement.setEscapeProcessing(true);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            FieldValue[] fieldValueArray = (FieldValue[])iterator.next();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("INSERT INTO ").append(table.getName()).append(" (");
            int n2 = fieldValueArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (fieldValueArray[n3] != null) {
                    stringBuffer.append(fieldValueArray[n3].getName());
                    if (n3 < n2 - 2) {
                        stringBuffer.append(",");
                    } else if (n3 == n2 - 2 && fieldValueArray[n2 - 1] != null) {
                        stringBuffer.append(",");
                    }
                }
                ++n3;
            }
            stringBuffer.append(") VALUES (");
            int n4 = 0;
            while (n4 < n2) {
                if (fieldValueArray[n4] != null) {
                    this.valueToString(stringBuffer, table, fieldValueArray[n4]);
                    if (n4 < n2 - 2) {
                        stringBuffer.append(",");
                    } else if (n4 == n2 - 2 && fieldValueArray[n2 - 1] != null) {
                        stringBuffer.append(",");
                    }
                }
                ++n4;
            }
            stringBuffer.append(")");
            String string = stringBuffer.toString();
            try {
                n += statement.executeUpdate(string);
            }
            catch (Throwable throwable) {
                statement.clearWarnings();
                connection.clearWarnings();
                ServiceLogger.logError(throwable);
                ServiceLogger.logError(string);
            }
        }
        statement.close();
        connection.close();
        return n;
    }

    protected abstract String valueToString(StringBuffer var1, Table var2, FieldValue var3);

    /*
     * Loose catch block
     */
    public final Recordset executeQuery(Field[] fieldArray, String string, int n) throws SQLException {
        long l;
        Recordset recordset;
        block23: {
            recordset = null;
            Connection connection = null;
            Statement statement = null;
            l = System.currentTimeMillis();
            boolean bl = false;
            connection = this.connector.getConnection();
            statement = connection.createStatement(1004, 1007);
            statement.setEscapeProcessing(true);
            ResultSet resultSet = statement.executeQuery(string);
            switch (n) {
                case 1: {
                    recordset = new LinkedRecordset(this, fieldArray, connection, statement, resultSet);
                    recordset.first();
                    break;
                }
                case 2: {
                    recordset = new CachedRecordset(this, fieldArray, resultSet);
                    recordset.first();
                    resultSet.close();
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    break;
                }
                default: {
                    throw new SQLException("Not support recordset type:" + n);
                }
            }
            Object var13_14 = null;
            if (!bl) break block23;
            try {
                recordset.close();
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block23;
            {
                catch (Throwable throwable) {
                    bl = true;
                    ServiceLogger.logError(throwable);
                    ServiceLogger.logError(string);
                    throw new SQLException(throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (bl) {
                    try {
                        recordset.close();
                        recordset = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                throw throwable;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.print(string + " ( " + l2 + " ms )");
        return recordset;
    }

    /*
     * Loose catch block
     */
    public final int executeUpdate(String string) throws SQLException {
        long l;
        int n;
        block11: {
            n = 0;
            Connection connection = null;
            Statement statement = null;
            l = System.currentTimeMillis();
            connection = this.connector.getConnection();
            statement = connection.createStatement();
            statement.setEscapeProcessing(true);
            n = statement.executeUpdate(string);
            Object var9_6 = null;
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block11;
            {
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                    ServiceLogger.logError(string);
                    throw new SQLException(throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                try {
                    statement.close();
                    statement = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                try {
                    connection.close();
                    connection = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.print(string + " ( " + l2 + " ms )");
        return n;
    }

    /*
     * Loose catch block
     */
    public final boolean execute(String string) throws SQLException {
        long l;
        boolean bl;
        block14: {
            bl = false;
            Connection connection = null;
            Statement statement = null;
            l = System.currentTimeMillis();
            connection = this.connector.getConnection();
            statement = connection.createStatement();
            statement.setEscapeProcessing(true);
            bl = statement.execute(string);
            Object var9_6 = null;
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block14;
            {
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                    ServiceLogger.logError(string);
                    throw new SQLException(throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                try {
                    statement.close();
                    statement = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                try {
                    connection.close();
                    connection = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.print(string + " ( " + l2 + " ms )");
        if (string.startsWith("CREATE")) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
        }
        return bl;
    }

    public final int getID(Table table, Field field) throws SQLException {
        if (this.idGen == null) {
            throw new SQLException("ID generator is null.");
        }
        return this.idGen.getID(table, field);
    }

    public final void setID(Table table, Field field, int n) throws SQLException {
        if (this.idGen == null) {
            throw new SQLException("ID generator is null.");
        }
        this.idGen.setID(table, field, n);
    }

    private abstract class RecordsetImpl
    implements Recordset {
        protected Field[] fields;
        protected FieldValue[] values;
        private HashMap append;
        private StringBuffer clear;
        private final DB this$0;

        RecordsetImpl(DB dB, Field[] fieldArray, ResultSetMetaData resultSetMetaData) throws Throwable {
            this.this$0 = dB;
            this.append = new HashMap();
            this.clear = new StringBuffer();
            int n = fieldArray.length;
            this.fields = new Field[n];
            this.values = new FieldValue[n];
            int n2 = 0;
            while (n2 < n) {
                FieldImpl fieldImpl = (FieldImpl)fieldArray[n2].createClone();
                this.fields[n2] = fieldImpl;
                this.values[n2] = fieldImpl.createFieldValue();
                String string = resultSetMetaData.getColumnName(n2 + 1);
                string = string == null || string.trim().length() == 0 ? String.valueOf(n2 + 1) : string;
                fieldImpl.setFieldName(string);
                fieldImpl.setSize(resultSetMetaData.getColumnDisplaySize(n2 + 1));
                this.append.put(fieldImpl.getName(), new Integer(n2));
                ++n2;
            }
        }

        public final FieldValue[] fields() {
            return this.values;
        }

        public final FieldValue fields(int n) {
            FieldValue[] fieldValueArray = this.fields();
            return fieldValueArray[n];
        }

        public final FieldValue fields(String string) {
            return this.fields(this.findField(string));
        }

        public final Object getValue(int n) {
            FieldValue fieldValue = this.fields(n);
            return fieldValue != null ? fieldValue.getValue() : null;
        }

        public final Object getValue(String string) {
            FieldValue fieldValue = this.fields(string);
            return fieldValue != null ? fieldValue.getValue() : null;
        }

        public final int columns() {
            return this.fields.length;
        }

        public final Date getDate(int n) throws SQLException {
            return this.fields(n).getDate();
        }

        public final Date getDate(String string) throws SQLException {
            return this.getDate(this.findField(string));
        }

        public final Time getTime(int n) throws SQLException {
            return this.fields(n).getTime();
        }

        public final Time getTime(String string) throws SQLException {
            return this.getTime(this.findField(string));
        }

        public final Timestamp getTimestamp(int n) throws SQLException {
            return this.fields(n).getTimestamp();
        }

        public final Timestamp getTimestamp(String string) throws SQLException {
            return this.getTimestamp(this.findField(string));
        }

        public final boolean getBoolean(int n) throws SQLException {
            return this.fields(n).getBoolean();
        }

        public final boolean getBoolean(String string) throws SQLException {
            return this.getBoolean(this.findField(string));
        }

        public final byte getByte(int n) throws SQLException {
            return this.fields(n).getByte();
        }

        public final byte getByte(String string) throws SQLException {
            return this.getByte(this.findField(string));
        }

        public final short getShort(int n) throws SQLException {
            return this.fields(n).getShort();
        }

        public final short getShort(String string) throws SQLException {
            return this.getShort(this.findField(string));
        }

        public final int getInt(int n) throws SQLException {
            return this.fields(n).getInt();
        }

        public final int getInt(String string) throws SQLException {
            return this.getInt(this.findField(string));
        }

        public final long getLong(int n) throws SQLException {
            return this.fields(n).getLong();
        }

        public final long getLong(String string) throws SQLException {
            return this.getLong(this.findField(string));
        }

        public final float getFloat(int n) throws SQLException {
            return this.fields(n).getFloat();
        }

        public final float getFloat(String string) throws SQLException {
            return this.getFloat(this.findField(string));
        }

        public final double getDouble(int n) throws SQLException {
            return this.fields(n).getDouble();
        }

        public final double getDouble(String string) throws SQLException {
            return this.getDouble(this.findField(string));
        }

        public final String getString(int n) throws SQLException {
            return this.fields(n).getString();
        }

        public final String getString(String string) throws SQLException {
            return this.getString(this.findField(string));
        }

        public final byte[] getBytes(int n) throws SQLException {
            return this.fields(n).getBytes();
        }

        public final byte[] getBytes(String string) throws SQLException {
            return this.getBytes(this.findField(string));
        }

        protected int findField(String string) {
            return (Integer)this.append.get(string.toUpperCase());
        }

        protected FieldValue[] newRecord(ResultSet resultSet) throws SQLException {
            FieldValue[] fieldValueArray = new FieldValue[this.fields.length];
            int n = fieldValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                fieldValueArray[n2] = this.fields[n2].createFieldValue();
                fieldValueArray[n2].setValue(resultSet.getObject(n2 + 1));
                ++n2;
            }
            return fieldValueArray;
        }

        public String toString() {
            this.clear.delete(0, this.clear.length());
            int n = this.columns();
            int n2 = 0;
            while (n2 < n) {
                this.clear.append(this.values[n2].getName()).append("=").append("'").append(this.values[n2].getValue()).append("'");
                if (n2 < n - 1) {
                    this.clear.append(", ");
                }
                ++n2;
            }
            return this.clear.toString();
        }

        protected void finalize() throws Throwable {
            this.append.clear();
            this.append = null;
            this.fields = null;
            this.values = null;
            super.finalize();
        }
    }

    private final class CachedRecordset
    extends RecordsetImpl
    implements Recordset {
        private List QOIV;
        private Iterator add;
        private final DB this$0;

        CachedRecordset(DB dB, Field[] fieldArray, ResultSet resultSet) throws Throwable {
            this.this$0 = dB;
            super(dB, fieldArray, resultSet.getMetaData());
            this.QOIV = new LinkedList();
            while (resultSet.next()) {
                this.QOIV.add(this.newRecord(resultSet));
            }
        }

        public int getSetType() {
            return 2;
        }

        public int rows() {
            return this.QOIV.size();
        }

        public boolean first() {
            this.add = this.QOIV.iterator();
            return true;
        }

        public boolean next() {
            if (this.add.hasNext()) {
                this.values = (FieldValue[])this.add.next();
                return true;
            }
            return false;
        }

        public void delete() {
            this.add.remove();
        }

        public void close() {
            this.QOIV.clear();
            this.add = null;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private final class LinkedRecordset
    extends RecordsetImpl
    implements Recordset {
        private Connection QOIV;
        private Statement beforeFirst;
        private ResultSet close;
        private final DB this$0;

        LinkedRecordset(DB dB, Field[] fieldArray, Connection connection, Statement statement, ResultSet resultSet) throws Throwable {
            this.this$0 = dB;
            super(dB, fieldArray, resultSet.getMetaData());
            this.QOIV = connection;
            this.beforeFirst = statement;
            this.close = resultSet;
        }

        public int getSetType() {
            return 1;
        }

        public int rows() {
            return 0;
        }

        public boolean first() {
            try {
                this.close.beforeFirst();
                return true;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return false;
            }
        }

        public boolean next() {
            try {
                if (this.close.next()) {
                    int n = this.columns();
                    int n2 = 0;
                    while (n2 < n) {
                        this.values[n2].setValue(this.close.getObject(n2 + 1));
                        ++n2;
                    }
                    return true;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return false;
        }

        public void delete() {
        }

        public void close() {
            if (this.QOIV == null) {
                return;
            }
            try {
                this.close.close();
                this.close = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                this.beforeFirst.close();
                this.beforeFirst = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                this.QOIV.close();
                this.QOIV = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

