/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jet.server.ServerEnvBuilder;
import jet.server.db.Connector;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DBCollectionImpl;
import jet.server.log.ServiceLogger;

public final class ConnectorManager {
    private static ConnectorManager QOIV = null;
    public static int MAX_HOLD = 128;
    public static int MIN_HOLD = 1;
    public static int MAX_USES = 128;
    public static long MAX_IDLE = 600000L;
    public static long MAX_WAIT = 30000L;
    private static HashMap access$100 = new HashMap(2);
    private DBCollectionImpl append = new DBCollectionImpl();
    private Thread class$;
    private LifeCycleController clear = new LifeCycleController(this, null);
    private static StringBuffer clone = new StringBuffer();
    private static Class[] contains = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectorManager.class$("java.sql.Connection")) : class$java$sql$Connection};
    private static Class[] delete = new Class[]{class$java$sql$Statement == null ? (class$java$sql$Statement = ConnectorManager.class$("java.sql.Statement")) : class$java$sql$Statement};
    private static Class[] disconnect = new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = ConnectorManager.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement};
    private static Class[] forName = new Class[]{class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = ConnectorManager.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement};
    static Class class$jet$server$db$core$ConnectorManager;
    static Class class$java$sql$Connection;
    static Class class$java$sql$Statement;
    static Class class$java$sql$PreparedStatement;
    static Class class$java$sql$CallableStatement;

    public static ConnectorManager getInstance() {
        return ConnectorManager.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorManager newInstance() {
        Class clazz = class$jet$server$db$core$ConnectorManager == null ? (class$jet$server$db$core$ConnectorManager = ConnectorManager.class$("jet.server.db.core.ConnectorManager")) : class$jet$server$db$core$ConnectorManager;
        synchronized (clazz) {
            if (QOIV == null) {
                QOIV = new ConnectorManager();
            }
        }
        return QOIV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Class clazz = class$jet$server$db$core$ConnectorManager == null ? (class$jet$server$db$core$ConnectorManager = ConnectorManager.class$("jet.server.db.core.ConnectorManager")) : class$jet$server$db$core$ConnectorManager;
        synchronized (clazz) {
            if (QOIV == null) {
                return;
            }
            if (ConnectorManager.QOIV.clear != null) {
                if (ConnectorManager.QOIV.clear.I()) {
                    ConnectorManager.QOIV.class$.interrupt();
                }
                ConnectorManager.QOIV.clear.stop();
                while (!ConnectorManager.QOIV.clear.Z()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        ServiceLogger.logError(interruptedException, 3);
                    }
                }
            }
            Iterator iterator = ConnectorManager.QOIV.append.iterator();
            while (iterator.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)iterator.next();
                try {
                    connectionPool.disconnect();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
            ConnectorManager.QOIV.append.clear();
            access$100.clear();
            QOIV = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
        }
    }

    public synchronized Connector getConnector(Properties properties) {
        Connector connector = null;
        Properties properties2 = null;
        String string = properties.getProperty("datasource");
        if (string != null) {
            if (string.startsWith("jndi://")) {
                properties2 = this.MAX_USES(string, properties);
                try {
                    connector = new JNDIDataSource(this, properties2);
                    return connector;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ServiceLogger.logError(exception);
                }
            }
            if (string.startsWith("jdbc://")) {
                properties2 = this.MAX_USES(string, properties);
            } else if (string.startsWith("file://")) {
                properties2 = (Properties)properties.clone();
            }
        } else {
            properties2 = (Properties)properties.clone();
        }
        String string2 = ConnectorManager.MAX_IDLE(properties2);
        if (this.append.contains(string2)) {
            connector = (Connector)this.append.get(string2);
        } else {
            connector = new ConnectionPool(this, properties2);
            this.append.append(connector);
        }
        return connector;
    }

    public Connector getConnector(String string, String string2, String string3, String string4) {
        Properties properties = new Properties();
        properties.setProperty("driver", string);
        properties.setProperty("url", string2);
        properties.setProperty("user", string3);
        properties.setProperty("password", string4);
        return this.getConnector(properties);
    }

    private ConnectorManager() {
        this.class$ = new Thread(this.clear);
        this.class$.start();
    }

    private synchronized void remove(ConnectionPool connectionPool) {
        this.append.remove(connectionPool.name);
    }

    private synchronized void MAX_HOLD() {
        Iterator iterator = this.append.iterator();
        while (iterator.hasNext()) {
            ConnectionPool connectionPool = (ConnectionPool)iterator.next();
            ConnectionPool.access$100(connectionPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String MAX_IDLE(Properties properties) {
        String string = null;
        StringBuffer stringBuffer = clone;
        synchronized (stringBuffer) {
            clone.delete(0, clone.length());
            clone.append(properties.getProperty("url", "")).append("#");
            clone.append("user=").append(properties.getProperty("user", ""));
            clone.append(",password=").append(properties.getProperty("password", ""));
            clone.append(",driver=").append(properties.getProperty("driver", ""));
            clone.append(",schema=").append(properties.getProperty("schema", ""));
            clone.append(",tablespace=").append(properties.getProperty("tablespace", ""));
            string = clone.toString();
        }
        return string;
    }

    private Properties MAX_USES(String string, Properties properties) {
        Properties properties2;
        Properties properties3 = properties2 = properties == null ? new Properties() : (Properties)properties.clone();
        if (string != null) {
            Object object;
            properties2.setProperty("datasource", string);
            String string2 = null;
            int n = 0;
            if (string.startsWith("jndi://")) {
                string2 = string.substring("jndi://".length());
                n = 1;
            } else if (string.startsWith("jdbc://")) {
                string2 = string.substring("jdbc://".length());
                n = 2;
            }
            int n2 = string2.indexOf("@");
            if (n2 != -1) {
                object = string2.substring(0, n2);
                int n3 = ((String)object).indexOf(":");
                if (n3 != -1) {
                    properties2.setProperty("user", ((String)object).substring(0, n3));
                    properties2.setProperty("password", ((String)object).substring(n3 + 1));
                }
                string2 = string2.substring(n2 + 1);
            }
            if ((n2 = string2.indexOf("#")) != -1) {
                switch (n) {
                    case 1: {
                        properties2.setProperty("jndi-name", string2.substring(0, n2));
                        break;
                    }
                    case 2: {
                        properties2.setProperty("url", string2.substring(0, n2));
                        break;
                    }
                }
                string2 = string2.substring(n2 + 1);
                if (string2 != null && string2.trim().length() > 0) {
                    object = new StringTokenizer(string2, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string3 = ((StringTokenizer)object).nextToken();
                        n2 = string3.indexOf("=");
                        if (n2 == -1) continue;
                        String string4 = string3.substring(0, n2).trim();
                        String string5 = string3.substring(n2 + 1).trim();
                        properties2.setProperty(string4, string5);
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        properties2.setProperty("jndi-name", string2);
                        break;
                    }
                    case 2: {
                        properties2.setProperty("url", string2);
                        break;
                    }
                }
            }
        }
        return properties2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static String access$200(Properties properties) {
        return ConnectorManager.MAX_IDLE(properties);
    }

    static void access$300(ConnectorManager connectorManager, ConnectionPool connectionPool) {
        connectorManager.remove(connectionPool);
    }

    static HashMap access$400() {
        return access$100;
    }

    static Class[] access$500() {
        return contains;
    }

    static Class[] access$700() {
        return delete;
    }

    static Class[] access$800() {
        return forName;
    }

    static Class[] access$900() {
        return disconnect;
    }

    static void access$1000(ConnectorManager connectorManager) {
        connectorManager.MAX_HOLD();
    }

    class 1 {
    }

    private final class JNDIDataSource
    extends AbstractDBObject
    implements Connector {
        private Context QOIV;
        private DataSource append;
        private final String close = "java:comp/env/";
        private String connect;
        private final ConnectorManager this$0;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JNDIDataSource(ConnectorManager connectorManager, Properties properties) throws Exception {
            this.this$0 = connectorManager;
            super(properties);
            this.QOIV = null;
            this.close = "java:comp/env/";
            this.connect = this.getProperty("jndi-name");
            if (this.connect == null) throw new Exception("jndi-name is null");
            this.QOIV = new InitialContext();
            try {
                this.QOIV.lookup(this.connect);
                return;
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (this.connect.startsWith("java:")) return;
                this.connect = "java:comp/env/" + this.connect;
                try {
                    this.QOIV.lookup(this.connect);
                    return;
                }
                catch (NameNotFoundException nameNotFoundException2) {
                    throw new Exception("Invalid jndi-name: " + this.connect);
                }
            }
        }

        public synchronized boolean testConnecting() throws SQLException {
            try {
                DataSource dataSource = (DataSource)this.QOIV.lookup(this.connect);
                if (dataSource != null) {
                    Connection connection = dataSource.getConnection();
                    connection.getMetaData();
                    connection.close();
                    return true;
                }
            }
            catch (NamingException namingException) {
                throw new SQLException("Can not found DataSource " + this.connect);
            }
            return false;
        }

        public synchronized void connect() throws SQLException {
            if (this.append == null) {
                try {
                    this.append = (DataSource)this.QOIV.lookup(this.connect);
                    ServiceLogger.logDebug(4640004, this.connect, 4);
                }
                catch (NamingException namingException) {
                    throw new SQLException(namingException.getMessage());
                }
            }
        }

        public synchronized void disconnect() throws SQLException {
            this.append = null;
        }

        public synchronized Connection getConnection() throws SQLException {
            if (this.append == null) {
                this.connect();
            }
            if (this.append != null) {
                String string = this.getProperty("user");
                String string2 = this.getProperty("password");
                if (string != null && string2 != null) {
                    return this.append.getConnection(string, string2);
                }
                return this.append.getConnection();
            }
            return null;
        }

        public synchronized Connection getConnection(long l) throws SQLException {
            if (this.append != null) {
                this.append.setLoginTimeout((int)l);
            }
            return this.getConnection();
        }

        public void destroy() {
            try {
                this.disconnect();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
        }
    }

    private final class LifeCycleController
    implements Runnable {
        long QOIV;
        boolean access$1000;
        boolean I;
        boolean Z;
        private final ConnectorManager this$0;

        private LifeCycleController(ConnectorManager connectorManager) {
            this.this$0 = connectorManager;
            this.QOIV = 60000L;
            this.access$1000 = false;
            this.I = false;
            this.Z = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LifeCycleController lifeCycleController;
            this.access$1000 = true;
            while (this.QOIV()) {
                lifeCycleController = this;
                synchronized (lifeCycleController) {
                    this.Z = true;
                }
                try {
                    Thread.sleep(this.QOIV);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                LifeCycleController lifeCycleController2 = this;
                synchronized (lifeCycleController2) {
                    this.Z = false;
                }
                if (!this.QOIV()) break;
                ConnectorManager.access$1000(this.this$0);
                if (!this.QOIV()) break;
            }
            lifeCycleController = this;
            synchronized (lifeCycleController) {
                this.I = true;
            }
        }

        synchronized void stop() {
            this.access$1000 = false;
        }

        synchronized boolean I() {
            return this.Z;
        }

        synchronized boolean Z() {
            return this.I;
        }

        synchronized boolean QOIV() {
            return this.access$1000;
        }

        LifeCycleController(ConnectorManager connectorManager, 1 var2_2) {
            this(connectorManager);
        }
    }

    private final class LifeCycle {
        Connection I;
        int Z;
        private long QOIV;
        private final ConnectorManager this$0;

        public LifeCycle(ConnectorManager connectorManager, Connection connection, int n) {
            this.this$0 = connectorManager;
            this.I = connection;
            this.Z = n;
            this.QOIV = System.currentTimeMillis();
        }

        public long lastAccessTime() {
            return this.QOIV;
        }
    }

    private final class ConnectionPool
    extends AbstractDBObject
    implements Connector {
        private int MAX_HOLD;
        private int MAX_IDLE;
        private int MAX_USES;
        private int MAX_WAIT;
        private long MIN_HOLD;
        private long QOIV;
        private Driver acceptsURL;
        private boolean access$200;
        private ArrayList access$300;
        private HashMap access$400;
        private int access$500;
        private final ConnectorManager this$0;

        public ConnectionPool(ConnectorManager connectorManager, Properties properties) {
            this.this$0 = connectorManager;
            super(ConnectorManager.access$200(properties), properties);
            this.access$200 = false;
            this.MAX_HOLD = this.getName().hashCode();
            this.MAX_IDLE = Integer.parseInt(this.getProperty("max-pooled", String.valueOf(MAX_HOLD)));
            this.MAX_USES = Integer.parseInt(this.getProperty("min-pooled", String.valueOf(MIN_HOLD)));
            this.MAX_WAIT = Integer.parseInt(this.getProperty("max-using", String.valueOf(MAX_USES)));
            this.MIN_HOLD = Long.parseLong(this.getProperty("max-idletime", String.valueOf(MAX_IDLE)));
            this.QOIV = Long.parseLong(this.getProperty("max-waittime", String.valueOf(MAX_WAIT)));
            this.access$300 = new ArrayList(this.MAX_IDLE);
            this.access$400 = new HashMap(this.MAX_IDLE);
        }

        public synchronized boolean testConnecting() throws SQLException {
            if (this.acceptsURL == null) {
                this.acceptsURL = this.MAX_IDLE(this.getClasspath(), this.getDriver(), this.getURL());
                if (this.acceptsURL == null) {
                    throw new SQLException("Cannot load " + this.getDriver());
                }
            }
            if (this.access$200) {
                return true;
            }
            Connection connection = this.MAX_USES();
            if (connection != null) {
                connection.close();
                return true;
            }
            return false;
        }

        public synchronized void connect() throws SQLException {
            if (this.acceptsURL == null) {
                this.acceptsURL = this.MAX_IDLE(this.getClasspath(), this.getDriver(), this.getURL());
                if (this.acceptsURL == null) {
                    throw new SQLException("No suitable driver for " + this.getDriver());
                }
            }
            if (this.access$200) {
                return;
            }
            Connection connection = this.MAX_USES();
            if (connection != null) {
                this.access$300.add(new LifeCycle(this.this$0, connection, 0));
            }
            this.access$200 = this.access$500 > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void disconnect() throws SQLException {
            Connection connection;
            if (!this.access$200) {
                return;
            }
            Iterator<Object> iterator = this.access$400.keySet().iterator();
            while (iterator.hasNext()) {
                Object var5_6;
                connection = (Connection)iterator.next();
                try {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 3);
                        var5_6 = null;
                        iterator.remove();
                        continue;
                    }
                    var5_6 = null;
                    iterator.remove();
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    iterator.remove();
                    throw throwable;
                }
            }
            iterator = this.access$300.iterator();
            while (iterator.hasNext()) {
                Object var7_8;
                connection = ((LifeCycle)iterator.next()).I;
                try {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 3);
                        var7_8 = null;
                        iterator.remove();
                        continue;
                    }
                    var7_8 = null;
                    iterator.remove();
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    iterator.remove();
                    throw throwable;
                }
            }
            this.access$500 = 0;
            this.access$200 = false;
        }

        public Connection getConnection() throws SQLException {
            return this.getConnection(this.QOIV);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Connection getConnection(long l) throws SQLException {
            Object object;
            Connection connection = null;
            int n = 0;
            if (!this.access$200) {
                this.connect();
            }
            if (!this.access$300.isEmpty()) {
                object = (LifeCycle)this.access$300.remove(0);
                connection = ((LifeCycle)object).I;
                n = ((LifeCycle)object).Z;
                if (!this.MAX_HOLD(connection)) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(((LifeCycle)object).lastAccessTime()));
                    ServiceLogger.logError(3640002, string, 3);
                    Connection connection2 = this.MAX_USES();
                    try {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException, 3);
                            Object var11_12 = null;
                            --this.access$500;
                        }
                        Object var11_11 = null;
                        --this.access$500;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        --this.access$500;
                        throw throwable;
                    }
                    connection = connection2;
                    n = 0;
                }
            } else {
                if (this.access$500 >= this.MAX_IDLE) {
                    long l2 = System.currentTimeMillis();
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new SQLException(interruptedException.getMessage());
                    }
                    long l3 = System.currentTimeMillis() - l2;
                    if (l <= l3 && l > 0L) {
                        throw new SQLException("Connecting is overtime.");
                    }
                    return this.getConnection(l - l3);
                }
                connection = this.MAX_USES();
            }
            object = this.MAX_WAIT(connection, n);
            this.access$400.put(connection, object);
            return object;
        }

        private boolean MAX_HOLD(Connection connection) {
            String string = "TBL_IDGENRATOR_JINFONET";
            String string2 = this.getProperty("schema");
            if (string2 != null && string2.length() > 0) {
                string = "\"" + string2 + "\"." + string;
            }
            boolean bl = false;
            try {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
                statement.close();
                statement = null;
                resultSet.close();
                resultSet = null;
                bl = true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug(sQLException.toString(), 3);
            }
            return bl;
        }

        public void destroy() {
            try {
                this.disconnect();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            ConnectorManager.access$300(this.this$0, this);
        }

        public String getClasspath() {
            return this.getProperty("classpath");
        }

        public String getDriver() {
            return this.getProperty("driver");
        }

        public String getURL() {
            return this.getProperty("url");
        }

        public String getUser() {
            return this.getProperty("user");
        }

        public String getPassword() {
            return this.getProperty("password");
        }

        public boolean equals(Object object) {
            return this.MAX_HOLD == object.hashCode();
        }

        public int hashCode() {
            return this.MAX_HOLD;
        }

        public String toString() {
            return this.getName();
        }

        private Driver MAX_IDLE(String string, String string2, String string3) {
            Object object;
            boolean bl = "org.hsqldb.jdbcDriver".equals(string2);
            if (bl) {
                object = ServerEnvBuilder.servEnv;
                string = ((Properties)object).getProperty("hsqldb.classpath");
                this.setProperty("shutdown", "false");
            }
            object = string == null ? string2 : string + string2;
            Driver driver = null;
            if (ConnectorManager.access$400().containsKey(object) && !bl) {
                driver = (Driver)ConnectorManager.access$400().get(object);
            } else {
                if (string != null && string.trim().length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (stringTokenizer.hasMoreElements()) {
                        arrayList.add(stringTokenizer.nextElement());
                    }
                    try {
                        URL[] uRLArray = new URL[arrayList.size()];
                        int n = 0;
                        while (n < uRLArray.length) {
                            uRLArray[n] = new File((String)arrayList.get(n)).toURL();
                            ++n;
                        }
                        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, null);
                        driver = (Driver)uRLClassLoader.loadClass(string2).newInstance();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        driver = null;
                    }
                }
                if (driver == null) {
                    try {
                        Class.forName(string2);
                        driver = DriverManager.getDriver(string3);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        driver = null;
                    }
                }
            }
            if (driver != null && !bl && !ConnectorManager.access$400().containsKey(object)) {
                ConnectorManager.access$400().put(object, driver);
            }
            return driver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Connection MAX_USES() throws SQLException {
            if (!this.acceptsURL.acceptsURL(this.getURL())) {
                throw new SQLException("Cannot accept URL: " + this.getURL());
            }
            Connection connection = null;
            try {
                connection = this.acceptsURL.connect(this.getURL(), this.getProperties());
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                ServiceLogger.logError("Connection URL:" + this.getURL() + ",\tConnection Properties:" + this.getProperties());
                throw new SQLException(sQLException.getMessage());
            }
            if (connection != null) {
                block11: {
                    connection.setAutoCommit(true);
                    Statement statement = null;
                    if ("org.hsqldb.jdbcDriver".equals(this.getDriver())) {
                        String string = this.getProperty("hsql-write-delay");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("SET WRITE_DELAY ");
                        if (string == null || string.trim().length() == 0) {
                            stringBuffer.append("FALSE");
                        } else {
                            stringBuffer.append(string).append(" MILLIS");
                        }
                        try {
                            try {
                                statement = connection.createStatement();
                                statement.execute(stringBuffer.toString());
                            }
                            catch (SQLException sQLException) {
                                ServiceLogger.logError(sQLException);
                                Object var7_7 = null;
                                statement.close();
                                connection.clearWarnings();
                                break block11;
                            }
                            Object var7_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            statement.close();
                            connection.clearWarnings();
                            throw throwable;
                        }
                        statement.close();
                        connection.clearWarnings();
                    }
                }
                ++this.access$500;
            }
            return connection;
        }

        private Connection MAX_WAIT(Connection connection, int n) {
            return (Connection)Proxy.newProxyInstance((class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectorManager.class$("java.sql.Connection")) : class$java$sql$Connection).getClassLoader(), ConnectorManager.access$500(), (InvocationHandler)new ConnectionInvocationHandler(this, connection, n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private synchronized void MIN_HOLD(Connection connection, int n) {
            block31: {
                if (n > this.MAX_WAIT && this.MAX_WAIT > 0) {
                    Object v0;
                    this.access$300.add(new LifeCycle(this.this$0, this.MAX_USES(), 0));
                    Object var5_3 = null;
                    try {
                        try {
                            connection.close();
                            v0 = null;
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException, 3);
                            v0 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v0 = null;
                    }
                    Object var8_12 = v0;
                    --this.access$500;
                    {
                        break block31;
                        catch (SQLException sQLException) {
                            Object v1;
                            ServiceLogger.logError(sQLException);
                            var5_3 = null;
                            try {
                                try {
                                    connection.close();
                                    v1 = null;
                                }
                                catch (SQLException sQLException2) {
                                    ServiceLogger.logError(sQLException2, 3);
                                    v1 = null;
                                }
                            }
                            catch (Throwable throwable) {
                                v1 = null;
                            }
                            Object var8_13 = v1;
                            --this.access$500;
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        Object v2;
                        Object var5_4 = null;
                        try {
                            try {
                                connection.close();
                                v2 = null;
                            }
                            catch (SQLException sQLException) {
                                ServiceLogger.logError(sQLException, 3);
                                v2 = null;
                            }
                        }
                        catch (Throwable throwable2) {
                            v2 = null;
                        }
                        Object var8_14 = v2;
                        --this.access$500;
                        throw throwable;
                    }
                }
                try {
                    connection.clearWarnings();
                    this.access$300.add(new LifeCycle(this.this$0, connection, n));
                }
                catch (SQLException sQLException) {
                    Object v3;
                    this.access$300.add(new LifeCycle(this.this$0, this.MAX_USES(), 0));
                    Object var10_21 = null;
                    try {
                        try {
                            connection.close();
                            v3 = null;
                        }
                        catch (SQLException sQLException3) {
                            ServiceLogger.logError(sQLException3, 3);
                            v3 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v3 = null;
                    }
                    Object var13_30 = v3;
                    --this.access$500;
                    {
                        catch (SQLException sQLException4) {
                            Object v4;
                            ServiceLogger.logError(sQLException4);
                            Object var10_22 = null;
                            try {
                                try {
                                    connection.close();
                                    v4 = null;
                                }
                                catch (SQLException sQLException5) {
                                    ServiceLogger.logError(sQLException5, 3);
                                    v4 = null;
                                }
                            }
                            catch (Throwable throwable) {
                                v4 = null;
                            }
                            Object var13_31 = v4;
                            --this.access$500;
                        }
                    }
                    catch (Throwable throwable) {
                        Object v5;
                        Object var10_23 = null;
                        try {
                            try {
                                connection.close();
                                v5 = null;
                            }
                            catch (SQLException sQLException6) {
                                ServiceLogger.logError(sQLException6, 3);
                                v5 = null;
                            }
                        }
                        catch (Throwable throwable3) {
                            v5 = null;
                        }
                        Object var13_32 = v5;
                        --this.access$500;
                        throw throwable;
                    }
                }
            }
            Object v = this.access$400.remove(connection);
            ConnectionInvocationHandler connectionInvocationHandler = (ConnectionInvocationHandler)Proxy.getInvocationHandler(v);
            connectionInvocationHandler.I = null;
            if (this.access$500 <= 0) {
                try {
                    this.access$300.add(new LifeCycle(this.this$0, this.MAX_USES(), 0));
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void QOIV() {
            if (!this.access$200) {
                return;
            }
            Iterator iterator = this.access$300.iterator();
            while (iterator.hasNext()) {
                Object var7_5;
                LifeCycle lifeCycle = (LifeCycle)iterator.next();
                long l = System.currentTimeMillis() - lifeCycle.lastAccessTime();
                if (l < this.MIN_HOLD || this.MIN_HOLD <= 0L || this.access$500 <= 1) continue;
                try {
                    try {
                        lifeCycle.I.close();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 3);
                        var7_5 = null;
                        iterator.remove();
                        --this.access$500;
                        continue;
                    }
                    var7_5 = null;
                    iterator.remove();
                    --this.access$500;
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    iterator.remove();
                    --this.access$500;
                    throw throwable;
                }
            }
        }

        static void access$100(ConnectionPool connectionPool) {
            connectionPool.QOIV();
        }

        static void access$600(ConnectionPool connectionPool, Connection connection, int n) {
            connectionPool.MIN_HOLD(connection, n);
        }

        private final class StatementInvocationHandler
        implements InvocationHandler {
            Object QOIV;
            Object getInvocationHandler;
            private final ConnectionPool this$1;

            StatementInvocationHandler(ConnectionPool connectionPool, Object object, Object object2) {
                this.this$1 = connectionPool;
                this.QOIV = object;
                this.getInvocationHandler = object2;
            }

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (((ConnectionInvocationHandler)Proxy.getInvocationHandler((Object)this.QOIV)).I == null) {
                    throw new SQLException("The connection is closed.");
                }
                return method.invoke(this.getInvocationHandler, objectArray);
            }
        }

        private final class ConnectionInvocationHandler
        implements InvocationHandler {
            Connection I;
            private int QOIV;
            private final ConnectionPool this$1;

            ConnectionInvocationHandler(ConnectionPool connectionPool, Connection connection, int n) {
                this.this$1 = connectionPool;
                this.I = connection;
                this.QOIV = n + 1;
            }

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (this.I == null || this.I.isClosed()) {
                    throw new SQLException("The connection is closed.");
                }
                if ("close".equals(method.getName())) {
                    ConnectionPool.access$600(this.this$1, this.I, this.QOIV);
                    return null;
                }
                if ("createStatement".equals(method.getName())) {
                    return Proxy.newProxyInstance((class$java$sql$Statement == null ? (class$java$sql$Statement = ConnectorManager.class$("java.sql.Statement")) : class$java$sql$Statement).getClassLoader(), ConnectorManager.access$700(), (InvocationHandler)new StatementInvocationHandler(this.this$1, object, method.invoke((Object)this.I, objectArray)));
                }
                if ("prepareCall".equals(method.getName())) {
                    return Proxy.newProxyInstance((class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = ConnectorManager.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement).getClassLoader(), ConnectorManager.access$800(), (InvocationHandler)new StatementInvocationHandler(this.this$1, object, method.invoke((Object)this.I, objectArray)));
                }
                if ("prepareStatement".equals(method.getName())) {
                    return Proxy.newProxyInstance((class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = ConnectorManager.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement).getClassLoader(), ConnectorManager.access$900(), (InvocationHandler)new StatementInvocationHandler(this.this$1, object, method.invoke((Object)this.I, objectArray)));
                }
                return method.invoke((Object)this.I, objectArray);
            }

            protected void finalize() throws Throwable {
                if (this.I != null) {
                    ConnectionPool.access$600(this.this$1, this.I, this.QOIV);
                }
                super.finalize();
            }
        }
    }
}

