/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.db.core.AbstractDBObject;

public final class FieldImpl
extends AbstractDBObject
implements Field,
Cloneable {
    private static final BigDecimal QOIV = new BigDecimal("0");
    private static final char[] append = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private Table byteToHex;
    private JDBCType byteValue;
    private String clone;
    private String compareTo;
    private int doubleValue = 0;
    private int getName = 0;
    private int getTableName = 0;

    protected FieldImpl() {
    }

    public FieldImpl(String string) {
        super(AbstractDBObject.getUCName(string));
    }

    public FieldImpl(String string, String string2, JDBCType jDBCType, int n, int n2, int n3) {
        super(AbstractDBObject.getUCName(string2));
        this.setTableName(string);
        this.byteValue = jDBCType;
        this.doubleValue = n;
        this.getName = n2;
        this.getTableName = n3;
    }

    public FieldImpl(String string, JDBCType jDBCType, int n, int n2) {
        super(AbstractDBObject.getUCName(string));
        this.byteValue = jDBCType;
        this.doubleValue = n;
        this.getTableName = n2;
    }

    public FieldImpl(Table table, String string, JDBCType jDBCType, int n, int n2, int n3) {
        super(AbstractDBObject.getUCName(string));
        this.setParentTable(table);
        this.byteValue = jDBCType;
        this.doubleValue = n;
        this.getName = n2;
        this.getTableName = n3;
    }

    public Table getParentTable() {
        return this.byteToHex;
    }

    public JDBCType getJDBCType() {
        return this.byteValue;
    }

    public int getSize() {
        return this.doubleValue;
    }

    public boolean isNotNull() {
        return (this.getName & 1) != 0;
    }

    public boolean isIdentity() {
        return (this.getName & 2) != 0;
    }

    public boolean isUnique() {
        return (this.getName & 4) != 0;
    }

    public boolean isPrimaryKey() {
        return (this.getName & 8) != 0;
    }

    public FieldValue createFieldValue() {
        return new FieldValueImpl(this, this.getName());
    }

    public int getCalculating() {
        return this.getTableName;
    }

    public String getTableName() {
        return this.clone;
    }

    public String getDispName() {
        return this.compareTo == null ? this.getName() : this.compareTo;
    }

    public void setDispName(String string) {
        this.compareTo = AbstractDBObject.getUCName(string);
    }

    public String getFullyQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTableName()).append(".").append(this.getName());
        return stringBuffer.substring(0);
    }

    public void setParentTable(Table table) {
        this.byteToHex = table;
        this.clone = this.byteToHex.getName();
    }

    public void setCalculating(int n) {
        this.getTableName = n;
    }

    public void setFieldName(String string) {
        super.setName(AbstractDBObject.getUCName(string));
    }

    public void setSize(int n) {
        this.doubleValue = n;
    }

    public void setTableName(String string) {
        this.clone = string;
    }

    public void setType(JDBCType jDBCType) {
        this.byteValue = jDBCType;
    }

    public void setNotNull(boolean bl) {
        if (bl) {
            this.getName |= 1;
        }
    }

    public void setIdentity(boolean bl) {
        if (bl) {
            this.getName |= 2;
        }
    }

    public Field createClone() {
        Field field = null;
        try {
            field = (Field)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return field;
    }

    public static final Object convertObject(Object object, int n) throws NumberFormatException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case -6: {
                if (object instanceof String) {
                    object = new Integer((String)object);
                }
                if (object instanceof Integer || object instanceof Long) {
                    int n2 = ((Number)object).intValue();
                    if (127 < n2 || n2 < -128) {
                        throw new NumberFormatException();
                    }
                    return object;
                }
                if (object instanceof Byte) {
                    return new Integer(((Number)object).intValue());
                }
                if (!(object instanceof Float) && !(object instanceof Double)) break;
                int n3 = ((Number)object).intValue();
                if (Short.MAX_VALUE < n3 || n3 < Short.MIN_VALUE) {
                    throw new NumberFormatException();
                }
                return new Integer(((Number)object).intValue());
            }
            case 5: {
                if (object instanceof String) {
                    object = new Integer((String)object);
                }
                if (object instanceof Integer || object instanceof Long) {
                    int n4 = ((Number)object).intValue();
                    if (Short.MAX_VALUE < n4 || n4 < Short.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return object;
                }
                if (object instanceof Byte || object instanceof Short) {
                    return new Integer(((Number)object).intValue());
                }
                if (!(object instanceof Float) && !(object instanceof Double)) break;
                int n5 = ((Number)object).intValue();
                if (Short.MAX_VALUE < n5 || n5 < Short.MIN_VALUE) {
                    throw new NumberFormatException();
                }
                return new Integer(((Number)object).intValue());
            }
            case 4: {
                if (object instanceof String) {
                    return new Integer((String)object);
                }
                if (object instanceof Integer) {
                    return object;
                }
                if (!(object instanceof Long) && !(object instanceof Float) && !(object instanceof Double)) break;
                int n6 = ((Number)object).intValue();
                if (Integer.MAX_VALUE < n6 || n6 < Integer.MIN_VALUE) {
                    throw new NumberFormatException();
                }
                return new Integer(((Number)object).intValue());
            }
            case -5: {
                if (object instanceof Long) {
                    return object;
                }
                if (object instanceof String) {
                    return new Long((String)object);
                }
                if (object instanceof Integer) {
                    return new Long(((Integer)object).longValue());
                }
                if (!(object instanceof Float) && !(object instanceof Double)) break;
                long l = ((Number)object).longValue();
                if (Long.MAX_VALUE < l || l < Long.MIN_VALUE) {
                    throw new NumberFormatException();
                }
                return new Long(((Number)object).longValue());
            }
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof String) {
                    return new Double((String)object);
                }
                if (!(object instanceof Number)) break;
                return new Double(((Number)object).doubleValue());
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) break;
                return object;
            }
            case -7: {
                if (object instanceof Boolean) {
                    return object;
                }
                if (object instanceof Byte) {
                    boolean bl = ((Number)object).byteValue() != 0;
                    return new Boolean(bl);
                }
                if (object instanceof String) {
                    return new Boolean((String)object);
                }
                if (object instanceof Integer || object instanceof Long) {
                    boolean bl = ((Number)object).longValue() != 0L;
                    return new Boolean(bl);
                }
                if (object instanceof Double) {
                    boolean bl = (Double)object != 0.0;
                    return new Boolean(bl);
                }
                if (!(object instanceof BigDecimal)) break;
                boolean bl = ((BigDecimal)object).compareTo(QOIV) != 0;
                return new Boolean(bl);
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof String) {
                    return object;
                }
                if (!(object instanceof byte[])) break;
                return FieldImpl.byteToHex((byte[])object);
            }
            case 92: {
                if (object instanceof Timestamp) {
                    return new Time(((Timestamp)object).getTime());
                }
                if (object instanceof Date) {
                    return new Time(0L);
                }
                if (!(object instanceof Time)) break;
                return object;
            }
            case 91: {
                if (object instanceof Timestamp) {
                    return new Date(((Timestamp)object).getTime());
                }
                if (!(object instanceof Date)) break;
                return object;
            }
            case 93: {
                if (object instanceof Date) {
                    return new Timestamp(((Date)object).getTime());
                }
                if (object instanceof Time) {
                    return new Timestamp(((Time)object).getTime());
                }
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(object instanceof byte[])) break;
                return object;
            }
            case 1111: {
                if (object instanceof String) break;
                return object;
            }
        }
        return object;
    }

    public static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            stringBuffer.append(append[n3 >> 4 & 0xF]);
            stringBuffer.append(append[n3 & 0xF]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private final class FieldValueImpl
    extends AbstractDBObject
    implements FieldValue {
        private Object QOIV;
        private final FieldImpl this$0;

        public FieldValueImpl(FieldImpl fieldImpl, String string) {
            this.this$0 = fieldImpl;
            super(AbstractDBObject.getUCName(string));
        }

        public Object getValue() {
            return FieldImpl.convertObject(this.QOIV, this.getJDBCType().dataType());
        }

        public void setValue(Object object) {
            int n = this.getJDBCType().dataType();
            if (n == 12 || n == 1 || n == -1) {
                int n2 = this.this$0.getSize();
                if (object == null) {
                    this.QOIV = null;
                } else {
                    String string = null;
                    if (object instanceof String) {
                        string = (String)object;
                    }
                    if (object instanceof byte[]) {
                        string = FieldImpl.byteToHex((byte[])object);
                    }
                    this.QOIV = n2 != 0 && string != null && string.length() > n2 ? string.substring(0, n2) : string;
                }
            } else {
                this.QOIV = FieldImpl.convertObject(object, n);
            }
        }

        public JDBCType getJDBCType() {
            return this.this$0.getJDBCType();
        }

        public boolean isIdentity() {
            return this.this$0.isIdentity();
        }

        public String toString() {
            return this.QOIV.toString();
        }

        public String getTableName() {
            return this.this$0.getTableName();
        }

        public boolean getBoolean() {
            Object object = FieldImpl.convertObject(this.getValue(), -7);
            return object == null ? false : (Boolean)object;
        }

        public byte getByte() {
            Object object = FieldImpl.convertObject(this.getValue(), 5);
            return object == null ? (byte)0 : ((Number)object).byteValue();
        }

        public short getShort() {
            Object object = FieldImpl.convertObject(this.getValue(), 5);
            return object == null ? (short)0 : ((Number)object).shortValue();
        }

        public int getInt() {
            Object object = FieldImpl.convertObject(this.getValue(), 4);
            return object == null ? 0 : ((Number)object).intValue();
        }

        public long getLong() {
            Object object = FieldImpl.convertObject(this.getValue(), -5);
            return object == null ? 0L : ((Number)object).longValue();
        }

        public float getFloat() {
            Object object = FieldImpl.convertObject(this.getValue(), 7);
            return object == null ? 0.0f : ((Number)object).floatValue();
        }

        public double getDouble() {
            Object object = FieldImpl.convertObject(this.getValue(), 8);
            return object == null ? 0.0 : ((Number)object).doubleValue();
        }

        public String getString() {
            Object object = this.getValue();
            return object == null ? null : object.toString();
        }

        public byte[] getBytes() {
            Object object = this.getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof String) {
                return ((String)object).getBytes();
            }
            object = FieldImpl.convertObject(this.getValue(), -2);
            return (byte[])object;
        }

        public Date getDate() {
            return (Date)FieldImpl.convertObject(this.getValue(), 91);
        }

        public Time getTime() {
            return (Time)FieldImpl.convertObject(this.getValue(), 92);
        }

        public Timestamp getTimestamp() {
            return (Timestamp)FieldImpl.convertObject(this.getValue(), 93);
        }
    }
}

