/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.sql.SQLException;
import java.util.HashMap;
import jet.server.api.db.DBObject;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.IDGenerator;
import jet.server.db.core.TableImpl;

public final class IDGeneratorImpl
extends TableImpl
implements IDGenerator {
    private HashMap INTEGER = new HashMap();
    private static int QOIV = 32;

    public IDGeneratorImpl(Database database) throws InstantiationException, SQLException {
        super(database, "TBL_IDGENRATOR_JINFONET");
        this.adapter.setIDGenerator(this);
        super.append(new FieldImpl(this.getName(), "TF_NAME", JDBCType.VARCHAR, 64, 9, 0));
        super.append(new FieldImpl(this.getName(), "NEXT_ID", JDBCType.INTEGER, 0, 1, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public void open() throws SQLException {
        Recordset recordset = this.getAllRecords();
        while (recordset.next()) {
            String string = recordset.fields("TF_NAME").getString();
            int n = recordset.fields("NEXT_ID").getInt();
            IDBroker iDBroker = new IDBroker(this, string, n);
            this.INTEGER.put(iDBroker.getName(), iDBroker);
        }
        recordset.close();
        recordset = null;
    }

    public void close() {
        super.close();
        this.INTEGER.clear();
    }

    public Recordset getAllRecords() throws SQLException {
        return super.query(this.fields().toArray(), null, false);
    }

    public void createIdentity(Table table, Field field) throws SQLException {
        if (!field.isIdentity()) {
            throw new SQLException("The " + field.getFullyQualifiedName() + " is not an identity.");
        }
        String string = this.INTEGER(table.getName(), field.getName());
        this.QOIV(string, 0);
    }

    public void deleteIdentity(Table table, Field field) throws SQLException {
        IDBroker iDBroker;
        Object object;
        Field field2 = null;
        if (field == null) {
            object = table.fields().toArray();
            int n = ((Field[])object).length;
            int n2 = 0;
            while (n2 < n) {
                if (object[n2].isIdentity()) {
                    field2 = object[n2];
                    break;
                }
                ++n2;
            }
            if (field2 == null) {
                return;
            }
        } else {
            field2 = field;
        }
        if ((iDBroker = (IDBroker)this.INTEGER.remove(object = this.INTEGER(table.getName(), field2.getName()))) != null) {
            super.delete("WHERE TF_NAME=" + this.adapter.formatValue((String)object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID(Table table, Field field) throws SQLException {
        if (!field.isIdentity()) {
            throw new SQLException("The " + field.getFullyQualifiedName() + " is not an identity.");
        }
        String string = this.INTEGER(table.getName(), field.getName());
        IDBroker iDBroker = null;
        HashMap hashMap = this.INTEGER;
        synchronized (hashMap) {
            iDBroker = (IDBroker)this.INTEGER.get(string);
        }
        if (iDBroker == null) {
            iDBroker = this.QOIV(string, 0);
        }
        return iDBroker.nextID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setID(Table table, Field field, int n) throws SQLException {
        if (!field.isIdentity()) {
            throw new SQLException("The " + field.getFullyQualifiedName() + " is not an identity.");
        }
        String string = this.INTEGER(table.getName(), field.getName());
        IDBroker iDBroker = null;
        HashMap hashMap = this.INTEGER;
        synchronized (hashMap) {
            iDBroker = (IDBroker)this.INTEGER.get(string);
        }
        if (iDBroker == null) {
            iDBroker = this.QOIV(string, n);
        } else {
            iDBroker.setInitValue(n);
        }
    }

    private String INTEGER(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.toUpperCase()).append("_").append(string2.toUpperCase());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDBroker QOIV(String string, int n) throws SQLException {
        FieldValue[] fieldValueArray = this.fields().values();
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(new Integer(n + QOIV));
        super.delete("WHERE TF_NAME=" + this.adapter.formatValue(string));
        super.insert(fieldValueArray);
        IDBroker iDBroker = new IDBroker(this, string, n);
        iDBroker.setUplimit(n + QOIV);
        HashMap hashMap = this.INTEGER;
        synchronized (hashMap) {
            this.INTEGER.put(iDBroker.getName(), iDBroker);
        }
        return iDBroker;
    }

    static int access$000() {
        return QOIV;
    }

    private final class IDBroker
    extends AbstractDBObject
    implements DBObject {
        private int QOIV;
        private int access$000;
        private final IDGeneratorImpl this$0;

        public IDBroker(IDGeneratorImpl iDGeneratorImpl, String string, int n) throws SQLException {
            this.this$0 = iDGeneratorImpl;
            super(AbstractDBObject.getUCName(string));
            this.QOIV = n;
        }

        public void setUplimit(int n) {
            this.access$000 = n;
        }

        public synchronized int setInitValue(int n) throws SQLException {
            if (n < this.QOIV) {
                return this.QOIV;
            }
            this.QOIV = n;
            this.QOIV();
            return n;
        }

        public synchronized int nextID() throws SQLException {
            ++this.QOIV;
            if (this.QOIV >= this.access$000) {
                this.QOIV();
            }
            return this.QOIV;
        }

        void QOIV() throws SQLException {
            this.setUplimit(this.QOIV + IDGeneratorImpl.access$000());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE TF_NAME=").append(this.this$0.adapter.formatValue(this.getName()));
            FieldValue[] fieldValueArray = new FieldValue[]{this.this$0.fields("NEXT_ID").createFieldValue()};
            fieldValueArray[0].setValue(new Integer(this.access$000));
            this.this$0.adapter.update(this.this$0, fieldValueArray, stringBuffer.substring(0));
        }
    }
}

