/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.File;
import java.sql.SQLException;
import java.util.List;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Fields;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.db.Unique;
import jet.server.api.db.Uniques;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.adapter.DBFactory;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.FieldsImpl;
import jet.server.db.core.UniquesImpl;

public class TableImpl
extends AbstractDBObject
implements Table {
    private Database C;
    protected FieldsImpl fields;
    protected UniquesImpl unqs = new UniquesImpl();
    protected DBAdapter adapter;

    public TableImpl(String string) {
        super(AbstractDBObject.getUCName(string));
        this.fields = new FieldsImpl();
    }

    public TableImpl(String string, Field[] fieldArray) {
        super(AbstractDBObject.getUCName(string));
        this.fields = new FieldsImpl(fieldArray);
    }

    public TableImpl(Database database, String string) throws InstantiationException {
        this(string);
        TableImpl tableImpl;
        String string2;
        this.C = database;
        String string3 = database.getProperty("tablespace");
        if (string3 != null) {
            this.setProperty("tablespace", string3);
        }
        if ((string2 = database.getProperty("schema")) != null) {
            this.setProperty("schema", string2);
        }
        if ((tableImpl = (TableImpl)database.tables(string)) != null) {
            this.adapter = tableImpl.getDBAdapter();
        }
        if (this.adapter == null) {
            this.adapter = DBFactory.create(((DatabaseImpl)database).getConnector());
        }
        this.adapter.setIDGenerator(((DatabaseImpl)database).getIDGenerator());
    }

    public Database getDatabase() {
        return this.C;
    }

    public String getName() {
        String string = super.getName();
        String string2 = this.getProperty("schema");
        if (string2 != null && string2.length() > 0) {
            string = "\"" + string2 + "\"." + string;
        }
        return string;
    }

    public final Fields fields() {
        return this.fields;
    }

    public final Field fields(int n) {
        return (Field)this.fields.get(n);
    }

    public final Field fields(String string) {
        return (Field)this.fields.get(string);
    }

    public final void append(Field field) {
        this.fields.append(field);
    }

    public final void remove(Field field) {
        this.fields.remove(field.getName());
    }

    public void close() {
        this.fields.clear();
        this.adapter = null;
    }

    public final Recordset query(Field[] fieldArray, String string, boolean bl) throws SQLException {
        return this.query(fieldArray, string, bl, 1);
    }

    public final Recordset query(Field[] fieldArray, String string, boolean bl, int n) throws SQLException {
        Table[] tableArray = new Table[]{this};
        return this.adapter.select(fieldArray, tableArray, string, bl, n);
    }

    public final int queryCountValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setType(JDBCType.INTEGER);
        ((FieldImpl)fieldArray[0]).setCalculating(1);
        Recordset recordset = this.query(fieldArray, string2, bl);
        int n = Integer.MIN_VALUE;
        if (recordset.next()) {
            n = recordset.getInt(0);
        }
        recordset.close();
        recordset = null;
        return n;
    }

    public final Number querySumValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(2);
        Recordset recordset = this.query(fieldArray, string2, bl);
        Number number = null;
        number = recordset.next() ? (Number)((Number)recordset.getValue(0)) : (Number)this.C(fieldArray[0].getJDBCType());
        recordset.close();
        recordset = null;
        return number;
    }

    public final Number queryAvgValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(3);
        Recordset recordset = this.query(fieldArray, string2, bl);
        Number number = null;
        number = recordset.next() ? (Number)((Number)recordset.getValue(0)) : (Number)this.C(fieldArray[0].getJDBCType());
        recordset.close();
        recordset = null;
        return number;
    }

    public final Number queryMaxValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(4);
        Recordset recordset = this.query(fieldArray, string2, bl);
        Number number = null;
        if (recordset.next()) {
            number = (Number)recordset.getValue(0);
            if (number == null) {
                number = this.C(fieldArray[0].getJDBCType());
            }
        } else {
            number = this.C(fieldArray[0].getJDBCType());
        }
        recordset.close();
        recordset = null;
        return number;
    }

    public final Number queryMinValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(5);
        Recordset recordset = this.query(fieldArray, string2, bl);
        Number number = null;
        if (recordset.next()) {
            number = (Number)recordset.getValue(0);
            if (number == null) {
                number = this.C(fieldArray[0].getJDBCType());
            }
        } else {
            number = this.C(fieldArray[0].getJDBCType());
        }
        recordset.close();
        recordset = null;
        return number;
    }

    public int insert(List list) throws SQLException {
        return this.adapter.insert((Table)this, list);
    }

    public final int insert(FieldValue[] fieldValueArray) throws SQLException {
        return this.adapter.insert((Table)this, fieldValueArray);
    }

    public final int update(FieldValue[] fieldValueArray, String string) throws SQLException {
        return this.adapter.update(this, fieldValueArray, string);
    }

    public final int delete(String string) throws SQLException {
        return this.adapter.delete(this, string);
    }

    public final int delete(FieldValue[] fieldValueArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ");
        int n = fieldValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue fieldValue = fieldValueArray[n2];
            int n3 = fieldValue.getJDBCType().dataType();
            stringBuffer.append(fieldValue.getName()).append("=");
            switch (n3) {
                case -7: 
                case 16: {
                    stringBuffer.append(this.adapter.formatValue(fieldValue.getBoolean()));
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stringBuffer.append(fieldValue.getValue());
                    break;
                }
                case 91: {
                    stringBuffer.append(this.adapter.formatValue(fieldValue.getDate()));
                    break;
                }
                case 92: {
                    stringBuffer.append(this.adapter.formatValue(fieldValue.getTime()));
                    break;
                }
                case 93: {
                    stringBuffer.append(this.adapter.formatValue(fieldValue.getTimestamp()));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    stringBuffer.append(this.adapter.formatValue(fieldValue.getString()));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    break;
                }
            }
            if (n2 < n - 1) {
                stringBuffer.append(" AND ");
            }
            ++n2;
        }
        return this.delete(stringBuffer.toString());
    }

    public boolean hasExternalData() {
        return false;
    }

    public String getExternalDataPath(FieldValue[] fieldValueArray) {
        return null;
    }

    private Number C(JDBCType jDBCType) {
        switch (jDBCType.dataType()) {
            case -6: {
                return new Byte(-128);
            }
            case 5: {
                return new Short(Short.MIN_VALUE);
            }
            case 4: {
                return new Integer(Integer.MIN_VALUE);
            }
            case -5: {
                return new Long(Long.MIN_VALUE);
            }
            case 6: {
                return new Float(Float.MIN_VALUE);
            }
            case 3: 
            case 7: 
            case 8: {
                return new Double(Double.MIN_VALUE);
            }
        }
        return null;
    }

    public DBAdapter getDBAdapter() {
        return this.adapter;
    }

    public final Uniques uniques() {
        return this.unqs;
    }

    public final Unique uniques(int n) {
        return (Unique)this.unqs.get(n);
    }

    public final Unique uniques(String string) {
        return (Unique)this.unqs.get(string);
    }

    public final void append(Unique unique) {
        this.unqs.append(unique);
    }

    public final void remove(Unique unique) {
        this.unqs.remove(unique.getName());
    }

    protected String rulesFilePath(String string) {
        String string2 = string;
        if (string != null && string.trim().length() > 0) {
            if (string.indexOf(47) != -1 && File.separatorChar != '/') {
                string2 = this.replacePathSeparator(string, '/', File.separatorChar);
            } else if (string.indexOf(92) != -1 && File.separatorChar != '\\') {
                string2 = this.replacePathSeparator(string, '\\', File.separatorChar);
            }
        }
        return string2;
    }

    protected String replacePathSeparator(String string, char c, char c2) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                cArray[n] = c2;
            }
            ++n;
        }
        return new String(cArray);
    }
}

