/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.JSRuntimeException;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.api.db.Workspaces;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspacesImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class WorkspaceManager {
    public static final String ACTIVE_WORKSPACE = "active.workspace";
    public static final String DATASOURCE = "datasource.";
    public static final String URL_FILE = "file://";
    public static final String URL_JDBC = "jdbc://";
    public static final String URL_JNDI = "jndi://";
    public static final String DB_SYSTABLES = "systables";
    public static final String DB_PROFILING = "profiling";
    private static WorkspaceManager QOIV = null;
    private String add;
    private HashMap append = null;
    private HashMap appendChild = null;
    private HashSet buildFrom = null;
    private HashSet close = null;
    private WorkspacesImpl contains = new WorkspacesImpl();

    public static WorkspaceManager getInstance() {
        return QOIV;
    }

    public static WorkspaceManager createInstance(Properties properties) throws Throwable {
        if (QOIV == null) {
            QOIV = new WorkspaceManager(properties);
        }
        return QOIV;
    }

    private WorkspaceManager(Properties properties) throws Throwable {
        String string;
        String string2;
        Object object;
        this.append = new HashMap();
        this.appendChild = new HashMap();
        this.buildFrom = new HashSet();
        this.close = new HashSet();
        this.add = properties.getProperty(ACTIVE_WORKSPACE);
        if (this.add == null) {
            throw new IllegalArgumentException("The active.workspace can not be null");
        }
        this.append(new WorkspaceImpl(this.add));
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).startsWith(DATASOURCE)) continue;
            string2 = ((String)object).substring(DATASOURCE.length());
            this.close.add(string2);
            string = properties.getProperty((String)object);
            if (string.startsWith(URL_FILE)) {
                this.appendChild.put(string2, string);
                continue;
            }
            this.append.put(string2, string);
        }
        iterator = this.appendChild.values().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this.buildFrom.contains(object)) continue;
            this.buildFrom.add(object);
            this.QOIV((String)object);
        }
        object = (WorkspaceImpl)this.getActiveWorkspace();
        iterator = this.append.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = (String)this.append.get(string2);
            DatabaseImpl databaseImpl = new DatabaseImpl((Workspace)object, string2);
            databaseImpl.setProperty("datasource", string);
            ((WorkspaceImpl)object).append(databaseImpl);
        }
        this.saveConfig();
    }

    public synchronized Workspace getActiveWorkspace() {
        return (Workspace)this.contains.get(this.add);
    }

    public synchronized void saveConfig() {
        Object object;
        Iterator iterator = this.workspaces().iterator();
        while (iterator.hasNext()) {
            object = (Workspace)iterator.next();
            Iterator iterator2 = object.databases().iterator();
            while (iterator2.hasNext()) {
                Database database = (Database)iterator2.next();
                String string = database.getProperty("configFile");
                if (string != null) continue;
                string = (String)this.appendChild.get(database.getName());
                database.setProperty("configFile", string);
            }
        }
        iterator = this.buildFrom.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.writeConfig((String)object, this.contains);
        }
    }

    public synchronized Workspaces workspaces() {
        return this.contains;
    }

    public synchronized Workspace workspaces(int n) {
        return (Workspace)this.contains.get(n);
    }

    public synchronized Workspace workspaces(String string) {
        return (Workspace)this.contains.get(string);
    }

    public synchronized boolean isDefault(Workspace workspace) {
        return workspace.getName().equals(this.add);
    }

    public synchronized void append(Workspace workspace) {
        this.contains.append(workspace);
    }

    public synchronized void remove(Workspace workspace) {
        Database[] databaseArray = workspace.databases().toArray();
        if (databaseArray != null && databaseArray.length > 0) {
            int n = 0;
            while (n < databaseArray.length) {
                DatabaseImpl databaseImpl = (DatabaseImpl)databaseArray[n];
                databaseImpl.close();
                ((WorkspaceImpl)workspace).remove(databaseImpl);
                ++n;
            }
        }
        this.contains.remove(workspace.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void QOIV(String string) {
        Object object3222;
        Document document;
        block25: {
            DocumentBuilder documentBuilder;
            Object object2;
            File file = null;
            try {
                object2 = new URL(string);
                file = new File(((URL)object2).getFile());
            }
            catch (MalformedURLException malformedURLException) {
                ServiceLogger.logError(malformedURLException, 2);
                return;
            }
            object2 = null;
            try {
                object2 = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException, 2);
                return;
            }
            document = null;
            document = documentBuilder.parse((InputStream)object2);
            Object var10_10 = null;
            try {
                ((BufferedInputStream)object2).close();
            }
            catch (IOException object3222) {
                ServiceLogger.logError((Throwable)object3222, 3);
            }
            break block25;
            {
                catch (SAXException sAXException) {
                    ServiceLogger.logError(sAXException, 2);
                    Object var10_11 = null;
                    try {
                        ((BufferedInputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException, 3);
                    }
                    return;
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 2);
                    Object var10_12 = null;
                    try {
                        ((BufferedInputStream)object2).close();
                    }
                    catch (IOException iOException2) {
                        ServiceLogger.logError(iOException2, 3);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    ((BufferedInputStream)object2).close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 3);
                }
                throw throwable;
            }
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("workspace");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object3222 = nodeList.item(n2);
            switch (object3222.getNodeType()) {
                case 1: {
                    WorkspaceImpl workspaceImpl = new WorkspaceImpl();
                    workspaceImpl.buildFrom((Element)object3222);
                    WorkspaceImpl workspaceImpl2 = null;
                    if (!this.contains.contains(workspaceImpl.getName())) {
                        workspaceImpl2 = new WorkspaceImpl(workspaceImpl.getName());
                        this.contains.append(workspaceImpl2);
                    } else {
                        workspaceImpl2 = (WorkspaceImpl)this.contains.get(workspaceImpl.getName());
                    }
                    Iterator iterator = this.close.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Database database = workspaceImpl.databases(string2);
                        if (database == null) continue;
                        ((DatabaseImpl)database).setWorkspace(workspaceImpl2);
                        database.setProperty("configFile", string);
                        workspaceImpl2.append(database);
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    protected synchronized void writeConfig(String string, WorkspacesImpl workspacesImpl) {
        Object object;
        Object object2;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JSRuntimeException(parserConfigurationException.getMessage());
        }
        document = documentBuilder.newDocument();
        Element element = document.createElement("dbconfig");
        document.appendChild(element);
        int n = workspacesImpl.size();
        int n2 = 0;
        while (n2 < n) {
            object2 = (WorkspaceImpl)workspacesImpl.get(n2);
            if (!((WorkspaceImpl)object2).databases().isEmpty()) {
                object = document.createElement("workspace");
                object.setAttribute("name", ((AbstractDBObject)object2).getName());
                element.appendChild((Node)object);
                int n3 = ((WorkspaceImpl)object2).databases().size();
                int n4 = 0;
                while (n4 < n3) {
                    Database database = ((WorkspaceImpl)object2).databases(n4);
                    if (string.equals(database.getProperty("configFile"))) {
                        String string2;
                        Object object3;
                        Element element2 = document.createElement("database");
                        element2.setAttribute("name", database.getName());
                        object.appendChild(element2);
                        Properties properties = database.getProperties();
                        String string3 = properties.getProperty("user");
                        if (string3 != null) {
                            object3 = "user=" + properties.getProperty("user") + "\r\n" + "password=" + properties.getProperty("password", "");
                            string2 = ServerUtil.encode((String)object3);
                            properties.setProperty("encrypt-sign", string2);
                        }
                        object3 = properties.keys();
                        while (object3.hasMoreElements()) {
                            String string4;
                            string2 = (String)object3.nextElement();
                            String string5 = properties.getProperty(string2);
                            if ("classpath".equalsIgnoreCase(string2) || string5.startsWith(URL_FILE) || "user".equals(string2) || "password".equals(string2)) continue;
                            Element element3 = document.createElement(string2);
                            element3.appendChild(document.createTextNode(string5));
                            element2.appendChild(element3);
                            if (!"driver".equalsIgnoreCase(string2) || "org.apache.derby.jdbc.EmbeddedDriver".equals(string5) || (string4 = properties.getProperty("classpath")) == null || string4.trim().length() <= 0) continue;
                            element3.setAttribute("classpath", string4);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        try {
            object2 = new URL(string);
            object = ((URL)object2).getFile();
            File file = new File((String)object);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            XMLWriter.write(document, (String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void destroy() {
        QOIV = null;
    }
}

