/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.resource;

import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.resource.NodeRecord;
import jet.server.db.resource.NodeTable;
import jet.server.log.ServiceLogger;

public class NodeTableImpl
extends TableImpl
implements Table,
NodeTable {
    protected static final String tableName = "NODES_3";
    protected static final String[] colNames = new String[]{"id", "name", "creatorName", "createTime", "parentID", "nodeType", "aclID", "description", "enablelinkedcat", "linkedcat", "useinherited"};

    public static NodeTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        return new NodeTableImpl(database, updateDetailsTable);
    }

    private NodeTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, tableName);
        super.append(new FieldImpl(this.getName(), colNames[0], JDBCType.INTEGER, 0, 3, 0));
        super.append(new FieldImpl(this.getName(), colNames[1], JDBCType.VARCHAR, 64, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[2], JDBCType.VARCHAR, 32, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[3], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[4], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[5], JDBCType.TINYINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[6], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[7], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[8], JDBCType.BIT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[9], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[10], JDBCType.BIT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "NODES_1";
        this.BIGINT(database, updateDetailsTable, string);
        string = "NODES_2";
        this.BIGINT(database, updateDetailsTable, string);
        int n = super.queryMaxValue("id", null, false).intValue();
        if (n == Integer.MIN_VALUE) {
            n = -1;
        }
        this.adapter.setID(this, this.fields("id"), n++);
    }

    private void BIGINT(Database database, UpdateDetailsTable updateDetailsTable, String string) throws SQLException {
        boolean bl = updateDetailsTable.isUpdating(string);
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!bl) {
                this.BIT(table);
                table.delete("");
                updateDetailsTable.setUpdateDetails(string, true);
            }
            ((DatabaseImpl)database).remove(table);
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
        }
    }

    protected synchronized int nextRecordID() throws SQLException {
        return this.adapter.getID(this, this.fields(colNames[0]));
    }

    public synchronized boolean deleteRecord(int n) {
        try {
            super.delete("WHERE " + super.fields(0).getName() + "=" + n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean deleteRecordByParent(int n) {
        try {
            super.delete("WHERE " + super.fields(4).getName() + "=" + n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean deleteAll() {
        try {
            int n = super.delete("");
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean addRecord(String string, String string2, Date date, int n, byte by, int n2, String string3, boolean bl, String string4, boolean bl2) {
        FieldValue[] fieldValueArray = super.fields().values();
        try {
            fieldValueArray[0].setValue(new Integer(this.nextRecordID()));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(string2);
        fieldValueArray[3].setValue(new Long(date.getTime()));
        fieldValueArray[4].setValue(new Integer(n));
        fieldValueArray[5].setValue(new Byte(by));
        fieldValueArray[6].setValue(new Integer(n2));
        fieldValueArray[7].setValue(string3);
        fieldValueArray[8].setValue(new Boolean(bl));
        fieldValueArray[9].setValue(string4);
        fieldValueArray[10].setValue(new Boolean(bl2));
        try {
            super.insert(fieldValueArray);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean updateName(int n, String string) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(1).createFieldValue()};
        fieldValueArray[0].setValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=").append(n);
        try {
            super.update(fieldValueArray, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean updateAcl(int n, int n2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(6).createFieldValue()};
        fieldValueArray[0].setValue(new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=").append(n);
        try {
            super.update(fieldValueArray, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean addRecord(NodeRecord nodeRecord) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(new Integer(nodeRecord.getID()));
        fieldValueArray[1].setValue(nodeRecord.getName());
        fieldValueArray[2].setValue(nodeRecord.getCreatorName());
        fieldValueArray[3].setValue(new Long(nodeRecord.getCreateTime().getTime()));
        fieldValueArray[4].setValue(new Integer(nodeRecord.getParentID()));
        fieldValueArray[5].setValue(new Byte(nodeRecord.getNodeType()));
        fieldValueArray[6].setValue(new Integer(nodeRecord.getAclID()));
        fieldValueArray[7].setValue(nodeRecord.getDescription());
        fieldValueArray[8].setValue(new Boolean(nodeRecord.isEnableLinkedCatalog));
        fieldValueArray[9].setValue(nodeRecord.getLinkedCatalog());
        fieldValueArray[10].setValue(new Boolean(nodeRecord.isUseInherited()));
        try {
            super.insert(fieldValueArray);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean updateDescription(int n, String string) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(7).createFieldValue()};
        fieldValueArray[0].setValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=").append(n);
        try {
            super.update(fieldValueArray, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean updateForReplace(int n, String string, String string2, Date date, int n2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(1).createFieldValue(), super.fields(2).createFieldValue(), super.fields(3).createFieldValue(), super.fields(6).createFieldValue()};
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(string2);
        fieldValueArray[2].setValue(new Long(date.getTime()));
        fieldValueArray[3].setValue(new Integer(n2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=").append(n);
        try {
            super.update(fieldValueArray, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean updateNameAndDesc(int n, String string, String string2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(1).createFieldValue(), super.fields(7).createFieldValue()};
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=").append(n);
        try {
            super.update(fieldValueArray, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    public synchronized boolean updateLinkedCatalogProps(int n, boolean bl, String string, boolean bl2) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(8).createFieldValue(), super.fields(9).createFieldValue(), super.fields(10).createFieldValue()};
        fieldValueArray[0].setValue(new Boolean(bl));
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(new Boolean(bl2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=").append(n);
        try {
            super.update(fieldValueArray, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Hashtable getAllNodeIDWithAclID() {
        Hashtable<Integer, Integer> hashtable;
        block12: {
            Field[] fieldArray = new Field[]{this.fields(colNames[6]), this.fields(colNames[0])};
            Recordset recordset = null;
            hashtable = new Hashtable<Integer, Integer>();
            recordset = super.query(fieldArray, "", true);
            while (recordset.next()) {
                int n = recordset.getInt(colNames[6]);
                int n2 = recordset.getInt(colNames[0]);
                if (n == -1) continue;
                hashtable.put(new Integer(n), new Integer(n2));
            }
            Object var7_7 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    hashtable = null;
                    ServiceLogger.logError(sQLException);
                    Object var7_8 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void BIT(Table table) throws SQLException {
        block12: {
            Recordset recordset = null;
            recordset = table.query(table.fields().toArray(), null, false);
            while (recordset.next()) {
                super.insert(recordset.fields());
            }
            Object var5_3 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var5_4 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        recordset = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector getAllNodeIDsByLinkCatalog(String string) throws SQLException {
        Vector<Integer> vector;
        block12: {
            vector = new Vector<Integer>();
            Field[] fieldArray = new Field[]{this.fields(colNames[0])};
            Recordset recordset = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(super.fields(8).getName()).append("=").append(this.adapter.formatValue(true)).append(" AND ").append(super.fields(9).getName()).append("=").append(this.adapter.formatValue(string)).append(" AND ").append(super.fields(10).getName()).append("=").append(this.adapter.formatValue(false));
            recordset = super.query(fieldArray, stringBuffer.toString(), true);
            while (recordset.next()) {
                int n = recordset.getInt(colNames[0]);
                vector.add(new Integer(n));
            }
            Object var8_8 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    vector = null;
                    ServiceLogger.logError(sQLException);
                    Object var8_9 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }
}

