/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.db.ColumnDescImpl;
import jet.server.db.DBToolkit;
import jet.server.db.DataTable;
import jet.server.db.security.RoleRecord;
import jet.server.db.security.RoleTable;
import jet.server.log.ServiceLogger;

public class RoleTableImpl
implements RoleTable {
    public static final int version = 1;
    private final String QOIV = "ROLES_1";
    private DataTable add = null;
    private static ColumnDescImpl[] addRecord = null;

    public static RoleTableImpl newInstance(DataTable dataTable) {
        try {
            return new RoleTableImpl(dataTable);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 1);
            return null;
        }
    }

    private RoleTableImpl(DataTable dataTable) throws SQLException {
        this.add = dataTable;
        this.QOIV();
        if (!dataTable.hasTable("ROLES_1") && !dataTable.createTable("ROLES_1", addRecord)) {
            ServiceLogger.logError(1640001, "ROLES_1", 1);
        }
    }

    private void QOIV() {
        addRecord = new ColumnDescImpl[4];
        RoleTableImpl.addRecord[0] = new ColumnDescImpl("name", 12, 32, false, true, false, true);
        RoleTableImpl.addRecord[1] = new ColumnDescImpl("parentRole", 12, 32, false, false, false, false);
        RoleTableImpl.addRecord[2] = new ColumnDescImpl("builtin", -7, 0, false, false, false, true);
        RoleTableImpl.addRecord[3] = new ColumnDescImpl("description", 12, 128, true, false, false, false);
    }

    public synchronized RoleRecord addRecord(String string, String string2, boolean bl, String string3) {
        RoleRecord roleRecord = new RoleRecord(string, string2, bl, string3);
        String[] stringArray = new String[4];
        String[] stringArray2 = new String[4];
        stringArray[0] = addRecord[0].getColName();
        stringArray[1] = addRecord[1].getColName();
        stringArray[2] = addRecord[2].getColName();
        stringArray[3] = addRecord[3].getColName();
        stringArray2[0] = DBToolkit.encStringForSQL(string);
        stringArray2[1] = string2 == null ? null : DBToolkit.encStringForSQL(string2);
        stringArray2[2] = String.valueOf(bl);
        stringArray2[3] = DBToolkit.encStringForSQL(string3);
        if (this.add.addRecord("ROLES_1", stringArray, stringArray2, true)) {
            return roleRecord;
        }
        return null;
    }

    public synchronized boolean deleteRole(String string) {
        return this.add.delRecord("ROLES_1", "WHERE " + addRecord[0].getColName() + "=" + DBToolkit.encStringForSQL(string), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized RoleRecord getParentRole(String string) throws NoSuchRoleException {
        RoleRecord roleRecord;
        block17: {
            String string2 = "*";
            String string3 = "WHERE " + addRecord[0].getColName() + " = " + DBToolkit.encStringForSQL(string);
            ResultSet resultSet = this.add.getResultSet("ROLES_1", string2, string3, true);
            roleRecord = new RoleRecord();
            try {
                while (resultSet.next()) {
                    roleRecord = this.add(resultSet);
                }
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return null;
            }
            if (roleRecord == null) {
                throw new NoSuchRoleException(630005, (Object[])new String[]{string}, null);
            }
            String string4 = roleRecord.getParentRole();
            if (string4.equalsIgnoreCase("RoleRoot")) {
                return null;
            }
            string3 = "WHERE " + addRecord[0].getColName() + " = " + DBToolkit.encStringForSQL(string4);
            resultSet = this.add.getResultSet("ROLES_1", string2, string3, true);
            roleRecord = null;
            while (resultSet.next()) {
                roleRecord = this.add(resultSet);
            }
            Object var9_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block17;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block17;
            {
                catch (SQLException sQLException) {
                    roleRecord = null;
                    ServiceLogger.logError(sQLException);
                    Object var9_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block17;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return roleRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getSubRoles(String string) {
        Vector<RoleRecord> vector;
        block13: {
            String string2 = "*";
            String string3 = "WHERE " + addRecord[1].getColName() + " = " + DBToolkit.encStringForSQL(string);
            ResultSet resultSet = this.add.getResultSet("ROLES_1", string2, string3, false);
            vector = new Vector<RoleRecord>();
            while (resultSet.next()) {
                RoleRecord roleRecord = this.add(resultSet);
                if (roleRecord != null) {
                    vector.add(roleRecord);
                    continue;
                }
                System.out.println("Null role record!");
            }
            Object var8_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block13;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block13;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var8_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized int getRoleCount() {
        int n;
        block12: {
            ResultSet resultSet;
            block11: {
                String string = "COUNT(*)";
                String string2 = "";
                resultSet = this.add.getResultSet("ROLES_1", string, string2, false);
                n = 0;
                if (!resultSet.next()) break block11;
                n = resultSet.getInt(1);
            }
            Object var7_5 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var7_6 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized RoleRecord getRole(String string) {
        RoleRecord roleRecord;
        block12: {
            String string2 = "*";
            String string3 = "WHERE " + addRecord[0].getColName() + " = " + DBToolkit.encStringForSQL(string);
            ResultSet resultSet = this.add.getResultSet("ROLES_1", string2, string3, true);
            roleRecord = null;
            while (resultSet.next()) {
                roleRecord = this.add(resultSet);
            }
            Object var8_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    roleRecord = null;
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return roleRecord;
    }

    private synchronized RoleRecord add(ResultSet resultSet) {
        RoleRecord roleRecord = new RoleRecord();
        ColumnDescImpl[] columnDescImplArray = addRecord;
        try {
            roleRecord.setName(resultSet.getString(columnDescImplArray[0].getColName()));
            roleRecord.setParentRole(resultSet.getString(columnDescImplArray[1].getColName()));
            roleRecord.setBuiltin(resultSet.getBoolean(columnDescImplArray[2].getColName()));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
        return roleRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllRoles() {
        Vector<RoleRecord> vector;
        block12: {
            String string = "*";
            ResultSet resultSet = this.add.getResultSet("ROLES_1", string, "", false);
            vector = new Vector<RoleRecord>();
            while (resultSet.next()) {
                RoleRecord roleRecord = this.add(resultSet);
                if (roleRecord == null) continue;
                vector.add(roleRecord);
            }
            Object var6_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    vector = null;
                    ServiceLogger.logError(sQLException);
                    Object var6_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    public synchronized void close() {
        this.add.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized int getSubRoleCount(String string) {
        int n;
        block12: {
            ResultSet resultSet;
            block11: {
                String string2 = "COUNT(*)";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("WHERE ");
                stringBuffer.append(addRecord[1].getColName());
                stringBuffer.append(" = ");
                stringBuffer.append(DBToolkit.encStringForSQL(string));
                resultSet = this.add.getResultSet("ROLES_1", string2, stringBuffer.toString(), false);
                n = 0;
                if (!resultSet.next()) break block11;
                n = resultSet.getInt(1);
            }
            Object var8_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return n;
    }

    public synchronized boolean upDataParentRole(String string, String string2) {
        if (string.equals(string2)) {
            return false;
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        stringArray[0] = addRecord[1].getColName();
        stringArray2[0] = DBToolkit.encStringForSQL(string2);
        return this.add.updRecord("ROLES_1", stringArray, stringArray2, "WHERE " + addRecord[0].getColName() + "=" + DBToolkit.encStringForSQL(string), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllRolesName() {
        Vector<String> vector;
        block12: {
            String string = addRecord[0].getColName();
            ResultSet resultSet = this.add.getResultSet("ROLES_1", string, "", false);
            vector = new Vector<String>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (string2 == null) continue;
                vector.add(string2);
            }
            Object var6_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    vector = null;
                    ServiceLogger.logError(sQLException);
                    Object var6_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }
}

