/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.AclRecord;
import jet.server.db.security2.AclTable;
import jet.server.log.ServiceLogger;

public class AclTableImpl
extends TableImpl
implements Table,
AclTable {
    public static final int OLDVERSION = 1;
    public static final int VERSION = 2;
    static final String[] BIGINT = new String[4];

    public static AclTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        AclTableImpl aclTableImpl = null;
        try {
            aclTableImpl = new AclTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, "ACLS_2", 1);
            ServiceLogger.logError(exception, 1);
        }
        return aclTableImpl;
    }

    private AclTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws SQLException, InstantiationException {
        super(database, "ACLS_2");
        int n;
        super.append(new FieldImpl(this.getName(), BIGINT[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[1], JDBCType.VARCHAR, 64, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[2], JDBCType.VARCHAR, 32, 1, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[3], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "ACLS_1";
        boolean bl = updateDetailsTable.isUpdating(string);
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!bl) {
                this.INTEGER(table);
                table.delete("");
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
        if ((n = super.queryMaxValue("id", null, false).intValue()) == Integer.MIN_VALUE) {
            n = -1;
        }
        this.adapter.setID(this, this.fields("id"), n++);
    }

    public synchronized AclRecord addRecord(String string, String string2, Date date, boolean bl) {
        try {
            int n = this.adapter.getID(this, this.fields(BIGINT[0]));
            AclRecord aclRecord = bl ? new AclRecord(n, string + "_" + n, string2, date) : new AclRecord(n, string, string2, date);
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(n));
            fieldValueArray[1].setValue(aclRecord.getName());
            fieldValueArray[2].setValue(string2);
            fieldValueArray[3].setValue(new Long(date.getTime()));
            super.insert(fieldValueArray);
            return aclRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized boolean deleteRecord(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(BIGINT[0]).getName()).append("=").append(n);
        try {
            int n2 = super.delete(stringBuffer.toString());
            return n2 >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized AclRecord getRecordByID(int n) {
        AclRecord aclRecord;
        block12: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(super.fields(BIGINT[0]).getName()).append("=").append(n);
            aclRecord = null;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), true);
            while (recordset.next()) {
                aclRecord = this.BIGINT(recordset);
            }
            Object var7_5 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    aclRecord = null;
                    ServiceLogger.logError(sQLException);
                    Object var7_6 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return aclRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized AclRecord getRecordByName(String string) {
        AclRecord aclRecord;
        block12: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(super.fields(BIGINT[1]).getName()).append("=").append(this.adapter.formatValue(string));
            aclRecord = null;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), true);
            while (recordset.next()) {
                aclRecord = this.BIGINT(recordset);
            }
            Object var7_5 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var7_6 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return aclRecord;
    }

    private synchronized AclRecord BIGINT(Recordset recordset) throws SQLException {
        AclRecord aclRecord = new AclRecord();
        aclRecord.setRecordID(recordset.getInt(BIGINT[0]));
        aclRecord.setName(recordset.getString(BIGINT[1]));
        aclRecord.setCreatorName(recordset.getString(BIGINT[2]));
        aclRecord.setCreateTime(recordset.getInt(BIGINT[0]));
        return aclRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllAclID() {
        Vector<String> vector;
        block12: {
            Field[] fieldArray = new Field[]{this.fields(BIGINT[0])};
            Recordset recordset = null;
            vector = new Vector<String>();
            recordset = super.query(fieldArray, "", true);
            while (recordset.next()) {
                int n = recordset.getInt(BIGINT[0]);
                String string = String.valueOf(n);
                vector.add(string);
            }
            Object var7_7 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    vector = null;
                    ServiceLogger.logError(sQLException);
                    Object var7_8 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void INTEGER(Table table) throws SQLException {
        block9: {
            Recordset recordset = null;
            recordset = table.query(table.fields().toArray(), null, false);
            while (recordset.next()) {
                FieldValue[] fieldValueArray = super.fields().values();
                fieldValueArray[0].setValue(recordset.fields("id").getValue());
                fieldValueArray[1].setValue(recordset.fields("name").getValue());
                fieldValueArray[2].setValue(recordset.fields("creatorName").getValue());
                fieldValueArray[3].setValue(recordset.fields("createTime").getValue());
                super.insert(fieldValueArray);
            }
            Object var5_5 = null;
            try {
                recordset.close();
            }
            catch (Exception exception) {}
            break block9;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var5_6 = null;
                    try {
                        recordset.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    recordset.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static {
        AclTableImpl.BIGINT[0] = "id";
        AclTableImpl.BIGINT[1] = "name";
        AclTableImpl.BIGINT[2] = "create_name";
        AclTableImpl.BIGINT[3] = "create_time";
    }
}

