/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.GUProfileRecord;
import jet.server.db.security2.GUProfileTable;
import jet.server.log.ServiceLogger;

public class GUProfileTableImpl
extends TableImpl
implements Table,
GUProfileTable {
    public static final int OLDVERSION = 1;
    public static final int VERSION = 2;
    public static final String TABLENAME = "GUPROFILES_2";
    static final String[] QOIV = new String[2];

    public static GUProfileTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new GUProfileTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private GUProfileTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), QOIV[0], JDBCType.VARCHAR, 32, 0, 0));
        super.append(new FieldImpl(this.getName(), QOIV[1], JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "GUPROFILES_1";
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!updateDetailsTable.isUpdating(string)) {
                this.VARCHAR(table);
                table.delete("");
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
    }

    public synchronized GUProfileRecord addRecord(String string, String string2) {
        GUProfileRecord gUProfileRecord = new GUProfileRecord(string, string2);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(gUProfileRecord.getGroupName());
        fieldValueArray[1].setValue(gUProfileRecord.getUserName());
        try {
            super.insert(fieldValueArray);
            return gUProfileRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized boolean deleteRecordByUserName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string));
        try {
            int n = super.delete(stringBuffer.toString());
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean deleteRecordByGroupName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string));
        try {
            int n = super.delete(stringBuffer.toString());
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean deleteRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string)).append(" AND ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string2));
        try {
            int n = super.delete(stringBuffer.toString());
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getGroupNamesByUser(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string));
        Field[] fieldArray = new Field[]{this.fields(QOIV[0])};
        Vector<String> vector = null;
        Recordset recordset = null;
        recordset = super.query(fieldArray, stringBuffer.toString(), false);
        vector = new Vector<String>();
        while (recordset.next()) {
            vector.add(recordset.getString(QOIV[0]));
        }
        Vector<String> vector2 = vector;
        Object var8_8 = null;
        try {
            if (recordset != null) {
                recordset.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vector2;
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Object var8_9 = null;
            {
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getUserNamesByGroup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string));
        Field[] fieldArray = new Field[]{this.fields(QOIV[1])};
        Vector<String> vector = null;
        Recordset recordset = null;
        recordset = super.query(fieldArray, stringBuffer.toString(), false);
        vector = new Vector<String>();
        while (recordset.next()) {
            vector.add(recordset.getString(QOIV[1]));
        }
        Vector<String> vector2 = vector;
        Object var8_8 = null;
        try {
            if (recordset != null) {
                recordset.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vector2;
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Object var8_9 = null;
            {
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    public synchronized int getGroupsCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string));
        int n = 0;
        try {
            n = super.queryCountValue(QOIV[0], stringBuffer.toString(), false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    public synchronized int getUsersCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string));
        int n = 0;
        try {
            n = super.queryCountValue(QOIV[1], stringBuffer.toString(), false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized GUProfileRecord getRecord(String string, String string2) {
        GUProfileRecord gUProfileRecord;
        block12: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("where ").append(super.fields(QOIV[0]).getName()).append(" = ").append(this.adapter.formatValue(string)).append(" AND ").append(super.fields(QOIV[1]).getName()).append(" = ").append(this.adapter.formatValue(string2));
            gUProfileRecord = null;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), true);
            while (recordset.next()) {
                gUProfileRecord = this.QOIV(recordset);
            }
            Object var8_6 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    gUProfileRecord = null;
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return gUProfileRecord;
    }

    private synchronized GUProfileRecord QOIV(Recordset recordset) throws SQLException {
        GUProfileRecord gUProfileRecord = new GUProfileRecord();
        gUProfileRecord.setGroupName(recordset.getString(QOIV[0]));
        gUProfileRecord.setUserName(recordset.getString(QOIV[1]));
        return gUProfileRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Hashtable[] getAllRecords() {
        Hashtable[] hashtableArray;
        block15: {
            hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable()};
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), null, false);
            while (recordset.next()) {
                Vector<String> vector;
                String string = recordset.getString(QOIV[0]);
                String string2 = recordset.getString(QOIV[1]);
                Vector vector2 = (Vector)hashtableArray[0].get(string);
                Vector vector3 = (Vector)hashtableArray[1].get(string2);
                if (vector2 != null) {
                    vector2.add(string2);
                } else {
                    vector = new Vector<String>();
                    vector.add(string2);
                    hashtableArray[0].put(string, vector);
                }
                if (vector3 != null) {
                    vector3.add(string);
                    continue;
                }
                vector = new Vector();
                vector.add(string);
                hashtableArray[1].put(string2, vector);
            }
            Object var9_9 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block15;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block15;
            {
                catch (SQLException sQLException) {
                    hashtableArray = null;
                    ServiceLogger.logError(sQLException);
                    Object var9_10 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return hashtableArray;
    }

    private void VARCHAR(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("group_name").getValue());
            fieldValueArray[1].setValue(recordset.fields("user_name").getValue());
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    static {
        GUProfileTableImpl.QOIV[0] = "group_name";
        GUProfileTableImpl.QOIV[1] = "user_name";
    }
}

