/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.log.ServiceLogger;

public class RoleTableImpl
extends TableImpl
implements Table,
RoleTable {
    public static final int VERSION = 2;
    public static final int OLDVERSION = 1;
    static final String[] BIT = new String[4];

    public static RoleTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new RoleTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, "ROLES_2", 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private RoleTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, "ROLES_2");
        super.append(new FieldImpl(this.getName(), BIT[0], JDBCType.VARCHAR, 32, 9, 0));
        super.append(new FieldImpl(this.getName(), BIT[1], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIT[2], JDBCType.VARCHAR, 32, 0, 0));
        super.append(new FieldImpl(this.getName(), BIT[3], JDBCType.INTEGER, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "ROLES_1";
        boolean bl = updateDetailsTable.isUpdating(string);
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!bl) {
                this.INTEGER(table);
                updateDetailsTable.setUpdateDetails(string, true);
            }
        }
    }

    public synchronized RoleRecord addRecord(String string, boolean bl, String string2, int n) {
        RoleRecord roleRecord = new RoleRecord(string, bl, string2, n);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(roleRecord.getName());
        fieldValueArray[1].setValue(new Boolean(roleRecord.isBuiltin()));
        fieldValueArray[2].setValue(roleRecord.getDescription());
        fieldValueArray[3].setValue(new Integer(n));
        try {
            super.insert(fieldValueArray);
            return roleRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized boolean deleteRole(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(BIT[0]).getName()).append("=").append(this.adapter.formatValue(string));
        try {
            int n = super.delete(stringBuffer.substring(0));
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized RoleRecord getRole(String string) {
        RoleRecord roleRecord;
        block12: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(super.fields(BIT[0]).getName()).append("=").append(this.adapter.formatValue(string));
            roleRecord = null;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), stringBuffer.substring(0), true);
            while (recordset.next()) {
                roleRecord = this.BIT(recordset);
            }
            Object var7_5 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var7_6 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return roleRecord;
    }

    private synchronized RoleRecord BIT(Recordset recordset) throws SQLException {
        RoleRecord roleRecord = new RoleRecord();
        roleRecord.setName(recordset.getString(BIT[0]));
        roleRecord.setBuiltin(recordset.getBoolean(BIT[1]));
        roleRecord.setDescription(recordset.getString(BIT[2]));
        roleRecord.setType(recordset.getInt(BIT[3]));
        return roleRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllRoles() {
        Vector<RoleRecord> vector;
        block12: {
            vector = new Vector<RoleRecord>();
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), "", true);
            while (recordset.next()) {
                RoleRecord roleRecord = this.BIT(recordset);
                if (roleRecord == null) continue;
                vector.add(roleRecord);
            }
            Object var5_5 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var5_6 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllRolesName() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        FieldValue[] fieldValueArray = new FieldValue[]{this.fields(BIT[0]).createFieldValue()};
        Recordset recordset = null;
        recordset = super.query(this.fields().toArray(), "", true);
        if (recordset.next() && (object = recordset.getString(BIT[0])) != null) {
            vector.add(object);
        }
        object = vector;
        Object var6_6 = null;
        try {
            if (recordset != null) {
                recordset.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return object;
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
            Object var6_7 = null;
            {
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private void INTEGER(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("name").getValue());
            fieldValueArray[1].setValue(recordset.fields("builtin").getValue());
            fieldValueArray[2].setValue(recordset.fields("description").getValue());
            fieldValueArray[3].setValue(new Integer(0));
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    static {
        RoleTableImpl.BIT[0] = "name";
        RoleTableImpl.BIT[1] = "buildin";
        RoleTableImpl.BIT[2] = "description";
        RoleTableImpl.BIT[3] = "role_type";
    }
}

