/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.TransferHelp;

public abstract class AbstractTransferHelp
implements TransferHelp {
    public static final String MANIFEST = "MANIFEST";
    public static final String SPCHAR = ";";
    protected static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static final ZipOutputStream createBackupVolume(String string, String string2) throws IOException {
        Object object;
        File file = new File(string);
        if (!file.exists() && (object = file.getParentFile()) != null) {
            ((File)object).mkdirs();
        }
        object = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        ((ZipOutputStream)object).putNextEntry(new ZipEntry(string2));
        return object;
    }

    public static final List getRestoreList(Properties properties) {
        Object var1_1 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("tableset"), SPCHAR);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static final boolean exportExternalData(ZipOutputStream zipOutputStream, String string, String string2, String string3) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (file.isDirectory()) {
            int n = string2.length();
            stringBuffer.append(string3).append(string.substring(n)).append("/");
            String string4 = AbstractTransferHelp.replacePathSeparator(stringBuffer.toString(), '\\', '/');
            zipOutputStream.putNextEntry(new ZipEntry(string4));
            zipOutputStream.closeEntry();
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(string).append(File.separator).append(stringArray[n2]);
                AbstractTransferHelp.exportExternalData(zipOutputStream, stringBuffer.toString(), string2, string3);
                ++n2;
            }
        } else {
            int n = string2.length();
            String string5 = AbstractTransferHelp.replacePathSeparator(string3 + string.substring(n), '\\', '/');
            zipOutputStream.putNextEntry(new ZipEntry(string5));
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray = new byte[2048];
            int n3 = -1;
            while ((n3 = randomAccessFile.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n3);
            }
            zipOutputStream.closeEntry();
            randomAccessFile.close();
        }
        return true;
    }

    public static final int exportTableData(ZipOutputStream zipOutputStream, ZipEntry zipEntry, Recordset recordset) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        zipOutputStream.putNextEntry(zipEntry);
        recordset.first();
        int n = 0;
        while (recordset.next()) {
            stringBuffer.delete(0, stringBuffer.length());
            zipOutputStream.write(AbstractTransferHelp.formatExport(stringBuffer, recordset.fields()).getBytes());
            ++n;
        }
        zipOutputStream.closeEntry();
        return n;
    }

    public static final int exportTableData(ZipOutputStream zipOutputStream, ZipEntry zipEntry, List list) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        zipOutputStream.putNextEntry(zipEntry);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldValue[] fieldValueArray = (FieldValue[])iterator.next();
            stringBuffer.delete(0, stringBuffer.length());
            zipOutputStream.write(AbstractTransferHelp.formatExport(stringBuffer, fieldValueArray).getBytes());
        }
        zipOutputStream.closeEntry();
        return list.size();
    }

    public static final String formatExport(StringBuffer stringBuffer, FieldValue[] fieldValueArray) {
        int n = stringBuffer.length();
        int n2 = fieldValueArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FieldValue fieldValue = fieldValueArray[n3];
            switch (fieldValue.getJDBCType().dataType()) {
                case -1: 
                case 1: 
                case 12: {
                    stringBuffer.append("\"").append(fieldValue.getString()).append("\"");
                    break;
                }
                case -7: 
                case 16: {
                    boolean bl = fieldValue.getBoolean();
                    stringBuffer.append(bl ? "true" : "false");
                    break;
                }
                case -6: {
                    stringBuffer.append(fieldValue.getByte());
                    break;
                }
                case 5: {
                    stringBuffer.append(fieldValue.getShort());
                    break;
                }
                case 4: {
                    stringBuffer.append(fieldValue.getInt());
                    break;
                }
                case -5: {
                    stringBuffer.append(fieldValue.getLong());
                    break;
                }
                case 6: 
                case 7: {
                    stringBuffer.append(fieldValue.getFloat());
                    break;
                }
                case 8: {
                    stringBuffer.append(fieldValue.getDouble());
                    break;
                }
                case 2: 
                case 3: {
                    stringBuffer.append(fieldValue.getValue());
                    break;
                }
                case 91: {
                    stringBuffer.append(fieldValue.getDate());
                    break;
                }
                case 92: {
                    stringBuffer.append(fieldValue.getTime());
                    break;
                }
                case 93: {
                    stringBuffer.append(fieldValue.getTimestamp());
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    stringBuffer.append("\"");
                    byte[] byArray = fieldValue.getBytes();
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        stringBuffer.append(AbstractTransferHelp.byteToHexString(byArray[n4]));
                        ++n4;
                    }
                    stringBuffer.append("\"");
                    break;
                }
                default: {
                    stringBuffer.append("\"").append(fieldValue.getValue()).append("\"");
                }
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(",");
            } else {
                stringBuffer.append(";\r\n");
            }
            ++n3;
        }
        return stringBuffer.substring(n);
    }

    public static final String byteToHexString(byte by) {
        String string = Integer.toHexString(by & 0xFF).toUpperCase();
        if (string.length() < 2) {
            return "0" + string;
        }
        return string;
    }

    public static final void importsExternalData(String string, InputStream inputStream) throws IOException {
        String string2 = AbstractTransferHelp.replacePathSeparator(string, '/', File.separatorChar);
        File file = new File(string2);
        if (string2.endsWith(File.separator)) {
            file.mkdirs();
            return;
        }
        file.getParentFile().mkdirs();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        byte[] byArray = new byte[2048];
        int n = -1;
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            randomAccessFile.write(byArray, 0, n);
        }
        randomAccessFile.close();
        bufferedInputStream.close();
    }

    public static final int importsTableData(Table table, List list, InputStream inputStream) throws SQLException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string);
            list.add(AbstractTransferHelp.C(table, bufferedReader, stringBuffer, string));
            ++n;
        }
        return n;
    }

    private static FieldValue[] C(Table table, BufferedReader bufferedReader, StringBuffer stringBuffer, String string) throws SQLException, IOException {
        FieldValue[] fieldValueArray = table.fields().values();
        while (!string.endsWith(SPCHAR)) {
            string = bufferedReader.readLine();
            stringBuffer.append(string);
        }
        try {
            fieldValueArray = AbstractTransferHelp.formatImport(fieldValueArray, stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("] is crushed") > 0) {
                String string2 = bufferedReader.readLine();
                stringBuffer.append(string2);
                return AbstractTransferHelp.C(table, bufferedReader, stringBuffer, string2);
            }
            throw iOException;
        }
        return fieldValueArray;
    }

    public static final FieldValue[] formatImport(FieldValue[] fieldValueArray, String string) throws SQLException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>(fieldValueArray.length);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"", 0)) {
                bl = true;
                if (string2.endsWith("\"")) {
                    arrayList.add(string2.substring(1, string2.length() - 1));
                    bl = false;
                    if (stringBuffer.length() <= 0) continue;
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(string2.substring(1));
                continue;
            }
            if (bl) {
                stringBuffer.append(",");
                if (string2.endsWith("\"")) {
                    stringBuffer.append(string2.substring(0, string2.length() - 1));
                    arrayList.add(stringBuffer.toString());
                    bl = false;
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.size() != fieldValueArray.length) {
            throw new IOException("The [" + string + "] is crushed");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < fieldValueArray.length) {
            int n3 = fieldValueArray[n2].getJDBCType().dataType();
            switch (n3) {
                case -6: {
                    fieldValueArray[n2].setValue(Byte.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case 5: {
                    fieldValueArray[n2].setValue(Short.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case 4: {
                    fieldValueArray[n2].setValue(Integer.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case -5: {
                    fieldValueArray[n2].setValue(Long.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case 6: {
                    fieldValueArray[n2].setValue(Float.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    fieldValueArray[n2].setValue(Double.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case -7: 
                case 16: {
                    fieldValueArray[n2].setValue(Boolean.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (((String)arrayList.get(n2)).equalsIgnoreCase("null")) {
                        ++n;
                        fieldValueArray[n2] = null;
                        break;
                    }
                    fieldValueArray[n2].setValue(arrayList.get(n2));
                    break;
                }
                case 91: {
                    fieldValueArray[n2].setValue(Date.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case 92: {
                    fieldValueArray[n2].setValue(Time.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case 93: {
                    fieldValueArray[n2].setValue(Timestamp.valueOf((String)arrayList.get(n2)));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    String string3 = (String)arrayList.get(n2);
                    byte[] byArray = new byte[string3.length() / 2];
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        byArray[n4] = Byte.decode("0x" + string3.substring(n4, n4 + 1));
                        ++n4;
                    }
                    fieldValueArray[n2].setValue(byArray);
                    break;
                }
            }
            ++n2;
        }
        return fieldValueArray;
    }

    public static final String replacePathSeparator(String string, char c, char c2) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                cArray[n] = c2;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static final void deleteExternalData(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                AbstractTransferHelp.deleteExternalData(fileArray[n]);
                ++n;
            }
            file.delete();
        }
    }

    public static Properties getVolumeSummary(ZipFile zipFile) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipFile.getEntry(MANIFEST));
        }
        catch (Exception exception) {
            properties.setProperty("status", "-1");
            properties.put("exception", exception);
            return properties;
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            properties.setProperty("status", "-1");
            properties.put("exception", iOException);
            return properties;
        }
        properties.setProperty("status", "0");
        return properties;
    }

    protected final class PK {
        Table I;
        Recordset Z;
        private final AbstractTransferHelp this$0;

        PK(AbstractTransferHelp abstractTransferHelp, Table table, Recordset recordset) {
            this.this$0 = abstractTransferHelp;
            this.I = table;
            this.Z = recordset;
        }
    }
}

