/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.DBToolkit;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.transfer.AbstractTransferHelp;
import jet.server.log.ServiceLogger;

public final class SystablesTransferHelp
extends AbstractTransferHelp {
    String BIT = null;

    public SystablesTransferHelp() {
        String string = System.getProperty("history_dir");
        String string2 = string == null ? ServerEnv.homePath + "history" : string;
        String string3 = this.BIT = ServerEnv.isSharedHistDir() ? ServerEnv.getSharedHistDir() : string2;
        if (this.BIT.endsWith(File.separator)) {
            this.BIT = this.BIT.substring(0, this.BIT.length() - 1);
        }
    }

    public synchronized boolean backup(Database database, String string) throws SQLException, IOException {
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        String string2 = database.getProperty("backup-type");
        if (string2 != null && string2.equalsIgnoreCase("DB")) {
            bl = true;
        }
        System.err.println("Backup begin...");
        String string3 = database.getWorkspace().getName();
        String string4 = database.getName();
        String string5 = string3 + "/";
        ZipOutputStream zipOutputStream = AbstractTransferHelp.createBackupVolume(string, string5);
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        properties.setProperty("version", "1.0");
        if (bl) {
            properties.setProperty("type", "BAK_DB");
        } else {
            properties.setProperty("type", "BAK");
        }
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string3);
        properties.setProperty("database", string4);
        Iterator iterator = database.tables().iterator();
        while (iterator.hasNext()) {
            object2 = (Table)iterator.next();
            object = object2.query(object2.fields().toArray(), null, false, 2);
            System.err.print("Backup " + string4 + "." + object2.getName() + " ... ");
            n = AbstractTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string5 + object2.getName() + ".dat"), (Recordset)object);
            object.close();
            System.err.println(n + " OK");
            stringBuffer.append(object2.getName()).append(";");
        }
        zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
        properties.setProperty("tableset", stringBuffer.toString());
        object2 = new ByteArrayOutputStream();
        properties.store((OutputStream)object2, "JREntServer server data backup archive");
        zipOutputStream.write(((ByteArrayOutputStream)object2).toByteArray());
        zipOutputStream.closeEntry();
        if (!bl) {
            String string6;
            Object object3;
            Object object4;
            object = new HashSet();
            System.err.print("Backup external data ... ");
            iterator = database.tables().iterator();
            while (iterator.hasNext()) {
                object4 = (Table)iterator.next();
                if (!object4.hasExternalData()) continue;
                object3 = object4.query(object4.fields().toArray(), null, false, 2);
                object3.first();
                while (object3.next()) {
                    Object object5;
                    FieldValue[] fieldValueArray = object3.fields();
                    string6 = object4.getExternalDataPath(fieldValueArray);
                    if (string6.endsWith(File.separator) && ((String)(object5 = string6.substring(0, string6.length() - 1))).equalsIgnoreCase(this.BIT)) continue;
                    object5 = new File(string6);
                    String string7 = null;
                    string7 = ServerEnv.isSharedHistDir() ? ((string7 = ServerEnv.getSharedHistDir()).endsWith(File.separator) ? (string7 = string7.substring(0, string7.length() - ("history" + File.separator).length())) : string7.substring(0, string7.length() - "history".length())) : ServerEnv.homePath;
                    if (!((File)object5).exists() || ((HashSet)object).contains(string6)) continue;
                    AbstractTransferHelp.exportExternalData(zipOutputStream, string6, string7, string5);
                    ((HashSet)object).add(string6);
                }
                object3.close();
            }
            ((HashSet)object).clear();
            object4 = new File(this.BIT);
            object3 = ((File)object4).listFiles();
            int n2 = 0;
            while (n2 < ((File[])object3).length) {
                if (((File)object3[n2]).isFile()) {
                    string6 = null;
                    string6 = ServerEnv.isSharedHistDir() ? ((string6 = ServerEnv.getSharedHistDir()).endsWith(File.separator) ? (string6 = string6.substring(0, string6.length() - ("history" + File.separator).length())) : string6.substring(0, string6.length() - "history".length())) : ServerEnv.homePath;
                    AbstractTransferHelp.exportExternalData(zipOutputStream, ((File)object3[n2]).getAbsolutePath(), string6, string5);
                }
                ++n2;
            }
            System.err.println(" OK");
        }
        zipOutputStream.close();
        System.gc();
        System.err.println("Backup end");
        return true;
    }

    public synchronized boolean restore(Database database, String string) throws SQLException, IOException {
        ZipEntry zipEntry;
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = AbstractTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getWorkspace().getName();
        String string7 = database.getName();
        if (!(string6.equals(string4) && string7.equals(string5) && string2.equals("1.0") && (string3.equals("BAK") || string3.equals("BAK_DB")))) {
            throw new IOException("The " + string + " is not for " + string6 + "." + string7);
        }
        String string8 = string6 + "/";
        ZipEntry zipEntry2 = zipFile.getEntry(string8);
        if (zipEntry2 == null) {
            throw new IOException("The " + string + " is not for " + string6 + " workspace.");
        }
        List list = AbstractTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        System.err.println("Restore begin...");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string9 = (String)iterator.next();
            object2 = database.tables(string9);
            object = string8 + string9 + ".dat";
            zipEntry = zipFile.getEntry((String)object);
            if (object2 == null || zipEntry == null) continue;
            System.err.print("Restore " + database.getName() + "." + string9 + " ...");
            object2.delete("");
            AbstractTransferHelp.importsTableData((Table)object2, arrayList, zipFile.getInputStream(zipEntry));
            int n2 = object2.insert(arrayList);
            arrayList.clear();
            System.err.println(n2 + " OK");
            hashSet.add(zipEntry.getName());
        }
        boolean bl = false;
        object2 = database.getProperty("restore-type");
        if (object2 != null && ((String)object2).equals("DB") || string3.equals("BAK_DB")) {
            bl = true;
        }
        if (!bl) {
            System.err.print("Restore external data ...");
            object = zipFile.entries();
            while (object.hasMoreElements()) {
                String string10;
                int n3;
                zipEntry = (ZipEntry)object.nextElement();
                String string11 = zipEntry.getName();
                if (!string11.startsWith(string4) || hashSet.contains(string11) || (n3 = (string10 = string11.substring(string4.length() + 1, string11.length())).indexOf("/")) <= 0) continue;
                string10 = this.BIT + string10.substring(n3, string10.length());
                AbstractTransferHelp.importsExternalData(string10, zipFile.getInputStream(zipEntry));
            }
            System.err.println(" OK");
        }
        hashSet.clear();
        zipFile.close();
        System.gc();
        System.err.println("Restore end");
        return true;
    }

    public synchronized boolean cutdownTable(Database database, Table table, String string, String string2) throws SQLException, IOException {
        Object object;
        Object object2;
        String string3;
        String string4;
        String string5;
        String string6 = database.getWorkspace().getName();
        String string7 = database.getName();
        String string8 = table.getName();
        String string9 = database.getProperty("schema");
        if (string9 != null && string9.length() > 0) {
            string5 = "\"" + string9 + "\".RESULTVERSION_2";
            string4 = "\"" + string9 + "\".VERSIONNODES_2";
            string3 = "\"" + string9 + "\".NODES_3";
        } else {
            string5 = "RESULTVERSION_2";
            string4 = "VERSIONNODES_2";
            string3 = "NODES_3";
        }
        if (!string5.equalsIgnoreCase(string8)) {
            throw new SQLException("Can not cut down " + string8 + " in " + string7);
        }
        String string10 = null;
        long l = 0L;
        if (string2 != null && string2.trim().length() > 0) {
            try {
                l = AbstractTransferHelp.DF.parse(string2).getTime() + 60000L;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        string10 = "WHERE CREATEDTIME <= " + l;
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "CUT");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string6);
        properties.setProperty("database", string7);
        Table table2 = database.tables(string4);
        Table table3 = database.tables(string3);
        ArrayList<FieldValue[]> arrayList = new ArrayList<FieldValue[]>();
        ArrayList<FieldValue[]> arrayList2 = new ArrayList<FieldValue[]>();
        Recordset recordset = table.query(table.fields().toArray(), string10 + " ORDER BY " + string5 + ".CREATEDTIME ASC", false);
        table.delete(string10);
        String string11 = null;
        if (recordset.next()) {
            string11 = AbstractTransferHelp.DF.format(new Date(recordset.getLong("CREATEDTIME")));
        }
        recordset.first();
        while (recordset.next()) {
            int n = recordset.getInt("VERSIONNUMBER");
            int n2 = recordset.getInt("RESOURCEID");
            stringBuffer2.delete(0, stringBuffer2.length());
            stringBuffer2.append("WHERE VERSIONNUMBER=").append(n).append(" AND ");
            stringBuffer2.append("RESOURCEID=").append(n2);
            object2 = table2.query(table2.fields().toArray(), stringBuffer2.toString(), true);
            if (object2.next()) {
                int n3 = recordset.getInt("ID");
                arrayList.add(object2.fields());
                table2.delete(stringBuffer2.toString());
                stringBuffer2.delete(0, stringBuffer2.length());
                stringBuffer2.append("WHERE ID=").append(n3);
                object = table3.query(table3.fields().toArray(), stringBuffer2.toString(), true);
                if (object.next()) {
                    arrayList2.add(object.fields());
                    table3.delete(stringBuffer2.toString());
                }
                object.close();
            }
            object2.close();
        }
        string11 = string11 != null ? string11 + " to " + AbstractTransferHelp.DF.format(new Date(recordset.getLong("CREATEDTIME"))) : "";
        properties.setProperty("scope", string11);
        if (string != null && string.trim().length() > 0) {
            String string12 = string6 + "/";
            ZipOutputStream zipOutputStream = AbstractTransferHelp.createBackupVolume(string, string12);
            System.err.println("Backup begin...");
            recordset.first();
            while (recordset.next()) {
                object2 = table.getExternalDataPath(recordset.fields());
                String string13 = null;
                string13 = ServerEnv.isSharedHistDir() ? ((string13 = ServerEnv.getSharedHistDir()).endsWith(File.separator) ? (string13 = string13.substring(0, string13.length() - ("history" + File.separator).length())) : string13.substring(0, string13.length() - "history".length())) : ServerEnv.homePath;
                AbstractTransferHelp.exportExternalData(zipOutputStream, (String)object2, string13, string12);
                AbstractTransferHelp.deleteExternalData(new File((String)object2));
            }
            System.err.print("Backup " + string7 + "." + string8 + " ... ");
            int n = AbstractTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string12 + string8 + ".dat"), recordset);
            recordset.close();
            System.err.println(n + " OK");
            String string14 = table2.getName();
            System.err.print("Backup " + string7 + "." + string14 + " ... ");
            n = AbstractTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string12 + string14 + ".dat"), arrayList);
            arrayList.clear();
            System.err.println(n + " OK");
            object = table3.getName();
            System.err.print("Backup " + string7 + "." + (String)object + " ... ");
            n = AbstractTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string12 + (String)object + ".dat"), arrayList2);
            arrayList2.clear();
            System.err.println(n + " OK");
            stringBuffer.append(string8).append(";").append(string14).append(";").append((String)object);
            zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
            properties.setProperty("tableset", stringBuffer.toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, "JREntServer result version cutdown archive");
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            System.err.println("Backup end");
        }
        System.gc();
        return true;
    }

    public synchronized boolean importsTable(Database database, Table table, String string) throws SQLException, IOException {
        Object object;
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = AbstractTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string3 = properties.getProperty("version");
        String string4 = properties.getProperty("type");
        String string5 = properties.getProperty("realm");
        String string6 = properties.getProperty("database");
        String string7 = database.getWorkspace().getName();
        String string8 = database.getName();
        if (!(string7.equals(string5) && string8.equals(string6) && string3.equals("1.0") && string4.equals("CUT"))) {
            throw new IOException("The " + string + " is not for " + string7 + "." + string8);
        }
        String string9 = database.getProperty("schema");
        String string10 = string9 != null && string9.length() > 0 ? "\"" + string9 + "\".RESULTVERSION_2" : "RESULTVERSION_2";
        if (!string10.equalsIgnoreCase(string2 = table.getName())) {
            throw new IOException("Can not import " + string2 + " in " + string8);
        }
        String string11 = string7 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string11);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string7 + " workspace.");
        }
        List list = AbstractTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            arrayList.add(object);
        }
        object = list.iterator();
        ArrayList arrayList2 = new ArrayList();
        while (object.hasNext()) {
            String string12 = (String)object.next();
            String string13 = string11 + string12 + ".dat";
            ZipEntry zipEntry2 = zipFile.getEntry(string13);
            System.err.print("Restore " + database.getName() + "." + string12 + " ...");
            AbstractTransferHelp.importsTableData(database.tables(string12), arrayList2, zipFile.getInputStream(zipEntry2));
            if (string12.equals(string2)) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    FieldValue[] fieldValueArray = (FieldValue[])iterator.next();
                    String string14 = table.getExternalDataPath(fieldValueArray);
                    int n2 = string14.lastIndexOf(File.separator);
                    String string15 = string14.substring(n2 + 1);
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        ZipEntry zipEntry3 = (ZipEntry)iterator2.next();
                        String string16 = zipEntry3.getName();
                        n2 = string16.indexOf(string15);
                        if (n2 == -1) continue;
                        if (!zipEntry3.isDirectory()) {
                            String string17 = string14 + string16.substring(n2 += string15.length());
                            AbstractTransferHelp.importsExternalData(string17, zipFile.getInputStream(zipEntry3));
                        }
                        iterator2.remove();
                    }
                }
            }
            int n3 = database.tables(string12).insert(arrayList2);
            arrayList2.clear();
            System.err.println(n3 + " OK");
        }
        zipFile.close();
        System.gc();
        System.err.println("Restore end");
        return true;
    }

    public synchronized void checkIntegrality(Database database, Map map) throws SQLException {
        Object object;
        String string;
        FieldValue[] fieldValueArray;
        int n;
        int n2;
        Object object2;
        int n3;
        Object object3;
        int n4;
        int n5;
        int n6;
        Recordset recordset;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        System.err.print("Checking " + database.getName() + " ...");
        StringBuffer stringBuffer = new StringBuffer();
        String string10 = database.getProperty("schema");
        if (string10 != null && string10.length() > 0) {
            string9 = "\"" + string10 + "\".CATALOGVERSION_2";
            string8 = "\"" + string10 + "\".REPORTVERSION_2";
            string7 = "\"" + string10 + "\".RESULTVERSION_2";
            string6 = "\"" + string10 + "\".FOLDERS_3";
            string5 = "\"" + string10 + "\".RESOURCENODES_3";
            string4 = "\"" + string10 + "\".VERSIONNODES_2";
            string3 = "\"" + string10 + "\".NODES_3";
            string2 = "\"" + string10 + "\".DYNAMICRESULT_1";
        } else {
            string9 = "CATALOGVERSION_2";
            string8 = "REPORTVERSION_2";
            string7 = "RESULTVERSION_2";
            string6 = "FOLDERS_3";
            string5 = "RESOURCENODES_3";
            string4 = "VERSIONNODES_2";
            string3 = "NODES_3";
            string2 = "DYNAMICRESULT_1";
        }
        Table table = database.tables(string9);
        Table table2 = database.tables(string8);
        Table table3 = database.tables(string7);
        Table table4 = database.tables(string6);
        Table table5 = database.tables(string5);
        Table table6 = database.tables(string4);
        Table table7 = database.tables(string3);
        Table table8 = database.tables(string2);
        HashMap<Object, Table> hashMap = new HashMap<Object, Table>();
        HashMap<Object, Table> hashMap2 = new HashMap<Object, Table>();
        Table[] tableArray = new Table[3];
        DBAdapter dBAdapter = ((TableImpl)table7).getDBAdapter();
        this.BIT(table7);
        tableArray[0] = table;
        tableArray[1] = table2;
        tableArray[2] = table3;
        int n7 = 0;
        while (n7 < 3) {
            recordset = tableArray[n7].query(tableArray[n7].fields().toArray(), null, false);
            while (recordset.next()) {
                n6 = recordset.getInt("RESOURCEID");
                n5 = recordset.getInt("VERSIONNUMBER");
                hashMap.put(n6 + ":" + n5, tableArray[n7]);
            }
            recordset.close();
            ++n7;
        }
        recordset = table6.query(table6.fields().toArray(), null, false, 2);
        while (recordset.next()) {
            n6 = recordset.getInt("ID");
            n5 = recordset.getInt("RESOURCEID");
            n4 = recordset.getInt("VERSIONNUMBER");
            object3 = n5 + ":" + n4;
            if (!hashMap.containsKey(object3)) {
                table6.delete("WHERE ID=" + n6);
                table7.delete("WHERE ID=" + n6);
                continue;
            }
            hashMap2.put(object3, table6);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string11 = (String)iterator.next();
            if (hashMap2.containsKey(string11)) continue;
            Table table9 = (Table)hashMap.get(string11);
            n4 = string11.indexOf(":");
            int n8 = Integer.parseInt(string11.substring(0, n4));
            n3 = Integer.parseInt(string11.substring(n4 + 1));
            table9.delete("WHERE RESOURCEID=" + n8 + " AND VERSIONNUMBER=" + n3);
        }
        hashMap.clear();
        hashMap2.clear();
        recordset.close();
        tableArray[0] = table4;
        tableArray[1] = table5;
        tableArray[2] = table6;
        recordset = table6.query(table6.fields().toArray(), null, false);
        while (recordset.next()) {
            int n9 = recordset.getInt("RESOURCEID");
            hashMap.put(new Integer(n9), table6);
        }
        recordset.close();
        Recordset recordset2 = table5.query(table5.fields().toArray(), null, false, 2);
        while (recordset2.next()) {
            int n10 = recordset2.getInt("ID");
            Integer n11 = new Integer(n10);
            if (hashMap.containsKey(n11)) continue;
            table5.delete("WHERE ID=" + n10);
            table7.delete("WHERE ID=" + n10);
        }
        recordset2.close();
        hashMap.clear();
        this.BIT(table7);
        int n12 = 0;
        while (n12 < 3) {
            Recordset recordset3 = tableArray[n12].query(tableArray[n12].fields().toArray(), null, false);
            while (recordset3.next()) {
                int n13 = recordset3.getInt("ID");
                hashMap.put(new Integer(n13), tableArray[n12]);
            }
            recordset3.close();
            ++n12;
        }
        Recordset recordset4 = table7.query(table7.fields().toArray(), null, false, 2);
        while (recordset4.next()) {
            int n14 = recordset4.getInt("ID");
            Integer n15 = new Integer(n14);
            if (!hashMap.containsKey(n15)) {
                table7.delete("WHERE ID=" + n14);
                continue;
            }
            hashMap2.put(n15, table7);
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (Integer)iterator.next();
            if (hashMap2.containsKey(object3)) continue;
            Table table10 = (Table)hashMap.get(object3);
            if (table6.getName().equals(table10.getName())) {
                object2 = table10.query(table10.fields().toArray(), "WHERE ID=" + (Integer)object3, false);
                if (object2.next()) {
                    n2 = object2.getInt("RESOURCEID");
                    n = object2.getInt("VERSIONNUMBER");
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append("WHERE RESOURCEID=").append(n2);
                    stringBuffer.append(" AND VERSIONNUMBER=").append(n);
                    table.delete(stringBuffer.toString());
                    table2.delete(stringBuffer.toString());
                    table3.delete(stringBuffer.toString());
                }
                object2.close();
            }
            table10.delete("WHERE ID=" + (Integer)object3);
        }
        hashMap.clear();
        hashMap2.clear();
        recordset4.close();
        tableArray[0] = table;
        tableArray[1] = table2;
        tableArray[2] = table3;
        int n16 = 0;
        while (n16 < 3) {
            Table table11 = tableArray[n16];
            object2 = table11.query(table11.fields().toArray(), null, false, 2);
            while (object2.next()) {
                n2 = object2.getInt("RESOURCEID");
                n = object2.getInt("VERSIONNUMBER");
                fieldValueArray = object2.fields();
                string = table11.getExternalDataPath(fieldValueArray);
                if (map.containsKey(string)) {
                    map.remove(string);
                    continue;
                }
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append("WHERE RESOURCEID=").append(n2);
                stringBuffer.append(" AND VERSIONNUMBER=").append(n);
                table11.delete(stringBuffer.toString());
                object = table6.query(table6.fields().toArray(), stringBuffer.toString(), false);
                if (object.next()) {
                    int n17 = object.getInt("ID");
                    table7.delete("WHERE ID=" + n17);
                }
                object.close();
                table6.delete(stringBuffer.toString());
            }
            object2.close();
            ++n16;
        }
        tableArray[0] = table4;
        tableArray[1] = table5;
        tableArray[2] = table6;
        recordset = table6.query(table6.fields().toArray(), null, false);
        while (recordset.next()) {
            n3 = recordset.getInt("RESOURCEID");
            hashMap.put(new Integer(n3), table6);
        }
        recordset.close();
        recordset2 = table5.query(table5.fields().toArray(), null, false, 2);
        while (recordset2.next()) {
            n3 = recordset2.getInt("ID");
            object2 = new Integer(n3);
            if (hashMap.containsKey(object2)) continue;
            table5.delete("WHERE ID=" + n3);
            table7.delete("WHERE ID=" + n3);
        }
        recordset2.close();
        hashMap.clear();
        this.BIT(table7);
        n3 = 0;
        while (n3 < 3) {
            object2 = tableArray[n3].query(tableArray[n3].fields().toArray(), null, false);
            while (object2.next()) {
                n2 = object2.getInt("ID");
                hashMap.put(new Integer(n2), tableArray[n3]);
            }
            object2.close();
            ++n3;
        }
        recordset4 = table7.query(table7.fields().toArray(), null, false, 2);
        while (recordset4.next()) {
            int n18 = recordset4.getInt("ID");
            Integer n19 = new Integer(n18);
            if (!hashMap.containsKey(n19)) {
                table7.delete("WHERE ID=" + n18);
                continue;
            }
            hashMap2.put(n19, table7);
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n20 = (Integer)iterator.next();
            if (hashMap2.containsKey(n20)) continue;
            Table table12 = (Table)hashMap.get(n20);
            if (table6.getName().equals(table12.getName())) {
                Recordset recordset5 = table12.query(table12.fields().toArray(), "WHERE ID=" + n20, false);
                if (recordset5.next()) {
                    int n21 = recordset5.getInt("RESOURCEID");
                    int n22 = recordset5.getInt("VERSIONNUMBER");
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append("WHERE RESOURCEID=").append(n21);
                    stringBuffer.append(" AND VERSIONNUMBER=").append(n22);
                    table.delete(stringBuffer.toString());
                    table2.delete(stringBuffer.toString());
                    table3.delete(stringBuffer.toString());
                }
                recordset5.close();
            }
            table12.delete("WHERE ID=" + n20);
        }
        hashMap.clear();
        hashMap2.clear();
        recordset4.close();
        Recordset recordset6 = table8.query(table8.fields().toArray(), null, false, 2);
        while (recordset6.next()) {
            String string12 = recordset6.getString("REPORTNAME");
            int n23 = recordset6.getInt("VERSIONNUMBER");
            fieldValueArray = recordset6.fields();
            string = table8.getExternalDataPath(fieldValueArray);
            if (map.containsKey(string)) {
                map.remove(string);
                continue;
            }
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("WHERE REPORTNAME=").append(DBToolkit.encStringForSQL(string12));
            stringBuffer.append(" AND VERSIONNUMBER=").append(n23);
            table8.delete(stringBuffer.toString());
        }
        recordset6.close();
        stringBuffer.delete(0, stringBuffer.length());
        Field[] fieldArray = new FieldImpl[]{new FieldImpl(table7, "ID", JDBCType.INTEGER, 0, 0, 0), new FieldImpl(table7, "NAME", JDBCType.VARCHAR, 256, 0, 0), new FieldImpl(table4, "REALPATH", JDBCType.VARCHAR, 256, 0, 0), new FieldImpl(table4, "ENABLEDYNAMICRESOURCE", JDBCType.BIT, 0, 0, 0)};
        Table[] tableArray2 = new Table[]{table7, table4};
        recordset6 = dBAdapter.select(fieldArray, tableArray2, "WHERE " + string3 + ".ID= " + string6 + ".ID", false);
        while (recordset6.next()) {
            File file;
            int n24 = recordset6.getInt("ID");
            boolean bl = recordset6.getBoolean("ENABLEDYNAMICRESOURCE");
            object = recordset6.getString("REALPATH");
            String string13 = recordset6.getString("NAME");
            if (!bl || object == null || (file = new File((String)object)).exists()) continue;
            System.err.println();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("\"").append((String)object).append("\"");
            stringBuffer.append(" does not exist for the mapped resource node [");
            stringBuffer.append(string13);
            stringBuffer.append("]");
            String string14 = stringBuffer.toString();
            System.err.print(string14);
            ServiceLogger.logError(string14);
        }
        recordset6.close();
        if (stringBuffer.length() == 0) {
            System.err.println(" OK");
        } else {
            System.err.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BIT(Table table) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        Field[] fieldArray = new FieldImpl[]{new FieldImpl(table, "PARENTID", JDBCType.INTEGER, 0, 0, 0)};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE PARENTID NOT IN (SELECT ID FROM ");
        stringBuffer.append(table.getName()).append(") AND PARENTID > 0");
        while (n > 0) {
            Object var9_9;
            Recordset recordset = null;
            try {
                try {
                    recordset = table.query(fieldArray, stringBuffer.toString(), false);
                    n = 0;
                    while (recordset.next()) {
                        int n3 = recordset.getInt("PARENTID");
                        table.delete("WHERE PARENTID=" + Integer.toString(n3));
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    var9_9 = null;
                    recordset.close();
                    n2 += n;
                    break;
                }
                var9_9 = null;
                recordset.close();
                n2 += n;
            }
            catch (Throwable throwable) {
                var9_9 = null;
                recordset.close();
                n2 += n;
                throw throwable;
            }
        }
        if (n2 > 0) {
            System.err.print("clear " + n2 + " invalid nodes ...");
        }
    }
}

