/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event;

import java.io.Serializable;
import java.util.Hashtable;
import jet.server.event.Filter;
import jet.server.event.Selector;
import jet.server.event.TopicEvent;

public final class FilterImpl
implements Filter,
Serializable {
    private static final long serialVersionUID = 7509523954433372768L;
    private Hashtable col = new Hashtable();
    private boolean isAcceptAll = false;

    public synchronized boolean accept(TopicEvent topicEvent) {
        if (this.isAcceptAll) {
            return true;
        }
        boolean bl = false;
        Selector selector = (Selector)this.col.get(topicEvent.getTopic());
        if (selector != null) {
            bl = selector.select(topicEvent.getType());
        }
        return bl;
    }

    public synchronized void addSelector(Selector selector) {
        String string = selector.getTopic();
        this.col.remove(string);
        this.col.put(string, selector);
        if ("*".equals(string)) {
            this.isAcceptAll = true;
        }
    }

    public synchronized Selector getSelector(String string) {
        return (Selector)this.col.get(string);
    }

    public synchronized Selector[] getAllSelectors() {
        Selector[] selectorArray = new Selector[this.col.size()];
        System.arraycopy(this.col.values().toArray(), 0, selectorArray, 0, selectorArray.length);
        return selectorArray;
    }

    public synchronized void delSelector(String string) {
        this.col.remove(string);
        if ("*".equals(string)) {
            this.isAcceptAll = false;
        }
    }

    public synchronized void delAllSelectors() {
        this.col.clear();
        this.isAcceptAll = false;
    }
}

