/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event.util;

import jet.server.event.util.Queue;

public class PriorityQueue {
    public static final int INIT_QUEUE_LEN = 32;
    private Queue[] append;

    public PriorityQueue(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The queues argument (" + n + ") is not a positive integer.");
        }
        this.append = new Queue[n];
        int n2 = 0;
        while (n2 < this.append.length) {
            this.append[n2] = new Queue(32);
            ++n2;
        }
    }

    public void distroy() {
        this.clear();
        this.append = null;
    }

    public final int getMaxQueues() {
        return this.append.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        int n = 0;
        while (n < this.append.length) {
            Queue queue = this.append[n];
            synchronized (queue) {
                this.append[n].clear();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.append.length) {
            Queue queue = this.append[n2];
            synchronized (queue) {
                n += this.append[n2].size();
            }
            ++n2;
        }
        return n;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object, int n) {
        Queue queue = this.append[n];
        synchronized (queue) {
            this.append[n].enqueue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object object = null;
        int n = 0;
        while (n < this.append.length) {
            Queue queue = this.append[n];
            synchronized (queue) {
                object = this.append[n].isEmpty() ? null : this.append[n].dequeue();
            }
            if (object != null) break;
            ++n;
        }
        return object;
    }
}

