/*
 * Decompiled with CFR 0.152.
 */
package jet.server.intf.security;

import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.resource.Node;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.intf.security.UserFolderListener;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.NoSuchAclEntryException;

public interface SecurityService {
    public boolean isValidUser(String var1, String var2);

    public boolean isAdminUser(String var1);

    public User getUser(String var1) throws NoSuchUserException;

    public User getIntegrityUser(String var1) throws NoSuchUserException;

    public Vector getAllUsers();

    public Vector getUsersNameByRole(String var1) throws NoSuchRoleException;

    public Role getRole(String var1) throws NoSuchRoleException;

    public Vector getAllRoles();

    public Vector getRolesNameByUser(String var1) throws NoSuchUserException;

    public Group getGroup(String var1) throws NoSuchGroupException;

    public Vector getAllGroups();

    public Vector getGroupsNameByUser(String var1) throws NoSuchUserException;

    public Vector getUsersNameByGroup(String var1) throws NoSuchGroupException;

    public String changePassword(boolean var1, String var2, String var3, String var4, String var5) throws NoSuchUserException;

    public boolean getAuditState(String var1, int var2, boolean var3) throws NoSuchUserException;

    public Vector getAllUsersName();

    public Vector getAllRolesName();

    public Vector getAllGroupsName();

    public void addUserFolderListener(UserFolderListener var1);

    public Vector getReferUsers(String var1) throws NoSuchUserException;

    public Vector getReferRoles(String var1) throws NoSuchUserException;

    public Vector getReferGroups(String var1) throws NoSuchUserException;

    public boolean checkPermission(Node var1, String var2, Permission var3);

    public boolean checkPrivilege(String var1, String var2);

    public void clearPermissions(Node var1);

    public Hashtable[] getPermissions(Node var1);

    public int setPermissions(Node var1, String var2, Hashtable[] var3) throws NoSuchAclException, NotOwnerException, AclExistException;

    public boolean removeUserPermissions(Node var1, String var2) throws NoSuchAclException, NoSuchAclEntryException;

    public boolean removeRolePermissions(Node var1, String var2) throws NoSuchAclException, NoSuchAclEntryException;

    public boolean removeGroupPermissions(Node var1, String var2) throws NoSuchAclException, NoSuchAclEntryException;

    public int getDefaultAclID();

    public ExSecurityData getSecurityData();

    public String getPassword(String var1) throws NoSuchUserException;

    public boolean isExpired(String var1);

    public boolean isEditing(int var1);

    public String[] getAllInheritRoleNames(String var1) throws NoSuchUserException;

    public String[] getAllInheritGroupNames(String var1) throws NoSuchUserException;

    public Vector getAllUserNamesByReferedRole(String var1) throws NoSuchRoleException, NoSuchGroupException;

    public Vector getAllContainedUserNamesByGroup(String var1) throws NoSuchGroupException;
}

