/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ReportMember;
import jet.server.intf.jrs.ClusterReceiver;
import jet.server.jrc.JRMemberManager;

public class JRClusterReceiver
extends UnicastRemoteObject
implements ClusterReceiver {
    Hashtable QOIV = new Hashtable();
    ReportMember[] arraycopy = null;
    JRMemberManager clear = null;

    public JRClusterReceiver(ReportMember[] reportMemberArray) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.arraycopy = reportMemberArray;
    }

    public void setMemberManager(JRMemberManager jRMemberManager) {
        this.clear = jRMemberManager;
    }

    public void receive(ReportMember reportMember) throws RemoteException {
        this.receive(reportMember, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(ReportMember reportMember, boolean bl) throws RemoteException {
        Hashtable hashtable = this.QOIV;
        synchronized (hashtable) {
            boolean bl2 = true;
            Enumeration enumeration = this.QOIV.keys();
            while (enumeration.hasMoreElements()) {
                ReportMember reportMember2 = (ReportMember)enumeration.nextElement();
                if (!reportMember2.equals(reportMember)) continue;
                this.QOIV.remove(reportMember2);
                bl2 = false;
                break;
            }
            long l = System.currentTimeMillis();
            if (bl || !bl2) {
                this.QOIV.put(reportMember, new Long(l));
            } else if (this.clear != null) {
                this.QOIV.put(reportMember, new Long(l));
                this.clear.registerMember(reportMember, true);
            }
        }
    }

    public void receivePredefined(ReportMember[] reportMemberArray, ReportMember reportMember) throws RemoteException {
        this.arraycopy = reportMemberArray;
        this.receive(reportMember);
    }

    public void receivePredefined(ReportMember[] reportMemberArray) throws RemoteException {
        this.arraycopy = reportMemberArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActiveMember(ReportMember reportMember) {
        Hashtable hashtable = this.QOIV;
        synchronized (hashtable) {
            Enumeration enumeration = this.QOIV.keys();
            while (enumeration.hasMoreElements()) {
                Long l;
                ReportMember reportMember2 = (ReportMember)enumeration.nextElement();
                if (!reportMember2.equals(reportMember)) continue;
                long l2 = System.currentTimeMillis();
                if (l2 - (l = (Long)this.QOIV.get(reportMember2)) >= 90000L) return false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getActiveServers() {
        long l = System.currentTimeMillis();
        Hashtable hashtable = null;
        Hashtable hashtable2 = this.QOIV;
        synchronized (hashtable2) {
            Enumeration enumeration = this.QOIV.keys();
            while (enumeration.hasMoreElements()) {
                ReportMember reportMember = (ReportMember)enumeration.nextElement();
                Long l2 = (Long)this.QOIV.get(reportMember);
                if (l - l2 <= 90000L) continue;
                this.QOIV.remove(reportMember);
            }
            hashtable = (Hashtable)this.QOIV.clone();
        }
        return hashtable.keys();
    }

    public ReportMember[] getPredefinedBackupServers() {
        if (this.arraycopy == null) {
            return null;
        }
        int n = 0;
        while (n < this.arraycopy.length) {
            if (this.arraycopy[n].getBackupPriority() == -1) break;
            ++n;
        }
        ReportMember[] reportMemberArray = new ReportMember[n];
        System.arraycopy(this.arraycopy, 0, reportMemberArray, 0, n);
        return reportMemberArray;
    }

    public ReportMember[] getPredefinedMembers() {
        return this.arraycopy;
    }

    public void clearMem() {
        this.QOIV.clear();
        this.QOIV = null;
        this.arraycopy = null;
        this.clear = null;
    }
}

