/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.CompletedTaskTable;
import jet.server.api.ResultVersionTable;
import jet.server.api.RptServerException;
import jet.server.api.VersionAmountLimitTable;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.db.CompletedTable;
import jet.server.db.CompletedTableImpl;
import jet.server.db.Connector;
import jet.server.db.SchdLastExeTimeTable;
import jet.server.db.SchdLastExeTimeTableImpl;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.VersionController;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspaceManager;
import jet.server.db.resource.AliasTable;
import jet.server.db.resource.AliasTableImpl;
import jet.server.db.resource.DynamicNodeTable;
import jet.server.db.resource.DynamicNodeTableImpl;
import jet.server.db.resource.FolderTableImpl;
import jet.server.db.resource.NodeTableImpl;
import jet.server.db.resource.ResourceMapTable;
import jet.server.db.resource.ResourceMapTableImpl;
import jet.server.db.resource.ResourceNodeTableImpl;
import jet.server.db.resource.VersionNodeTableImpl;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclEntryTableImpl;
import jet.server.db.security2.AclTable;
import jet.server.db.security2.AclTableImpl;
import jet.server.db.security2.AclsWithResourceTable;
import jet.server.db.security2.AclsWithResourceTableImpl;
import jet.server.db.security2.ExtendAclEntryTable;
import jet.server.db.security2.ExtendAclEntryTableImpl;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.GUProfileTableImpl;
import jet.server.db.security2.GroupProfileTable;
import jet.server.db.security2.GroupProfileTableImpl;
import jet.server.db.security2.GroupTable;
import jet.server.db.security2.GroupTableImpl;
import jet.server.db.security2.RGProfileTable;
import jet.server.db.security2.RGProfileTableImpl;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleProfileTableImpl;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.RoleTableImpl;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserProfileTableImpl;
import jet.server.db.security2.UserTable;
import jet.server.db.security2.UserTableImpl;
import jet.server.db.transfer.SystablesTransferHelp;
import jet.server.db.version.CatalogVersionTableImpl;
import jet.server.db.version.DynamicResultVersionTableImpl;
import jet.server.db.version.ReportVersionTableImpl;
import jet.server.db.version.ResultVersionTableImpl;
import jet.server.intf.jrs.DataService;
import jet.server.intf.version.CatalogVersionTable;
import jet.server.intf.version.DynamicResultVersionTable;
import jet.server.intf.version.ReportVersionTable;
import jet.server.intf.version.ResultVersionTableNew;
import jet.server.jrc.JRSchedulingService;
import jet.server.jrserver.JRCompletedTaskTable;
import jet.server.jrserver.JRResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.trigger.TriggerTableImpl;

public class JRDataService
implements DataService {
    private UpdateDetailsTableImpl QOIV = null;
    private NodeTableImpl append = null;
    private FolderTableImpl clearMem = null;
    private ResourceNodeTableImpl close = null;
    private AliasTable createStatement = null;
    private VersionNodeTableImpl databases = null;
    private CompletedTaskTable destroy = null;
    private ResultVersionTable equalsIgnoreCase = null;
    private VersionAmountLimitTable execute = null;
    private CompletedTable exists = null;
    private CatalogVersionTable getActiveRealm = null;
    private ReportVersionTable getConnection = null;
    private ResultVersionTableNew getConnector = null;
    private UserTable getDatabaseProductName = null;
    private UserProfileTable getHistDir = null;
    private RoleTable getInstance = null;
    private AclTable getMetaData = null;
    private AclEntryTable getName = null;
    private RoleProfileTable getProperties = null;
    private GroupTable getProperty = null;
    private GroupProfileTable getRemoteObject = null;
    private RGProfileTable hasClusterLicense = null;
    private GUProfileTable indexOf = null;
    private ExtendAclEntryTable length = null;
    private DynamicNodeTable logDebug = null;
    private DynamicResultVersionTable logError = null;
    private ResourceMapTable mkdirs = null;
    private SchdLastExeTimeTable newInstance = null;
    private AclsWithResourceTable open = null;
    private boolean printStackTrace = false;
    private boolean propertiesPath = false;
    private String quit = null;
    private int register;
    private Database remove = null;
    private Connector restore;
    private String saveConfig = null;

    public JRDataService() {
    }

    public JRDataService(String string) throws Exception {
        this.init(string);
    }

    public JRDataService(boolean bl, String string, int n) throws Exception {
        this.propertiesPath = bl;
        this.quit = string;
        this.register = n;
        if (bl) {
            this.init(ServerEnv.getActiveRealm());
        }
    }

    private void init(String string) throws Exception {
        Workspace workspace;
        this.saveConfig = string;
        File file = new File(ServerEnv.propertiesPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((workspace = WorkspaceManager.getInstance().workspaces(string)) == null) {
            workspace = new WorkspaceImpl(string);
            this.remove = this.append(workspace);
            WorkspaceManager.getInstance().append(workspace);
            WorkspaceManager.getInstance().saveConfig();
        } else {
            this.remove = workspace.databases("systables");
            if (this.remove == null) {
                this.remove = this.append(workspace);
                WorkspaceManager.getInstance().saveConfig();
            }
        }
        if (this.remove instanceof DatabaseImpl) {
            ((DatabaseImpl)this.remove).setTransferHelp(new SystablesTransferHelp());
        }
        try {
            ((DatabaseImpl)this.remove).open();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.restore = ((DatabaseImpl)this.remove).getConnector();
        try {
            try {
                String string2;
                this.QOIV = UpdateDetailsTableImpl.newInstance(this.remove);
                this.append = NodeTableImpl.newInstance(this.remove, this.QOIV);
                this.clearMem = FolderTableImpl.newInstance(this.remove, this.append, this.QOIV);
                this.close = ResourceNodeTableImpl.newInstance(this.remove, this.append, this.QOIV);
                this.databases = VersionNodeTableImpl.newInstance(this.remove, this.append, this.QOIV);
                this.createStatement = AliasTableImpl.newInstance(this.remove, this.QOIV);
                this.getActiveRealm = CatalogVersionTableImpl.newInstance(this.remove, this.QOIV);
                this.getConnection = ReportVersionTableImpl.newInstance(this.remove, this.QOIV);
                this.getConnector = ResultVersionTableImpl.newInstance(this.remove, this.QOIV);
                this.logDebug = DynamicNodeTableImpl.newInstance(this.remove, this.QOIV);
                this.logError = DynamicResultVersionTableImpl.newInstance(this.remove, this.QOIV);
                this.mkdirs = ResourceMapTableImpl.newInstance(this.remove);
                this.getDatabaseProductName = UserTableImpl.newInstance(this.remove, this.QOIV);
                this.getHistDir = UserProfileTableImpl.newInstance(this.remove, this.QOIV);
                this.getInstance = RoleTableImpl.newInstance(this.remove, this.QOIV);
                this.getMetaData = AclTableImpl.newInstance(this.remove, this.QOIV);
                this.getName = AclEntryTableImpl.newInstance(this.remove, this.QOIV);
                this.getProperties = RoleProfileTableImpl.newInstance(this.remove, this.QOIV);
                this.getProperty = GroupTableImpl.newInstance(this.remove);
                this.getRemoteObject = GroupProfileTableImpl.newInstance(this.remove);
                this.hasClusterLicense = RGProfileTableImpl.newInstance(this.remove);
                this.indexOf = GUProfileTableImpl.newInstance(this.remove, this.QOIV);
                this.length = ExtendAclEntryTableImpl.newInstance(this.remove, this.QOIV);
                this.exists = CompletedTableImpl.newInstance(this.remove, this.QOIV);
                TriggerTableImpl.newInstance(this.remove);
                this.newInstance = SchdLastExeTimeTableImpl.newInstance(this.remove);
                this.open = AclsWithResourceTableImpl.newInstance(this.remove, this.QOIV, this.getMetaData);
                if (string.equalsIgnoreCase(ServerEnv.getActiveRealm()) && (string2 = System.getProperty("restore.systables")) != null && string2.trim().length() > 0) {
                    String string3 = System.getProperty("restore-type");
                    if (string3 != null) {
                        this.remove.setProperty("restore-type", string3);
                    }
                    try {
                        this.remove.restore(string2);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception, 3);
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    System.getProperties().remove("restore.systables");
                }
                this.printStackTrace = true;
                ServiceLogger.logDebug(4640002, new String[]{string, "systables"}, 4);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw exception;
            }
            Object var9_11 = null;
            if (!this.printStackTrace) {
                if (this.remove != null) {
                    ((DatabaseImpl)this.remove).close();
                }
                if (this.restore != null) {
                    this.restore.destroy();
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!this.printStackTrace) {
                if (this.remove != null) {
                    ((DatabaseImpl)this.remove).close();
                }
                if (this.restore != null) {
                    this.restore.destroy();
                }
            }
            throw throwable;
        }
    }

    public void setSchdulingService(JRSchedulingService jRSchedulingService, JRResourceManager jRResourceManager) throws Exception {
        if (this.propertiesPath) {
            ((CompletedTableImpl)this.exists).setHistoryDir(jRResourceManager.getHistDir());
            ((CompletedTableImpl)this.exists).setSchedulingService(jRSchedulingService);
        }
        if (ServerEnv.hasClusterLicense()) {
            if (this.propertiesPath) {
                RemoteObjectFactory.register("CompletedTable", this.exists);
            } else {
                this.exists = (CompletedTable)RemoteObjectFactory.getRemoteObject(this.quit, this.register, "CompletedTable");
            }
        }
        this.destroy = new JRCompletedTaskTable(this.exists, jRResourceManager);
    }

    public VersionController getVersionController() {
        return null;
    }

    public CompletedTaskTable getCompletedTaskTable() {
        return this.destroy;
    }

    public ResultVersionTable getResultVersionTable() {
        return this.equalsIgnoreCase;
    }

    public VersionAmountLimitTable getVersionAmountLimitTable() {
        return this.execute;
    }

    public CompletedTable getCompletedTable() {
        return this.exists;
    }

    public void quit() {
        if (this.printStackTrace) {
            if (this.propertiesPath) {
                ((CompletedTableImpl)this.exists).close();
            }
            this.clearMem.close();
            this.close.close();
            this.databases.close();
            this.append.close();
            this.getMetaData.close();
            this.getName.close();
            this.getDatabaseProductName.close();
            this.getHistDir.close();
            this.getInstance.close();
            this.getProperties.close();
            this.length.close();
            ((AliasTableImpl)this.createStatement).close();
            ((CatalogVersionTableImpl)this.getActiveRealm).close();
            ((ReportVersionTableImpl)this.getConnection).close();
            ((ResultVersionTableImpl)this.getConnector).close();
            ((DynamicNodeTableImpl)this.logDebug).close();
            ((DynamicResultVersionTableImpl)this.logError).close();
            ((ResourceMapTableImpl)this.mkdirs).close();
            ((SchdLastExeTimeTableImpl)this.newInstance).close();
            this.open.close();
            this.getProperty.close();
            this.getRemoteObject.close();
            this.hasClusterLicense.close();
            this.indexOf.close();
            this.QOIV.close();
            this.QOIV();
        }
    }

    public void destroy() {
        this.quit();
        WorkspaceManager workspaceManager = WorkspaceManager.getInstance();
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)workspaceManager.workspaces(this.saveConfig);
        workspaceImpl.remove(this.remove);
        workspaceManager.remove(workspaceImpl);
        workspaceManager.saveConfig();
        this.clearMem();
    }

    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, String string6) throws RptServerException {
    }

    private void QOIV() {
        if (this.restore != null) {
            try {
                Connection connection = this.restore.getConnection(10000L);
                Statement statement = connection.createStatement();
                if (connection.getMetaData().getDatabaseProductName().indexOf("HSQL") != -1) {
                    statement.execute("SHUTDOWN COMPACT");
                }
                statement.close();
                connection.close();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
    }

    public CatalogVersionTable getCatalogVersionTable() {
        return this.getActiveRealm;
    }

    public ReportVersionTable getReportVersionTable() {
        return this.getConnection;
    }

    public ResultVersionTableNew getResultVersionTableNew() {
        return this.getConnector;
    }

    public AliasTable getAliasTable() {
        return this.createStatement;
    }

    public DynamicNodeTable getDynamicNodeTable() {
        return this.logDebug;
    }

    public DynamicResultVersionTable getDynamicResultVersionTable() {
        return this.logError;
    }

    public ResourceMapTable getResourceMapTable() {
        return this.mkdirs;
    }

    public FolderTableImpl getFolderTable() {
        return this.clearMem;
    }

    public ResourceNodeTableImpl getResourceNodeTable() {
        return this.close;
    }

    public VersionNodeTableImpl getVersionNodeTable() {
        return this.databases;
    }

    public NodeTableImpl getNodeTable() {
        return this.append;
    }

    public AclTable getAclTable() {
        return this.getMetaData;
    }

    public RoleProfileTable getRoleProfileTable() {
        return this.getProperties;
    }

    public RoleTable getRoleTable() {
        return this.getInstance;
    }

    public UserProfileTable getUserProfileTable() {
        return this.getHistDir;
    }

    public UserTable getUserTable() {
        return this.getDatabaseProductName;
    }

    public AclEntryTable getAclEntryTable() {
        return this.getName;
    }

    public GroupTable getGroupTable() {
        return this.getProperty;
    }

    public GroupProfileTable getGroupProfileTable() {
        return this.getRemoteObject;
    }

    public RGProfileTable getRGProfileTable() {
        return this.hasClusterLicense;
    }

    public GUProfileTable getGUProfileTable() {
        return this.indexOf;
    }

    public void setAdmin(boolean bl, String string, int n) {
        this.propertiesPath = bl;
        this.quit = string;
        this.register = n;
    }

    public void clearMem() {
        this.quit();
        this.getActiveRealm = null;
        this.getConnection = null;
        if (this.getConnector != null) {
            ((ResultVersionTableImpl)this.getConnector).clearMem();
        }
        this.getConnector = null;
        this.equalsIgnoreCase = null;
        this.execute = null;
        this.destroy = null;
        this.exists = null;
        this.logDebug = null;
        this.logError = null;
        this.mkdirs = null;
        this.newInstance = null;
        this.printStackTrace = false;
        this.propertiesPath = false;
        if (this.remove != null) {
            ((DatabaseImpl)this.remove).close();
        }
        if (this.restore != null) {
            this.restore.destroy();
        }
    }

    private Database append(Workspace workspace) {
        DatabaseImpl databaseImpl = new DatabaseImpl(workspace, "systables");
        databaseImpl.setProperty("driver", "org.hsqldb.jdbcDriver");
        databaseImpl.setProperty("user", "sa");
        databaseImpl.setProperty("password", "");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:hsqldb:").append(ServerEnv.propertiesPath).append("systable.").append(workspace.getName());
        databaseImpl.setProperty("url", stringBuffer.substring(0));
        ((WorkspaceImpl)workspace).append(databaseImpl);
        return databaseImpl;
    }

    public ExtendAclEntryTable getExtendAclEntryTable() {
        return this.length;
    }

    public SchdLastExeTimeTable getSchdLastExeTimeTable() {
        return this.newInstance;
    }

    public AclsWithResourceTable getAclsWithResourceTable() {
        return this.open;
    }

    public void setAclsWithResourceTable(AclsWithResourceTable aclsWithResourceTable) {
        this.open = aclsWithResourceTable;
    }

    public Database getDatabase() {
        return this.remove;
    }
}

