/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.util.Vector;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.log.ServiceLogger;

public class JRLoadBalancer
implements LoadBalancer {
    protected Member localMember = null;

    public Member selectMember(Member member, Member[] memberArray) {
        this.localMember = member;
        if (memberArray.length == 1) {
            return member;
        }
        Member[] memberArray2 = this.getEligibleMembers(memberArray);
        if (memberArray2.length == 0) {
            return this.select(memberArray);
        }
        if (memberArray2.length == 1) {
            return memberArray2[0];
        }
        return this.select(memberArray2);
    }

    protected float[] make(Member[] memberArray) {
        float[] fArray = new float[memberArray.length];
        int n = 0;
        while (n < memberArray.length) {
            fArray[n] = ((ReportMember)memberArray[n]).getConcurrentReports();
            ServiceLogger.logDebug(6650028, new String[]{memberArray[n].getServerName(), "" + fArray[n]}, 6);
            ++n;
        }
        return fArray;
    }

    protected Member select(Member[] memberArray) {
        Member[] memberArray2 = this.getGoodMembers(memberArray);
        return this.getBestMembers(memberArray2);
    }

    protected Member[] getGoodMembers(Member[] memberArray) {
        float[] fArray = this.make(memberArray);
        if (fArray.length == 0) {
            return new Member[0];
        }
        float f = fArray[0];
        Vector<Member> vector = new Vector<Member>();
        vector.addElement(memberArray[0]);
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] < f) {
                vector.removeAllElements();
                vector.add(memberArray[n]);
                f = fArray[n];
            } else if (fArray[n] == f) {
                vector.addElement(memberArray[n]);
            }
            ++n;
        }
        return this.getMembers(vector.toArray());
    }

    protected Member getBestMembers(Member[] memberArray) {
        if (memberArray.length == 1) {
            return memberArray[0];
        }
        int n = 0;
        while (n < memberArray.length) {
            if (memberArray[n] == this.localMember) {
                return this.localMember;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < memberArray.length) {
            if (!memberArray[n2].isAdmin()) {
                return memberArray[n2];
            }
            ++n2;
        }
        if (memberArray.length >= 1) {
            return memberArray[0];
        }
        return null;
    }

    protected Member[] getEligibleMembers(Member[] memberArray) {
        Vector<Member> vector = new Vector<Member>();
        int n = 0;
        while (n < memberArray.length) {
            if (this.canSelectMember(memberArray[n])) {
                vector.addElement(memberArray[n]);
            }
            ++n;
        }
        return this.getMembers(vector.toArray());
    }

    protected Member[] getMembers(Object[] objectArray) {
        if (objectArray != null) {
            Member[] memberArray = new Member[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                memberArray[n] = (Member)objectArray[n];
                ++n;
            }
            return memberArray;
        }
        return new Member[0];
    }

    protected boolean canSelectMember(Member member) {
        int n = ((ReportMember)member).getConcurrentReports();
        int n2 = ((ReportMember)member).getMaxConcurrentReports();
        if (n2 <= 0) {
            return true;
        }
        if (n < n2) {
            return true;
        }
        ServiceLogger.logDebug(6650029, new String[]{member.getServerName(), "" + n, "" + n2}, 6);
        return false;
    }
}

