/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.api.cluster.Member;

public abstract class JRMember
implements Member,
Serializable {
    protected String serverName = null;
    protected String host = null;
    protected String port = null;
    protected int memberType = 0;
    protected int backupPriority = -1;

    public JRMember(int n, String string, String string2) throws UnknownHostException {
        InetAddress inetAddress = string != null && !string.equalsIgnoreCase("localhost") && !string.equalsIgnoreCase("127.0.0.1") ? InetAddress.getByName(string) : InetAddress.getLocalHost();
        this.host = inetAddress.getHostAddress();
        this.memberType = n;
        this.port = string2;
        this.serverName = this.host + "(" + this.port + ")";
    }

    public JRMember(String string, String string2, String string3, int n) throws UnknownHostException {
        InetAddress inetAddress = string2 != null && !string2.equalsIgnoreCase("localhost") && !string2.equalsIgnoreCase("127.0.0.1") ? InetAddress.getByName(string2) : InetAddress.getLocalHost();
        this.host = inetAddress.getHostAddress();
        this.port = string3;
        this.serverName = string == null || string.trim().length() == 0 ? this.host + "(" + this.port + ")" : string;
        this.backupPriority = n < 0 ? -1 : n;
    }

    public JRMember(Properties properties) throws UnknownHostException {
        String string = properties.getProperty("jrs.cluster.server.host");
        InetAddress inetAddress = string != null && !string.equalsIgnoreCase("localhost") && !string.equalsIgnoreCase("127.0.0.1") ? InetAddress.getByName(string) : InetAddress.getLocalHost();
        this.host = inetAddress.getHostAddress();
        this.port = properties.getProperty("jrs.cluster.server.rmi.port");
        String string2 = properties.getProperty("jrs.cluster.server.name");
        this.serverName = string2 == null || string2.trim().length() == 0 ? this.host + "(" + this.port + ")" : string2;
        this.backupPriority = CSUtil.parseInt(properties.getProperty("jrs.cluster.server.backup.priority"), -1);
        this.backupPriority = this.backupPriority < 0 ? -1 : this.backupPriority;
    }

    public JRMember() {
    }

    public boolean equals(Object object) {
        JRMember jRMember = (JRMember)object;
        try {
            InetAddress inetAddress = InetAddress.getByName(this.host);
            InetAddress inetAddress2 = InetAddress.getByName(jRMember.getHost());
            return inetAddress.equals(inetAddress2) && this.port.equalsIgnoreCase(jRMember.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public boolean equals(Member member) {
        return this.host.equalsIgnoreCase(member.getHost()) && this.port.equalsIgnoreCase(member.getPort());
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isAdmin() {
        return this.memberType == 1;
    }

    public boolean isBackupAdmin() {
        return this.memberType == 2;
    }

    public void setMemberType(int n) {
        this.memberType = n;
    }

    public void setBackupPriority(int n) {
        this.backupPriority = n < 0 ? -1 : n;
    }

    public int getBackupPriority() {
        return this.backupPriority;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.cluster.server.name", this.serverName);
        properties2.put("jrs.cluster.server.host", this.host);
        properties2.put("jrs.cluster.server.rmi.port", this.port);
        if (this.backupPriority != -1) {
            properties2.put("jrs.cluster.server.backup.priority", String.valueOf(this.backupPriority));
        }
        return properties2;
    }
}

