/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.intf.jrs.BackupService;
import jet.server.intf.jrs.ClusterListener;
import jet.server.intf.jrs.ClusterReceiver;
import jet.server.intf.jrs.MemberManager;
import jet.server.jrc.JRClusterReceiver;
import jet.server.jrc.JRMemberTable;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.PredefinedServerList;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRMemberManager
extends UnicastRemoteObject
implements MemberManager {
    private JRMemberTable QOIV = null;
    private JRClusterReceiver add = null;
    private long addClusterListener;
    private boolean currentTimeMillis = false;
    protected LoadBalancer loadBalancer = null;
    private Integer equals = new Integer(-1);
    private ClusterListener getAllMembers;

    public JRMemberManager(JRClusterReceiver jRClusterReceiver) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.add = jRClusterReceiver;
        this.QOIV = new JRMemberTable(jRClusterReceiver);
        this.addClusterListener = System.currentTimeMillis();
        ReportMember[] reportMemberArray = jRClusterReceiver.getPredefinedMembers();
        int n = 0;
        int n2 = 0;
        while (n2 < reportMemberArray.length) {
            if (n < reportMemberArray[n2].getBackupPriority()) {
                n = reportMemberArray[n2].getBackupPriority();
            }
            ++n2;
        }
        this.equals = new Integer(n);
    }

    public ReportMember[] getAllMembers() {
        return this.QOIV.getAllMembers();
    }

    public ReportMember getAdminMember() throws RemoteException {
        ReportMember[] reportMemberArray = this.QOIV.getAllMembers();
        int n = 0;
        while (n < reportMemberArray.length) {
            if (reportMemberArray[n].isAdmin()) {
                return reportMemberArray[n];
            }
            ++n;
        }
        return null;
    }

    public ReportMember canAcceptMember(ReportMember reportMember) throws RemoteException {
        JRReportMember jRReportMember = (JRReportMember)reportMember;
        ReportMember[] reportMemberArray = this.add.getPredefinedMembers();
        Member member = null;
        int n = reportMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (reportMemberArray[n2].equals(reportMember)) {
                member = reportMemberArray[n2];
                break;
            }
            ++n2;
        }
        if (member != null) {
            jRReportMember.setServerName(member.getServerName());
            jRReportMember.setBackupPriority(member.getBackupPriority());
        } else {
            if (ServerEnv.onlyAcceptPredefinedServer()) {
                return null;
            }
            if (jRReportMember.isBackupAdmin()) {
                this.setPriority(jRReportMember);
                if (!this.QOIV(jRReportMember)) {
                    return null;
                }
            } else {
                jRReportMember.setMemberType(0);
                this.QOIV(jRReportMember);
            }
        }
        return jRReportMember;
    }

    public void modifyConcurrentReports(ReportMember reportMember) throws RemoteException {
        this.QOIV.modifyConcurrentReports(reportMember);
    }

    public void registerMember(ReportMember reportMember, boolean bl) throws RemoteException {
        Object object;
        this.QOIV.registerMember(reportMember);
        ReportMember[] reportMemberArray = this.add.getPredefinedMembers();
        if (!reportMember.isAdmin()) {
            if (!bl) {
                this.add.receive(reportMember, true);
            }
            try {
                object = null;
                object = (ClusterReceiver)RemoteObjectFactory.getRemoteObject(reportMember.getHost(), Integer.parseInt(reportMember.getPort()), "ClusterReceiver");
                object.receivePredefined(reportMemberArray);
                this.getAllMembers.registeredMember(reportMember);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        object = this.QOIV.getAllMembers();
        BackupService backupService = null;
        int n = 0;
        while (n < ((ReportMember[])object).length) {
            if (!object[n].isAdmin()) {
                try {
                    backupService = (BackupService)RemoteObjectFactory.getRemoteObject(object[n].getHost(), Integer.parseInt(object[n].getPort()), "BackupService");
                    backupService.refreshActiveMembers((Member[])object, this.addClusterListener);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 2);
                }
            }
            ++n;
        }
    }

    public void registerMember(ReportMember reportMember) throws RemoteException {
        this.registerMember(reportMember, false);
    }

    public void removeMember(ReportMember reportMember) {
        this.QOIV.removeMember(reportMember);
        if (!reportMember.isAdmin()) {
            this.getAllMembers.removeMember(reportMember);
        }
    }

    public long getCreateAdminServerTime() {
        return this.addClusterListener;
    }

    public synchronized void setAdminServerPrepared() {
        this.currentTimeMillis = true;
    }

    public boolean isAdminServerPrepared() {
        return this.currentTimeMillis;
    }

    public String selectMember(String string) {
        if (this.loadBalancer != null) {
            Member member = this.loadBalancer.selectMember(this.getMember(string), this.getAllMembers());
            if (member != null) {
                ReportMember reportMember = (ReportMember)member;
                reportMember.setConcurrentReports(reportMember.getConcurrentReports() + 1);
                return member.getServerName();
            }
            return null;
        }
        return string;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public Member getMember(String string) {
        ReportMember[] reportMemberArray = this.QOIV.getAllMembers();
        int n = 0;
        while (n < reportMemberArray.length) {
            if (reportMemberArray[n].getServerName().equals(string)) {
                return reportMemberArray[n];
            }
            ++n;
        }
        return null;
    }

    public void addClusterListener(ClusterListener clusterListener) {
        this.getAllMembers = clusterListener;
        this.QOIV.addClusterListener(clusterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPriority(ReportMember reportMember) {
        if (!reportMember.isBackupAdmin() || reportMember.isAdmin()) {
            return;
        }
        int n = 0;
        Integer n2 = this.equals;
        synchronized (n2) {
            n = this.equals;
            this.equals = new Integer(n + 1);
        }
        JRReportMember jRReportMember = (JRReportMember)reportMember;
        jRReportMember.setBackupPriority(n + 1);
    }

    private boolean QOIV(JRReportMember jRReportMember) {
        try {
            PredefinedServerList predefinedServerList = ServerEnv.getPredefinedServerList();
            if (predefinedServerList == null) {
                return false;
            }
            predefinedServerList.add(jRReportMember);
            predefinedServerList.save();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            return false;
        }
        return this.add();
    }

    private boolean add() {
        PredefinedServerList predefinedServerList = ServerEnv.getPredefinedServerList();
        if (predefinedServerList == null) {
            return false;
        }
        ReportMember[] reportMemberArray = predefinedServerList.getServerList();
        try {
            this.add.receivePredefined(reportMemberArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 6);
            return false;
        }
        ReportMember[] reportMemberArray2 = this.QOIV.getAllMembers();
        ClusterReceiver clusterReceiver = null;
        int n = 0;
        while (n < reportMemberArray2.length) {
            if (!reportMemberArray2[n].isAdmin()) {
                try {
                    clusterReceiver = (ClusterReceiver)RemoteObjectFactory.getRemoteObject(reportMemberArray2[n].getHost(), Integer.parseInt(reportMemberArray2[n].getPort()), "ClusterReceiver");
                    clusterReceiver.receivePredefined(reportMemberArray);
                }
                catch (RemoteException remoteException) {
                    ServiceLogger.logError(remoteException, 6);
                }
                catch (NumberFormatException numberFormatException) {
                    ServiceLogger.logError(numberFormatException, 6);
                }
                catch (MalformedURLException malformedURLException) {
                    ServiceLogger.logError(malformedURLException, 6);
                }
                catch (NotBoundException notBoundException) {
                    ServiceLogger.logError(notBoundException, 6);
                }
            }
            ++n;
        }
        return true;
    }
}

