/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.FileNameFromTemplate;
import jet.css.CssStyleSheetManager;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpUtil;
import jet.server.api.monitor.CurrentMonitorStatistics;
import jet.server.api.monitor.FinishedReportTable;
import jet.server.api.monitor.RunningReportTable;
import jet.server.db.core.WorkspaceManager;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRUserPreferenceManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class JRMemberMonitor
extends UnicastRemoteObject
implements MemberMonitor {
    JRRptServer QOIV = null;

    public JRMemberMonitor(JRRptServer jRRptServer) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = jRRptServer;
    }

    public int getConcurrentReports() throws RemoteException {
        return this.QOIV.getConCurrentReports();
    }

    public void stopServer() throws RemoteException {
        if (System.getProperty("jrs.isMyServer") == "true") {
            try {
                HttpUtil.shutdownServer();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            System.exit(0);
        }
    }

    public ExProperties getCommonProps() throws RemoteException {
        ExProperties exProperties = new ExProperties();
        exProperties.setProperty("server.realm.active", ServerEnv.getActiveRealm());
        exProperties.setProperty("server.security", ServerEnv.needSecurity());
        exProperties.setProperty("server.version.from.temp", ServerEnv.isPublishTempToVersion());
        exProperties.setProperty("server.completed.max_count", ServerEnv.getMaxCompletedRecordCount());
        exProperties.setProperty("cluster.send_concurrent_reports", ServerEnv.mustSendConcurrentReports());
        exProperties.setProperty("cluster.enable_notify_server_down", ServerEnv.enableNotifyServerDown());
        exProperties.setProperty("cluster.notify_server_down_address", ServerEnv.getNotifyServerDownAddress());
        exProperties.setProperty("jrs.auth_scheme", HttpUtil.getAuthScheme());
        return exProperties;
    }

    public long runTestReport(Properties properties) throws RptServerException {
        return this.QOIV.runTestReport(properties);
    }

    public String getRemoteRealmsPath() throws RemoteException {
        return ServerEnv.realmsPath;
    }

    public Properties getMailConfig() throws RemoteException {
        try {
            return SchdTools.loadMailConfig();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 6);
            throw new ServerException("", exception);
        }
    }

    public Properties getLdapConfig() throws RemoteException {
        return ServerEnv.getLdapConfig();
    }

    public void setLdapConfig(Hashtable hashtable) throws RemoteException {
        LDAPData.replaceProperties(hashtable);
    }

    public void broadcastDefaultPreference() throws RemoteException {
        ((JRUserPreferenceManager)this.QOIV.getUserPreferenceManager()).loadDefaultPref();
    }

    public RunningReportTable getRunningReportTable() throws RemoteException {
        return this.QOIV.getMonitorService().getRunningReportTable();
    }

    public FinishedReportTable getFinishedReportTable() throws RemoteException {
        return this.QOIV.getMonitorService().getFinishedReportTable();
    }

    public CurrentMonitorStatistics getCurrentMonitorStatistics() throws RemoteException {
        return this.QOIV.getMonitorService().getCurrentMonitorStatistics();
    }

    public long getMonitorRefreshInterval() throws RemoteException {
        return this.QOIV.getMonitorService().getMonitorSetting().getMonitorRefreshInterval();
    }

    public long getMonitorOverTimeRunning() throws RemoteException {
        return this.QOIV.getMonitorService().getMonitorSetting().getMonitorOverTimeRunning();
    }

    public int getMonitorMaxNumberSaveReport() throws RemoteException {
        return this.QOIV.getMonitorService().getMonitorSetting().getMonitorNumberSaveReport();
    }

    public int getMonitorMaxMinuteSaveReport() throws RemoteException {
        return this.QOIV.getMonitorService().getMonitorSetting().getMonitorMaxMinuteSaveReport();
    }

    public void deleteOndemandReport(String string) throws RemoteException {
        ((JRTaskManager)this.QOIV.getTaskManager()).deleteOndemandReport(string);
    }

    public Properties getDatabaseInfo(String string, String string2) throws RemoteException {
        WorkspaceManager workspaceManager = WorkspaceManager.getInstance();
        return workspaceManager.workspaces(string).databases(string2).getProperties();
    }

    public int[] getActiveAndWaiting() throws RemoteException {
        JRTaskManager jRTaskManager = (JRTaskManager)this.QOIV.getTaskManager();
        int[] nArray = new int[]{jRTaskManager.getActiveReportsInQueue(), jRTaskManager.getWaitingReports(), jRTaskManager.getQueuingReports()};
        return nArray;
    }

    public void removePipelineFilenames(String string) throws RemoteException {
        ((JRTaskManager)this.QOIV.getTaskManager()).removePipelineFilenames(string);
    }

    public String getPathNameFromTemplate(String string, String string2, String string3, String string4) throws RemoteException {
        return FileNameFromTemplate.getPathNameFromTemplate(string, string2, string3, string4);
    }

    public String getFileNameFromTemplate(String string, String string2, String string3, String string4, String string5) throws RemoteException {
        return FileNameFromTemplate.getFileNameFromTemplate(string, string2, string3, string4, string5);
    }

    public String[] getSupportStyleNames() throws RemoteException {
        List list = CssStyleSheetManager.getSupportStyleNameList();
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public boolean isTaskQueueFull(int n) throws RemoteException {
        return this.QOIV.isTaskQueueFull(n);
    }
}

