/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.RptServer;
import jet.server.api.admin.ConnectionInformation;
import jet.server.api.cluster.Member;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRWebPageOptions;
import jet.server.jrserver.monitor.JRUserSessionMonitor;
import jet.server.log.ServiceLogger;

public class JRRemoteMonitorService
extends UnicastRemoteObject
implements RemoteMonitorService {
    private Hashtable QOIV = null;
    private int append = 0;
    private RptServer currentTimeMillis = null;
    private static final long serialVersionUID = -3839424265930975410L;

    public JRRemoteMonitorService(RptServer rptServer) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.currentTimeMillis = rptServer;
    }

    public boolean isClusterEnable() throws RemoteException {
        return this.currentTimeMillis.isClusterEnable();
    }

    public String getClusterName() throws RemoteException {
        if (this.isClusterEnable()) {
            return this.currentTimeMillis.getClusterService().getClusterName();
        }
        return null;
    }

    public Member[] getPredefinedServers() throws RemoteException {
        Member[] memberArray = null;
        if (this.isClusterEnable() && ServerEnv.isClusterAdminServer()) {
            memberArray = this.currentTimeMillis.getAdminService().getClusterAdminService().getPredefinedServers();
        }
        if (memberArray == null) {
            memberArray = new Member[1];
            try {
                memberArray[0] = new JRReportMember(ServerEnv.getLocalRMIHost(), String.valueOf(ServerEnv.getActiveRMIPort()));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RemoteException(exception.getMessage());
            }
        }
        return memberArray;
    }

    public boolean isStarted(String string, int n) throws RemoteException {
        Member[] memberArray = null;
        try {
            if (this.isClusterEnable()) {
                memberArray = this.currentTimeMillis.getClusterService().getAllMembers();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (memberArray != null) {
            int n2 = 0;
            while (n2 < memberArray.length) {
                if (memberArray[n2].getHost().equals(string) && memberArray[n2].getPort().equals(String.valueOf(n))) {
                    return true;
                }
                ++n2;
            }
        } else {
            try {
                String string2 = InetAddress.getLocalHost().getHostAddress();
                int n3 = ServerEnv.getActiveRMIPort();
                if (string.equals(string2) || string.equalsIgnoreCase("localhost") && n == n3) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isStarting() throws RemoteException {
        return true;
    }

    public boolean isAdminUser(String string, String string2, String string3) throws RemoteException {
        return this.currentTimeMillis.getUserSessionManager().getAuthenticator().isValidAdminUser(string, string2, string3);
    }

    public String getActiveRealm() throws RemoteException {
        return this.currentTimeMillis.getResourceManager().getRealm();
    }

    public String getPassword(String string, String string2) throws RemoteException {
        try {
            return UserDataToolkit.getSecurityService(string).getIntegrityUser(string2).getPassword();
        }
        catch (NoSuchUserException noSuchUserException) {
            return null;
        }
    }

    private String QOIV() {
        return ServerEnv.getMonitorBindAddress() + "_" + ++this.append;
    }

    public Properties[] getConnectionProperties() throws RemoteException {
        this.QOIV = new Hashtable();
        this.append = 0;
        String string = null;
        ConnectionInformation[] connectionInformationArray = this.currentTimeMillis.getAdminService().getConnectionPoolManager().getConnections();
        Properties[] propertiesArray = new Properties[connectionInformationArray != null ? connectionInformationArray.length : 0];
        int n = 0;
        while (n < connectionInformationArray.length) {
            string = this.QOIV();
            this.QOIV.put(string, connectionInformationArray[n]);
            propertiesArray[n] = new Properties();
            propertiesArray[n].put("id", string);
            propertiesArray[n].put("User", connectionInformationArray[n].getUser().length() == 0 ? " " : connectionInformationArray[n].getUser());
            propertiesArray[n].put("URL", connectionInformationArray[n].getUrl());
            propertiesArray[n].put("Expiring_Time", String.valueOf(connectionInformationArray[n].getExpire() / 1000));
            propertiesArray[n].put("Idle_Expiring_Time", String.valueOf(connectionInformationArray[n].getIdleExpire() / 1000));
            propertiesArray[n].put("Maximal_Connection_Count", String.valueOf(connectionInformationArray[n].getMaxCount()));
            propertiesArray[n].put("Maximal_Share_Count", String.valueOf(connectionInformationArray[n].getShare()));
            propertiesArray[n].put("Attempt", String.valueOf(connectionInformationArray[n].getAttempt()));
            propertiesArray[n].put("Interval", String.valueOf(connectionInformationArray[n].getInterval()));
            propertiesArray[n].put("Last_User_Connecting_Time", String.valueOf(connectionInformationArray[n].getStartTime() / 1000));
            propertiesArray[n].put("Current_Idle_Time", String.valueOf(connectionInformationArray[n].getIdleTime() / 1000));
            propertiesArray[n].put("Current_Share_Count", String.valueOf(connectionInformationArray[n].getLockNumber()));
            ++n;
        }
        return propertiesArray;
    }

    public void disconnect(String string) throws RemoteException {
        ConnectionInformation connectionInformation = (ConnectionInformation)this.QOIV.get(string);
        if (connectionInformation != null) {
            this.currentTimeMillis.getAdminService().getConnectionPoolManager().disconnect(connectionInformation);
        }
    }

    public Vector getAllUserSessions() throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getAllUserSessions();
    }

    public Vector getUserSessionsByUser(String string) throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getAllUserSessionsByUserID(string);
    }

    public Vector getSortedUserSessions(Vector vector, int[] nArray) throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getSortedUserSessions(vector, nArray);
    }

    public void removeUserSessionBySessionID(String string) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeUserSessionBySessionID(string);
    }

    public void removeUserSessionsByUserID(String string) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeUserSessionsByUserID(string);
    }

    public void removeAllSelectedUserSessions(String[] stringArray) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeAllSelectedUserSessions(stringArray);
    }

    public void removeAllUserSessions() throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().removeAllUserSessions();
    }

    public String getHttpSessionID(String string) throws RemoteException {
        return ((JRUserSessionMonitor)this.currentTimeMillis.getMonitorService().getUserSessionMonitor()).getHttpSessionID(string);
    }

    public void setSessionTimeout(int n) throws RemoteException {
        this.currentTimeMillis.getMonitorService().getUserSessionMonitor().setSessionTimeout(n);
    }

    public int getSessionTimeout() throws RemoteException {
        return this.currentTimeMillis.getMonitorService().getUserSessionMonitor().getSessionTimeout();
    }

    public void stopTask(String string, int n) throws RemoteException {
        if (n == 1) {
            this.currentTimeMillis.getOndemandReportManager().removeOndemandReport(string, true);
        } else if (n == 2) {
            this.currentTimeMillis.stopActiveTask(string);
        }
    }

    public void killTask(String string, int n) throws RemoteException {
        if (n == 1) {
            ((JRTaskManager)((JRRptServer)this.currentTimeMillis).getTaskManager()).deleteOndemandReport(string, true);
        } else if (n == 2) {
            ((JRTaskManager)((JRRptServer)this.currentTimeMillis).getTaskManager()).stopActiveTask(string, true);
        }
    }

    public void stopServer(String string, int n) throws RemoteException {
        if (System.getProperty("jrs.isMyServer") == "true") {
            this.currentTimeMillis.shutdown();
            System.exit(0);
        }
    }

    public boolean isAdminServer() throws RemoteException {
        boolean bl = false;
        try {
            bl = ServerEnv.isClusterAdminServer() || this.currentTimeMillis.getClusterService().getLocalMember().equals(this.currentTimeMillis.getClusterService().getAdminMember());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public long getServerCurrentTime() throws RemoteException {
        return System.currentTimeMillis();
    }

    public void setMonitorServerURL(String string) throws RemoteException {
        ((JRWebPageOptions)this.currentTimeMillis.getServerEnv().getWebPageOptions()).setMonitoringWebURL(string);
    }

    public String getMonitorServerURL() throws RemoteException {
        return this.currentTimeMillis.getServerEnv().getWebPageOptions().getMonitoringWebURL();
    }

    public Vector getAllTaskStatistics() throws RemoteException {
        return ((JRRptServer)this.currentTimeMillis).getTaskManager().getAllTaskStatistics();
    }
}

