/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FilenameFilter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.PathInfo;
import jet.server.api.ReportVersionRecord;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.api.VersionRecord;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.RemoteResourceManager;
import jet.server.intf.jrs.VersionService;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.Version;
import jet.server.jrc.JRRemoteFileService;
import jet.server.jrc.JRRemotePathInfo;
import jet.server.jrc.resource.ResourceToolkit;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.Realm;
import jet.server.log.ServiceLogger;
import jet.server.resource.RptResourceManager;
import jet.server.util.RefResource;
import jet.server.util.ui.UITree;
import jet.util.WildcardMatcher;

public class JRRemoteResourceManager
extends UnicastRemoteObject
implements RemoteResourceManager {
    private RptResourceManager QOIV = null;
    private String add = null;
    private String addElement = null;
    private ResourceTreeManagerImpl addResource = null;
    private VersionService addResult = null;
    private Realm addResultInReport = null;

    public JRRemoteResourceManager(String string, String string2, String string3, ResourceTreeManagerImpl resourceTreeManagerImpl) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.add = string2;
        this.addElement = string3;
        this.addResource = resourceTreeManagerImpl;
        this.addResult = resourceTreeManagerImpl.getVersionService();
        try {
            this.addResultInReport = Realm.get(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 5);
        }
    }

    public UITree refreshFolders(String string) throws RemoteException {
        return this.addResource.getUITreeByUser(string);
    }

    public String getMIMEType(String string) {
        return ServerEnv.getMimeTypeTable().getMimeType(string);
    }

    public String[] getExtensions(String string) {
        return ServerEnv.getMimeTypeTable().getExts(string);
    }

    public String getRealm() {
        return this.addResultInReport.getName();
    }

    public String getRealmDir() {
        return ServerEnv.realmsPath;
    }

    public PathInfo getPathInfo(String string, String string2) throws RptServerException {
        Node node = null;
        try {
            node = this.addResource.getNodeByPath(string2, string);
            node = this.addResource.checkNode(node, string2, string);
            return node.toPathInfo(string);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public Vector getSubpaths(String string, String string2) throws RptServerException {
        if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
            return new Vector(1);
        }
        Vector vector = null;
        try {
            vector = this.QOIV.getSubpathsAndFileSysDirs(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return this.addElement(string, string2, vector, false, false, false, false);
    }

    public Vector getSubpathsAndCatalogs(String string, String string2) throws RptServerException, RemoteException {
        int n;
        Vector vector = null;
        try {
            vector = this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        Vector vector2 = this.getCatalogsInPath(string, string2);
        Vector vector3 = new Vector();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                vector3.addElement(vector.elementAt(n));
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                vector3.addElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector3;
    }

    public Vector getSubnodes(String string, String string2) throws RptServerException {
        try {
            Node node = this.addResource.getNodeByPath(string2, string);
            Vector<PathInfo> vector = null;
            if (node != null && node.getNodeType() == 1) {
                Node node2;
                int n;
                Vector vector2;
                vector = new Vector<PathInfo>();
                if (!this.addResource.getResourceAliasManager().isAliasNode(string2, string)) {
                    vector2 = this.addResource.getChildren((Folder)node, string);
                    n = vector2.size();
                    int n2 = 0;
                    while (n2 < n) {
                        node2 = (Node)vector2.elementAt(n2);
                        node2 = this.addResource.checkNode(node2, string2, string);
                        vector.add(node2.toPathInfo(string));
                        ++n2;
                    }
                }
                vector2 = null;
                if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string) || string2.equalsIgnoreCase("/")) {
                    vector2 = this.addResource.getAliasChildrenByPath(string2, string);
                }
                if (vector2 != null && vector2.size() > 0) {
                    n = 0;
                    while (n < vector2.size()) {
                        node2 = (Node)vector2.elementAt(n);
                        vector.add(node2.toPathInfo(string));
                        ++n;
                    }
                }
                return vector;
            }
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return null;
    }

    public Vector getFileSysDirsInPath(String string, String string2) throws RptServerException {
        if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
            return new Vector(1);
        }
        Vector vector = null;
        try {
            vector = this.QOIV.getSubpathsAndFileSysDirs(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return this.addElement(string, string2, vector, true, false, false, false);
    }

    public Vector getCatalogsInPath(String string, String string2) throws RptServerException {
        try {
            return this.QOIV(string, string2, (byte)1);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    private Vector QOIV(String string, String string2, byte by) throws NoPrivilegeException, UnknownResource {
        Node node = this.addResource.getNodeByPath(string2, string);
        Vector<PathInfo> vector = null;
        if (node != null && node.getNodeType() == 1) {
            Resource resource;
            int n;
            Vector vector2;
            if (!this.addResource.getResourceAliasManager().isAliasNode(string2, string)) {
                vector2 = this.addResource.getResources((Folder)node, string);
                int n2 = vector2.size();
                vector = new Vector<PathInfo>(n2);
                n = 0;
                while (n < n2) {
                    resource = (Resource)vector2.elementAt(n);
                    if ((resource = (Resource)this.addResource.checkNode(resource, string2, string)).getResourceType() == by) {
                        vector.add(resource.toPathInfo(string));
                    }
                    ++n;
                }
            }
            vector2 = null;
            if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string) || string2.equalsIgnoreCase("/")) {
                vector2 = this.addResource.getAliasChildrenByPath(string2, string);
            }
            if (vector2 != null && vector2.size() > 0) {
                if (vector == null) {
                    vector = new Vector(vector2.size());
                }
                n = 0;
                while (n < vector2.size()) {
                    Node node2 = (Node)vector2.elementAt(n);
                    if (node2.getNodeType() == 2 && (resource = (Resource)node2).getResourceType() == by) {
                        vector.add(resource.toPathInfo(string));
                    }
                    ++n;
                }
            }
        }
        return vector;
    }

    private Vector add(String string, String string2, String[] stringArray) throws NoPrivilegeException, UnknownResource {
        Vector<File> vector = new Vector<File>();
        try {
            String string3;
            if (string2 != null && string2.length() > 0 && (string3 = this.getRealPath(string, string2)) != null && string3.length() > 0) {
                int n;
                int n2 = string3.lastIndexOf("/");
                int n3 = n2 = n2 > (n = string3.lastIndexOf(File.separator)) ? n2 : n;
                if (n2 >= 0) {
                    string3 = string3.substring(0, n2);
                }
                File file = new File(string3);
                String string4 = null;
                File[] fileArray = file.listFiles();
                int n4 = 0;
                while (n4 < fileArray.length) {
                    String string5 = fileArray[n4].getName();
                    if (string5.lastIndexOf(46) != -1) {
                        string4 = string5.substring(string5.lastIndexOf(46));
                    }
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        if (stringArray[n5].equalsIgnoreCase(string4)) {
                            vector.add(fileArray[n4]);
                            break;
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
        }
        catch (Exception exception) {
            throw new UnknownResource(exception);
        }
        return vector;
    }

    public Vector getFileSysFilesInPath(String string, String string2) throws RptServerException {
        if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
            return new Vector(1);
        }
        Vector vector = null;
        try {
            vector = this.QOIV.getSubRscRefFileOrDir(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return this.addElement(string, string2, vector, false, false, true, false);
    }

    public Vector getReports(String string, String string2) throws RptServerException {
        Vector<JRRemotePathInfo> vector = null;
        try {
            if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
                vector = new Vector<JRRemotePathInfo>(8);
                String string3 = this.getRealPath(string, string2);
                if (string3 != null) {
                    File file;
                    String[] stringArray;
                    int n;
                    int n2 = string3.lastIndexOf("/");
                    int n3 = n2 = n2 > (n = string3.lastIndexOf(File.separator)) ? n2 : n;
                    if (n2 >= 0) {
                        string3 = string3.substring(0, n2);
                    }
                    if ((stringArray = (file = new File(string3)).list((FilenameFilter)new WildcardMatcher("*.cls", true, 2))) != null && stringArray.length > 0) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            vector.addElement(new JRRemotePathInfo(string, string2 + (string2.endsWith("/") ? "" : "/") + stringArray[n4], this.QOIV));
                            ++n4;
                        }
                    }
                }
                return vector;
            }
            vector = this.QOIV.getReports(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return this.addElement(string, string2, vector, false, false, false, true);
    }

    private Vector addElement(String string, String string2, Vector vector, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws RptServerException {
        Vector<JRRemotePathInfo> vector2 = null;
        int n = vector == null ? 0 : vector.size();
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        AdminService adminService = httpRptServer.getAdminService();
        SecurityAdminService securityAdminService = adminService.getSecurityAdminService();
        String string3 = securityAdminService.getActiveRealm();
        if (n > 0) {
            vector2 = new Vector<JRRemotePathInfo>(n);
            try {
                int n2 = 0;
                while (n2 < n) {
                    String string4;
                    String string5 = (String)vector.elementAt(n2);
                    int n3 = string5.length();
                    if (bl) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n3 - 3);
                        if (httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible") && string5.charAt(n3 - 2) == '1') {
                            vector2.addElement(new JRRemotePathInfo(string, string4, this.QOIV));
                        }
                    } else if (bl2) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n3 - 3);
                        if (httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible") && string5.charAt(n3 - 2) == '1') {
                            vector2.addElement(new JRRemotePathInfo(string, string4, this.QOIV));
                        }
                    } else if (bl3) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n3 - 2);
                        if (httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible") && string5.charAt(n3 - 2) == '2') {
                            vector2.addElement(new JRRemotePathInfo(string, string4, this.QOIV));
                        }
                    } else if (bl4) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n3 - 1);
                        if (httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible")) {
                            vector2.addElement(new JRRemotePathInfo(string, string4, this.QOIV));
                        }
                    } else {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n3 - 3);
                        if (httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible")) {
                            if (string5.endsWith("120")) {
                                vector2.addElement(new JRRemotePathInfo(string, string2, this.QOIV, true));
                            } else {
                                vector2.addElement(new JRRemotePathInfo(string, string4, this.QOIV));
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new RptServerException(exception);
            }
        }
        return vector2;
    }

    public String getRoot() {
        return ServerEnv.getResourceRoot();
    }

    public String getTempDir() {
        return this.add;
    }

    public String getHistDir() {
        return this.addElement;
    }

    public String getRealPath(String string, String string2) throws RptServerException, RemoteException {
        return this.getPathInfo(string, string2).getRealPath();
    }

    public String getRptRealPath(String string, String string2, String string3) throws RptServerException, RemoteException {
        return this.getPathInfo(string, string3).getRealPath();
    }

    public RptResourceManager getRptResourceManager() {
        return this.QOIV;
    }

    public String getSchedulePath() {
        String string;
        File file;
        String string2 = ServerEnv.realmsPath;
        if (!string2.endsWith(CSUtil.fileSep)) {
            string2 = string2 + CSUtil.fileSep;
        }
        if (!(file = new File(string = string2 + this.getRealm() + CSUtil.fileSep + "schedule" + CSUtil.fileSep)).exists()) {
            file.mkdir();
        }
        return string;
    }

    public boolean isShared(String string, String string2) throws RptServerException {
        return this.getPathInfo(string, string2).isShared();
    }

    public boolean isShared(String string, String string2, String string3) throws RptServerException {
        return this.getPathInfo(string, string3).isShared();
    }

    public boolean isNodeExist(String string, String string2) throws RptServerException, RemoteException {
        return this.addResource.isNodeExist(string, string2);
    }

    public String getHomePath() {
        String string = ServerEnv.homePath;
        if (string != null && !string.endsWith(CSUtil.fileSep)) {
            string = string + CSUtil.fileSep;
        }
        return string;
    }

    public String getFontPath() {
        return ServerEnv.getFontPath();
    }

    public Vector getImagesByCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        String[] stringArray = new String[]{".bmp", ".jpg", ".jpeg", ".gif", ".png"};
        return this.add(string, string2, stringArray);
    }

    public Vector getReportsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.QOIV(string, string2, (byte)2);
    }

    public Vector getResultsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.QOIV(string, string2, (byte)3);
    }

    public Vector getFoldersInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        Vector<PathInfo> vector = null;
        if (node != null && node.getNodeType() == 1) {
            Vector vector2 = this.addResource.getSubFolders((Folder)node, string);
            int n = vector2.size();
            vector = new Vector<PathInfo>(n);
            int n2 = 0;
            while (n2 < n) {
                vector.add(((Node)vector2.elementAt(n2)).toPathInfo(string));
                ++n2;
            }
        }
        return vector;
    }

    public String getRptRealPath(String string, String string2) throws RptServerException, RemoteException {
        return this.getPathInfo(string, string2).getRealPath();
    }

    public Vector getRptRefResource(String string, String string2) throws RptServerException, RemoteException {
        try {
            Vector[] vectorArray = RefResource.getRptFiles(string2);
            Vector<String> vector = new Vector<String>();
            if (vectorArray != null) {
                int n = 0;
                while (n < vectorArray.length) {
                    Vector vector2 = vectorArray[n];
                    if (vector2 != null) {
                        int n2 = 0;
                        while (n2 < vector2.size()) {
                            Object e = vector2.elementAt(n2);
                            if (e instanceof String) {
                                vector.addElement((String)e);
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            return vector;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    private Vector getVersions(String string, String string2, byte by) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Vector vector = null;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == by) {
            vector = this.addResource(string, resource);
        }
        return vector;
    }

    public Vector getCatalogVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.getVersions(string, string2, (byte)1);
    }

    public Vector getReportVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.getVersions(string, string2, (byte)2);
    }

    public Vector getResultVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Vector vector = null;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null) {
            vector = this.addResource(string, resource.getResult());
        }
        return vector;
    }

    public Vector getResultDocVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.getVersions(string, string2, (byte)3);
    }

    private Vector addResource(String string, Resource resource) throws NoPrivilegeException {
        Vector<Object> vector = null;
        Vector vector2 = this.addResource.getVersions(resource, string);
        vector = new Vector<Object>(vector2.size());
        int n = 0;
        while (n < vector2.size()) {
            vector.addElement(((Version)vector2.elementAt(n)).toVersionRecord(this.addResource, string));
            ++n;
        }
        return vector;
    }

    public void removeNode(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node;
        Node node2 = this.addResource.getNodeByPath(string2, string);
        if (node2.isDynamic()) {
            throw new NoPrivilegeException(630009);
        }
        if (node2 != null && (node = node2.getParent()).getNodeType() == 1) {
            this.addResource.removeChild((Folder)node, node2, string);
            if (node2.getNodeType() == 1) {
                this.refreshFolders(string);
            }
        }
    }

    public VersionRecord addResource(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 1) {
            ResourceInfo resourceInfo;
            String string3 = (String)hashtable.get("jrs.node_name");
            if (string3 == null || string3.trim().length() == 0 || !CSUtil.isValidNodeName(string3)) {
                throw new UnknownResource("Unknown resource name " + string3);
            }
            Folder folder = (Folder)node;
            if (folder.isFakeFolder()) {
                folder = this.addResource.upgradeFakeFolder(folder);
            }
            if ((resourceInfo = ResourceToolkit.createResourceInfo(hashtable, string, this.addResource)) != null) {
                String[] stringArray;
                Version version = this.addResource.addResource(folder, hashtable, resourceInfo, string);
                if (CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false) && (stringArray = this.addResult(hashtable)) != null) {
                    File file = new File(stringArray[0]);
                    ResourceToolkit.importResources(file, folder, stringArray[1], this.addResource, string);
                }
                return (VersionRecord)version.toVersionRecord(this.addResource, string);
            }
            ServiceLogger.logError(2620028, new Object[]{string2, string, hashtable}, 2);
        } else {
            ServiceLogger.logError(2620027, new Object[]{string2, string}, 2);
        }
        return null;
    }

    public VersionRecord addResource(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node;
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if ((node = this.addResource.getNodeByPath(string2, string)) != null && node.getNodeType() == 1) {
            ResourceInfo resourceInfo;
            String string3 = (String)hashtable.get("jrs.node_name");
            if (string3 == null || string3.trim().length() == 0 || !CSUtil.isValidNodeName(string3)) {
                throw new UnknownResource(string3);
            }
            Folder folder = (Folder)node;
            if (folder.isFakeFolder()) {
                folder = this.addResource.upgradeFakeFolder(folder);
            }
            if ((resourceInfo = ResourceToolkit.createResourceInfo(hashtable, string, this.addResource)) != null) {
                String[] stringArray;
                Version version = this.addResource.addResource(folder, hashtable, resourceInfo, string);
                if (CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false) && (stringArray = this.addResult(hashtable)) != null) {
                    File file = new File(stringArray[0]);
                    ResourceToolkit.importResources(file, folder, stringArray[1], this.addResource, string);
                }
                return (VersionRecord)version.toVersionRecord(this.addResource, string);
            }
            ServiceLogger.logError(2620028, new Object[]{string2, string, hashtable}, 2);
        } else {
            ServiceLogger.logError(2620027, new Object[]{string2, string}, 2);
        }
        return null;
    }

    public VersionRecord addResource(String string, String string2, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node;
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if ((node = this.addResource.getNodeByPath(string2, string)) != null && node.getNodeType() == 1) {
            ResourceInfo resourceInfo;
            String string3 = (String)hashtable.get("jrs.node_name");
            if (string3 == null || string3.trim().length() == 0 || !CSUtil.isValidNodeName(string3)) {
                throw new UnknownResource(string3);
            }
            Folder folder = (Folder)node;
            if (folder.isFakeFolder()) {
                folder = this.addResource.upgradeFakeFolder(folder);
            }
            if ((resourceInfo = ResourceToolkit.createResourceInfo(hashtable, string, folder, bl, this.addResource)) != null) {
                String[] stringArray;
                Version version = this.addResource.addResource(folder, hashtable, resourceInfo, string);
                if (CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false) && (stringArray = this.addResult(hashtable)) != null) {
                    File file = new File(stringArray[0]);
                    ResourceToolkit.importResources(file, folder, stringArray[1], bl, this.addResource, string);
                }
                return (VersionRecord)version.toVersionRecord(this.addResource, string);
            }
        } else {
            ServiceLogger.logError(2620027, new Object[]{string2, string}, 2);
        }
        return null;
    }

    private String[] addResult(Hashtable hashtable) {
        String string;
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
        if (by == -1) {
            return null;
        }
        switch (by) {
            case 2: {
                string = (String)hashtable.get("jrs.catalog");
                break;
            }
            case 0: {
                string = (String)hashtable.get("jrs.report");
                break;
            }
            default: {
                return null;
            }
        }
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray = new String[]{file.getParent(), file.getName()};
            return stringArray;
        }
        return null;
    }

    public VersionRecord addResultInReport(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && ((Resource)node).getResourceType() == 2) {
            ResourceInfo resourceInfo = ResourceToolkit.createResourceInfo(hashtable, string, this.addResource);
            if (resourceInfo != null) {
                return (VersionRecord)this.addResource.addResult((Resource)node, hashtable, resourceInfo, string).toVersionRecord(this.addResource, string);
            }
            ServiceLogger.logError(2620029, new Object[]{string2, string, hashtable}, 2);
        }
        return null;
    }

    public void removeVersion(String string, int n) throws NoPrivilegeException, RemoteException {
        if (n == -1) {
            throw new NoPrivilegeException(630009);
        }
        this.addResource.removeVersion(n, string);
    }

    public String addFolder(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node.getNodeType() == 1) {
            Object object;
            String string3 = (String)hashtable.get("jrs.deploy_from_file");
            if (string3 == null) {
                string3 = (String)hashtable.get("jrs.node_real_path");
            }
            String string4 = (String)hashtable.get("jrs.node_name");
            boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files_and_subfolders"), false);
            boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files"), false);
            if (!(bl || bl2 || string4 != null && string4.trim().length() != 0 && CSUtil.isValidNodeName(string4))) {
                throw new UnknownResource(string4);
            }
            if (!(string3 == null || string3.trim().length() == 0 || ((File)(object = new File(string3))).exists() && ((File)object).isDirectory())) {
                return null;
            }
            object = null;
            object = bl || bl2 ? (Folder)node : this.addResource.addSubFolder((Folder)node, hashtable, string);
            if (object != null) {
                if (object.isFakeFolder()) {
                    object = this.addResource.upgradeFakeFolder((Folder)object);
                }
                if ((CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false) || bl || bl2) && string3 != null && string3.trim().length() != 0) {
                    ResourceToolkit.importResources(new File(string3), (Folder)object, true, true, CSUtil.getBoolean((String)hashtable.get("jrs.node_no_real_path"), false), this.addResource, string, bl2, hashtable);
                }
                return object.getAbsolutePath();
            }
        }
        return null;
    }

    public String createFolder(String string, String string2, String string3, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node;
        if (string3 == null) {
            return null;
        }
        hashtable.put("jrs.node_name", string3);
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if ((node = this.addResource.getNodeByPath(string2, string)).getNodeType() == 1) {
            String string4 = (String)hashtable.get("jrs.deploy_local_style_dir");
            ResourceToolkit.saveStyleFiles(string4);
            hashtable.put("createOnly", "true");
            Folder folder = this.addResource.addSubFolder((Folder)node, hashtable, string);
            if (folder != null) {
                return folder.getAbsolutePath();
            }
        }
        return null;
    }

    public void addResourcesToFolder(String string, String string2, String string3, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Object object;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (ServerEnv.hasClusterLicense()) {
            object = HttpUtil.getHttpRptServer().getClusterService().getLocalMember();
            string5 = (String)hashtable.get("jrs.remote_host");
            string6 = (String)hashtable.get("jrs.remote_port");
            if (string5.equals(object.getHost()) && string6.equals(object.getPort())) {
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        object = this.addResource.getNodeByPath(string2, string);
        if (object != null && object.getNodeType() == 1 && ((Folder)object).isFakeFolder()) {
            object = this.addResource.upgradeFakeFolder((Folder)object);
        }
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        if (bl2) {
            if (object.getNodeType() == 1) {
                string4 = string3;
                Folder folder = (Folder)object;
                if (folder != null) {
                    ResourceToolkit.importResources(new File(string4), folder, true, true, true, this.addResource, string, !bl, hashtable);
                }
            }
        } else {
            Folder folder;
            JRRemoteFileService jRRemoteFileService = null;
            string4 = this.add + "upload" + System.currentTimeMillis();
            try {
                jRRemoteFileService = new JRRemoteFileService(string5, Integer.parseInt(string6));
                jRRemoteFileService.copyFromRemote(string3, string4);
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
            hashtable.put("jrs.deploy_local_font_dir", string4 + File.separator + "font");
            hashtable.put("jrs.deploy_local_style_dir", string4 + File.separator + ServerEnv.getStyleFolder());
            hashtable.put("jrs.deploy_from_file", string4);
            File file = new File(string4);
            if (object.getNodeType() == 1 && (folder = (Folder)object) != null) {
                ResourceToolkit.importResources(file, folder, true, true, true, this.addResource, string, !bl, hashtable);
            }
            CSUtil.deleteFolderTree(file);
        }
    }

    public void addResourcesToFolder(String string, String string2, String string3, boolean bl, boolean bl2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Object object;
        boolean bl3 = false;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (ServerEnv.hasClusterLicense()) {
            object = HttpUtil.getHttpRptServer().getClusterService().getLocalMember();
            string5 = (String)hashtable.get("jrs.remote_host");
            string6 = (String)hashtable.get("jrs.remote_port");
            if (string5.equals(object.getHost()) && string6.equals(object.getPort())) {
                bl3 = true;
            }
        } else {
            bl3 = true;
        }
        object = this.addResource.getNodeByPath(string2, string);
        if (object != null && object.getNodeType() == 1 && ((Folder)object).isFakeFolder()) {
            object = this.addResource.upgradeFakeFolder((Folder)object);
        }
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        if (bl3) {
            if (object.getNodeType() == 1) {
                string4 = string3;
                Folder folder = (Folder)object;
                if (folder != null) {
                    ResourceToolkit.importResources(new File(string4), folder, true, true, true, bl2, this.addResource, string, !bl, hashtable);
                }
            }
        } else {
            Folder folder;
            JRRemoteFileService jRRemoteFileService = null;
            string4 = this.add + "upload" + System.currentTimeMillis();
            try {
                jRRemoteFileService = new JRRemoteFileService(string5, Integer.parseInt(string6));
                jRRemoteFileService.copyFromRemote(string3, string4);
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
            hashtable.put("jrs.deploy_local_font_dir", string4 + File.separator + "font");
            hashtable.put("jrs.deploy_local_style_dir", string4 + File.separator + ServerEnv.getStyleFolder());
            hashtable.put("jrs.deploy_from_file", string4);
            File file = new File(string4);
            if (object.getNodeType() == 1 && (folder = (Folder)object) != null) {
                ResourceToolkit.importResources(file, folder, true, true, true, bl2, this.addResource, string, !bl, hashtable);
            }
            CSUtil.deleteFolderTree(file);
        }
    }

    public Vector getAllUsers(String string) throws RemoteException {
        return this.addResource.getSecurityService().getAllUsersName();
    }

    public Vector getUsersByRole(String string, String string2) throws NoSuchRoleException, RemoteException {
        return this.addResource.getSecurityService().getUsersNameByRole(string2);
    }

    public Vector getAllRoles(String string) throws RemoteException {
        return this.addResource.getSecurityService().getAllRolesName();
    }

    public Vector getRolesByUser(String string, String string2) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getRolesNameByUser(string2);
    }

    public Vector getReferUsers(String string) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getReferUsers(string);
    }

    public Vector getReferRoles(String string) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getReferRoles(string);
    }

    public Vector getReferGroups(String string) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getReferGroups(string);
    }

    public Hashtable[] getPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource.getPermissions(string2, n, string);
    }

    public Hashtable[] getInheritedPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        if (string2 == null || string2.trim().equals("/")) {
            return null;
        }
        Hashtable[] hashtableArray = null;
        if (n > 0) {
            hashtableArray = this.getPermissions(string, string2, 0);
            return hashtableArray == null ? this.getInheritedPermissions(string, string2, 0) : hashtableArray;
        }
        if (n == 0) {
            String string3 = string2.substring(0, string2.lastIndexOf("/"));
            if (string3.length() == 0) {
                string3 = "/";
            }
            return (hashtableArray = this.getPermissions(string, string3, 0)) == null ? this.getInheritedPermissions(string, string3, 0) : hashtableArray;
        }
        return null;
    }

    public void setPermissions(String string, String string2, int n, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.addResource.setPermissions(string2, n, hashtableArray, string);
    }

    public String getRealPathOfNode(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node == null) {
            throw new UnknownResource(string2);
        }
        switch (node.getNodeType()) {
            case 1: {
                return ((Folder)node).getRealPath();
            }
            case 2: {
                return ((Resource)node).getRealDir();
            }
        }
        throw new UnknownResource(string2);
    }

    public int getLatestVersinNumber(String string) throws RemoteException, UnknownResource {
        return this.getLatestVersinNumber(string, "JReport_System_User");
    }

    public int getLatestVersinNumber(String string, String string2) throws RemoteException, UnknownResource {
        try {
            Node node = this.addResource.getNodeByPath(string, string2);
            if (node.getNodeType() == 2) {
                return ((Resource)node).getLatestVersionNumber();
            }
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException.getMessage());
        }
        return -1;
    }

    public String getRealPath(String string, String string2, int n) throws RemoteException, NoPrivilegeException, UnknownResource {
        if (n < 1) {
            try {
                return this.getRealPath(string, string2);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError(rptServerException, 6);
                return null;
            }
        }
        Version version = this.addResource.getVersion(string2, n, string);
        if (version != null) {
            return version.getEntity().getRealPath();
        }
        return null;
    }

    public void setNodeProperties(String string, String string2, int n, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node.getNodeType() == 2 && n != 0 && !node.isDynamic()) {
            node = this.addResource.getVersion(string2, n, string);
        }
        try {
            this.addResource.setNodeProperties(node, hashtable, hashtableArray, string);
        }
        catch (NodeExistsException nodeExistsException) {
            throw new RemoteException("", nodeExistsException);
        }
    }

    public void setNodeProperties(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        hashtable.put("jrs.node_path", string2);
        this.addResource.setNodeProperties(node, hashtable, hashtableArray, string);
    }

    public void setResultVersionProperties(String string, String string2, int n, Hashtable hashtable) throws NoPrivilegeException, UnknownResource, RemoteException {
        Version version;
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null && (version = !resource.isDynamic() ? this.addResource.getVersion(resource.getResult().getAbsolutePath(), n, string) : this.addResource.getVersion(resource.getResult(), n, string)) != null) {
            try {
                this.addResource.setNodeProperties(version, hashtable, null, string);
            }
            catch (NodeExistsException nodeExistsException) {
                throw new RemoteException("", nodeExistsException);
            }
        }
    }

    public boolean checkPermission(String string, String string2, Permission permission) throws NoSuchUserException, UnknownResource, RemoteException {
        return this.addResource.checkPermission(string, string2, permission);
    }

    public boolean checkPermission(String string, int n, String string2, Permission permission) throws NoSuchUserException, UnknownResource, RemoteException {
        return this.addResource.checkPermission(string, n, string2, permission);
    }

    public CatalogVersionRecord getCatalogVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (CatalogVersionRecord)this.addResultInReport(string, string2, n, (byte)1);
    }

    public ReportVersionRecord getReportVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (ReportVersionRecord)this.addResultInReport(string, string2, n, (byte)2);
    }

    public ResultVersionRecord getResultVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null) {
            Resource resource2 = resource.getResult();
            String string3 = resource2.getAbsolutePath();
            if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string)) {
                string3 = string2 + string3.substring(resource.getAbsolutePath().length());
            }
            Version version = null;
            version = !resource.isDynamic() ? this.addResource.getVersion(string3, n, string) : this.addResource.getVersion(resource.getResult(), n, string);
            if (version != null) {
                return (ResultVersionRecord)version.toVersionRecord(this.addResource, string);
            }
        }
        return null;
    }

    public ResultVersionRecord getResultVersionByNodeID(String string) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource.getResultVersionRecord(string);
    }

    public ResultVersionRecord getResultDocVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (ResultVersionRecord)this.addResultInReport(string, string2, n, (byte)3);
    }

    private Object addResultInReport(String string, String string2, int n, byte by) throws NoPrivilegeException, UnknownResource, RemoteException {
        Version version;
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == by && (version = this.addResource.getVersion(string2, n, string)) != null) {
            return version.toVersionRecord(this.addResource, string);
        }
        return null;
    }

    public String getArchivePath(String string) {
        return this.addResource.getVersionService().getArchivePath(string);
    }

    public String getRptRealPath(String string, String string2, int n) throws Exception, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node.getNodeType() == 2 && ((Resource)node).getResourceType() == 2) {
            Version version = this.addResource.getVersion(string2, n, string);
            ReportVersionRecord reportVersionRecord = (ReportVersionRecord)version.toVersionRecord(this.addResource, string);
            return reportVersionRecord.getRealPath();
        }
        return null;
    }

    public String getArchivePath(String string, String string2) throws RemoteException {
        return this.addResource.getVersionService().getVersionFolderManager().getArchivePath(string, string2);
    }

    public boolean deleteArchivePath(String string) throws RemoteException {
        return this.addResource.getVersionService().getVersionFolderManager().deleteArchivePath(string, true);
    }

    public void setResultMaxVersionAmount(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2) {
            if (resource.isDynamic()) {
                this.addResource.setDynamicResultMaxVersionAmount(resource, n);
            } else {
                Resource resource2 = resource.getResult();
                if (resource2 == null) {
                    this.addResource.addResult(resource, n, string);
                } else {
                    this.addResource.setMaxVersionAmount(resource2, n);
                }
            }
        }
    }

    public int getResultMaxVersionAmount(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null) {
            if (!resource.isDynamic()) {
                return resource.getResult().getMaxVersionAmount();
            }
            return this.addResource.getDynamicResultMaxVersionAmount(resource.getAbsolutePath());
        }
        return 0;
    }

    public boolean isAdminUser(String string) throws RemoteException {
        return this.addResource.getSecurityService().isAdminUser(string);
    }

    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, Properties properties2, String string6) throws NoPrivilegeException, UnknownResource, RemoteException {
        Properties properties3 = this.addResult.publishResultToVersion(string, string2, string3, string4, string5, properties, string6);
        Enumeration<Object> enumeration = properties2.keys();
        String string7 = (String)properties3.get("jrs.result");
        while (enumeration.hasMoreElements()) {
            String string8;
            boolean bl;
            String string9 = (String)enumeration.nextElement();
            if (!string9.startsWith("jrs.report_sheet$") || !(bl = CSUtil.getBoolean(string8 = (String)properties2.get(string9), true))) continue;
            string9 = string9.substring("jrs.report_sheet".length() + 1);
            properties3.put(string9, string7);
        }
        if (string3.endsWith(".rst")) {
            properties3.put("jrs.rst_result", string7);
        }
        if (properties3.containsKey("jrs.param_file")) {
            properties2.remove("jrs.param_file");
        }
        properties3.putAll((Map<?, ?>)properties2);
        this.addResultInReport(string6, string2, properties3);
    }

    public Vector getAllInvalidDynamicNodes(String string) throws NoPrivilegeException, RemoteException {
        return this.addResource.getAllInvalidDynamicNodes(string);
    }

    public void deleteInvalidDynamicNodes(String string, Vector vector) throws NoPrivilegeException, RemoteException {
        this.addResource.deleteInvalidDynamicNodes(string, vector);
    }

    public void loadUserResAliasToMem(String string) {
        this.addResource.getResourceAliasManager().loadUserAliasToMem(string);
    }

    public void rmUserResAliasFromMem(String string) {
        this.addResource.getResourceAliasManager().removeUserAliasFromMem(string);
    }

    public String getInheritedLinkedCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        return this.addResource.getInheritedLinkedCatalog(node, string);
    }

    public boolean isCatalogLinked(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource.isCatalogLinked(string, string2);
    }

    public void setResultVersionViewed(String string, String string2, int n, String string3, int n2) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.addResource.setResultVersionViewed(string, string2, n, string3, n2);
    }
}

